/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource
implements IXtendXpandResource {
    private IStorage underlyingFile;
    private Resource resource;

    protected AbstractResource(IStorage res) {
        this.underlyingFile = res;
    }

    public void setExtXptResource(Resource res) {
        this.resource = res;
    }

    @Override
    public Resource getExtXptResource() {
        if (this.resource == null) {
            this.resource = new StubResource();
        }
        return this.resource;
    }

    @Override
    public IStorage getUnderlyingStorage() {
        return this.underlyingFile;
    }

    public String getFullyQualifiedName() {
        return this.getExtXptResource().getFullyQualifiedName();
    }

    public String[] getImportedNamespaces() {
        return this.getExtXptResource().getImportedNamespaces();
    }

    public void setFullyQualifiedName(String fqn) {
        this.getExtXptResource().setFullyQualifiedName(fqn);
    }

    public String[] getImportedExtensions() {
        return this.getExtXptResource().getImportedExtensions();
    }

    @Override
    public final void analyze(ExecutionContext ctx) {
        if (this.getUnderlyingStorage() instanceof IFile) {
            IFile f = (IFile)this.getUnderlyingStorage();
            HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
            this.analyze(ctx, issues);
            Iterator iterator = issues.iterator();
            while (iterator.hasNext()) {
                XtendXpandMarkerManager.addMarker(f, (AnalysationIssue)iterator.next());
            }
            if (issues.isEmpty()) {
                XtendXpandMarkerManager.deleteMarkers((IResource)f);
            }
        }
    }

    protected abstract void analyze(ExecutionContext var1, Set<AnalysationIssue> var2);

    @Override
    public final boolean refresh() {
        return this.internalRefresh();
    }

    protected abstract boolean internalRefresh();

    private class StubResource
    implements Resource {
        private String fullyQualifiedName;

        private StubResource() {
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String[] getImportedExtensions() {
            return new String[0];
        }

        public String[] getImportedNamespaces() {
            return new String[0];
        }

        public void setFullyQualifiedName(String fqn) {
            this.fullyQualifiedName = fqn;
        }
    }
}

