/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ErrorStatement;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.ExpressionStatement;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xpand2.ast.ForEachStatement;
import org.eclipse.internal.xpand2.ast.IfStatement;
import org.eclipse.internal.xpand2.ast.LetStatement;
import org.eclipse.internal.xpand2.ast.ProtectStatement;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExecutionListener;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.ConcatExpression;
import org.eclipse.xtend.backend.expr.DeferredEvalExpression;
import org.eclipse.xtend.backend.expr.HidingLocalVarDefExpression;
import org.eclipse.xtend.backend.expr.IfExpression;
import org.eclipse.xtend.backend.expr.InitClosureExpression;
import org.eclipse.xtend.backend.expr.InvocationOnObjectExpression;
import org.eclipse.xtend.backend.expr.LiteralExpression;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.expr.NewLocalVarDefExpression;
import org.eclipse.xtend.backend.expr.SequenceExpression;
import org.eclipse.xtend.backend.functions.SourceDefinedFunction;
import org.eclipse.xtend.backend.syslib.DeferredEvalExecutionListener;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.StringType;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.xpand.plugin.XpandDefinitionName;
import org.eclipse.xtend.middleend.xtend.internal.OldExpressionConverter;
import org.eclipse.xtend.middleend.xtend.internal.OldTypeAnalyzer;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendIterator;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OldDefinitionConverter {
    public static final List<String> ADVICE_LOCAL_VAR_NAMES = Arrays.asList("targetDef", "thisJoinPointStaticPart");
    private XpandExecutionContext _ctx;
    private final TypeToBackendType _typeConverter;
    private String _definitionName;
    private int _localVarCounter = 0;

    public OldDefinitionConverter(XpandExecutionContext ctx, TypeToBackendType typeConverter) {
        this._ctx = ctx;
        this._typeConverter = typeConverter;
    }

    public AroundAdvice create(Advice a, Set<XpandDefinitionName> referencedDefinitions) {
        XpandExecutionContext oldCtx = this._ctx;
        try {
            OldExpressionConverter exprConv = new OldExpressionConverter((org.eclipse.xtend.expression.ExecutionContext)this._ctx, this._typeConverter, "<around>");
            this._ctx = (XpandExecutionContext)this._ctx.cloneWithoutVariables();
            List<String> localAdviceVarNames = ADVICE_LOCAL_VAR_NAMES;
            List<Type> localAdviceVarTypes = this.getAdviceLocalVarTypes((TypeSystem)oldCtx);
            int i = 0;
            while (i < localAdviceVarNames.size()) {
                this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(localAdviceVarNames.get(i), (Object)localAdviceVarTypes.get(i)));
                ++i;
            }
            List localVarNames = a.getParamsAsList();
            for (DeclaredParameter declaredParameter : localVarNames) {
                this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(declaredParameter.getName().getValue(), (Object)declaredParameter.getType()));
            }
            ExpressionBase body = this.convertStatementSequence(a.getBody(), (SyntaxElement)a, referencedDefinitions, null);
            AroundAdvice aroundAdvice = exprConv.convertAdvice(body, a.getPointCut().getValue(), a.getType(), Arrays.asList(a.getParams()), a.isWildcardParams());
            return aroundAdvice;
        }
        finally {
            this._ctx = oldCtx;
        }
    }

    public NamedFunction createUnregistered(XpandDefinition def, Set<XpandDefinitionName> referencedDefinitions) {
        if (def instanceof Definition) {
            String canonicalName = new XpandDefinitionName(def).getCanonicalDefinitionName();
            return new NamedFunction(new QualifiedName(canonicalName.replaceAll("/", "::")), this.createNormalDefinition((Definition)def, referencedDefinitions));
        }
        throw new IllegalArgumentException("unsupported definition type " + def.getClass().getName());
    }

    private Function createNormalDefinition(Definition def, Set<XpandDefinitionName> referencedDefinitions) {
        XpandExecutionContext oldCtx = this._ctx;
        try {
            ArrayList<String> paramNames = new ArrayList<String>();
            ArrayList<BackendType> paramTypes = new ArrayList<BackendType>();
            Type ft = this._ctx.getTypeForName(def.getTargetType());
            this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable("this", (Object)ft));
            paramNames.add("this");
            paramTypes.add(this._typeConverter.convertToBackendType(ft));
            DeclaredParameter[] declaredParameterArray = def.getParams();
            int n = declaredParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeclaredParameter dp = declaredParameterArray[n2];
                Type pt = this._ctx.getTypeForName(dp.getType().getValue());
                this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(dp.getName().getValue(), (Object)pt));
                paramNames.add(dp.getName().getValue());
                paramTypes.add(this._typeConverter.convertToBackendType(pt));
                ++n2;
            }
            SourceDefinedFunction sourceDefinedFunction = new SourceDefinedFunction(new QualifiedName(def.getFileName().replaceAll("/", "::"), def.getName()), paramNames, paramTypes, (BackendType)StringType.INSTANCE, this.convertStatementSequence(def.getBody(), (SyntaxElement)def, referencedDefinitions, null), false, null);
            return sourceDefinedFunction;
        }
        finally {
            this._ctx = oldCtx;
        }
    }

    public ExpressionBase convertStatementSequence(Statement[] statements, SyntaxElement oldPos, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        ArrayList<ExpressionBase> parts = new ArrayList<ExpressionBase>();
        Statement[] statementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement stmt = statementArray[n2];
            parts.add(this.convertStatement(stmt, referencedDefinitions, onFileCloseListener));
            ++n2;
        }
        if (parts.size() == 1) {
            return (ExpressionBase)parts.get(0);
        }
        return new ConcatExpression(parts, this.getSourcePos(oldPos));
    }

    public ExpressionBase convertStatement(Statement stmt, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        if (stmt instanceof ErrorStatement) {
            return this.convertErrorStatement((ErrorStatement)stmt);
        }
        if (stmt instanceof ExpandStatement) {
            return this.convertExpandStatement((ExpandStatement)stmt, referencedDefinitions, onFileCloseListener);
        }
        if (stmt instanceof ExpressionStatement) {
            return this.convertExpressionStatement((ExpressionStatement)stmt);
        }
        if (stmt instanceof FileStatement) {
            return this.convertFileStatement((FileStatement)stmt, referencedDefinitions);
        }
        if (stmt instanceof ForEachStatement) {
            return this.convertForEachStatement((ForEachStatement)stmt, referencedDefinitions, onFileCloseListener);
        }
        if (stmt instanceof IfStatement) {
            return this.convertIfStatement((IfStatement)stmt, referencedDefinitions, onFileCloseListener);
        }
        if (stmt instanceof LetStatement) {
            return this.convertLetStatement((LetStatement)stmt, referencedDefinitions, onFileCloseListener);
        }
        if (stmt instanceof ProtectStatement) {
            return this.convertProtectStatement((ProtectStatement)stmt, referencedDefinitions);
        }
        if (stmt instanceof TextStatement) {
            return this.convertTextStatement((TextStatement)stmt);
        }
        throw new IllegalArgumentException("unknown statement type " + stmt.getClass().getName());
    }

    private ExpressionBase convertErrorStatement(ErrorStatement stmt) {
        final ExpressionBase msg = this.convertExpression(stmt.getMessage());
        return new ExpressionBase(OldExpressionConverter.getSourcePos((SyntaxElement)stmt, (String)stmt.getFileName())){

            protected Object evaluateInternal(ExecutionContext ctx) {
                System.err.println(msg.evaluate(ctx));
                return null;
            }
        };
    }

    private ExpressionBase convertExpandStatement(ExpandStatement stmt, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        if (stmt.isForeach()) {
            ExpressionBase separator = stmt.getSeparator() != null ? this.convertExpression(stmt.getSeparator()) : null;
            ExpressionBase target = this.convertExpression(stmt.getTarget());
            String closureParamName = this.createUniqueLocalVarName();
            ArrayList<Object> params2 = new ArrayList<Object>();
            params2.add(new LocalVarEvalExpression(closureParamName, this.getSourcePos((SyntaxElement)stmt)));
            Expression[] expressionArray = stmt.getParameters();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                params2.add(this.convertExpression(e));
                ++n2;
            }
            Type rawTargetType = new OldTypeAnalyzer().analyze((org.eclipse.xtend.expression.ExecutionContext)this._ctx, stmt.getTarget());
            Type targetType = rawTargetType instanceof ParameterizedType ? ((ParameterizedType)rawTargetType).getInnerType() : this._ctx.getObjectType();
            Type[] argTypes = new Type[stmt.getParametersAsList().size()];
            int i = 0;
            while (i < stmt.getParametersAsList().size()) {
                argTypes[i] = ((Expression)stmt.getParametersAsList().get(i)).analyze((org.eclipse.xtend.expression.ExecutionContext)this._ctx, new HashSet());
                ++i;
            }
            XpandDefinitionName called = new XpandDefinitionName(stmt.getDefinition().getValue(), targetType, argTypes, this._ctx);
            referencedDefinitions.add(called);
            InvocationOnObjectExpression invocationExpression = new InvocationOnObjectExpression(new QualifiedName(called.getCanonicalDefinitionName()), params2, false, this.getSourcePos((SyntaxElement)stmt));
            InitClosureExpression loopBody = new InitClosureExpression(Arrays.asList(closureParamName), Arrays.asList(ObjectType.INSTANCE), (ExpressionBase)invocationExpression, this.getSourcePos((SyntaxElement)stmt));
            InvocationOnObjectExpression expExpr = null;
            expExpr = separator == null ? new InvocationOnObjectExpression(new QualifiedName("XpandForEach"), Arrays.asList(target, loopBody), true, this.getSourcePos((SyntaxElement)stmt)) : new InvocationOnObjectExpression(new QualifiedName("XpandForEach"), Arrays.asList(target, loopBody, separator), true, this.getSourcePos((SyntaxElement)stmt));
            if (stmt.isOnFileClose() && onFileCloseListener != null) {
                DeferredEvalExpression defExpr = new DeferredEvalExpression((ExpressionBase)expExpr, this.getSourcePos((SyntaxElement)stmt));
                onFileCloseListener.registerDeferredEvalExpression(defExpr);
                return defExpr;
            }
            return expExpr;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (stmt.getTarget() != null) {
            params.add(this.convertExpression(stmt.getTarget()));
        } else {
            params.add(new LocalVarEvalExpression("this", this.getSourcePos((SyntaxElement)stmt)));
        }
        Expression[] expressionArray = stmt.getParameters();
        int params2 = expressionArray.length;
        int closureParamName = 0;
        while (closureParamName < params2) {
            Expression e = expressionArray[closureParamName];
            params.add(this.convertExpression(e));
            ++closureParamName;
        }
        XpandDefinitionName called = new XpandDefinitionName(stmt.getDefinition().getValue(), stmt.getTarget(), stmt.getParametersAsList(), this._ctx);
        referencedDefinitions.add(called);
        InvocationOnObjectExpression expExpr = new InvocationOnObjectExpression(new QualifiedName(called.getCanonicalDefinitionName().replaceAll("/", "::")), params, true, this.getSourcePos((SyntaxElement)stmt));
        if (stmt.isOnFileClose()) {
            DeferredEvalExpression defExpr = new DeferredEvalExpression((ExpressionBase)expExpr, this.getSourcePos((SyntaxElement)stmt));
            onFileCloseListener.registerDeferredEvalExpression(defExpr);
            return defExpr;
        }
        return expExpr;
    }

    private String createUniqueLocalVarName() {
        return "$localVar_" + this._localVarCounter++;
    }

    private ExpressionBase convertExpressionStatement(ExpressionStatement stmt) {
        return this.convertExpression(stmt.getExpression());
    }

    private ExpressionBase convertForEachStatement(ForEachStatement stmt, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        ExpressionBase body;
        XpandExecutionContext oldContext = this._ctx;
        ExpressionBase separator = stmt.getSeparator() != null ? this.convertExpression(stmt.getSeparator()) : null;
        ExpressionBase target = this.convertExpression(stmt.getTarget());
        Type collType = new OldTypeAnalyzer().analyze((org.eclipse.xtend.expression.ExecutionContext)oldContext, stmt.getTarget());
        Type eleType = collType instanceof ParameterizedType ? ((ParameterizedType)collType).getInnerType() : this._ctx.getObjectType();
        String varName = stmt.getVariable().getValue();
        if (stmt.getIteratorName() == null) {
            ExpressionBase body2;
            this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(varName, (Object)eleType));
            try {
                body2 = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
            }
            finally {
                this._ctx = oldContext;
            }
            InitClosureExpression closureCreation = new InitClosureExpression(Arrays.asList(varName), Arrays.asList(this._typeConverter.convertToBackendType(eleType)), body2, this.getSourcePos((SyntaxElement)stmt));
            if (separator == null) {
                return new InvocationOnObjectExpression(new QualifiedName("XpandForEach"), Arrays.asList(target, closureCreation), true, this.getSourcePos((SyntaxElement)stmt));
            }
            return new InvocationOnObjectExpression(new QualifiedName("XpandForEach"), Arrays.asList(target, closureCreation, separator), true, this.getSourcePos((SyntaxElement)stmt));
        }
        this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(varName, (Object)eleType));
        this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(stmt.getIteratorName().getValue(), (Object)this._ctx.getTypeForName("xpand2::Iterator")));
        try {
            body = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
        }
        finally {
            this._ctx = oldContext;
        }
        List<String> paramNames = Arrays.asList(varName, stmt.getIteratorName().getValue());
        List<BackendType> paramTypes = Arrays.asList(this._typeConverter.convertToBackendType(eleType), this._typeConverter.convertToBackendType(XtendIterator.class));
        InitClosureExpression closureCreation = new InitClosureExpression(paramNames, paramTypes, body, this.getSourcePos((SyntaxElement)stmt));
        if (separator == null) {
            return new InvocationOnObjectExpression(new QualifiedName("XpandForEachWithIterator"), Arrays.asList(target, closureCreation), true, this.getSourcePos((SyntaxElement)stmt));
        }
        return new InvocationOnObjectExpression(new QualifiedName("XpandForEachWithIterator"), Arrays.asList(target, closureCreation, separator), true, this.getSourcePos((SyntaxElement)stmt));
    }

    private ExpressionBase convertIfStatement(IfStatement stmt, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        if (stmt.getCondition() != null) {
            ExpressionBase condExpr = this.convertExpression(stmt.getCondition());
            ExpressionBase ifExpr = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
            LiteralExpression elseExpr = stmt.getElseIf() != null ? this.convertStatement((Statement)stmt.getElseIf(), referencedDefinitions, onFileCloseListener) : new LiteralExpression(null, this.getSourcePos((SyntaxElement)stmt));
            return new IfExpression(condExpr, ifExpr, (ExpressionBase)elseExpr, this.getSourcePos((SyntaxElement)stmt));
        }
        return this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
    }

    private ExpressionBase convertLetStatement(LetStatement stmt, Set<XpandDefinitionName> referencedDefinitions, DeferredEvalExecutionListener onFileCloseListener) {
        String varName = stmt.getVarName().getValue();
        Type type = new OldTypeAnalyzer().analyze((org.eclipse.xtend.expression.ExecutionContext)this._ctx, stmt.getVarValue());
        XpandExecutionContext oldContext = this._ctx;
        this._ctx = (XpandExecutionContext)this._ctx.cloneWithVariable(new Variable(varName, (Object)type));
        try {
            ExpressionBase def = this.convertExpression(stmt.getVarValue());
            ExpressionBase body = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
            if (oldContext.getVisibleVariables().containsKey(varName)) {
                HidingLocalVarDefExpression hidingLocalVarDefExpression = new HidingLocalVarDefExpression(varName, def, body, this.getSourcePos((SyntaxElement)stmt));
                return hidingLocalVarDefExpression;
            }
            NewLocalVarDefExpression newLocalVarDefExpression = new NewLocalVarDefExpression(varName, def, body, this.getSourcePos((SyntaxElement)stmt));
            return newLocalVarDefExpression;
        }
        finally {
            this._ctx = oldContext;
        }
    }

    private ExpressionBase convertFileStatement(FileStatement stmt, Set<XpandDefinitionName> referencedDefinitions) {
        DeferredEvalExecutionListener onFileCloseListener = new DeferredEvalExecutionListener();
        ExpressionBase body = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, onFileCloseListener);
        body.registerExecutionListener((ExecutionListener)onFileCloseListener);
        ExpressionBase filename = this.convertExpression(stmt.getTargetFileName());
        Outlet outlet = this._ctx.getOutput().getOutlet(stmt.getOutletName());
        if (outlet == null) {
            if (stmt.getOutletName() == null) {
                throw new IllegalStateException("no default outlet was registered");
            }
            throw new IllegalStateException("no outlet for name '" + stmt.getOutletName() + "' was registered");
        }
        LiteralExpression outletName = new LiteralExpression((Object)(stmt.getOutletName() != null ? stmt.getOutletName() : "OUT"), this.getSourcePos((SyntaxElement)stmt));
        LiteralExpression append = new LiteralExpression((Object)outlet.isAppend(), this.getSourcePos((SyntaxElement)stmt));
        List emptyParamList = Collections.emptyList();
        InvocationOnObjectExpression initIsDeleteLineExpression = new InvocationOnObjectExpression(new QualifiedName("XpandInitNewScope"), emptyParamList, false, this.getSourcePos((SyntaxElement)stmt));
        InvocationOnObjectExpression postprocessIsDeleteLineExpression = new InvocationOnObjectExpression(new QualifiedName("XpandPostprocess"), Arrays.asList(body), false, this.getSourcePos((SyntaxElement)stmt));
        InvocationOnObjectExpression writeToFileExpression = new InvocationOnObjectExpression(new QualifiedName("writeToFile"), Arrays.asList(outletName, filename, append, postprocessIsDeleteLineExpression), false, this.getSourcePos((SyntaxElement)stmt));
        return new SequenceExpression(Arrays.asList(initIsDeleteLineExpression, writeToFileExpression), this.getSourcePos((SyntaxElement)stmt));
    }

    private ExpressionBase convertProtectStatement(ProtectStatement stmt, Set<XpandDefinitionName> referencedDefinitions) {
        ExpressionBase body = this.convertStatementSequence(stmt.getBody(), (SyntaxElement)stmt, referencedDefinitions, null);
        ExpressionBase id = this.convertExpression(stmt.getId());
        ExpressionBase startComment = this.convertExpression(stmt.getCommentStart());
        ExpressionBase endComment = this.convertExpression(stmt.getCommentEnd());
        LiteralExpression isDisabled = new LiteralExpression((Object)stmt.getDisable(), this.getSourcePos((SyntaxElement)stmt));
        InvocationOnObjectExpression protectExpr = new InvocationOnObjectExpression(new QualifiedName("XpandProtect"), Arrays.asList(id, startComment, endComment, isDisabled, body), true, this.getSourcePos((SyntaxElement)stmt));
        return protectExpr;
    }

    private ExpressionBase convertTextStatement(TextStatement stmt) {
        if (stmt.isDeleteLine()) {
            List emptyParamList = Collections.emptyList();
            InvocationOnObjectExpression registerExpression = new InvocationOnObjectExpression(new QualifiedName("XpandRegisterDeleteLine"), emptyParamList, false, this.getSourcePos((SyntaxElement)stmt));
            LiteralExpression markerExpression = new LiteralExpression((Object)"MARKER_FOR_XPAND_ISDELETELINE_59&21?%5&6<#_ENDMARKER", this.getSourcePos((SyntaxElement)stmt));
            LiteralExpression contentExpression = new LiteralExpression((Object)stmt.getValue(), this.getSourcePos((SyntaxElement)stmt));
            ConcatExpression concatExpression = new ConcatExpression(Arrays.asList(markerExpression, contentExpression), this.getSourcePos((SyntaxElement)stmt));
            return new SequenceExpression(Arrays.asList(registerExpression, concatExpression), this.getSourcePos((SyntaxElement)stmt));
        }
        return new LiteralExpression((Object)stmt.getValue(), this.getSourcePos((SyntaxElement)stmt));
    }

    private SourcePos getSourcePos(SyntaxElement stmt) {
        return OldExpressionConverter.getSourcePos((SyntaxElement)stmt, (String)this._definitionName);
    }

    private ExpressionBase convertExpression(Expression expr) {
        OldExpressionConverter exprConverter = new OldExpressionConverter((org.eclipse.xtend.expression.ExecutionContext)this._ctx, this._typeConverter, this._definitionName);
        return exprConverter.convert(expr);
    }

    private List<Type> getAdviceLocalVarTypes(TypeSystem ts) {
        return Arrays.asList(ts.getStringType(), ts.getStringType());
    }
}

