/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jet.internal.launch.JETProcess;

public class JET2TransformationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String id = this.getId(configuration);
        IResource source = this.getSource(configuration);
        int logFilterLevel = this.getLogFilterLevel(configuration);
        JETProcess process = new JETProcess(launch, id, source, logFilterLevel, monitor);
        launch.addProcess((IProcess)process);
        process.run();
    }

    private IResource getSource(ILaunchConfiguration configuration) throws CoreException {
        String sourcePath = configuration.getAttribute("org.eclipse.jet.source", null);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = wsRoot.findMember(sourcePath);
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        return resource;
    }

    private String getId(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("org.eclipse.jet.id", null);
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return id;
    }

    private int getLogFilterLevel(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.jet.logFilterLevel", 3);
    }
}

