/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.util.Iterator;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;

public final class TagValidationVisitor
extends JETASTVisitor {
    private final JETCompilationUnit cu;

    public TagValidationVisitor(JETCompilationUnit cu) {
        this.cu = cu;
    }

    public boolean visit(XMLBodyElement xmlBodyElement) {
        if (!xmlBodyElement.getTagDefinition().isContentAllowed()) {
            this.cu.createProblem(ProblemSeverity.ERROR, 12, JET2Messages.JET2Compiler_TagCannotHaveContent, new Object[0], xmlBodyElement.getStart(), xmlBodyElement.getEnd(), xmlBodyElement.getLine(), xmlBodyElement.getColumn());
        }
        this.validateAttributes(xmlBodyElement);
        return true;
    }

    private void validateAttributes(XMLElement xmlElement) {
        TagDefinition tagDefinition = xmlElement.getTagDefinition();
        if (tagDefinition.isDeprecated() || tagDefinition.getTagLibrary().isDeprecated()) {
            this.cu.createProblem(ProblemSeverity.WARNING, 14, JET2Messages.JET2Compiler_DeprecatedTag, new Object[0], xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
        Iterator<Object> i = xmlElement.getAttributes().keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (tagDefinition.getAttributeDefinition(attrName) != null) continue;
            this.cu.createProblem(ProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
        i = tagDefinition.getAttributeDefinitions().iterator();
        while (i.hasNext()) {
            TagAttributeDefinition tad = (TagAttributeDefinition)i.next();
            String attributeName = tad.getName();
            if (tad.isRequired() && !xmlElement.getAttributes().containsKey(attributeName)) {
                this.cu.createProblem(ProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingRequiredAttribute, new Object[]{attributeName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
            }
            if (!tad.isDeprecated() || !xmlElement.getAttributes().containsKey(attributeName)) continue;
            this.cu.createProblem(ProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attributeName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
    }

    public boolean visit(XMLEmptyElement xmlEmptyElement) {
        if (!xmlEmptyElement.getTagDefinition().isEmptyTagAllowed()) {
            this.cu.createProblem(ProblemSeverity.ERROR, 13, JET2Messages.JET2Compiler_TagRequiresContent, new Object[0], xmlEmptyElement.getStart(), xmlEmptyElement.getEnd(), xmlEmptyElement.getLine(), xmlEmptyElement.getColumn());
        }
        this.validateAttributes(xmlEmptyElement);
        return true;
    }
}

