/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;

public final class JMergeUtil {
    private JMergeUtil() {
    }

    public static Writer mergeFileContent(File target, String content, boolean previewMode, String oldContent) throws IOException {
        StringWriter newWriter = null;
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            FileWriter writer = new FileWriter(target);
            writer.append(content);
            writer.close();
        }
        String newContent = content;
        if (target.getName().endsWith(".java")) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
            if (model.canMerge()) {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(content));
                if (!previewMode) {
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(target)));
                } else {
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForContents(oldContent));
                }
                jMerger.merge();
                newContent = jMerger.getTargetCompilationUnit().getContents();
            }
        }
        if (!previewMode) {
            FileWriter writer = new FileWriter(target);
            writer.append(newContent);
            writer.close();
        } else {
            newWriter = new StringWriter();
            ((Writer)newWriter).append(newContent);
            ((Writer)newWriter).flush();
        }
        return newWriter;
    }
}

