/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.text.MessageFormat;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.CustomTagFactory;
import org.eclipse.jet.internal.runtime.DoNothingRuntimeTagElement;
import org.eclipse.jet.internal.runtime.SafeConditionalRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeContainerRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeEmptyRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeFunctionRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeIteratingRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeOtherRuntimeTag;
import org.eclipse.jet.taglib.ConditionalTag;
import org.eclipse.jet.taglib.ContainerTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.EmptyTag;
import org.eclipse.jet.taglib.FunctionTag;
import org.eclipse.jet.taglib.IteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.OtherTag;
import org.eclipse.jet.taglib.RuntimeTagElement;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagFactory;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;

public class TagFactoryImpl
implements TagFactory {
    private final JET2Context context;

    public TagFactoryImpl(JET2Context context) {
        this.context = context;
    }

    public RuntimeTagElement createRuntimeTag(String libraryId, String tagNCName, String tagQName, TagInfo tagInfo) {
        TagLibrary tagLibrary = TagLibraryManager.getInstance().getTagLibrary(libraryId, false);
        if (tagLibrary == null) {
            String msg = JET2Messages.TagFactoryImpl_TagCreateFailed;
            this.context.logError(tagInfo, MessageFormat.format(msg, tagNCName, libraryId), null);
            return new DoNothingRuntimeTagElement();
        }
        try {
            TagDefinition tagDefinition = tagLibrary.getTagDefinition(tagNCName);
            if (tagDefinition instanceof CustomTagFactory) {
                CustomTag newCustomTag = ((CustomTagFactory)tagDefinition).newTagElement();
                CustomTagKind kind = newCustomTag.getKind();
                if (kind == CustomTagKind.CONDITIONAL) {
                    return new SafeConditionalRuntimeTag((ConditionalTag)newCustomTag);
                }
                if (kind == CustomTagKind.EMPTY) {
                    return new SafeEmptyRuntimeTag((EmptyTag)newCustomTag);
                }
                if (kind == CustomTagKind.FUNCTION) {
                    return new SafeFunctionRuntimeTag((FunctionTag)newCustomTag);
                }
                if (kind == CustomTagKind.ITERATING) {
                    return new SafeIteratingRuntimeTag((IteratingTag)newCustomTag);
                }
                if (kind == CustomTagKind.OTHER) {
                    return new SafeOtherRuntimeTag((OtherTag)newCustomTag);
                }
                if (kind == CustomTagKind.CONTAINER) {
                    return new SafeContainerRuntimeTag((ContainerTag)newCustomTag);
                }
            }
        }
        catch (JET2TagException e) {
            String msg = JET2Messages.TagFactoryImpl_TagCreateFailed;
            this.context.logError(tagInfo, MessageFormat.format(msg, tagNCName, libraryId), (Throwable)e);
        }
        return new DoNothingRuntimeTagElement();
    }
}

