/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jet.internal.InternalJET2Platform;

public class SavedStateManager
implements ISaveParticipant {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/savedState")) != false;
    private ISavedState savedState;
    private final Map stateSaverByProject = new HashMap();
    private final Plugin plugin;
    private boolean needNewSaveNumber = true;

    public SavedStateManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void doneSaving(ISaveContext context) {
        if (context.getKind() == 1) {
            File stateDir;
            int previousSaveNumber = context.getPreviousSaveNumber();
            Path saveDirectory = this.getSaveDirectory(previousSaveNumber);
            IPath location = this.plugin.getStateLocation().append((IPath)saveDirectory);
            File file = location.toFile();
            if (file.exists()) {
                this.deleteDirectory(file);
            }
            if ((stateDir = this.plugin.getStateLocation().toFile()).exists() && stateDir.isDirectory()) {
                final String currentSaveDirectory = this.getSaveDirectory(context.getSaveNumber()).toString();
                File[] orphanedSaveDirs = stateDir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("save-") && !name.equals(currentSaveDirectory);
                    }
                });
                int i = 0;
                while (i < orphanedSaveDirs.length) {
                    this.deleteDirectory(orphanedSaveDirs[i]);
                    ++i;
                }
            }
        }
    }

    private void deleteDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            dir.delete();
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        switch (context.getKind()) {
            case 1: {
                this.doFullSave(context, this.stateSaverByProject.values());
                break;
            }
            case 3: {
                IProject project = context.getProject();
                this.stateSaverByProject.remove(project);
                break;
            }
        }
    }

    private void doFullSave(ISaveContext context, Collection projectSavers) throws CoreException {
        Iterator i = projectSavers.iterator();
        while (i.hasNext()) {
            WeakReference ref = (WeakReference)i.next();
            IStateSaver saver = (IStateSaver)ref.get();
            if (saver == null) continue;
            this.doProjectSave(context, saver);
        }
        this.needNewSaveNumber = true;
    }

    private void doProjectSave(ISaveContext context, IStateSaver saver) throws CoreException {
        if (this.needNewSaveNumber) {
            context.needSaveNumber();
            this.needNewSaveNumber = false;
        }
        IPath logicalPath = this.getLogicalStatePath(saver);
        IPath realPath = this.getActualPath(logicalPath, context.getSaveNumber());
        context.map(logicalPath, realPath);
        IPath location = this.plugin.getStateLocation().append(realPath);
        saver.doSave(location);
    }

    private IPath getActualPath(IPath logicalPath, int saveNumber) {
        Path saveDirPath = this.getSaveDirectory(saveNumber);
        IPath realPath = saveDirPath.append(logicalPath);
        return realPath;
    }

    private IPath getLogicalStatePath(IStateSaver saver) {
        IPath logicalPath = new Path(saver.getProject().getName()).append(saver.getStateFileName());
        return logicalPath;
    }

    private Path getSaveDirectory(int saveNumber) {
        return new Path("save-" + Integer.toString(saveNumber));
    }

    public void startup() {
        if (DEBUG) {
            System.out.println("SavedStateManager.startup()");
        }
        try {
            this.savedState = ResourcesPlugin.getWorkspace().addSaveParticipant(this.plugin, (ISaveParticipant)this);
            if (DEBUG && this.savedState != null) {
                System.out.println("   found saved state: " + this.savedState.getSaveNumber());
            }
        }
        catch (CoreException coreException) {
            this.savedState = null;
        }
    }

    public void shutdown() {
        if (DEBUG) {
            System.out.println("SavedStateManager.shutdown()");
        }
        ResourcesPlugin.getWorkspace().removeSaveParticipant(this.plugin);
    }

    public IPath addSaveSaver(IStateSaver saver, IProject project) {
        this.stateSaverByProject.put(project, new WeakReference<IStateSaver>(saver));
        IPath initialLocation = null;
        if (this.savedState != null) {
            int saveNumber = this.savedState.getSaveNumber();
            IPath realPath = this.getActualPath(this.getLogicalStatePath(saver), saveNumber);
            initialLocation = this.plugin.getStateLocation().append(realPath);
        }
        if (DEBUG) {
            System.out.println("SavedStateManager.addSaveSaver(): " + project + ", " + initialLocation);
        }
        return initialLocation;
    }

    public static interface IStateSaver {
        public String getStateFileName();

        public void doSave(IPath var1) throws CoreException;

        public IProject getProject();
    }
}

