/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrace {
    protected int currentOffset;
    protected final LinkedHashMap<InputElement, Set<GeneratedText>> traces = new LinkedHashMap();

    public void addTrace(InputElement input, GeneratedText trace, Object value) {
        Set<GeneratedText> referredTraces = this.traces.get(input);
        if (referredTraces == null) {
            referredTraces = new LinkedHashSet<GeneratedText>();
            this.traces.put(input, referredTraces);
        }
        String stringValue = value.toString();
        int startOffset = this.currentOffset;
        this.currentOffset += stringValue.length();
        trace.setSourceElement(input);
        trace.setStartOffset(startOffset);
        trace.setEndOffset(this.currentOffset);
        referredTraces.add(trace);
    }

    public void dispose() {
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : this.traces.entrySet()) {
            entry.getValue().clear();
        }
        this.traces.clear();
    }

    public LinkedHashMap<InputElement, Set<GeneratedText>> getTraces() {
        return new LinkedHashMap<InputElement, Set<GeneratedText>>(this.traces);
    }

    public void setOffset(int offset) {
        this.currentOffset = offset;
    }
}

