/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example.AbstractM2TContentStrategy;

public class XpandContentStrategy
extends AbstractM2TContentStrategy {
    public String getDescription() {
        return AcceleoUIMessages.getString("XpandContentStrategy.Description");
    }

    public String getInitialFileNameFilter() {
        return "*.xpt";
    }

    protected void modifyM2TContent(StringBuffer text, String moduleName) {
        int end;
        int offset = text.indexOf("/*");
        if (offset > -1 && (end = text.indexOf("*/", offset)) > -1) {
            text.replace(offset, end + 2, "[comment " + text.substring(offset + 2, end) + "/]");
        }
        String[] mappings = this.getMappings(moduleName);
        int i = 0;
        while (i < mappings.length - 1) {
            String initialString = mappings[i];
            String replacingString = mappings[i + 1];
            this.replaceAll(text, initialString, replacingString);
            i += 2;
        }
        this.modifyTemplateInvocation(text, "\\[[a-zA-Z_\\:]+");
        this.modifyTemplateInvocation(text, "\\.a-zA-Z_\\:]+");
    }

    private String[] getMappings(String moduleName) {
        return new String[]{"-\u00bb\\n", "\u00bb", "\u00ab IMPORT \"*\" \u00bb \u00ab IMPORT \"*\" \u00bb \u00ab IMPORT \"*\" \u00bb", "[module " + moduleName + "('$1', '$2', '$3')/]", "\u00ab IMPORT \"*\" \u00bb \u00ab IMPORT \"*\" \u00bb", "[module " + moduleName + "('$1', '$2')/]", "\u00ab IMPORT \"*\" \u00bb\\n", "[module " + moduleName + "('$1')/]", "\u00ab EXTENSION * \u00bb\\n", "[import $1/]", "\u00ab DEFINE * ( * ) FOR * :: * \u00bb\\n", "[template public $1 (v$4 : $4, $2)]", "\u00ab DEFINE * ( * ) FOR * \u00bb\\n", "[template public $1 (v$3 : EObject, $2)]", "\u00ab DEFINE * FOR * :: * \u00bb\\n", "[template public $1 (v$3 : $3)]", "\u00ab DEFINE * FOR * \u00bb\\n", "[template public $1 (v$2 : EObject)]", "\u00ab ENDDEFINE \u00bb\\n", "[/template]", "\u00ab FOREACH * AS * \u00bb\\n", "[for ($2 : EObject | $1)]", "\u00ab ENDFOREACH \u00bb\\n", "[/for]", "\u00ab IF * \u00bb\\n", "[if ($1)]", "\u00ab ELSE IF * \u00bb\\n", "[else if ($1)]", "\u00ab ELSE * \u00bb\\n", "[else]", "\u00ab ENDIF \u00bb\\n", "[/if]", "\u00ab LET * AS * \u00bb\\n", "[let $2 : EObject = $1]", "\u00ab ENDLET \u00bb\\n", "[/let]", "\u00ab REM \u00bb * \u00ab ENDREM \u00bb", "[comment $1 /]", "\u00ab EXPAND * \u00bb\\n", "[$1/]", "\u00ab * \u00bb\\n", "[$1/]", "[*\"*\"*\"*\"*]\\n", "[$1'$2'$3'$4'$5]", "[*\"*\"*]\\n", "[$1'$2'$3]"};
    }

    private void modifyTemplateInvocation(StringBuffer text, String pattern) {
        Pattern p = Pattern.compile(String.valueOf(pattern) + "[ ]*/\\]");
        Matcher m = p.matcher(text);
        int offset = 0;
        while (offset > -1 && m.find(offset)) {
            Pattern pDeclare;
            Matcher mDeclare;
            int b = m.start();
            offset = m.end();
            String string = text.substring(b, offset).trim();
            Pattern pID = Pattern.compile("[a-zA-Z_\\:]+");
            Matcher mID = pID.matcher(string);
            if (mID.find()) {
                string = string.substring(mID.start(), mID.end());
            }
            if (string.lastIndexOf(":") > -1) {
                string = string.substring(string.lastIndexOf(":") + 1);
            }
            if (!(mDeclare = (pDeclare = Pattern.compile("public[ \t]+" + string + "[ \t]*\\(")).matcher(text)).find()) continue;
            text.insert(offset - 2, "()");
        }
    }
}

