/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.prefs;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class AcceleoCompilerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IAdaptable element;
    private Button strictCompliance;

    public AcceleoCompilerPage() {
        this.setDescription(AcceleoUIMessages.getString("AcceleoCompilerPage.Description"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if (this.strictCompliance.getSelection()) {
                settings.setCompliance("strict");
            } else {
                settings.setCompliance("pragmatic");
            }
            try {
                settings.save();
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createComplianceGroup(composite);
        return composite;
    }

    private void createComplianceGroup(Composite parent) {
        this.strictCompliance = new Button(parent, 32);
        this.strictCompliance.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.StrictMTLCompliance"));
        GridData gridData = new GridData();
        this.strictCompliance.setLayoutData((Object)gridData);
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("strict" == settings.getCompliance()) {
                this.strictCompliance.setSelection(true);
            } else if ("pragmatic" == settings.getCompliance()) {
                this.strictCompliance.setSelection(false);
            } else {
                this.strictCompliance.setSelection(false);
            }
        } else {
            this.strictCompliance.setSelection(false);
        }
    }
}

