/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.ocl.OclQvtoPlugin;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LegacyNativeLibSupport;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibrariesRegistry;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNativeLibraryProviderAdapter
extends AbstractBlackboxProvider {
    protected String getProviderID() {
        return "legacy";
    }

    public List<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext loadContext) {
        LibrariesRegistry registry = OclQvtoPlugin.getDefault().getLibrariesRegistry();
        Collection<Library> rawLibs = registry.getLibraries();
        ArrayList<AbstractCompilationUnitDescriptor> libDescriptors = new ArrayList<AbstractCompilationUnitDescriptor>(rawLibs.size());
        for (Library lib : rawLibs) {
            libDescriptors.add(new LibraryDescriptor(lib));
        }
        return libDescriptors;
    }

    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        LibrariesRegistry registry = OclQvtoPlugin.getDefault().getLibrariesRegistry();
        Library library = registry.getLibrary(qualifiedName);
        if (library != null) {
            return new LibraryDescriptor(library);
        }
        return null;
    }

    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (!(descriptor instanceof LibraryDescriptor)) {
            throw new IllegalArgumentException("Descriptor not recognized by provider");
        }
        try {
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)descriptor;
            return this.createCompilationUnit(LegacyNativeLibSupport.INSTANCE.defineLibrary(libraryDescriptor.fLibrary));
        }
        catch (LibraryCreationException e) {
            new BlackboxException(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private class LibraryDescriptor
    extends AbstractCompilationUnitDescriptor {
        private Library fLibrary;

        protected LibraryDescriptor(Library library) {
            super((AbstractBlackboxProvider)LegacyNativeLibraryProviderAdapter.this, library.getId());
            this.fLibrary = library;
        }

        public String getDescription() {
            return this.fLibrary.getLibraryClassName();
        }
    }
}

