/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleCommentBlock
implements IEditorActionDelegate {
    public void run(IAction action) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart part = page.getActiveEditor();
        if (!(part instanceof AbstractTextEditor)) {
            return;
        }
        ITextEditor editor = (ITextEditor)part;
        ISelectionProvider sp = editor.getSelectionProvider();
        ISelection selection = sp.getSelection();
        ITextSelection text = (ITextSelection)selection;
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        if (text.getText().startsWith("--")) {
            this.shiftLeft(text.getStartLine(), text.getEndLine(), new String[]{"--"}, false, doc);
        } else {
            this.shiftRight(text.getStartLine(), text.getEndLine(), "--", doc);
        }
    }

    private void shiftLeft(int startLine, int endLine, String[] prefixes, boolean ignoreWhitespace, IDocument d) {
        try {
            IRegion[] occurrences = new IRegion[endLine - startLine + 1];
            int i = 0;
            while (i < occurrences.length) {
                int length;
                IRegion line = d.getLineInformation(startLine + i);
                String text = d.get(line.getOffset(), line.getLength());
                int index = -1;
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] != -1) {
                    if (ignoreWhitespace) {
                        String s = d.get(line.getOffset(), found[0]);
                        if ((s = s.trim()).length() == 0) {
                            index = line.getOffset() + found[0];
                        }
                    } else if (found[0] == 0) {
                        index = line.getOffset();
                    }
                }
                if (index > -1) {
                    length = prefixes[found[1]].length();
                    if (length == 0 && !ignoreWhitespace && line.getLength() > 0) {
                        return;
                    }
                } else {
                    return;
                }
                occurrences[i] = new Region(index, length);
                ++i;
            }
            int decrement = 0;
            int i2 = 0;
            while (i2 < occurrences.length) {
                IRegion r = occurrences[i2];
                d.replace(r.getOffset() - decrement, r.getLength(), "");
                decrement += r.getLength();
                ++i2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void shiftRight(int startLine, int endLine, String prefix, IDocument d) {
        try {
            while (startLine <= endLine) {
                d.replace(d.getLineOffset(startLine++), 0, prefix);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }
}

