/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtil {
    private SignatureUtil() {
    }

    public static String getPackageSignature(EcoreEnvironment env, EPackage ePackage) {
        String qname = env.getUMLReflection().getQualifiedName((Object)ePackage);
        if (qname != null) {
            return String.valueOf(qname) + " - " + EcoreUtil.getURI((EObject)ePackage);
        }
        return ePackage.getName();
    }

    public static String getOperationSignature(EcoreEnvironment env, EOperation operation) {
        StringBuilder result = new StringBuilder();
        result.append(env.getUMLReflection().getName((Object)operation));
        result.append('(');
        Iterator iter = env.getUMLReflection().getParameters((Object)operation).iterator();
        while (iter.hasNext()) {
            EParameter next = (EParameter)iter.next();
            if (env.getUMLReflection().getOCLType((Object)next) != null) {
                result.append(SignatureUtil.getTypedElementSignature(env, (ETypedElement)next));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        EClassifier returnType = (EClassifier)env.getUMLReflection().getOCLType((Object)operation);
        if (returnType == null) {
            result.append(')');
        } else {
            result.append(") : ");
            result.append(env.getUMLReflection().getQualifiedName((Object)returnType));
        }
        EClassifier owner = (EClassifier)env.getUMLReflection().getOwningClassifier((Object)operation);
        if (owner != null) {
            result.append(" - ");
            result.append(env.getUMLReflection().getQualifiedName((Object)owner));
        }
        return result.toString();
    }

    public static String getTypedElementSignature(EcoreEnvironment env, ETypedElement typedElement) {
        StringBuilder result = new StringBuilder();
        result.append(env.getUMLReflection().getName((Object)typedElement));
        result.append(" : ");
        EClassifier eType = (EClassifier)env.getUMLReflection().getOCLType((Object)typedElement);
        if (eType != null) {
            if (SignatureUtil.isStdLibType(env, eType)) {
                result.append(env.getUMLReflection().getName((Object)eType));
            } else {
                result.append(env.getUMLReflection().getQualifiedName((Object)eType));
            }
        }
        return result.toString();
    }

    public static String getVariableSignature(EcoreEnvironment env, Variable<EClassifier, EParameter> typedElement) {
        StringBuilder result = new StringBuilder();
        result.append(typedElement.getName());
        result.append(" : ");
        EClassifier eType = (EClassifier)env.getUMLReflection().getOCLType(typedElement.getType());
        if (eType != null) {
            if (SignatureUtil.isStdLibType(env, eType)) {
                result.append(env.getUMLReflection().getName((Object)eType));
            } else {
                result.append(env.getUMLReflection().getQualifiedName((Object)eType));
            }
        }
        return result.toString();
    }

    public static boolean isStdLibType(EcoreEnvironment env, EClassifier type) {
        return type instanceof PredefinedType;
    }

    public static String getPropertySignature(EStructuralFeature feature, EcoreEnvironment env) {
        if (feature != null) {
            String owner = null;
            String type = null;
            if (feature.getEContainingClass() != null && env != null) {
                UMLReflection uml = env.getUMLReflection();
                owner = uml.getQualifiedName(uml.getOCLType((Object)feature.getEContainingClass()));
                type = uml.getQualifiedName(uml.getOCLType((Object)feature));
            }
            return String.valueOf(feature.getName()) + " : " + type + " - " + owner;
        }
        return null;
    }
}

