/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.common.emf.ExtendedEmfUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.common.TraceWorkbenchPart;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.editor.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.EObjectNode;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

public class TraceEditorPart
extends EditorPart
implements IGotoMarker {
    private final TraceWorkbenchPart myTraceWorkbenchPart = new TraceWorkbenchPart((IWorkbenchPart)this);
    private Trace myTrace;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(NLS.bind((String)Messages.TraceEditorPart_InvalidInput, (Object)input));
        }
        IFileEditorInput inp = (IFileEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.setInput(input);
        this.myTrace = this.initTrace(inp.getFile());
    }

    public void createPartControl(Composite parent) {
        this.myTraceWorkbenchPart.createPartControl(parent);
        this.myTraceWorkbenchPart.setInput(this.myTrace);
    }

    public void setFocus() {
        if (!this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().setFocus();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public TreeViewer getViewer() {
        return this.myTraceWorkbenchPart.getViewer();
    }

    public void gotoMarker(IMarker marker) {
        try {
            EObject eObject;
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.m2m.qvt.oml.qvtProblem") && (uriAttribute = marker.getAttribute("uri", null)) != null && (eObject = this.myTrace.eResource().getEObject(uriAttribute)) != null) {
                this.myTraceWorkbenchPart.setSelection(new EObjectNode((Object)eObject.eContainer(), eObject));
            }
        }
        catch (CoreException coreException) {}
    }

    private Trace initTrace(IFile file) throws PartInitException {
        EObject eObject = ExtendedEmfUtil.loadModel((CFile)new EclipseFile(file));
        if (!(eObject instanceof Trace)) {
            throw new PartInitException(NLS.bind((String)Messages.TraceEditorPart_LoadingFailed, (Object)file.getFullPath()));
        }
        return (Trace)eObject;
    }
}

