/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.migration.AbstractImportsManager;

public class StandardLibraryImports
extends AbstractImportsManager {
    private static final String GLOBAL_VAR_LIBRARY_NAME = "xpt::GlobalVarOperations";
    private static final Map<EOperation, MapEntry> operationsMap = new HashMap<EOperation, MapEntry>();
    private Set<String> usedLibraries = new LinkedHashSet<String>();

    static {
        operationsMap.put(BuiltinMetaModel.EString_ToFirstUpper, MapEntry.newEntry("firstToUpper"));
        operationsMap.put(BuiltinMetaModel.EString_ToFirstLower, MapEntry.newStringLibEntry("xpandToFirstLower"));
        operationsMap.put(BuiltinMetaModel.EString_SubString_StartEnd, MapEntry.newEntry("substring"));
        operationsMap.put(BuiltinMetaModel.EString_SubString, MapEntry.newStringLibEntry("xpandSubstring"));
        operationsMap.put(BuiltinMetaModel.EString_ToUpperCase, MapEntry.newEntry("toUpper"));
        operationsMap.put(BuiltinMetaModel.EString_ToLowerCase, MapEntry.newEntry("toLower"));
        operationsMap.put(BuiltinMetaModel.EString_ReplaceFirst, MapEntry.newStringLibEntry("xpandReplaceFirst"));
        operationsMap.put(BuiltinMetaModel.EString_ToCharList, MapEntry.newStringLibEntry("xpandToCharList"));
        operationsMap.put(BuiltinMetaModel.EString_ReplaceAll, MapEntry.newStringLibEntry("xpandReplaceAll"));
        operationsMap.put(BuiltinMetaModel.EString_Split, MapEntry.newStringLibEntry("xpandSplit"));
        operationsMap.put(BuiltinMetaModel.EString_Matches, MapEntry.newStringLibEntry("xpandMatches"));
        operationsMap.put(BuiltinMetaModel.EString_StartsWith, MapEntry.newEntry("startsWith"));
        operationsMap.put(BuiltinMetaModel.EString_EndsWith, MapEntry.newEntry("endsWith"));
        operationsMap.put(BuiltinMetaModel.EString_Length, MapEntry.newEntry("size"));
        operationsMap.put(BuiltinMetaModel.Object_CompareTo, MapEntry.newOclAnyLibEntry("xpandCompareTo"));
        operationsMap.put(BuiltinMetaModel.Object_ToString, MapEntry.newEntry("repr"));
        operationsMap.put(BuiltinMetaModel.Int_Div_Int, MapEntry.newEntry("div"));
        operationsMap.put(BuiltinMetaModel.Int_UpTo, MapEntry.newIntegerLibEntry("xpandUpTo"));
    }

    public StandardLibraryImports(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    public StandardLibraryImports(int placeholder) {
        super(placeholder);
    }

    public String[] getLibraries() {
        return this.usedLibraries.toArray(new String[this.usedLibraries.size()]);
    }

    String getOperationName(EOperation eOperation) {
        if (operationsMap.containsKey(eOperation)) {
            MapEntry entry = operationsMap.get(eOperation);
            if (entry.isLibraryOperation()) {
                this.usedLibraries.add(entry.getLibraryName());
            }
            return entry.getQvtOperationName();
        }
        return null;
    }

    public String getXpandGetObjectGlobalVarOperationName() {
        this.usedLibraries.add(GLOBAL_VAR_LIBRARY_NAME);
        return "xpandGetObjectGlobalVar";
    }

    public CharSequence getXpandGetStringGlobalVarOperationName() {
        this.usedLibraries.add(GLOBAL_VAR_LIBRARY_NAME);
        return "xpandGetStringGlobalVar";
    }

    void registerNativeLibrary(String libraryName) {
        this.usedLibraries.add(libraryName);
    }

    private static class MapEntry {
        private static final String STRING_LIBRARY_NAME = "xpt::StringOperations";
        private static final String OCLANY_LIBRARY_NAME = "xpt::OclAnyOperations";
        private static final String INTEGER_LIBRARY_NAME = "xpt::IntegerOperations";
        private String qvtOperationName;
        private String libraryName;

        public static MapEntry newEntry(String qvtOperationName) {
            return new MapEntry(qvtOperationName);
        }

        public static MapEntry newStringLibEntry(String qvtOperationName) {
            return new MapEntry(qvtOperationName, STRING_LIBRARY_NAME);
        }

        public static MapEntry newOclAnyLibEntry(String qvtOperationName) {
            return new MapEntry(qvtOperationName, OCLANY_LIBRARY_NAME);
        }

        public static MapEntry newIntegerLibEntry(String qvtOperationName) {
            return new MapEntry(qvtOperationName, INTEGER_LIBRARY_NAME);
        }

        private MapEntry(String qvtOperationName) {
            this.qvtOperationName = qvtOperationName;
        }

        private MapEntry(String qvtOperationName, String libraryName) {
            this(qvtOperationName);
            this.libraryName = libraryName;
        }

        public String getQvtOperationName() {
            return this.qvtOperationName;
        }

        public boolean isLibraryOperation() {
            return this.libraryName != null;
        }

        public String getLibraryName() {
            return this.libraryName;
        }
    }
}

