/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.annotated;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.DesignLabelMapping;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.annotated.AbstractASetup;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.ToolRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDefASetup
extends AbstractASetup
implements MapDefSource {
    protected EPackage ePackage;
    protected Mapping mapping;
    protected ToolRegistry registry;
    protected Canvas canvas;
    protected Map<EClass, List<ChildReference>> nodeMappings;
    protected Map<EClass, List<CompartmentMapping>> compartmentMappings;
    protected Map<EClass, List<FeatureLabelMapping>> labelMappings;

    public MapDefASetup(EPackage ePackage, ToolRegistry registry, Canvas canvas) {
        this.ePackage = ePackage;
        this.registry = registry;
        this.canvas = canvas;
    }

    @Override
    protected Iterator<EObject> getAllDomainModelContents() {
        return this.ePackage.eAllContents();
    }

    protected void createMapping() {
        this.nodeMappings = new HashMap<EClass, List<ChildReference>>();
        this.compartmentMappings = new HashMap<EClass, List<CompartmentMapping>>();
        this.labelMappings = new HashMap<EClass, List<FeatureLabelMapping>>();
        this.mapping = GMFMapFactory.eINSTANCE.createMapping();
        this.processDomainModel();
        List<ChildReference> refs = this.nodeMappings.remove(this.mapping.getDiagram().getDomainMetaElement());
        if (refs != null) {
            for (ChildReference ref : refs) {
                TopNodeReference tref = GMFMapFactory.eINSTANCE.createTopNodeReference();
                tref.setContainmentFeature(ref.getContainmentFeature());
                tref.setOwnedChild(ref.getOwnedChild());
                this.mapping.getNodes().add((Object)tref);
                List<CompartmentMapping> compartments = this.compartmentMappings.remove(tref.getOwnedChild().getDomainMetaElement());
                if (compartments != null) {
                    tref.getOwnedChild().getCompartments().addAll(compartments);
                }
                this.unwindNodeMappings(tref.getOwnedChild());
            }
        }
        assert (this.nodeMappings.isEmpty()) : "Inconsistent gmf annotations (nodes)";
        TreeIterator it = this.mapping.eAllContents();
        while (it.hasNext()) {
            MappingEntry entry;
            List<FeatureLabelMapping> list;
            Object next = it.next();
            if (!(next instanceof MappingEntry) || (list = this.labelMappings.remove((entry = (MappingEntry)next).getDomainMetaElement())) == null) continue;
            for (FeatureLabelMapping lmapping : list) {
                entry.getLabelMappings().add((Object)lmapping);
            }
        }
        assert (this.labelMappings.isEmpty()) : "Inconsistent gmf annotations (labels)";
    }

    protected void unwindNodeMappings(NodeMapping parent) {
        List<ChildReference> refs = this.nodeMappings.remove(parent.getDomainMetaElement());
        if (refs != null) {
            for (ChildReference ref : refs) {
                parent.getChildren().add((Object)ref);
                List<CompartmentMapping> compartments = this.compartmentMappings.remove(ref.getOwnedChild().getDomainMetaElement());
                if (compartments != null) {
                    ref.getOwnedChild().getCompartments().addAll(compartments);
                }
                this.unwindNodeMappings(ref.getOwnedChild());
                CompartmentMapping cmapping = this.findCompartment(parent, ref.getOwnedChild());
                if (cmapping == null) continue;
                ref.setCompartment(cmapping);
            }
        }
    }

    protected CompartmentMapping findCompartment(NodeMapping parent, NodeMapping child) {
        List<AbstractASetup.Parameter> params = this.getParameters((EModelElement)child.getDomainMetaElement());
        for (AbstractASetup.Parameter param : params) {
            if (!"in".equals(param.name)) continue;
            String comparmtentName = param.value;
            assert (comparmtentName != null);
            for (CompartmentMapping cmapping : parent.getCompartments()) {
                if (!cmapping.getCompartment().getName().equals(comparmtentName)) continue;
                return cmapping;
            }
        }
        return null;
    }

    @Override
    protected void processCanvas(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        CanvasMapping cmapping = GMFMapFactory.eINSTANCE.createCanvasMapping();
        cmapping.setDomainModel(this.ePackage);
        cmapping.setDomainMetaElement((EClass)element);
        cmapping.setPalette(this.registry.getPalette());
        cmapping.setDiagramCanvas(this.canvas);
        this.mapping.setDiagram(cmapping);
    }

    @Override
    protected void processNode(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        name = this.getName(element, name);
        EReference containment = this.findReferenceByQName(this.ePackage, params, "containment");
        assert (((EClass)containment.getEType()).isSuperTypeOf((EClass)element)) : "Containment feature should contain instances of node class";
        ChildReference ref = GMFMapFactory.eINSTANCE.createChildReference();
        ref.setContainmentFeature(containment);
        NodeMapping nmapping = GMFMapFactory.eINSTANCE.createNodeMapping();
        nmapping.setDomainMetaElement((EClass)element);
        nmapping.setTool((AbstractTool)this.findCreationTool(element, name));
        nmapping.setDiagramNode(this.findNode(element, name));
        ref.setOwnedChild(nmapping);
        List<ChildReference> refs = this.nodeMappings.get(containment.getEContainingClass());
        if (refs == null) {
            refs = new ArrayList<ChildReference>();
            this.nodeMappings.put(containment.getEContainingClass(), refs);
        }
        refs.add(ref);
    }

    @Override
    protected void processCompartment(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        assert (name != null);
        CompartmentMapping cmapping = GMFMapFactory.eINSTANCE.createCompartmentMapping();
        cmapping.setCompartment(this.findCompartment(element, name));
        assert (element instanceof EClass);
        List<CompartmentMapping> list = this.compartmentMappings.get(element);
        if (list == null) {
            list = new ArrayList<CompartmentMapping>();
            this.compartmentMappings.put((EClass)element, list);
        }
        list.add(cmapping);
    }

    @Override
    protected void processLink(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        name = this.getName(element, name);
        LinkMapping lmapping = GMFMapFactory.eINSTANCE.createLinkMapping();
        if (element instanceof EClass) {
            EClass type = (EClass)element;
            lmapping.setDomainMetaElement(type);
            lmapping.setContainmentFeature(this.findReferenceByQName(this.ePackage, params, "containment"));
            lmapping.setSourceMetaFeature((EStructuralFeature)this.findReference(type, "source"));
            lmapping.setLinkMetaFeature((EStructuralFeature)this.findReference(type, "target"));
        } else {
            lmapping.setLinkMetaFeature((EStructuralFeature)((EReference)element));
        }
        lmapping.setTool((AbstractTool)this.findCreationTool(element, name));
        lmapping.setDiagramLink(this.findConnection(element, name));
        this.mapping.getLinks().add((Object)lmapping);
    }

    @Override
    protected void processLabel(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        name = this.getName(element, name);
        EAttribute attr = (EAttribute)element;
        FeatureLabelMapping lmapping = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
        lmapping.getFeatures().add((Object)attr);
        lmapping.setDiagramLabel(this.findLabel(element, name));
        List<FeatureLabelMapping> list = this.labelMappings.get(attr.getEContainingClass());
        if (list == null) {
            list = new ArrayList<FeatureLabelMapping>();
            this.labelMappings.put(attr.getEContainingClass(), list);
        }
        list.add(lmapping);
    }

    protected CreationTool findCreationTool(EModelElement element, String name) {
        TreeIterator it = this.registry.eAllContents();
        while (it.hasNext()) {
            CreationTool tool;
            EObject next = (EObject)it.next();
            if (!(next instanceof CreationTool) || !name.equals((tool = (CreationTool)next).getTitle())) continue;
            return tool;
        }
        return null;
    }

    protected Node findNode(EModelElement element, String name) {
        for (Node node : this.canvas.getNodes()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    protected Compartment findCompartment(EModelElement element, String name) {
        for (Compartment compartment : this.canvas.getCompartments()) {
            if (!name.equals(compartment.getName())) continue;
            return compartment;
        }
        return null;
    }

    protected Connection findConnection(EModelElement element, String name) {
        for (Connection connection : this.canvas.getConnections()) {
            if (!name.equals(connection.getName())) continue;
            return connection;
        }
        return null;
    }

    protected DiagramLabel findLabel(EModelElement element, String name) {
        for (DiagramLabel label : this.canvas.getLabels()) {
            if (!name.equals(label.getName())) continue;
            return label;
        }
        return null;
    }

    public void detachFromDomainModel() {
        Mapping mapping = this.getMapping();
        mapping.getDiagram().setDomainModel(null);
        mapping.getDiagram().setDomainMetaElement(null);
        for (TopNodeReference tref : mapping.getNodes()) {
            tref.setContainmentFeature(null);
            tref.setChildrenFeature(null);
            this.detachNodeMapping(tref.getOwnedChild());
        }
        for (LinkMapping linkMapping : mapping.getLinks()) {
            linkMapping.setContainmentFeature(null);
            linkMapping.setDomainMetaElement(null);
            linkMapping.setLinkMetaFeature(null);
            linkMapping.setSourceMetaFeature(null);
            linkMapping.setDomainInitializer(null);
            linkMapping.setDomainSpecialization(null);
            linkMapping.setCreationConstraints(null);
            this.detachLabelMappings((MappingEntry)linkMapping);
        }
        TreeIterator it = mapping.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            for (EReference ref : next.eClass().getEAllReferences()) {
                Object value = next.eGet((EStructuralFeature)ref);
                if (value == null) continue;
                if (value instanceof List) {
                    for (Object nvalue : (List)value) {
                        this.checkNotDomainElement((EObject)nvalue);
                    }
                    continue;
                }
                this.checkNotDomainElement((EObject)value);
            }
        }
    }

    protected void checkNotDomainElement(EObject obj) {
        assert (obj.eClass().getEPackage() != this.ePackage);
    }

    protected void detachNodeMapping(NodeMapping nodeMapping) {
        nodeMapping.setDomainMetaElement(null);
        nodeMapping.setDomainInitializer(null);
        nodeMapping.setDomainSpecialization(null);
        this.detachLabelMappings((MappingEntry)nodeMapping);
        for (ChildReference ref : nodeMapping.getChildren()) {
            ref.setChildrenFeature(null);
            ref.setContainmentFeature(null);
            this.detachNodeMapping(ref.getOwnedChild());
        }
    }

    protected void detachLabelMappings(MappingEntry entry) {
        EList list = entry.getLabelMappings();
        int i = 0;
        while (i < list.size()) {
            LabelMapping labelMapping = (LabelMapping)list.get(i);
            if (labelMapping instanceof FeatureLabelMapping) {
                DesignLabelMapping newLebdelMapping = GMFMapFactory.eINSTANCE.createDesignLabelMapping();
                newLebdelMapping.setDiagramLabel(labelMapping.getDiagramLabel());
                newLebdelMapping.setReadOnly(labelMapping.isReadOnly());
                list.set(i, newLebdelMapping);
            }
            ++i;
        }
    }

    @Override
    public Mapping getMapping() {
        if (this.mapping == null) {
            this.createMapping();
            this.saveModel((EObject)this.mapping, "gmfmap");
            this.validate((EObject)this.mapping);
        }
        return this.mapping;
    }

    @Override
    public NodeMapping getNodeA() {
        return null;
    }

    @Override
    public NodeMapping getNodeB() {
        return null;
    }

    @Override
    public LinkMapping getClassLink() {
        return null;
    }

    @Override
    public LinkMapping getReferenceLink() {
        return null;
    }
}

