/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.tests.runtime.common.core.internal.service.ServiceTest;

public class ExecutionStrategyTest
extends TestCase {
    private Fixture fixture = null;
    private ServiceTest.Fixture service = null;

    public static void main(String[] args) {
        TestRunner.run((Test)ExecutionStrategyTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ExecutionStrategyTest.class);
    }

    public ExecutionStrategyTest(String name) {
        super(name);
    }

    protected Fixture getFixture() {
        return this.fixture;
    }

    private void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    protected ServiceTest.Fixture getService() {
        return this.service;
    }

    private void setService(ServiceTest.Fixture service) {
        this.service = service;
    }

    protected void setUp() {
        this.setFixture(new Fixture());
        this.setService(new ServiceTest.Fixture());
        this.getService().addFixtureProvider(ProviderPriority.HIGHEST, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("Highest")));
        this.getService().addFixtureProvider(ProviderPriority.HIGHEST, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("tsehgiH")));
        this.getService().addFixtureProvider(ProviderPriority.HIGH, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("High")));
        this.getService().addFixtureProvider(ProviderPriority.HIGH, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("hgiH")));
        this.getService().addFixtureProvider(ProviderPriority.MEDIUM, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("Medium")));
        this.getService().addFixtureProvider(ProviderPriority.MEDIUM, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("muideM")));
        this.getService().addFixtureProvider(ProviderPriority.LOW, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("Low")));
        this.getService().addFixtureProvider(ProviderPriority.LOW, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("woL")));
        this.getService().addFixtureProvider(ProviderPriority.LOWEST, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("Lowest")));
        this.getService().addFixtureProvider(ProviderPriority.LOWEST, new ServiceTest.Fixture.ProviderDescriptor((IProvider)new Provider("tsewoL")));
    }

    public void test_readResolve() {
        block13: {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutput output = null;
            ObjectInput input = null;
            try {
                try {
                    output = new ObjectOutputStream(stream);
                    Iterator i = this.getFixture().getValues().iterator();
                    while (i.hasNext()) {
                        output.writeObject(i.next());
                    }
                    output.flush();
                    input = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                    i = this.getFixture().getValues().iterator();
                    while (i.hasNext()) {
                        ExecutionStrategyTest.assertSame(i.next(), (Object)input.readObject());
                    }
                }
                catch (Exception exception) {
                    ExecutionStrategyTest.fail();
                    try {
                        output.close();
                        input.close();
                    }
                    catch (Exception exception2) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                    input.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                output.close();
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public void test_execute_FIRST() {
        List result = Fixture.FIRST.execute((Service)this.getService(), (IOperation)new Operation());
        ExecutionStrategyTest.assertEquals((int)1, (int)result.size());
        ExecutionStrategyTest.assertEquals((Object)"Highest", result.get(0));
    }

    public void test_execute_LAST() {
        List result = Fixture.LAST.execute((Service)this.getService(), (IOperation)new Operation());
        ExecutionStrategyTest.assertEquals((int)1, (int)result.size());
        ExecutionStrategyTest.assertEquals((Object)"tsewoL", result.get(0));
    }

    public void test_execute_FORWARD() {
        List result = Fixture.FORWARD.execute((Service)this.getService(), (IOperation)new Operation());
        ExecutionStrategyTest.assertEquals((int)10, (int)result.size());
        ExecutionStrategyTest.assertEquals((Object)"Highest", result.get(0));
        ExecutionStrategyTest.assertEquals((Object)"tsehgiH", result.get(1));
        ExecutionStrategyTest.assertEquals((Object)"High", result.get(2));
        ExecutionStrategyTest.assertEquals((Object)"hgiH", result.get(3));
        ExecutionStrategyTest.assertEquals((Object)"Medium", result.get(4));
        ExecutionStrategyTest.assertEquals((Object)"muideM", result.get(5));
        ExecutionStrategyTest.assertEquals((Object)"Low", result.get(6));
        ExecutionStrategyTest.assertEquals((Object)"woL", result.get(7));
        ExecutionStrategyTest.assertEquals((Object)"Lowest", result.get(8));
        ExecutionStrategyTest.assertEquals((Object)"tsewoL", result.get(9));
    }

    public void test_execute_REVERSE() {
        List result = Fixture.REVERSE.execute((Service)this.getService(), (IOperation)new Operation());
        ExecutionStrategyTest.assertEquals((int)10, (int)result.size());
        ExecutionStrategyTest.assertEquals((Object)"tsewoL", result.get(0));
        ExecutionStrategyTest.assertEquals((Object)"Lowest", result.get(1));
        ExecutionStrategyTest.assertEquals((Object)"woL", result.get(2));
        ExecutionStrategyTest.assertEquals((Object)"Low", result.get(3));
        ExecutionStrategyTest.assertEquals((Object)"muideM", result.get(4));
        ExecutionStrategyTest.assertEquals((Object)"Medium", result.get(5));
        ExecutionStrategyTest.assertEquals((Object)"hgiH", result.get(6));
        ExecutionStrategyTest.assertEquals((Object)"High", result.get(7));
        ExecutionStrategyTest.assertEquals((Object)"tsehgiH", result.get(8));
        ExecutionStrategyTest.assertEquals((Object)"Highest", result.get(9));
    }

    protected static class Fixture
    extends ExecutionStrategy {
        private static final long serialVersionUID = 1L;

        protected Fixture() {
            super("Fixture", 0);
        }

        protected List getValues() {
            return super.getValues();
        }

        public List execute(Service service, IOperation operation) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static class Operation
    implements IOperation {
        protected Operation() {
        }

        public Object execute(IProvider provider) {
            return ((Provider)provider).getName();
        }
    }

    protected static class Provider
    extends AbstractProvider {
        private final String name;

        protected Provider(String name) {
            this.name = name;
        }

        protected String getName() {
            return this.name;
        }

        public boolean provides(IOperation operation) {
            return true;
        }
    }
}

