/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update.canonical;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.ReplaceNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.AbstractNotationModelRefresher;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.ElementDescriptor;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ChildNotationModelRefresher
extends AbstractNotationModelRefresher {
    public Command buildRefreshNotationModelCommand() {
        List semanticChildren = this.getSemanticChildNodes();
        EList notationalChildren = this.getHost().getChildren();
        if (semanticChildren.isEmpty() && notationalChildren.isEmpty()) {
            return null;
        }
        HashMap<EObject, View> semanticToNotational = new HashMap<EObject, View>();
        for (View next : notationalChildren) {
            EObject nextSemantic;
            if (!next.isSetElement() || (nextSemantic = next.getElement()) == null) continue;
            semanticToNotational.put(nextSemantic, next);
        }
        CompoundCommand command = new CompoundCommand();
        for (ElementDescriptor next : semanticChildren) {
            EObject node = next.getElement();
            View currentView = (View)semanticToNotational.remove(node);
            int nodeVisualID = next.getVisualID();
            if (currentView == null) {
                if (!this.shouldCreateView(next)) continue;
                command.appendIfCanExecute((Command)this.getCreateNotationalElementCommand(next));
                continue;
            }
            if (nodeVisualID == this.getVisualID(currentView)) continue;
            CreateNotationalElementCommand notationalCommand = this.getCreateNotationalElementCommand(next);
            if (notationalCommand != null) {
                command.appendIfCanExecute((Command)new ReplaceNotationalElementCommand(this.getHost(), notationalCommand, currentView));
                continue;
            }
            command.appendIfCanExecute((Command)new RemoveNotationalElementCommand(this.getHost(), currentView));
        }
        for (View obsoleteView : semanticToNotational.values()) {
            command.appendIfCanExecute((Command)new RemoveNotationalElementCommand(this.getHost(), obsoleteView));
        }
        return command.getCommandList().isEmpty() ? null : command;
    }

    protected abstract List getSemanticChildNodes();
}

