/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.BorderLayoutHelper;
import org.eclipse.gmf.graphdef.editor.edit.policies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.swt.graphics.Color;

public class BorderLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final Color FEEDBACK_COLOR = ColorConstants.lightBlue;
    private RoundedRectangle myFeedbackFigure;
    private BorderLayoutHelper myFeedbackBoundsHelper;

    protected void showLayoutTargetFeedback(Request request) {
        if ("create child".equals(request.getType()) || "move".equals(request.getType())) {
            DropRequest dropRequest = (DropRequest)request;
            IFigure figure = this.getLayoutContainer();
            Point where = dropRequest.getLocation().getCopy();
            figure.translateToRelative((Translatable)where);
            figure.translateFromParent((Translatable)where);
            where.translate(this.getLayoutOrigin().getNegated());
            if (this.myFeedbackBoundsHelper == null) {
                this.myFeedbackBoundsHelper = new BorderLayoutHelper((AbstractFigureEditPart)this.getHost());
            }
            Rectangle feedbackBounds = this.myFeedbackBoundsHelper.getFeedbackBounds(where);
            figure.translateToParent((Translatable)feedbackBounds);
            figure.translateToAbsolute((Translatable)feedbackBounds);
            this.getFeedbackLayer().translateToRelative((Translatable)feedbackBounds);
            if (this.myFeedbackFigure == null) {
                this.myFeedbackFigure = new RoundedRectangle();
                this.myFeedbackFigure.setFill(false);
                this.myFeedbackFigure.setOutline(true);
                this.myFeedbackFigure.setForegroundColor(FEEDBACK_COLOR);
                this.myFeedbackFigure.setLineWidth(2);
                this.myFeedbackFigure.setAntialias(1);
                this.myFeedbackFigure.setBounds(feedbackBounds);
                this.getFeedbackLayer().add((IFigure)this.myFeedbackFigure);
            } else {
                this.myFeedbackFigure.setBounds(feedbackBounds);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("create child".equals(request.getType()) || "move".equals(request.getType()) || "drop".equals(request.getType())) {
            if (this.myFeedbackFigure != null) {
                this.getFeedbackLayer().remove((IFigure)this.myFeedbackFigure);
                this.myFeedbackFigure = null;
            }
            this.myFeedbackBoundsHelper = null;
        } else {
            super.eraseTargetFeedback(request);
        }
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        Point p = new Point(request.getLocation().getCopy());
        IFigure feedback = this.getSizeOnDropFeedback(request);
        feedback.translateToRelative((Translatable)p);
        Dimension size = request.getSize().getCopy();
        feedback.translateToRelative((Translatable)size);
        feedback.setBounds(new Rectangle(p, size).expand(this.getCreationFeedbackOffset(request)));
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if ("move children".equals(request.getType())) {
            Point where = request.getLocation().getCopy();
            this.getLayoutContainer().translateToRelative((Translatable)where);
            this.getLayoutContainer().translateFromParent((Translatable)where);
            where.translate(this.getLayoutOrigin().getNegated());
            Rectangle feedbackBounds = new BorderLayoutHelper((AbstractFigureEditPart)this.getHost()).getFeedbackBounds(where);
            return this.createChangeConstraintCommand(child, constraint, feedbackBounds);
        }
        if ("resize children".equals(request.getType())) {
            return this.createChangeSizeCommand(child, request);
        }
        assert (false);
        return null;
    }

    private Command createChangeSizeCommand(EditPart childEditPart, ChangeBoundsRequest request) {
        assert (childEditPart instanceof AbstractFigureEditPart);
        AbstractFigureEditPart childFigureEditPart = (AbstractFigureEditPart)childEditPart;
        final RealFigure realFigure = childFigureEditPart.getRealFigure();
        if (request.getSizeDelta() == null) {
            return null;
        }
        if (!(realFigure.getLayoutData() instanceof BorderLayoutData)) {
            return null;
        }
        final Dimension sizeDelta = request.getSizeDelta().getCopy();
        this.getLayoutContainer().translateToRelative((Translatable)sizeDelta);
        final BorderLayoutData currentLayoutData = (BorderLayoutData)realFigure.getLayoutData();
        if (currentLayoutData.getAlignment() == Alignment.CENTER_LITERAL || currentLayoutData.isVertical() ? sizeDelta.height == 0 : sizeDelta.width == 0) {
            return null;
        }
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(childFigureEditPart.getEditingDomain(), "Changing preferred size", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)realFigure.eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                org.eclipse.gmf.gmfgraph.Dimension preferredSize = realFigure.getPreferredSize();
                if (preferredSize == null) {
                    preferredSize = GMFGraphFactory.eINSTANCE.createDimension();
                    realFigure.setPreferredSize(preferredSize);
                }
                if (currentLayoutData.isVertical()) {
                    preferredSize.setDy(preferredSize.getDy() + sizeDelta.height);
                } else {
                    preferredSize.setDx(preferredSize.getDx() + sizeDelta.width);
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.createChangeConstraintCommand(childEditPart, constraint, null);
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, final Rectangle feedbackBounds) {
        assert (childEditPart instanceof AbstractFigureEditPart);
        AbstractFigureEditPart childFigureEditPart = (AbstractFigureEditPart)childEditPart;
        assert (constraint instanceof BorderLayoutData);
        final BorderLayoutData layoutData = (BorderLayoutData)constraint;
        if (!this.isValidChildLayoutData(layoutData)) {
            return UnexecutableCommand.INSTANCE;
        }
        final RealFigure realFigure = childFigureEditPart.getRealFigure();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(childFigureEditPart.getEditingDomain(), "Changing Border Layout Data", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)realFigure.eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                realFigure.setLayoutData((LayoutData)layoutData);
                if (layoutData.getAlignment() != Alignment.CENTER_LITERAL && feedbackBounds != null) {
                    org.eclipse.gmf.gmfgraph.Dimension preferredSize;
                    if (realFigure.getPreferredSize() == null) {
                        realFigure.setPreferredSize(GMFGraphFactory.eINSTANCE.createDimension());
                    }
                    if ((preferredSize = realFigure.getPreferredSize()).getDx() == 0) {
                        preferredSize.setDx(feedbackBounds.width);
                    }
                    if (preferredSize.getDy() == 0) {
                        preferredSize.setDy(feedbackBounds.height);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    private boolean isValidChildLayoutData(BorderLayoutData layoutData) {
        for (Figure childFigure : this.getRealFigure().getChildren()) {
            LayoutData childFigureLayoutData = childFigure.getLayoutData();
            if (!(childFigureLayoutData instanceof BorderLayoutData)) continue;
            BorderLayoutData childLayoutData = (BorderLayoutData)childFigureLayoutData;
            if (layoutData.isVertical() != childLayoutData.isVertical() || layoutData.getAlignment() != childLayoutData.getAlignment()) continue;
            return false;
        }
        return true;
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        BorderLayoutData data = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        if (BorderLayout.BOTTOM == figureConstraint) {
            data.setVertical(true);
            data.setAlignment(Alignment.END_LITERAL);
        } else if (BorderLayout.TOP == figureConstraint) {
            data.setVertical(true);
            data.setAlignment(Alignment.BEGINNING_LITERAL);
        } else if (BorderLayout.LEFT == figureConstraint) {
            data.setVertical(false);
            data.setAlignment(Alignment.BEGINNING_LITERAL);
        } else if (BorderLayout.RIGHT == figureConstraint) {
            data.setVertical(false);
            data.setAlignment(Alignment.END_LITERAL);
        } else {
            assert (BorderLayout.CENTER == figureConstraint);
            data.setAlignment(Alignment.CENTER_LITERAL);
        }
        return data;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        IFigure figure = this.getLayoutContainer();
        Point where = request.getLocation().getCopy();
        figure.translateToRelative((Translatable)where);
        figure.translateFromParent((Translatable)where);
        where.translate(this.getLayoutOrigin().getNegated());
        return this.getConstraintFor(where);
    }

    protected Object getConstraintFor(Point point) {
        return new BorderLayoutHelper((AbstractFigureEditPart)this.getHost()).getConstraintFor(point);
    }

    protected Object getConstraintFor(Rectangle rect) {
        return this.getConstraintFor(rect.getTopLeft());
    }

    protected Command getCreateCommand(CreateRequest request) {
        Dimension requestedSize;
        if (!(request instanceof CreateViewRequest)) {
            return null;
        }
        final CreateViewRequest createViewRequest = (CreateViewRequest)request;
        if (createViewRequest.getViewDescriptors().size() != 1) {
            return null;
        }
        final CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)createViewRequest.getViewDescriptors().iterator().next();
        Object modelConstraint = this.translateToModelConstraint(this.getConstraintFor((CreateRequest)createViewRequest));
        assert (modelConstraint instanceof BorderLayoutData);
        final BorderLayoutData childLayoutData = (BorderLayoutData)modelConstraint;
        if (!this.isValidChildLayoutData(childLayoutData)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (createViewRequest.getSize() != null) {
            requestedSize = createViewRequest.getSize().getCopy();
            this.getLayoutContainer().translateToRelative((Translatable)requestedSize);
        } else {
            Point where = createViewRequest.getLocation().getCopy();
            this.getLayoutContainer().translateToRelative((Translatable)where);
            this.getLayoutContainer().translateFromParent((Translatable)where);
            where.translate(this.getLayoutOrigin().getNegated());
            Rectangle feedbackBounds = new BorderLayoutHelper((AbstractFigureEditPart)this.getHost()).getFeedbackBounds(where);
            requestedSize = feedbackBounds.getSize();
        }
        AbstractFigureEditPart host = (AbstractFigureEditPart)this.getHost();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(host.getEditingDomain(), "Setting BorderLayoutData for child figure", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)host.getRealFigure().eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IAdaptable elementAdapter = viewDescriptor.getElementAdapter();
                RealFigure realFigure = (RealFigure)elementAdapter.getAdapter(RealFigure.class);
                if (realFigure == null) {
                    return CommandResult.newErrorCommandResult((String)"Unable to locate newly created child figure");
                }
                realFigure.setLayoutData((LayoutData)childLayoutData);
                if (childLayoutData.getAlignment() != Alignment.CENTER_LITERAL) {
                    int requestedHeight;
                    int requestedWidth;
                    if (realFigure.getPreferredSize() == null) {
                        realFigure.setPreferredSize(GMFGraphFactory.eINSTANCE.createDimension());
                    }
                    org.eclipse.gmf.gmfgraph.Dimension preferredSize = realFigure.getPreferredSize();
                    if (createViewRequest.getSize() != null) {
                        requestedWidth = requestedSize.width;
                        requestedHeight = requestedSize.height;
                    } else {
                        requestedWidth = preferredSize.getDx() == 0 ? requestedSize.width : preferredSize.getDx();
                        requestedHeight = preferredSize.getDy() == 0 ? requestedSize.height : preferredSize.getDy();
                    }
                    if (preferredSize.getDy() != requestedHeight) {
                        preferredSize.setDy(requestedHeight);
                    }
                    if (preferredSize.getDx() != requestedWidth) {
                        preferredSize.setDx(requestedWidth);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected EditPolicy createChildEditPolicy(EditPart childEditPart) {
        assert (childEditPart instanceof AbstractFigureEditPart);
        AbstractFigureEditPart childFigureEditPart = (AbstractFigureEditPart)childEditPart;
        LayoutData layoutData = childFigureEditPart.getRealFigure().getLayoutData();
        if (!(layoutData instanceof BorderLayoutData)) {
            return null;
        }
        BorderLayoutData borderLayoutData = (BorderLayoutData)layoutData;
        ResizableEditPolicy result = new ResizableEditPolicy();
        if (borderLayoutData.getAlignment() == Alignment.CENTER_LITERAL) {
            result.setResizeDirections(0);
        } else if (borderLayoutData.getAlignment() == Alignment.BEGINNING_LITERAL) {
            result.setResizeDirections(borderLayoutData.isVertical() ? 4 : 16);
        } else {
            result.setResizeDirections(borderLayoutData.isVertical() ? 1 : 8);
        }
        return result;
    }

    private RealFigure getRealFigure() {
        return ((AbstractFigureEditPart)this.getHost()).getRealFigure();
    }
}

