/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.widgets.Display;

public class HiMetricMapMode
implements IMapMode {
    private float dpi;
    private double scale = 1.0;
    private static final double UNITS_PER_INCH = 2540.0;

    public HiMetricMapMode() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                HiMetricMapMode.this.dpi = Display.getDefault().getDPI().x;
            }
        });
        this.scale = (double)this.dpi / 2540.0;
    }

    public int LPtoDP(int logicalUnit) {
        Point devPt = new Point(logicalUnit, 0);
        devPt.performScale(this.scale);
        return devPt.x;
    }

    public int DPtoLP(int deviceUnit) {
        Point logPt = new Point(deviceUnit, 0);
        logPt.performScale(1.0 / this.scale);
        return logPt.x;
    }

    public Translatable DPtoLP(Translatable t) {
        t.performScale(1.0 / this.scale);
        return t;
    }

    public Translatable LPtoDP(Translatable t) {
        t.performScale(this.scale);
        return t;
    }
}

