/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.util.Assert;

public class SetConnectionBendpointsCommand
extends AbstractTransactionalCommand {
    private IAdaptable edgeAdapter;
    private PointList newPointList;
    private Point sourceRefPoint;
    private Point targetRefPoint;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SetConnectionBendpointsCommand(TransactionalEditingDomain editingDomain) {
        super(editingDomain, DiagramUIMessages.Commands_SetBendpointsCommand_Label, null);
    }

    public List getAffectedFiles() {
        View view;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((view = (View)this.edgeAdapter.getAdapter((Class)clazz)) != null) {
            return SetConnectionBendpointsCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    public IAdaptable getEdgeAdaptor() {
        return this.edgeAdapter;
    }

    public Point getTargetRefPoint() {
        return this.targetRefPoint;
    }

    public PointList getNewPointList() {
        return this.newPointList;
    }

    public Point getSourceRefPoint() {
        return this.sourceRefPoint;
    }

    public void setEdgeAdapter(IAdaptable edgeAdapter) {
        this.edgeAdapter = edgeAdapter;
    }

    public void setNewPointList(PointList newPointList, Point sourceRefPoint, Point targetRefPoint) {
        this.newPointList = new PointList(newPointList.size());
        int i = 0;
        while (i < newPointList.size()) {
            this.newPointList.addPoint(newPointList.getPoint(i));
            ++i;
        }
        this.sourceRefPoint = sourceRefPoint;
        this.targetRefPoint = targetRefPoint;
    }

    public void setNewPointList(PointList newPointList, ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor) {
        this.newPointList = new PointList(newPointList.size());
        int i = 0;
        while (i < newPointList.size()) {
            this.newPointList.addPoint(newPointList.getPoint(i));
            ++i;
        }
        if (sourceAnchor != null) {
            this.sourceRefPoint = sourceAnchor.getReferencePoint();
            sourceAnchor.getOwner().translateToRelative((Translatable)this.sourceRefPoint);
        }
        if (targetAnchor != null) {
            this.targetRefPoint = targetAnchor.getReferencePoint();
            targetAnchor.getOwner().translateToRelative((Translatable)this.targetRefPoint);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)this.newPointList);
        Assert.isNotNull((Object)this.sourceRefPoint);
        Assert.isNotNull((Object)this.targetRefPoint);
        IAdaptable iAdaptable = this.getEdgeAdaptor();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.notation.Edge");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Edge edge = (Edge)iAdaptable.getAdapter((Class)clazz);
        Assert.isNotNull((Object)edge);
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        int numOfPoints = this.newPointList.size();
        int i = 0;
        while (i < numOfPoints) {
            Dimension s = this.newPointList.getPoint(i).getDifference(this.sourceRefPoint);
            Dimension t = this.newPointList.getPoint(i).getDifference(this.targetRefPoint);
            newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
        points.setPoints(newBendpoints);
        return CommandResult.newOKCommandResult();
    }
}

