/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.util.Assistant;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.ModelURISelector;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.gmf.tooldef.ToolRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class InputPage
extends WizardPage
implements ModelURISelector.Loader {
    private ModelURISelector ecoreSelector;
    private ModelURISelector gmfgraphSelector;
    private ModelURISelector tooldefSelector;
    private final WizardInput holder;

    public InputPage(WizardInput input) {
        super("inputPage");
        this.holder = input;
        this.setTitle(Messages.inputPageTitle);
        this.setDescription(Messages.inputPageDesc);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.ecoreSelector = new ModelURISelector(Messages.ecoreSelector, "ecore", this);
        this.gmfgraphSelector = new ModelURISelector(Messages.graphdefSelector, "gmfgraph", this);
        this.tooldefSelector = new ModelURISelector(Messages.tooldefSelector, "gmftool", this);
        Composite p = new Composite(parent, 0);
        GridLayout l = new GridLayout(1, false);
        l.verticalSpacing = 30;
        p.setLayout((Layout)l);
        Control c = this.ecoreSelector.createControl(p);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ecoreSelector.addBrowseMenuSeparator();
        this.ecoreSelector.addBrowseMenuAction(Messages.useECore, "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore");
        this.initializeEcoreFileURI();
        c = this.gmfgraphSelector.createControl(p);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.gmfgraphSelector.setURIText(Assistant.getBasicGraphDef());
        this.gmfgraphSelector.addBrowseMenuSeparator();
        this.gmfgraphSelector.addBrowseMenuAction(Messages.useBasic, Assistant.getBasicGraphDef().toString());
        this.initializeGraphFileURI();
        c = this.tooldefSelector.createControl(p);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tooldefSelector.addBrowseMenuSeparator();
        this.tooldefSelector.addBrowseMenuAction(Messages.createBlank, new NewBlankToolDef());
        this.initializeToolFileURI();
        this.setControl((Control)p);
    }

    private void initializeEcoreFileURI() {
        if (this.holder.getInitialECoreFile() != null) {
            this.ecoreSelector.setURIText(this.holder.getInitialECoreFile());
        }
    }

    private void initializeGraphFileURI() {
        if (this.holder.getInitialGraphFile() != null) {
            this.gmfgraphSelector.setURIText(this.holder.getInitialGraphFile());
        }
    }

    private void initializeToolFileURI() {
        if (this.holder.getInitialToolFile() != null) {
            this.tooldefSelector.setURIText(this.holder.getInitialToolFile());
        }
    }

    public void run(ModelURISelector selector, String uriText) {
        URI uri = URI.createURI((String)uriText);
        Resource r = this.holder.getResourceSet().getResource(uri, true);
        if (selector == this.ecoreSelector) {
            if (r != null && r.getContents().get(0) instanceof EPackage) {
                this.holder.setDomainModel((EPackage)r.getContents().get(0));
            }
        } else if (selector == this.gmfgraphSelector) {
            if (r != null && r.getContents().get(0) instanceof Canvas) {
                this.holder.setGraphDef((Canvas)r.getContents().get(0));
            }
        } else if (r != null && r.getContents().get(0) instanceof ToolRegistry) {
            this.holder.setToolDef((ToolRegistry)r.getContents().get(0));
        }
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        IStatus s = this.holder.isReady2Go();
        if (s.isOK()) {
            this.setPageComplete(true);
            this.setMessage(null);
        } else {
            this.setPageComplete(false);
            this.setMessage(s.getMessage(), s.getCode());
        }
    }

    private class NewBlankToolDef
    implements Listener {
        private NewBlankToolDef() {
        }

        public void handleEvent(Event event) {
            InputPage.this.tooldefSelector.setURIText(InputPage.this.holder.createBlankToolDef());
            InputPage.this.tooldefSelector.disableLoad();
            InputPage.this.updatePageComplete();
        }
    }
}

