/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.ui.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditorWithFlyoutPalette;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class LogicNotationEditor
extends FileDiagramEditorWithFlyoutPalette {
    private static final String EDITING_DOMAIN_ID = "org.eclipse.gmf.examples.runtime.diagram.logicEditingDomain";
    private static final List SUPPORTED_DRAG_DROP_ECLASSES = new ArrayList();

    static {
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getLED());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getAndGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getOrGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getXORGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getCircuit());
    }

    protected String getEditingDomainID() {
        return EDITING_DOMAIN_ID;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DiagramDropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalTransfer.getInstance()){

            protected List getObjectsBeingDropped() {
                TransferData[] data = this.getCurrentEvent().dataTypes;
                ArrayList eObjects = new ArrayList();
                int i = 0;
                while (i < data.length) {
                    if (LocalTransfer.getInstance().isSupportedType(data[i])) {
                        IStructuredSelection selection = (IStructuredSelection)LocalTransfer.getInstance().nativeToJava(data[i]);
                        eObjects.addAll(selection.toList());
                    }
                    ++i;
                }
                return eObjects;
            }

            public boolean isEnabled(DropTargetEvent event) {
                Object modelObj;
                if (super.isEnabled(event) && (modelObj = this.getViewer().getContents().getModel()) instanceof EObject) {
                    List eObjects = this.getDropObjectsRequest().getObjects();
                    if (eObjects == null) {
                        return false;
                    }
                    Iterator i = eObjects.iterator();
                    while (i.hasNext()) {
                        Object o = i.next();
                        if (!(o instanceof EObject)) {
                            return false;
                        }
                        if (SUPPORTED_DRAG_DROP_ECLASSES.contains(((EObject)o).eClass())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

