/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;

public class ConnectionHandleEditPolicy
extends DiagramAssistantEditPolicy {
    private OwnerMovedListener ownerMovedListener = new OwnerMovedListener();
    private List handles = null;

    @Override
    protected boolean isDiagramAssistant(Object object) {
        return object instanceof ConnectionHandle;
    }

    protected List getHandleFigures() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>(2);
        String tooltip = this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING);
        if (tooltip != null) {
            list.add(new ConnectionHandle((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, tooltip));
        }
        if ((tooltip = this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)) != null) {
            list.add(new ConnectionHandle((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, tooltip));
        }
        return list;
    }

    protected String buildTooltip(ConnectionHandle.HandleDirection direction) {
        boolean supportsSRE;
        boolean supportsCreation;
        ModelingAssistantService service = ModelingAssistantService.getInstance();
        boolean bl = direction == ConnectionHandle.HandleDirection.OUTGOING ? !service.getRelTypesOnSource((IAdaptable)this.getHost()).isEmpty() : (supportsCreation = !service.getRelTypesOnTarget((IAdaptable)this.getHost()).isEmpty());
        boolean bl2 = direction == ConnectionHandle.HandleDirection.OUTGOING ? !service.getRelTypesForSREOnSource((IAdaptable)this.getHost()).isEmpty() : (supportsSRE = !service.getRelTypesForSREOnTarget((IAdaptable)this.getHost()).isEmpty());
        if (supportsSRE) {
            if (supportsCreation) {
                return DiagramUIMessages.ConnectionHandle_ToolTip_ShowRelatedElementsAndCreateRelationship;
            }
            return DiagramUIMessages.ConnectionHandle_ToolTip_ShowRelatedElementsOnly;
        }
        if (supportsCreation) {
            return DiagramUIMessages.ConnectionHandle_ToolTip_CreateRelationshipOnly;
        }
        return null;
    }

    @Override
    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addFigureListener((FigureListener)this.ownerMovedListener);
    }

    @Override
    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeFigureListener((FigureListener)this.ownerMovedListener);
        super.deactivate();
    }

    @Override
    protected void showDiagramAssistant(Point referencePoint) {
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getRight();
        }
        this.handles = this.getHandleFigures();
        if (this.handles == null) {
            return;
        }
        ConnectionHandleLocator locator = this.getConnectionHandleLocator(referencePoint);
        IFigure layer = this.getLayer("Handle Layer");
        for (ConnectionHandle handle : this.handles) {
            handle.setLocator(locator);
            locator.addHandle(handle);
            handle.addMouseMotionListener(this);
            layer.add((IFigure)handle);
            this.getHost().getViewer().getVisualPartMap().put(handle, this.getHost());
        }
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    @Override
    String getPreferenceName() {
        return "Global.showConnectionHandles";
    }

    @Override
    protected void hideDiagramAssistant() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (IFigure handle : this.handles) {
            handle.removeMouseMotionListener((MouseMotionListener)this);
            layer.remove(handle);
            this.getHost().getViewer().getVisualPartMap().remove(handle);
        }
        this.handles = null;
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    @Override
    protected boolean shouldShowDiagramAssistant() {
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        return this.handles == null && this.isSelectionToolActive();
    }

    protected ConnectionHandleLocator getConnectionHandleLocator(Point referencePoint) {
        return new ConnectionHandleLocator(this.getHostFigure(), referencePoint);
    }

    @Override
    protected boolean isDiagramAssistantShowing() {
        return this.handles != null;
    }

    @Override
    protected String getDiagramAssistantID() {
        return ConnectionHandleEditPolicy.class.getName();
    }

    public void addHandle(ConnectionHandle aHandle) {
        this.handles.add(aHandle);
    }

    private class OwnerMovedListener
    implements FigureListener {
        private OwnerMovedListener() {
        }

        public void figureMoved(IFigure source) {
            ConnectionHandleEditPolicy.this.hideDiagramAssistant();
        }
    }
}

