/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.WorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;

public abstract class DiagramActionBarContributor
extends ActionBarContributor {
    private ActivityManagerListener activityManagerListener;
    private IWorkbenchPartDescriptor descriptor;

    public void init(IActionBars bars) {
        super.init(bars);
        this.descriptor = new WorkbenchPartDescriptor(this.getEditorId(), this.getEditorClass(), this.getPage());
        try {
            ContributionItemService.getInstance().contributeToActionBars(bars, this.descriptor);
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"init()", (Throwable)e);
        }
        bars.updateActionBars();
        this.activityManagerListener = new ActivityManagerListener();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this.activityManagerListener);
    }

    public void dispose() {
        ContributionItemService.getInstance().disposeContributions(this.descriptor);
        this.descriptor = null;
        if (this.activityManagerListener != null) {
            PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this.activityManagerListener);
        }
        this.activityManagerListener = null;
        super.dispose();
    }

    protected void buildActions() {
    }

    protected void declareGlobalActionKeys() {
    }

    protected abstract String getEditorId();

    protected abstract Class getEditorClass();

    private void updateActionBars() {
        ContributionItemService.getInstance().updateActionBars(this.getActionBars(), this.descriptor);
        this.getActionBars().updateActionBars();
    }

    class ActivityManagerListener
    implements IActivityManagerListener {
        ActivityManagerListener() {
        }

        public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
            if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                DiagramActionBarContributor.this.updateActionBars();
            }
        }
    }
}

