/*

   Copyright 2001  The Apache Software Foundation 

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package org.apache.batik.util;

/**
 * Provider interface for new url protocols, used by the ParsedURL class.
 */
public interface ParsedURLProtocolHandler {
    /**
     * Returns the protocol to be handled by this class.
     * The protocol must _always_ be the part of the URL before the
     * first ':'.
     */
    public String getProtocolHandled();
    /**
     * Parse an absolute url string.
     */
    public ParsedURLData parseURL(String urlStr);
    /**
     * Parse a relative url string of this protocol.
     */
    public ParsedURLData parseURL(ParsedURL basepurl, String urlStr);
}

