/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class AWTGlyphGeometryCache {
    protected static final int INITIAL_CAPACITY = 71;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int n) {
        this.table = new Entry[n];
    }

    public int size() {
        return this.count;
    }

    public Value get(char c) {
        int n = this.hashCode(c) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.match(c)) {
                return (Value)entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    public Value put(char c, Value value) {
        int n;
        this.removeClearedEntries();
        int n2 = this.hashCode(c) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        if (entry != null) {
            if (entry.hash == n2 && entry.match(c)) {
                Object t = entry.get();
                this.table[n3] = new Entry(n2, c, value, entry.next);
                return (Value)t;
            }
            Entry entry2 = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.hash == n2 && entry.match(c)) {
                    Object t = entry.get();
                    entry2.next = entry = new Entry(n2, c, value, entry.next);
                    return (Value)t;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (this.count++ >= (n = this.table.length) * 3 >>> 2) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = new Entry(n2, c, value, this.table[n3]);
        return null;
    }

    public void clear() {
        this.table = new Entry[71];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected int hashCode(char c) {
        return c;
    }

    /*
     * Unable to fully structure code
     */
    protected void removeClearedEntries() {
        while ((var1_1 = (Entry)this.referenceQueue.poll()) != null) {
            block3: {
                var2_2 = var1_1.hash % this.table.length;
                var3_3 = this.table[var2_2];
                if (var3_3 != var1_1) ** GOTO lbl12
                this.table[var2_2] = var1_1.next;
                break block3;
lbl-1000:
                // 1 sources

                {
                    var4_4 = var3_3.next;
                    if (var4_4 == var1_1) {
                        var3_3.next = var1_1.next;
                        break;
                    }
                    var3_3 = var4_4;
lbl12:
                    // 2 sources

                    ** while (var3_3 != null)
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int n, char c, Value value, Entry entry) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = n;
            this.c = c;
            this.next = entry;
        }

        public boolean match(char c) {
            return this.c == c;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape shape, Rectangle2D rectangle2D) {
            this.outline = shape;
            this.outlineBounds = shape.getBounds2D();
            this.gmB = rectangle2D;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

