/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.search.internal.replace.provisional;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.internal.replace.provisional.AbstractModelSearchTransformation;
import org.eclipse.emf.search.ecore.engine.EcoreModelSearchQuery;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2RegexReplaceTransformation
extends AbstractModelSearchTransformation<EObject, IModelSearchQuery, String, String> {
    public UML2RegexReplaceTransformation(NamedElement element, IModelSearchQuery query, String valuation) {
        super((Object)element, (Object)query, (Object)valuation);
    }

    public boolean isValid() {
        return this.getModifiedElement() instanceof NamedElement;
    }

    public IStatus perform() {
        try {
            if (this.getQuery() instanceof EcoreModelSearchQuery) {
                EcoreModelSearchQuery query = (EcoreModelSearchQuery)this.getQuery();
                String input = ((ENamedElement)this.getModifiedElement()).getName();
                String expr = ((IModelSearchQuery)this.getQuery()).getQueryExpression();
                switch (query.getKind()) {
                    case REGULAR_EXPRESSION: {
                        Pattern pattern = Pattern.compile(expr);
                        String newValue = pattern.matcher(input).replaceFirst((String)this.getValuation());
                        ((NamedElement)this.getModifiedElement()).setName(newValue);
                        break;
                    }
                    case CASE_SENSITIVE: 
                    case NORMAL_TEXT: {
                        ((NamedElement)this.getModifiedElement()).setName((String)this.getValuation());
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getResult() {
        return ((NamedElement)this.getModifiedElement()).getName();
    }
}

