/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.adapter;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractSequenceModelAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IMetaDataAspect;
import org.eclipse.net4j.examples.mvc.aspect.ISequenceModelAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSequenceModelAdapter
extends AbstractSequenceModelAdapter<List>
implements List {
    public ListSequenceModelAdapter(Factory factory) {
        super(factory);
    }

    public List getList() {
        return (List)this.getTarget();
    }

    @Override
    public Object[] getMetaDataKeys() {
        Annotation[] data = ((List)this.getTarget()).getClass().getAnnotations();
        Object[] result = new Object[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[i].annotationType();
            ++i;
        }
        return result;
    }

    @Override
    public Object getMetaData(Object key) {
        return ((List)this.getTarget()).getClass().getAnnotation((Class)key);
    }

    @Override
    public boolean add(Object item) {
        this.getList().add(item);
        this.onAdd(this.getList().size() - 1, item);
        return true;
    }

    public void add(int index, Object item) {
        this.getList().add(index, item);
        this.onAdd(index, item);
    }

    @Override
    public boolean addAll(Collection coll) {
        boolean changed = false;
        for (Object item : coll) {
            changed |= this.add(item);
        }
        return changed;
    }

    public boolean addAll(int index, Collection coll) {
        for (Object item : coll) {
            this.add(index++, item);
        }
        return true;
    }

    @Override
    public void clear() {
        while (!this.getList().isEmpty()) {
            this.remove(0);
        }
    }

    @Override
    public boolean contains(Object item) {
        return this.getList().contains(item);
    }

    @Override
    public boolean containsAll(Collection coll) {
        return this.getList().containsAll(coll);
    }

    public Object get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object item) {
        return this.getList().indexOf(item);
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.getList().iterator();
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.getList().lastIndexOf(item);
    }

    public ListIterator listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public boolean remove(Object item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object remove(int index) {
        Object item = this.getList().remove(index);
        if (item != null) {
            this.onRemove(index, item);
        }
        return item;
    }

    @Override
    public boolean removeAll(Collection coll) {
        Object[] items = coll.toArray(new Object[coll.size()]);
        boolean changed = false;
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            changed |= this.remove(item);
            ++i;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection coll) {
        Object[] items = this.getList().toArray(new Object[coll.size()]);
        boolean changed = false;
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            if (!coll.contains(item)) {
                this.remove(i);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    public Object set(int index, Object item) {
        Object oldObject = this.getList().set(index, item);
        if (oldObject == item) {
            return false;
        }
        this.onSet(index, item, oldObject);
        return false;
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.getList().toArray(a);
    }

    @Override
    protected void connectTarget(Class aspect) {
    }

    @Override
    protected void disconnectTarget(Class aspect) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractAdapter.AbstractFactory<List> {
        private static final Class[] ASPECTS = new Class[]{IMetaDataAspect.class, ISequenceModelAspect.class};
        private static final Class[] ADAPTABLE_CLASSES = new Class[]{List.class};

        @Override
        public IAdapter<List> createAdapter() {
            return new ListSequenceModelAdapter(this);
        }

        @Override
        public Class[] getAspects() {
            return ASPECTS;
        }

        @Override
        public Class[] getAdaptableClasses() {
            return ADAPTABLE_CLASSES;
        }
    }
}

