/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ocl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingPackageRegistry
extends EPackageRegistryImpl {
    private static final long serialVersionUID = -7606528898701523821L;
    private final List<EPackage.Registry> delegates;

    public DelegatingPackageRegistry(EPackage.Registry delegate) {
        this.delegates = new BasicEList.FastCompare(1);
        this.delegates.add(delegate);
    }

    public DelegatingPackageRegistry(EPackage.Registry delegate1, EPackage.Registry delegate2) {
        this.delegates = new BasicEList.FastCompare(2);
        this.delegates.add(delegate1);
        this.delegates.add(delegate2);
    }

    public DelegatingPackageRegistry(List<EPackage.Registry> delegates) {
        this.delegates = new BasicEList.FastCompare(delegates);
    }

    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet keys = new HashSet(this.keySet());
        result.addAll(super.values());
        for (EPackage.Registry next : this.delegates) {
            for (String key : next.keySet()) {
                if (keys.contains(key)) continue;
                result.add(next.get((Object)key));
            }
        }
        return result;
    }

    protected EFactory delegatedGetEFactory(String nsURI) {
        EFactory result = null;
        for (EPackage.Registry next : this.delegates) {
            result = next.getEFactory(nsURI);
        }
        return result;
    }

    protected EPackage delegatedGetEPackage(String nsURI) {
        EPackage result = null;
        for (EPackage.Registry next : this.delegates) {
            result = next.getEPackage(nsURI);
        }
        return result;
    }
}

