/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.protocol;

import java.nio.channels.Channel;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.examples.prov.protocol.AbstractProvisioningProtocol;
import org.eclipse.net4j.examples.prov.server.SiteManager;
import org.eclipse.net4j.examples.prov.server.protocol.LoadSiteIndication;
import org.eclipse.net4j.examples.prov.server.protocol.RemoveFeatureIndication;
import org.eclipse.net4j.examples.prov.server.protocol.SaveSiteIndication;
import org.eclipse.net4j.examples.prov.server.protocol.UploadArchiveIndication;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;

public class ProvisioningServerProtocol
extends AbstractProvisioningProtocol {
    private SiteManager siteManager;
    private transient Channel lockingChannel;

    public int getType() {
        return 1;
    }

    public Indication createIndication(short signalId) {
        switch (signalId) {
            case 1: {
                return new LoadSiteIndication();
            }
            case 2: {
                return new SaveSiteIndication();
            }
            case 4: {
                return new UploadArchiveIndication(this.siteManager.getTempManager());
            }
            case 5: {
                return new RemoveFeatureIndication();
            }
        }
        throw new ImplementationError("Invalid signalId: " + signalId);
    }

    public SiteManager getSiteManager() {
        return this.siteManager;
    }

    public void setSiteManager(SiteManager siteManager) {
        this.doSet("siteManager", siteManager);
    }

    public synchronized Channel getLockingChannel() {
        return this.lockingChannel;
    }

    public synchronized void setLockingChannel(Channel lockingChannel) {
        this.lockingChannel = lockingChannel;
    }

    public synchronized boolean isLocked() {
        return this.lockingChannel != null;
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("siteManager");
    }

    protected void deactivate() throws Exception {
        this.lockingChannel = null;
        this.siteManager = null;
        super.deactivate();
    }
}

