/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.core.ConnectionLimitExceededException;
import org.eclipse.net4j.core.ConnectionManager;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class ConnectionManagerImpl
extends ServiceImpl
implements ConnectionManager {
    public static final int INITIAL_CAPACITY = 211;
    public static final int DEFAULT_MAXIMUM = Integer.MAX_VALUE;
    private int maxConnections = Integer.MAX_VALUE;
    private transient Set<Connector> connectors = new HashSet<Connector>(211);

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.doSet("maxConnections", maxConnections);
    }

    public void registerConnector(Connector connector) throws ConnectionLimitExceededException {
        if (this.connectors != null) {
            if (this.connectors.size() >= this.maxConnections) {
                throw new ConnectionLimitExceededException("Limit of " + this.maxConnections + " connections is exceeded");
            }
            if (this.isDebugEnabled()) {
                this.debug("Registering connector: " + connector);
            }
            this.connectors.add(connector);
        }
    }

    public void deregisterConnector(Connector connector) {
        if (this.connectors != null) {
            this.connectors.remove(connector);
            if (this.isDebugEnabled()) {
                this.debug("Deregistered connector: " + connector);
            }
        }
    }

    public Connector[] getConnectors() {
        return this.connectors.toArray(new Connector[this.connectors.size()]);
    }

    protected void deactivate() throws Exception {
        this.connectors = null;
        super.deactivate();
    }
}

