/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.engine.ITargetMetaElementHandler;
import org.eclipse.emf.search.core.engine.ITargetMetaElementProvider;
import org.eclipse.emf.search.core.engine.ITargetMetaElementSelectionListener;
import org.eclipse.emf.search.core.engine.ITargetMetaElementSelectionProvider;
import org.eclipse.emf.search.core.engine.ITargetMetaModelHandler;
import org.eclipse.emf.search.core.internal.replace.provisional.IModelSearchReplaceHandler;
import org.eclipse.emf.search.core.internal.replace.provisional.ITransformation;
import org.eclipse.emf.search.core.internal.replace.provisional.ITransformationProvider;
import org.eclipse.emf.search.core.internal.replace.provisional.TextualModelSearchReplaceRefactoring;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.core.scope.ModelSearchScope;
import org.eclipse.emf.search.core.services.ModelExtensibleSearchEngineExtensionManager;
import org.eclipse.emf.search.core.services.ModelSearchEngineDescriptor;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchCompositeArea;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchQueryArea;
import org.eclipse.emf.search.ui.areas.IModelSearchArea;
import org.eclipse.emf.search.ui.areas.IModelSearchParticipantArea;
import org.eclipse.emf.search.ui.internal.replace.provisional.TextualModelSearchRefactoringOperation;
import org.eclipse.emf.search.ui.internal.replace.provisional.TextualModelSearchReplaceWizard;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.scope.ModelSearchWorkspaceScopeFactory;
import org.eclipse.emf.search.ui.services.EngineMappingDescriptor;
import org.eclipse.emf.search.ui.services.ModelSearchEngineMappingExtensionManager;
import org.eclipse.emf.search.ui.services.ModelSearchParticipantTabExtensionManager;
import org.eclipse.emf.search.ui.services.ModelSearchQueryTabExtensionManager;
import org.eclipse.emf.search.ui.services.ParticipantTabDescriptor;
import org.eclipse.emf.search.ui.services.QueryTabDescriptor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage,
IModelSearchReplaceHandler,
ITransformationProvider<EObject, IModelSearchQuery, String, String> {
    private static final String QUERY_SECTION_DIALOG_SETTINGS_ID = "QuerySection";
    private static final String SELECTED_QUERY_ID = "SelectedQueryTabID";
    private String queryTabID = "";
    private String currentParticipantDescID = "";
    private TabItem queryTabItemToSelect;
    private ModelSearchQueryTabExtensionManager queryAreaExtensionManager = ModelSearchQueryTabExtensionManager.getInstance();
    private ModelSearchParticipantTabExtensionManager participantAreaExtensionManager = ModelSearchParticipantTabExtensionManager.getInstance();
    private ModelExtensibleSearchEngineExtensionManager searchEngineExtensionManager = ModelExtensibleSearchEngineExtensionManager.getInstance();
    private TabFolder searchQueryTabFolder;
    private Map<String, ModelSearchEngineDescriptor> searchEngineDescriptorsMap = new HashMap<String, ModelSearchEngineDescriptor>();
    private List<EngineMappingDescriptor> engineMappingDescriptorList = new ArrayList<EngineMappingDescriptor>();
    private ISearchPageContainer searchPageContainer;
    private IDialogSettings settings = Activator.getDefault().getDialogSettings();

    protected abstract String getModelSearchPageID();

    public String getID() {
        return this.getModelSearchPageID();
    }

    protected void createSearchQueryArea(Composite parent) {
        this.searchQueryTabFolder = new TabFolder(parent, 128);
        GridLayout gl1 = new GridLayout();
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        this.searchQueryTabFolder.setLayout((Layout)gl1);
        GridData gd1 = new GridData(1808);
        gd1.heightHint = 200;
        this.searchQueryTabFolder.setLayoutData((Object)gd1);
        assert (this.queryAreaExtensionManager.getModelSearchQueryAreas() != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage1");
        assert (this.queryAreaExtensionManager.getModelSearchQueryAreas()[0] != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage2");
        QueryTabDescriptor[] queryTabDescriptorArray = this.queryAreaExtensionManager.getModelSearchQueryAreas();
        int n = queryTabDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryTabDescriptor queryAreaDescriptor = queryTabDescriptorArray[n2];
            if (this.getModelSearchPageID().equals(queryAreaDescriptor.getTargetSearchPageID())) {
                Map<String, Object> map;
                IModelSearchArea area = queryAreaDescriptor.createArea((Composite)this.searchQueryTabFolder, this);
                TabItem queryTabItem = new TabItem(this.searchQueryTabFolder, 0);
                queryTabItem.setText(queryAreaDescriptor.getLabel());
                queryTabItem.setToolTipText(queryAreaDescriptor.getTooltip());
                queryTabItem.setControl(area.getControl());
                queryTabItem.setData((Object)queryAreaDescriptor);
                queryTabItem.setImage(queryAreaDescriptor.getImage());
                GridData gd2 = new GridData(1808);
                gd2.heightHint = 100;
                queryTabItem.getControl().setLayoutData((Object)gd2);
                GridData gd3 = new GridData(1808);
                gd3.heightHint = 100;
                area.getControl().setLayoutData((Object)gd3);
                IModelSearchArea data = queryAreaDescriptor.queryModelSearchArea;
                if (data instanceof AbstractModelSearchCompositeArea && (map = ((AbstractModelSearchCompositeArea)data).getDataMap()) != null && map.get("SETTINGS_PREFIX") == null) {
                    map.put("SETTINGS_PREFIX", this.getID());
                }
                area.loadDialogSettings();
            }
            ++n2;
        }
        this.searchQueryTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractModelSearchPage.this.handleTargetMetaModelEnvironmentConfiguration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private IModelSearchScope<?, Resource> computeModelSearchWorkspaceScope(IModelSearchQueryParameters parameters) {
        ModelSearchWorkspaceScopeFactory scopeFactory = ModelSearchWorkspaceScopeFactory.getInstance();
        if (this.getContainer() == null) {
            if (parameters.getScope() == null) {
                return scopeFactory.createModelSearchWorkspaceScope(parameters.getModelSearchEngineID());
            }
            return parameters.getScope();
        }
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return scopeFactory.createModelSearchWorkspaceScope(parameters.getModelSearchEngineID());
            }
            case 1: {
                return scopeFactory.createModelSearchScope(parameters.getModelSearchEngineID(), this.getContainer().getSelection());
            }
            case 3: {
                String[] projectNames = this.getContainer().getSelectedProjectNames();
                return scopeFactory.createModelProjectSearchScope(parameters.getModelSearchEngineID(), projectNames);
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return null;
                }
                return scopeFactory.createModelSearchScope(parameters.getModelSearchEngineID(), workingSets);
            }
        }
        return new ModelSearchScope("%%%% VOID MODEL SEARCH SCOPE %%%%");
    }

    protected void createParticipantTabsArea(Composite parent) {
        TabFolder searchParticipantTabFolder = new TabFolder(parent, 128);
        GridLayout gl0 = new GridLayout();
        gl0.marginHeight = 0;
        gl0.marginWidth = 0;
        searchParticipantTabFolder.setLayout((Layout)gl0);
        GridData gd0 = new GridData(1808);
        gd0.heightHint = 240;
        searchParticipantTabFolder.setLayoutData((Object)gd0);
        assert (this.participantAreaExtensionManager.getModelSearchParticipantDescriptors() != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage3");
        assert (this.participantAreaExtensionManager.getModelSearchParticipantDescriptors()[0] != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage4");
        ParticipantTabDescriptor[] participantTabDescriptorArray = this.participantAreaExtensionManager.getModelSearchParticipantDescriptors();
        int n = participantTabDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticipantTabDescriptor participantAreaDescriptor = participantTabDescriptorArray[n2];
            if (this.getModelSearchPageID().equals(participantAreaDescriptor.getTargetSearchPageID())) {
                Map<String, Object> map;
                IModelSearchArea pArea = participantAreaDescriptor.createArea((Composite)searchParticipantTabFolder, this);
                TabItem participantTabItem = new TabItem(searchParticipantTabFolder, 0);
                participantTabItem.setText(participantAreaDescriptor.getLabel());
                participantTabItem.setToolTipText(participantAreaDescriptor.getTooltip());
                participantTabItem.setControl(pArea.getControl());
                participantTabItem.setImage(participantAreaDescriptor.getImage());
                participantTabItem.setData((Object)participantAreaDescriptor);
                GridData gd1 = new GridData(1808);
                gd1.heightHint = 180;
                participantTabItem.getControl().setLayoutData((Object)gd1);
                GridData gd2 = new GridData(1808);
                gd2.heightHint = 180;
                pArea.getControl().setLayoutData((Object)gd2);
                IModelSearchArea data = participantAreaDescriptor.participantModelSearchArea;
                if (data instanceof AbstractModelSearchCompositeArea && (map = ((AbstractModelSearchCompositeArea)data).getDataMap()) != null && map.get("SETTINGS_PREFIX") == null) {
                    map.put("SETTINGS_PREFIX", this.getModelSearchPageID());
                }
                pArea.loadDialogSettings();
                if (pArea instanceof IModelSearchParticipantArea) {
                    QueryTabDescriptor[] queryTabDescriptorArray = this.queryAreaExtensionManager.getModelSearchQueryAreas();
                    int n3 = queryTabDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        QueryTabDescriptor queryAreaDescriptor = queryTabDescriptorArray[n4];
                        IModelSearchArea qArea = queryAreaDescriptor.getQueryModelSearchArea();
                        if (qArea instanceof ITargetMetaElementSelectionProvider) {
                            ((ITargetMetaElementSelectionProvider)qArea).addTargetMetaElementSelectionListener((ITargetMetaElementSelectionListener)pArea);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        searchParticipantTabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object data;
                if (event.item instanceof TabItem && (data = ((TabItem)event.item).getData()) instanceof ParticipantTabDescriptor) {
                    ParticipantTabDescriptor participantTabDesc = (ParticipantTabDescriptor)data;
                    AbstractModelSearchPage.this.currentParticipantDescID = participantTabDesc.ID;
                }
            }
        });
        this.currentParticipantDescID = ((ParticipantTabDescriptor)searchParticipantTabFolder.getItem(0).getData()).getID();
    }

    private void initModelSearchEngineMap() {
        ModelSearchEngineDescriptor[] modelSearchEngineDescriptorArray = this.searchEngineExtensionManager.getModelSearchEngines();
        int n = modelSearchEngineDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelSearchEngineDescriptor modelSearchEngineDescriptor = modelSearchEngineDescriptorArray[n2];
            this.searchEngineDescriptorsMap.put(modelSearchEngineDescriptor.getID(), modelSearchEngineDescriptor);
            ++n2;
        }
    }

    private void initEngineMappingsList() {
        EngineMappingDescriptor[] engineMappingDescriptorArray = ModelSearchEngineMappingExtensionManager.getInstance().getModelSearchEngineMappingDescriptors();
        int n = engineMappingDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EngineMappingDescriptor engineMappingDescriptor = engineMappingDescriptorArray[n2];
            this.engineMappingDescriptorList.add(engineMappingDescriptor);
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        GridLayout glP = new GridLayout();
        glP.marginWidth = 0;
        glP.marginHeight = 0;
        parent.setLayout((Layout)glP);
        parent.setLayoutData((Object)new GridData(1808));
        this.getContainer().setPerformActionEnabled(false);
        SashForm sashForm = new SashForm(parent, 512);
        GridLayout gl0 = new GridLayout();
        gl0.marginWidth = 0;
        gl0.marginHeight = 0;
        sashForm.setLayout((Layout)gl0);
        GridData data = new GridData(1808);
        data.heightHint = 375;
        data.widthHint = 225;
        sashForm.setLayoutData((Object)data);
        this.createSearchQueryArea((Composite)sashForm);
        Composite participantTabsContainer = new Composite((Composite)sashForm, 0);
        GridData gd1 = new GridData(768);
        gd1.heightHint = 250;
        participantTabsContainer.setLayout((Layout)new GridLayout());
        participantTabsContainer.setLayoutData((Object)gd1);
        this.createParticipantTabsArea(participantTabsContainer);
        this.initModelSearchEngineMap();
        this.initEngineMappingsList();
        this.loadDialogSettings();
        sashForm.setWeights(new int[]{40, 60});
        this.setControl((Control)sashForm);
        this.hookListeners();
        this.handleTargetMetaModelEnvironmentConfiguration();
        this.validateInput();
        parent.pack();
    }

    private IModelSearchQuery newQuery() {
        IModelSearchArea pArea;
        String expression = "";
        ParticipantTabDescriptor participant = this.getCurrentlySelectedParticipantDescriptor();
        QueryTabDescriptor queryTabDescriptor = this.getCurrentlySelectedQueryDescriptor();
        ModelSearchEngineDescriptor searchEngine = this.getSearchEngineDescriptorFromPageSelection();
        if (!(searchEngine instanceof ModelSearchEngineDescriptor)) {
            return null;
        }
        IModelSearchQueryParameters parameters = searchEngine.getModelSearchParametersFactory().createSearchQueryParameters();
        IModelSearchArea qArea = queryTabDescriptor.getQueryModelSearchArea();
        if (qArea instanceof AbstractModelSearchQueryArea) {
            AbstractModelSearchQueryArea queryArea = (AbstractModelSearchQueryArea)qArea;
            parameters.setScope(this.computeModelSearchWorkspaceScope(parameters));
            Map<String, Object> dataMap = queryArea.getDataMap();
            for (String key : dataMap.keySet()) {
                parameters.setData(key, dataMap.get(key));
            }
            expression = queryArea.getQueryExpression();
        }
        if ((pArea = participant.getParticipantModelSearchArea()) instanceof IModelSearchParticipantArea) {
            parameters.setParticipantElements(((IModelSearchParticipantArea)pArea).getSelectedParticipants());
        }
        return searchEngine.getModelSearchQueryFactory().createModelSearchQuery(expression, parameters);
    }

    private void storeQueryTabsDialogSettings(IDialogSettings settings) {
        IDialogSettings querySectionDialogSettings = settings.getSection(QUERY_SECTION_DIALOG_SETTINGS_ID);
        if (querySectionDialogSettings == null) {
            querySectionDialogSettings = settings.addNewSection(QUERY_SECTION_DIALOG_SETTINGS_ID);
        }
        String selectedQueryTabID = this.getCurrentlySelectedQueryDescriptor().getID();
        querySectionDialogSettings.put(SELECTED_QUERY_ID, selectedQueryTabID);
        TabItem[] tabItemArray = this.searchQueryTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            QueryTabDescriptor queryAreaDescriptor = (QueryTabDescriptor)tabItem.getData();
            queryAreaDescriptor.getQueryModelSearchArea().storeDialogSettings();
            ++n2;
        }
    }

    private void storeParticipantTabsDialogSettings(IDialogSettings settings) {
    }

    private void saveDialogSettings() {
        this.storeQueryTabsDialogSettings(this.settings);
        this.storeParticipantTabsDialogSettings(this.settings);
    }

    private void loadQueryTabsDialogSettings() {
        IDialogSettings querySectionDialogSettings = this.settings.getSection(QUERY_SECTION_DIALOG_SETTINGS_ID);
        if (querySectionDialogSettings == null) {
            querySectionDialogSettings = this.settings.addNewSection(QUERY_SECTION_DIALOG_SETTINGS_ID);
        }
        this.queryTabID = querySectionDialogSettings.get(SELECTED_QUERY_ID);
        this.queryTabItemToSelect = null;
        TabItem[] tabItemArray = this.searchQueryTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            QueryTabDescriptor queryAreaDescriptor = (QueryTabDescriptor)tabItem.getData();
            if (this.queryTabID != null && this.queryTabID.equals(queryAreaDescriptor.ID)) {
                this.queryTabItemToSelect = tabItem;
            }
            ++n2;
        }
        if (this.queryTabItemToSelect != null) {
            this.searchQueryTabFolder.setSelection(this.queryTabItemToSelect);
        } else if (this.searchQueryTabFolder.getItemCount() > 0) {
            this.searchQueryTabFolder.setSelection(0);
        }
    }

    private void loadParticipantTabsDialogSettings() {
    }

    private void loadDialogSettings() {
        this.loadQueryTabsDialogSettings();
        this.loadParticipantTabsDialogSettings();
    }

    private void prepareQueries() {
        TabItem[] tabItemArray = this.searchQueryTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            QueryTabDescriptor queryAreaDescriptor = (QueryTabDescriptor)tabItem.getData();
            queryAreaDescriptor.getQueryModelSearchArea().prepare();
            ++n2;
        }
    }

    private void prepareParticipants() {
    }

    private void prepareQuery() {
        this.prepareQueries();
        this.prepareParticipants();
    }

    private boolean validateQueryTabs() {
        TabItem[] tabItemArray = this.searchQueryTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            QueryTabDescriptor queryAreaDescriptor = (QueryTabDescriptor)tabItem.getData();
            if (!queryAreaDescriptor.getQueryModelSearchArea().validateStatus()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean vaidateParticipantTabs() {
        return true;
    }

    private boolean validateInput() {
        boolean status = this.validateQueryTabs() && this.vaidateParticipantTabs();
        this.getContainer().setPerformActionEnabled(status);
        return status;
    }

    public ParticipantTabDescriptor getCurrentlySelectedParticipantDescriptor() {
        assert (this.participantAreaExtensionManager.getModelSearchParticipantDescriptors() != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage5");
        assert (this.participantAreaExtensionManager.getModelSearchParticipantDescriptors()[0] != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage7");
        return this.participantAreaExtensionManager.find(this.currentParticipantDescID);
    }

    public QueryTabDescriptor getCurrentlySelectedQueryDescriptor() {
        assert (this.searchQueryTabFolder.getSelection() != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage8");
        assert (this.searchQueryTabFolder.getSelection().length == 1) : Messages.getString("ModelExtensibleSearchPage.assertMessage9");
        assert (this.searchQueryTabFolder.getSelection()[0] != null) : Messages.getString("ModelExtensibleSearchPage.assertMessage10");
        return (QueryTabDescriptor)this.searchQueryTabFolder.getSelection()[0].getData();
    }

    public TabItem getCurrentlySelectedQueryTabItem() {
        if (this.searchQueryTabFolder == null || this.searchQueryTabFolder.getSelection() == null || this.searchQueryTabFolder.getSelection().length < 1 || this.searchQueryTabFolder.getSelection()[0] == null) {
            return null;
        }
        return this.searchQueryTabFolder.getSelection()[0];
    }

    public ModelSearchEngineDescriptor getSearchEngineDescriptorFromPageSelection() {
        return this.searchEngineDescriptorsMap.get(this.getApplicableModelSearchEngineIDIfAny());
    }

    private String getApplicableModelSearchEngineIDIfAny() {
        QueryTabDescriptor qDesc = this.getCurrentlySelectedQueryDescriptor();
        for (EngineMappingDescriptor engineMappingDescriptor : this.engineMappingDescriptorList) {
            if (!engineMappingDescriptor.getQueryTabID().equals(qDesc.getID())) continue;
            return engineMappingDescriptor.getSearchEngineID();
        }
        return "";
    }

    private void hookListeners() {
    }

    private void handleTargetMetaModelEnvironmentConfiguration() {
        QueryTabDescriptor qDesc = this.getCurrentlySelectedQueryDescriptor();
        ParticipantTabDescriptor pDesc = this.getCurrentlySelectedParticipantDescriptor();
        IModelSearchArea modelSearchArea = pDesc.getParticipantModelSearchArea();
        if (modelSearchArea instanceof IModelSearchParticipantArea) {
            for (String targetMetaModelID : ((IModelSearchParticipantArea)modelSearchArea).getTargetMetaModelIDs()) {
                if (qDesc.getQueryModelSearchArea() instanceof ITargetMetaModelHandler) {
                    ((ITargetMetaModelHandler)qDesc.getQueryModelSearchArea()).handleTargetMetaModel(targetMetaModelID);
                }
                if (!(qDesc.getQueryModelSearchArea() instanceof ITargetMetaElementProvider)) continue;
                EObject element = ((ITargetMetaElementProvider)qDesc.getQueryModelSearchArea()).getTargetMetaElement();
                if (!(modelSearchArea instanceof ITargetMetaElementHandler)) continue;
                ((ITargetMetaElementHandler)modelSearchArea).handleTargetMetaElementParticipantSelection(element);
            }
        }
    }

    public void setContainer(ISearchPageContainer c) {
        this.searchPageContainer = c;
        this.searchPageContainer.setPerformActionEnabled(false);
    }

    public ISearchPageContainer getContainer() {
        return this.searchPageContainer;
    }

    public boolean performAction() {
        try {
            this.prepareQuery();
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
            this.saveDialogSettings();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ui", 0, Messages.getString("ModelExtensibleSearchPage.addExtensionErrorMessage"), (Throwable)e));
            return false;
        }
        return true;
    }

    public boolean performReplace() {
        try {
            this.prepareQuery();
            this.handleReplaceAction(this.newQuery());
            this.saveDialogSettings();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ui", 0, Messages.getString("ModelExtensibleSearchPage.addExtensionErrorMessage"), (Throwable)e));
            return false;
        }
        return true;
    }

    public abstract ITransformation<EObject, IModelSearchQuery, String, String> getTransformation(EObject var1, IModelSearchQuery var2, String var3);

    public void handleReplace(Object element, IModelSearchQuery query, Object value) {
        ITransformation<EObject, IModelSearchQuery, String, String> transformation;
        if (element instanceof EObject && value instanceof String && (transformation = this.getTransformation((EObject)element, query, (String)value)).isValid()) {
            transformation.perform();
            this.handleTransformationResult(transformation.getResult());
        }
    }

    protected void handleTransformationResult(Object result) {
    }

    private void handleReplaceAction(IModelSearchQuery query) {
        try {
            TextualModelSearchReplaceRefactoring refactoring = new TextualModelSearchReplaceRefactoring(query, (IModelSearchReplaceHandler)this);
            TextualModelSearchReplaceWizard refactoringWizard = new TextualModelSearchReplaceWizard((Refactoring)refactoring, 0);
            TextualModelSearchRefactoringOperation op = new TextualModelSearchRefactoringOperation(refactoringWizard);
            op.run(this.getShell(), Messages.getString("AbstractModelSearchPage.ReplacePageTitle"));
        }
        catch (InterruptedException interruptedException) {}
    }
}

