/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.api.IDiffEngine;
import org.eclipse.emf.compare.diff.metamodel.AddReferenceValue;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.RemoteAddReferenceValue;
import org.eclipse.emf.compare.diff.metamodel.RemoteMoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.RemoteRemoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.RemoteRemoveReferenceValue;
import org.eclipse.emf.compare.diff.metamodel.RemoteUpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.RemoteUpdateUniqueReferenceValue;
import org.eclipse.emf.compare.diff.metamodel.RemoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.RemoveReferenceValue;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateUniqueReferenceValue;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Element;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.RemoteUnMatchElement;
import org.eclipse.emf.compare.match.metamodel.UnMatchElement;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDiffEngine
implements IDiffEngine {
    protected static final int ANCESTOR_OBJECT = 0;
    protected static final int LEFT_OBJECT = 1;
    protected static final int RIGHT_OBJECT = 2;
    protected final Map<UnMatchElement, Boolean> unMatchedElements = new EMFCompareMap();
    private final Map<EObject, Match2Elements> eObjectToMatch = new EMFCompareMap();

    @Override
    public DiffModel doDiff(MatchModel match) {
        return this.doDiff(match, false);
    }

    @Override
    public DiffModel doDiff(MatchModel match, boolean threeWay) {
        this.updateEObjectToMatch(match, threeWay);
        DiffModel result = DiffFactory.eINSTANCE.createDiffModel();
        result.setLeft(match.getLeftModel());
        result.setRight(match.getRightModel());
        result.setOrigin(match.getOriginModel());
        DiffGroup diffRoot = null;
        diffRoot = threeWay ? this.doDiffThreeWay(match) : this.doDiffTwoWay(match);
        result.getOwnedElements().add((Object)diffRoot);
        return result;
    }

    @Override
    public void reset() {
        this.unMatchedElements.clear();
        this.eObjectToMatch.clear();
    }

    protected void addInContainerPackage(DiffGroup root, DiffElement operation, EObject targetParent) {
        if (targetParent == null) {
            root.getSubDiffElements().add((Object)operation);
            return;
        }
        DiffGroup targetGroup = this.findExistingGroup(root, targetParent);
        if (targetGroup == null && (targetGroup = this.findExistingGroup(root, this.getMatchedEObject(targetParent))) == null) {
            targetGroup = this.buildHierarchyGroup(targetParent, root);
        }
        targetGroup.getSubDiffElements().add((Object)operation);
    }

    protected void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next)) continue;
            String attributeName = next.getName();
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            if (leftValue instanceof EEnumLiteral && rightValue instanceof EEnumLiteral) {
                StringBuilder value1 = new StringBuilder();
                value1.append(((EEnumLiteral)leftValue).getLiteral()).append(((EEnumLiteral)leftValue).getValue());
                StringBuilder value2 = new StringBuilder();
                value2.append(((EEnumLiteral)rightValue).getLiteral()).append(((EEnumLiteral)rightValue).getValue());
                if (value1.toString().equals(value2.toString())) continue;
                this.createNonConflictingAttributeChange(root, next, mapping.getLeftElement(), mapping.getRightElement());
                continue;
            }
            if ((leftValue == null || leftValue.equals(rightValue)) && (leftValue != null || leftValue == rightValue)) continue;
            this.createNonConflictingAttributeChange(root, next, mapping.getLeftElement(), mapping.getRightElement());
        }
    }

    protected void checkAttributesUpdates(DiffGroup root, Match3Element mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            boolean leftDistinctFromOrigin;
            Object ancestorValue;
            if (this.shouldBeIgnored(next)) continue;
            String attributeName = next.getName();
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            boolean rightDistinctFromOrigin = rightValue != (ancestorValue = EFactory.eGet((EObject)mapping.getOriginElement(), (String)attributeName)) && rightValue != null && !rightValue.equals(ancestorValue);
            boolean rightDistinctFromLeft = rightValue != leftValue && rightValue != null && !rightValue.equals(leftValue);
            boolean bl = leftDistinctFromOrigin = leftValue != ancestorValue && leftValue != null && !leftValue.equals(ancestorValue);
            if (!rightDistinctFromOrigin && !rightDistinctFromLeft && !leftDistinctFromOrigin) continue;
            if (rightDistinctFromOrigin && !leftDistinctFromOrigin) {
                this.createNonConflictingAttributeChange(root, next, mapping.getLeftElement(), mapping.getRightElement());
                continue;
            }
            if (leftDistinctFromOrigin && !rightDistinctFromOrigin) {
                this.createRemoteAttributeChange(root, next, mapping);
                continue;
            }
            if (rightDistinctFromOrigin && !rightDistinctFromLeft) continue;
            this.checkConflictingAttributesUpdate(root, next, mapping);
        }
    }

    protected void checkForDiffs(DiffGroup current, Match2Elements match) throws FactoryException {
        this.checkAttributesUpdates(current, match);
        this.checkReferencesUpdates(current, match);
        this.checkMoves(current, match);
    }

    protected void checkForDiffs(DiffGroup current, Match3Element match) throws FactoryException {
        this.checkAttributesUpdates(current, match);
        this.checkReferencesUpdates(current, match);
        this.checkMoves(current, match);
    }

    protected void checkMoves(DiffGroup root, Match2Elements matchElement) {
        if (matchElement.getLeftElement().eContainer() != null && matchElement.getRightElement().eContainer() != null && this.getMatchedEObject(matchElement.getLeftElement().eContainer()) != matchElement.getRightElement().eContainer()) {
            this.createMoveOperation(root, matchElement.getLeftElement(), matchElement.getRightElement());
        }
    }

    protected void checkMoves(DiffGroup root, Match3Element matchElement) {
        boolean rightMoved;
        EObject leftElement = matchElement.getLeftElement();
        EObject rightElement = matchElement.getRightElement();
        EObject originElement = matchElement.getOriginElement();
        boolean leftMoved = originElement != null && leftElement.eContainer() != null && !this.getMatchedEObject(leftElement.eContainer(), 0).equals(originElement.eContainer());
        boolean bl = rightMoved = originElement != null && rightElement.eContainer() != null && !this.getMatchedEObject(rightElement.eContainer(), 0).equals(originElement.eContainer());
        if (leftMoved && rightMoved && !this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer())) {
            MoveModelElement operation = DiffFactory.eINSTANCE.createMoveModelElement();
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setRightTarget(this.getMatchedEObject(leftElement.eContainer()));
            operation.setLeftTarget(this.getMatchedEObject(rightElement.eContainer()));
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(leftElement);
            conflictingDiff.setRightParent(rightElement);
            conflictingDiff.setOriginElement(originElement);
            conflictingDiff.getSubDiffElements().add((Object)operation);
            root.getSubDiffElements().add((Object)conflictingDiff);
        } else if (rightMoved && !this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer())) {
            this.createMoveOperation(root, leftElement, rightElement);
        } else if (leftMoved && !this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer())) {
            this.createRemoteMoveOperation(root, leftElement, rightElement);
        }
    }

    protected void checkReferencesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (this.shouldBeIgnored(next)) continue;
            this.createNonConflictingReferencesUpdate(root, next, mapping.getLeftElement(), mapping.getRightElement());
        }
    }

    protected void checkReferencesUpdates(DiffGroup root, Match3Element mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            List ancestorReferences;
            List rightReferences;
            if (this.shouldBeIgnored(next)) continue;
            String referenceName = next.getName();
            List leftReferences = EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName);
            if (this.isConflictual(next, leftReferences, rightReferences = EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName), ancestorReferences = EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName))) {
                this.createConflictingReferenceUpdate(root, next, mapping);
                continue;
            }
            ArrayList<EObject> remoteDeletedReferences = new ArrayList<EObject>();
            ArrayList<EObject> remoteAddedReferences = new ArrayList<EObject>();
            ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
            ArrayList<EObject> addedReferences = new ArrayList<EObject>();
            this.populateThreeWayReferencesChanges(mapping, next, addedReferences, deletedReferences, remoteAddedReferences, remoteDeletedReferences);
            this.createRemoteReferencesUpdate(root, next, mapping, remoteAddedReferences, remoteDeletedReferences);
            if (!next.isMany()) {
                EObject addedValue = null;
                EObject deletedValue = null;
                if (addedReferences.size() > 0) {
                    addedValue = (EObject)addedReferences.get(0);
                }
                if (deletedReferences.size() > 0) {
                    deletedValue = (EObject)deletedReferences.get(0);
                }
                if ((addedValue == null || deletedValue == null) && addedValue != deletedValue) {
                    root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(mapping.getLeftElement(), mapping.getRightElement(), next, addedValue, deletedValue));
                    continue;
                }
                if (addedValue == null || deletedValue == null || EcoreUtil.getURI((EObject)addedValue).equals((Object)EcoreUtil.getURI((EObject)deletedValue))) continue;
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(mapping.getLeftElement(), mapping.getRightElement(), next, addedValue, deletedValue));
                continue;
            }
            if (addedReferences.size() > 0) {
                this.createNewReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), next, addedReferences);
                continue;
            }
            if (deletedReferences.size() <= 0) continue;
            this.createRemovedReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), next, deletedReferences);
        }
    }

    protected DiffGroup doDiffThreeWay(MatchModel match) {
        DiffGroup diffRoot = DiffFactory.eINSTANCE.createDiffGroup();
        Resource leftModel = null;
        if (match.getMatchedElements().size() > 0) {
            Match3Element matchRoot = (Match3Element)match.getMatchedElements().get(0);
            leftModel = matchRoot.getLeftElement().eResource();
            this.doDiffDelegate(diffRoot, matchRoot);
        }
        this.unMatchedElements.clear();
        for (UnMatchElement unMatchElement : match.getUnMatchedElements()) {
            boolean isChild = false;
            boolean isAncestor = false;
            for (Object object : match.getUnMatchedElements()) {
                if (unMatchElement != (UnMatchElement)object) {
                    if (EcoreUtil.isAncestor((EObject)unMatchElement.getElement(), (EObject)((UnMatchElement)object).getElement())) {
                        isAncestor = true;
                    }
                    if (EcoreUtil.isAncestor((EObject)((UnMatchElement)object).getElement(), (EObject)unMatchElement.getElement())) {
                        isChild = true;
                    }
                }
                if (isChild || isAncestor) break;
            }
            if (isChild) continue;
            this.unMatchedElements.put(unMatchElement, isAncestor);
        }
        if (this.unMatchedElements.size() > 0) {
            if (leftModel == null) {
                for (UnMatchElement element : this.unMatchedElements.keySet()) {
                    if (element.getElement().eResource() == null || !element.getElement().eResource().getURI().toString().equals(match.getLeftModel())) continue;
                    leftModel = element.getElement().eResource();
                    break;
                }
            }
            this.processUnMatchedElements(diffRoot, leftModel, this.unMatchedElements);
        }
        return diffRoot;
    }

    protected DiffGroup doDiffTwoWay(MatchModel match) {
        DiffGroup diffRoot = DiffFactory.eINSTANCE.createDiffGroup();
        Resource leftModel = null;
        if (match.getMatchedElements().size() > 0) {
            Match2Elements matchRoot = (Match2Elements)match.getMatchedElements().get(0);
            leftModel = matchRoot.getLeftElement().eResource();
            this.doDiffDelegate(diffRoot, matchRoot);
        }
        ArrayList<UnMatchElement> unMatched = new ArrayList<UnMatchElement>();
        for (Object anUnMatched : match.getUnMatchedElements()) {
            unMatched.add((UnMatchElement)anUnMatched);
        }
        if (leftModel == null) {
            for (UnMatchElement element : unMatched) {
                if (element.getElement().eResource() == null || !element.getElement().eResource().getURI().toString().equals(match.getLeftModel())) continue;
                leftModel = element.getElement().eResource();
                break;
            }
        }
        this.processUnMatchedElements(diffRoot, leftModel, unMatched);
        return diffRoot;
    }

    protected EObject getMatchedEObject(EObject from) {
        EObject matchedEObject = null;
        Match2Elements matchElem = this.eObjectToMatch.get(from);
        if (matchElem != null && from.equals(matchElem.getRightElement())) {
            matchedEObject = matchElem.getLeftElement();
        } else if (matchElem != null) {
            matchedEObject = matchElem.getRightElement();
        }
        return matchedEObject;
    }

    protected EObject getMatchedEObject(EObject from, int side) throws IllegalArgumentException {
        if (side != 1 && side != 2 && side != 0) {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("DiffMaker.IllegalSide"));
        }
        EObject matchedEObject = null;
        Match2Elements matchElem = this.eObjectToMatch.get(from);
        if (matchElem != null) {
            if (side == 1) {
                matchedEObject = matchElem.getLeftElement();
            } else if (side == 2) {
                matchedEObject = matchElem.getRightElement();
            } else if (side == 0 && matchElem instanceof Match3Element) {
                matchedEObject = ((Match3Element)matchElem).getOriginElement();
            }
        }
        return matchedEObject;
    }

    protected void processUnMatchedElements(DiffGroup diffRoot, Resource leftModel, List<UnMatchElement> unMatched) {
        for (UnMatchElement unMatchElement : unMatched) {
            ModelElementChange operation;
            EObject element = unMatchElement.getElement();
            if (element.eResource() == leftModel) {
                operation = DiffFactory.eINSTANCE.createRemoveModelElement();
                operation.setLeftElement(element);
                if (element.eContainer() != null) {
                    operation.setRightParent(this.getMatchedEObject(element.eContainer()));
                }
                this.addInContainerPackage(diffRoot, operation, element.eContainer());
                continue;
            }
            operation = DiffFactory.eINSTANCE.createAddModelElement();
            operation.setRightElement(element);
            if (element.eContainer() != null) {
                operation.setLeftParent(this.getMatchedEObject(element.eContainer()));
                this.addInContainerPackage(diffRoot, operation, this.getMatchedEObject(element.eContainer()));
                continue;
            }
            this.addInContainerPackage(diffRoot, operation, element.eContainer());
        }
    }

    protected void processUnMatchedElements(DiffGroup diffRoot, Resource leftModel, Map<UnMatchElement, Boolean> unMatched) {
        for (UnMatchElement unMatchElement : unMatched.keySet()) {
            ModelElementChange removeOperation;
            DiffElement operation;
            ModelElementChange addOperation;
            boolean isConflicting = unMatched.get(unMatchElement);
            EObject element = unMatchElement.getElement();
            EObject matchedParent = this.getMatchedEObject(element.eContainer());
            EObject matchedAncestor = this.getMatchedEObject(element, 0);
            if (unMatchElement instanceof RemoteUnMatchElement && element.eResource() == leftModel) {
                addOperation = DiffFactory.eINSTANCE.createRemoteAddModelElement();
                addOperation.setLeftElement(element);
                addOperation.setRightParent(matchedParent);
                this.addInContainerPackage(diffRoot, addOperation, element.eContainer());
                continue;
            }
            if (unMatchElement instanceof RemoteUnMatchElement) {
                if (isConflicting) {
                    operation = DiffFactory.eINSTANCE.createConflictingDiffElement();
                    operation.setLeftParent(matchedParent);
                    ((ConflictingDiffElement)operation).setRightParent(element);
                    ((ConflictingDiffElement)operation).setOriginElement(matchedAncestor);
                    removeOperation = DiffFactory.eINSTANCE.createRemoteRemoveModelElement();
                    removeOperation.setRightElement(element);
                    removeOperation.setLeftParent(matchedParent);
                    operation.getSubDiffElements().add((Object)removeOperation);
                } else {
                    operation = DiffFactory.eINSTANCE.createRemoteRemoveModelElement();
                    ((RemoteRemoveModelElement)operation).setRightElement(element);
                    ((RemoteRemoveModelElement)operation).setLeftParent(matchedParent);
                }
                this.addInContainerPackage(diffRoot, operation, matchedParent);
                continue;
            }
            if (element.eResource() == leftModel) {
                if (isConflicting) {
                    operation = DiffFactory.eINSTANCE.createConflictingDiffElement();
                    ((ConflictingDiffElement)operation).setLeftParent(element);
                    ((ConflictingDiffElement)operation).setRightParent(matchedParent);
                    ((ConflictingDiffElement)operation).setOriginElement(matchedAncestor);
                    removeOperation = DiffFactory.eINSTANCE.createRemoveModelElement();
                    removeOperation.setLeftElement(element);
                    removeOperation.setRightParent(matchedParent);
                    operation.getSubDiffElements().add((Object)removeOperation);
                } else {
                    operation = DiffFactory.eINSTANCE.createRemoveModelElement();
                    ((RemoveModelElement)operation).setLeftElement(element);
                    ((RemoveModelElement)operation).setRightParent(matchedParent);
                }
                this.addInContainerPackage(diffRoot, operation, matchedParent);
                continue;
            }
            addOperation = DiffFactory.eINSTANCE.createAddModelElement();
            addOperation.setRightElement(element);
            addOperation.setLeftParent(matchedParent);
            this.addInContainerPackage(diffRoot, addOperation, matchedParent);
        }
    }

    protected boolean shouldBeIgnored(EAttribute attribute) {
        boolean ignore = attribute.isTransient();
        return ignore |= attribute.isDerived();
    }

    protected boolean shouldBeIgnored(EReference reference) {
        boolean ignore = reference.isContainment();
        ignore |= reference.isDerived();
        ignore |= reference.isTransient();
        return ignore |= reference.isContainer();
    }

    private DiffGroup buildHierarchyGroup(EObject targetParent, DiffGroup root) {
        DiffGroup curGroup = DiffFactory.eINSTANCE.createDiffGroup();
        curGroup.setLeftParent(targetParent);
        DiffGroup targetGroup = this.findExistingGroup(root, targetParent);
        if (targetGroup != null) {
            curGroup = targetGroup;
        }
        if (targetParent.eContainer() == null) {
            root.getSubDiffElements().add((Object)curGroup);
            return curGroup;
        }
        this.buildHierarchyGroup(targetParent.eContainer(), root).getSubDiffElements().add((Object)curGroup);
        return curGroup;
    }

    private void checkConflictingAttributesUpdate(DiffGroup root, EAttribute attribute, Match3Element mapping) throws FactoryException {
        if (!attribute.isMany()) {
            this.createConflictingAttributeChange(root, attribute, mapping);
        } else {
            AttributeChange operation;
            List<EObject> leftValue = this.internalConvertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attribute.getName()));
            List<EObject> rightValue = this.internalConvertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attribute.getName()));
            List<EObject> ancestorValue = this.internalConvertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)attribute.getName()));
            for (EObject aValue : leftValue) {
                if (!rightValue.contains(aValue) && !ancestorValue.contains(aValue)) {
                    operation = DiffFactory.eINSTANCE.createRemoteAddAttribute();
                    operation.setAttribute(attribute);
                    operation.setRightElement(mapping.getRightElement());
                    operation.setLeftElement(mapping.getLeftElement());
                    operation.setLeftTarget(aValue);
                    root.getSubDiffElements().add((Object)operation);
                    continue;
                }
                if (rightValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createRemoveAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (EObject aValue : rightValue) {
                if (!leftValue.contains(aValue) && !ancestorValue.contains(aValue)) {
                    operation = DiffFactory.eINSTANCE.createAddAttribute();
                    operation.setAttribute(attribute);
                    operation.setRightElement(mapping.getRightElement());
                    operation.setLeftElement(mapping.getLeftElement());
                    operation.setRightTarget(aValue);
                    root.getSubDiffElements().add((Object)operation);
                    continue;
                }
                if (leftValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createRemoteRemoveAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        }
    }

    private List<EObject> computeAddedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        if (leftReferences != null) {
            deletedReferences.addAll(leftReferences);
        }
        if (rightReferences != null) {
            addedReferences.addAll(rightReferences);
        }
        List<EObject> matchedOldReferences = this.getMatchedReferences(deletedReferences);
        addedReferences.removeAll(matchedOldReferences);
        ArrayList<EObject> remoteMatchedElements = new ArrayList<EObject>();
        for (EObject deleted : deletedReferences) {
            if (!addedReferences.contains(deleted)) continue;
            remoteMatchedElements.add(deleted);
        }
        addedReferences.removeAll(remoteMatchedElements);
        return addedReferences;
    }

    private List<EObject> computeDeletedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        if (leftReferences != null) {
            deletedReferences.addAll(leftReferences);
        }
        if (rightReferences != null) {
            addedReferences.addAll(rightReferences);
        }
        List<EObject> matchedNewReferences = this.getMatchedReferences(addedReferences);
        deletedReferences.removeAll(matchedNewReferences);
        ArrayList<EObject> remoteMatchedElements = new ArrayList<EObject>();
        for (EObject deleted : deletedReferences) {
            if (!addedReferences.contains(deleted)) continue;
            remoteMatchedElements.add(deleted);
        }
        deletedReferences.removeAll(remoteMatchedElements);
        return deletedReferences;
    }

    private void createConflictingAttributeChange(DiffGroup root, EAttribute attribute, Match3Element mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingAttributeChange(dummyGroup, attribute, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            conflictingDiff.getSubDiffElements().add((Object)((DiffElement)dummyGroup.getSubDiffElements().get(0)));
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private void createConflictingReferenceUpdate(DiffGroup root, EReference reference, Match3Element mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingReferencesUpdate(dummyGroup, reference, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            conflictingDiff.getSubDiffElements().add((Object)((DiffElement)dummyGroup.getSubDiffElements().get(0)));
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private void createMoveOperation(DiffGroup root, EObject left, EObject right) {
        MoveModelElement operation = DiffFactory.eINSTANCE.createMoveModelElement();
        operation.setRightElement(right);
        operation.setLeftElement(left);
        operation.setRightTarget(this.getMatchedEObject(left.eContainer()));
        operation.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add((Object)operation);
    }

    private void createNewReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> addedReferences) {
        for (EObject eobj : addedReferences) {
            AddReferenceValue addOperation = DiffFactory.eINSTANCE.createAddReferenceValue();
            addOperation.setRightElement(right);
            addOperation.setLeftElement(left);
            addOperation.setReference(reference);
            addOperation.setRightAddedTarget(eobj);
            if (this.getMatchedEObject(eobj) != null) {
                addOperation.setLeftAddedTarget(this.getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)addOperation);
        }
    }

    private void createNonConflictingAttributeChange(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement) throws FactoryException {
        if (attribute.isMany()) {
            AttributeChange operation;
            List leftValue = EFactory.eGetAsList((EObject)leftElement, (String)attribute.getName());
            List rightValue = EFactory.eGetAsList((EObject)rightElement, (String)attribute.getName());
            for (Object aValue : leftValue) {
                if (rightValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createRemoveAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(rightElement);
                operation.setLeftElement(leftElement);
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (Object aValue : rightValue) {
                if (leftValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAddAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(rightElement);
                operation.setLeftElement(leftElement);
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        } else {
            UpdateAttribute operation = DiffFactory.eINSTANCE.createUpdateAttribute();
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }

    private void createNonConflictingReferencesUpdate(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement) throws FactoryException {
        List leftElementReferences = EFactory.eGetAsList((EObject)leftElement, (String)reference.getName());
        List rightElementReferences = EFactory.eGetAsList((EObject)rightElement, (String)reference.getName());
        List<EObject> deletedReferences = this.computeDeletedReferences(leftElementReferences, rightElementReferences);
        List<EObject> addedReferences = this.computeAddedReferences(leftElementReferences, rightElementReferences);
        if (!reference.isMany()) {
            EObject addedValue = null;
            EObject deletedValue = null;
            if (addedReferences.size() > 0) {
                addedValue = addedReferences.get(0);
            }
            if (deletedReferences.size() > 0) {
                deletedValue = deletedReferences.get(0);
            }
            if ((addedValue == null || deletedValue == null) && addedValue != deletedValue) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(leftElement, rightElement, reference, addedValue, deletedValue));
            } else if (addedValue != null && deletedValue != null && !EcoreUtil.getURI((EObject)addedValue).equals((Object)EcoreUtil.getURI((EObject)deletedValue))) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(leftElement, rightElement, reference, addedValue, deletedValue));
            }
        } else {
            if (addedReferences.size() > 0) {
                this.createNewReferencesOperation(root, leftElement, rightElement, reference, addedReferences);
            }
            if (deletedReferences.size() > 0) {
                this.createRemovedReferencesOperation(root, leftElement, rightElement, reference, deletedReferences);
            }
        }
    }

    private void createRemoteAttributeChange(DiffGroup root, EAttribute attribute, Match3Element mapping) throws FactoryException {
        if (attribute.isMany()) {
            AttributeChange operation;
            List leftValue = EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attribute.getName());
            List rightValue = EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attribute.getName());
            for (Object aValue : leftValue) {
                if (rightValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createRemoteAddAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (Object aValue : rightValue) {
                if (leftValue.contains(aValue)) continue;
                operation = DiffFactory.eINSTANCE.createRemoteRemoveAttribute();
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        } else {
            RemoteUpdateAttribute operation = DiffFactory.eINSTANCE.createRemoteUpdateAttribute();
            operation.setRightElement(mapping.getRightElement());
            operation.setLeftElement(mapping.getLeftElement());
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }

    private void createRemoteMoveOperation(DiffGroup root, EObject left, EObject right) {
        RemoteMoveModelElement operation = DiffFactory.eINSTANCE.createRemoteMoveModelElement();
        operation.setRightElement(right);
        operation.setLeftElement(left);
        operation.setRightTarget(this.getMatchedEObject(left.eContainer()));
        operation.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add((Object)operation);
    }

    private void createRemoteReferencesUpdate(DiffGroup root, EReference reference, Match3Element mapping, List<EObject> remotelyAdded, List<EObject> remotelyDeleted) {
        if (!reference.isMany() && remotelyAdded.size() > 0 && remotelyDeleted.size() > 0) {
            RemoteUpdateUniqueReferenceValue operation = DiffFactory.eINSTANCE.createRemoteUpdateUniqueReferenceValue();
            operation.setLeftElement(mapping.getLeftElement());
            operation.setRightElement(mapping.getRightElement());
            operation.setReference(reference);
            EObject leftTarget = this.getMatchedEObject(remotelyAdded.get(0));
            EObject rightTarget = this.getMatchedEObject(remotelyDeleted.get(0));
            if (leftTarget == null) {
                leftTarget = remotelyAdded.get(0);
            }
            if (rightTarget == null) {
                rightTarget = remotelyDeleted.get(0);
            }
            operation.setLeftTarget(leftTarget);
            operation.setRightTarget(rightTarget);
            root.getSubDiffElements().add((Object)operation);
        } else {
            for (EObject eobj : remotelyAdded) {
                RemoteAddReferenceValue addOperation = DiffFactory.eINSTANCE.createRemoteAddReferenceValue();
                addOperation.setRightElement(mapping.getRightElement());
                addOperation.setLeftElement(mapping.getLeftElement());
                addOperation.setReference(reference);
                addOperation.setLeftRemovedTarget(eobj);
                if (this.getMatchedEObject(eobj) != null) {
                    addOperation.setRightRemovedTarget(this.getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)addOperation);
            }
            for (EObject eobj : remotelyDeleted) {
                RemoteRemoveReferenceValue delOperation = DiffFactory.eINSTANCE.createRemoteRemoveReferenceValue();
                delOperation.setRightElement(mapping.getRightElement());
                delOperation.setLeftElement(mapping.getLeftElement());
                delOperation.setReference(reference);
                delOperation.setRightAddedTarget(eobj);
                if (this.getMatchedEObject(eobj) != null) {
                    delOperation.setLeftAddedTarget(this.getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)delOperation);
            }
        }
    }

    private void createRemovedReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> deletedReferences) {
        for (EObject eobj : deletedReferences) {
            RemoveReferenceValue delOperation = DiffFactory.eINSTANCE.createRemoveReferenceValue();
            delOperation.setRightElement(right);
            delOperation.setLeftElement(left);
            delOperation.setReference(reference);
            delOperation.setLeftRemovedTarget(eobj);
            if (this.getMatchedEObject(eobj) != null) {
                delOperation.setRightRemovedTarget(this.getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)delOperation);
        }
    }

    private UpdateUniqueReferenceValue createUpdatedReferenceOperation(EObject left, EObject right, EReference reference, EObject addedValue, EObject deletedValue) {
        UpdateUniqueReferenceValue operation = DiffFactory.eINSTANCE.createUpdateUniqueReferenceValue();
        operation.setLeftElement(left);
        operation.setRightElement(right);
        operation.setReference(reference);
        EObject leftTarget = this.getMatchedEObject(addedValue);
        EObject rightTarget = this.getMatchedEObject(deletedValue);
        if (leftTarget == null) {
            leftTarget = addedValue;
        }
        if (rightTarget == null) {
            rightTarget = deletedValue;
        }
        operation.setLeftTarget(leftTarget);
        operation.setRightTarget(rightTarget);
        return operation;
    }

    private void doDiffDelegate(DiffGroup root, Match2Elements match) {
        DiffGroup current = DiffFactory.eINSTANCE.createDiffGroup();
        current.setLeftParent(match.getLeftElement());
        try {
            this.checkForDiffs(current, match);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        ArrayList<DiffElement> shouldAddToList = new ArrayList<DiffElement>();
        if (current.getSubDiffElements().size() > 0) {
            for (DiffElement diff : current.getSubDiffElements()) {
                if (diff instanceof DiffGroup) continue;
                shouldAddToList.add(diff);
            }
            for (DiffElement diff : shouldAddToList) {
                this.addInContainerPackage(root, diff, current.getLeftParent());
            }
        } else {
            current = root;
        }
        for (Match2Elements element : match.getSubMatchElements()) {
            this.doDiffDelegate(root, element);
        }
    }

    private void doDiffDelegate(DiffGroup root, Match3Element match) {
        DiffGroup current = DiffFactory.eINSTANCE.createDiffGroup();
        current.setLeftParent(match.getLeftElement());
        try {
            this.checkForDiffs(current, match);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        ArrayList<DiffElement> shouldAddToList = new ArrayList<DiffElement>();
        if (current.getSubDiffElements().size() > 0) {
            for (DiffElement diff : current.getSubDiffElements()) {
                if (diff instanceof DiffGroup) continue;
                shouldAddToList.add(diff);
            }
            for (DiffElement diff : shouldAddToList) {
                this.addInContainerPackage(root, diff, current.getLeftParent());
            }
        } else {
            current = root;
        }
        for (MatchElement element : match.getSubMatchElements()) {
            if (element instanceof Match3Element) {
                this.doDiffDelegate(root, (Match3Element)element);
                continue;
            }
            this.doDiffDelegate(root, (Match2Elements)element);
        }
    }

    private DiffGroup findExistingGroup(DiffGroup root, EObject targetParent) {
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof DiffGroup) || ((DiffGroup)obj).getLeftParent() != targetParent) continue;
            return (DiffGroup)obj;
        }
        return null;
    }

    private List<EObject> getMatchedReferences(List<EObject> references) {
        ArrayList<EObject> matchedReferences = new ArrayList<EObject>();
        for (EObject currentReference : references) {
            EObject currentMapped;
            if (currentReference == null || (currentMapped = this.getMatchedEObject(currentReference)) == null) continue;
            matchedReferences.add(currentMapped);
        }
        return matchedReferences;
    }

    private List<EObject> internalConvertFeatureMapList(List<?> input) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object inputValue : input) {
            result.add(this.internalFindActualEObject(inputValue));
        }
        return result;
    }

    private EObject internalFindActualEObject(Object data) {
        if (data instanceof FeatureMap.Entry) {
            return this.internalFindActualEObject(((FeatureMap.Entry)data).getValue());
        }
        return (EObject)data;
    }

    private boolean isConflictual(EReference reference, List<?> leftReferences, List<?> rightReferences, List<?> ancestorReferences) {
        boolean isConflictual = false;
        if (!reference.isMany()) {
            if (leftReferences.size() != ancestorReferences.size() && rightReferences.size() != ancestorReferences.size()) {
                if (leftReferences.size() > 0 && !leftReferences.get(0).equals(this.getMatchedEObject((EObject)rightReferences.get(0)))) {
                    isConflictual = true;
                }
            } else if (!(leftReferences.size() <= 0 || rightReferences.size() <= 0 || leftReferences.get(0).equals(this.getMatchedEObject((EObject)ancestorReferences.get(0), 1)) || rightReferences.get(0).equals(this.getMatchedEObject((EObject)ancestorReferences.get(0), 2)) || rightReferences.get(0).equals(this.getMatchedEObject((EObject)leftReferences.get(0))))) {
                isConflictual = true;
            }
        }
        return isConflictual;
    }

    private void populateThreeWayReferencesChanges(Match3Element mapping, EReference reference, List<EObject> addedReferences, List<EObject> deletedReferences, List<EObject> remoteAddedReferences, List<EObject> remoteDeletedReferences) throws FactoryException {
        String referenceName = reference.getName();
        List leftReferences = EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName);
        List rightReferences = EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName);
        List ancestorReferences = EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName);
        for (Object left : leftReferences) {
            if (!(left instanceof EObject) || ancestorReferences.contains(this.getMatchedEObject((EObject)left, 0)) || rightReferences.contains(this.getMatchedEObject((EObject)left))) continue;
            remoteAddedReferences.add((EObject)left);
        }
        for (Object right : rightReferences) {
            if (!(right instanceof EObject) || ancestorReferences.contains(this.getMatchedEObject((EObject)right, 0)) || leftReferences.contains(this.getMatchedEObject((EObject)right))) continue;
            addedReferences.add((EObject)right);
        }
        for (Object origin : ancestorReferences) {
            if (origin instanceof EObject && !leftReferences.contains(this.getMatchedEObject((EObject)origin, 1)) && rightReferences.contains(this.getMatchedEObject((EObject)origin, 2))) {
                remoteDeletedReferences.add((EObject)origin);
                continue;
            }
            if (!(origin instanceof EObject) || rightReferences.contains(this.getMatchedEObject((EObject)origin, 2)) || !leftReferences.contains(this.getMatchedEObject((EObject)origin, 1))) continue;
            deletedReferences.add((EObject)origin);
        }
    }

    private void updateEObjectToMatch(MatchModel match, boolean threeWay) {
        for (Match2Elements matchRoot : match.getMatchedElements()) {
            this.eObjectToMatch.put(matchRoot.getLeftElement(), matchRoot);
            this.eObjectToMatch.put(matchRoot.getRightElement(), matchRoot);
            if (threeWay) {
                this.eObjectToMatch.put(((Match3Element)matchRoot).getOriginElement(), matchRoot);
            }
            TreeIterator matchElemIt = matchRoot.eAllContents();
            while (matchElemIt.hasNext()) {
                Match2Elements matchElem = (Match2Elements)matchElemIt.next();
                this.eObjectToMatch.put(matchElem.getLeftElement(), matchElem);
                this.eObjectToMatch.put(matchElem.getRightElement(), matchElem);
                if (!threeWay || ((Match3Element)matchElem).getOriginElement() == null) continue;
                this.eObjectToMatch.put(((Match3Element)matchElem).getOriginElement(), matchElem);
            }
        }
    }
}

