/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceFactoryHelper;
import org.eclipse.emf.cdo.examples.ui.internal.ExampleUIActivator;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDOExportWizardPage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class CDOExportWizard
extends Wizard
implements IImportWizard {
    public static final String WIZARD_ID = "org.eclipse.emf.cdo.examples.ui.CDOExportWizard";
    public static final String TITLE = "Export CDO Resource";
    private CDOExportWizardPage page;
    private CDOResource resource;
    private IStructuredSelection selection;

    public CDOExportWizard(CDOResource resource) {
        this.resource = resource;
        this.setDialogSettings(CDOExportWizard.getCDOExportWizardDialogSettings());
        this.setWindowTitle(TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public CDOExportWizard() {
        this(null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new CDOExportWizardPage(this.resource, this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public static IDialogSettings getCDOExportWizardDialogSettings() {
        IDialogSettings workbenchSettings = ExampleUIActivator.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("CDOExportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("CDOExportWizard");
        }
        return section;
    }

    public boolean performFinish() {
        final String sourcePath = this.page.getSourcePath();
        final String destinationURI = this.page.getDestinationURI();
        final String resourceFactoryExtension = this.page.getResourceFactoryExtension();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    CDOExportWizard.this.doFinish(sourcePath, resourceFactoryExtension, destinationURI, monitor);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.page.saveValues();
        return true;
    }

    private void doFinish(String sourcePath, String resourceFactoryExtension, String destinationURI, IProgressMonitor monitor) throws Exception {
        CDOResource source;
        URI uri;
        ResourceManager resourceManager;
        if (this.resource == null) {
            resourceManager = ExampleClientPlugin.createResourceManager((ResourceSet)new ResourceSetImpl());
            uri = URI.createURI((String)("cdo://" + sourcePath));
            source = (CDOResource)resourceManager.getResource(uri, true);
        } else {
            resourceManager = this.resource.getResourceManager();
            source = this.resource;
        }
        uri = URI.createURI((String)destinationURI);
        IPath path = new Path(uri.path()).removeLastSegments(1);
        ContainerGenerator gen = new ContainerGenerator(path);
        gen.generateContainer(monitor);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("*", ResourceFactoryHelper.getResourceFactory(resourceFactoryExtension));
        Resource destination = resourceSet.createResource(uri);
        source.preLoad();
        Collection contents = EcoreUtil.copyAll((Collection)source.getContents());
        for (EObject object : contents) {
            destination.getContents().add((Object)object);
        }
        destination.save(Collections.EMPTY_MAP);
        if (this.resource == null) {
            resourceManager.stop();
        }
    }
}

