/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.views;

import java.util.HashSet;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.protocol.ClientCDOResProtocolImpl;
import org.eclipse.emf.cdo.examples.client.ResourceCache;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceContentProvider;
import org.eclipse.emf.cdo.examples.ui.ResourceLabelProvider;
import org.eclipse.emf.cdo.examples.ui.UIUtils;
import org.eclipse.emf.cdo.examples.ui.internal.actions.CDOCreateResourceAction;
import org.eclipse.emf.cdo.examples.ui.internal.actions.CDOExportResourceAction;
import org.eclipse.emf.cdo.examples.ui.internal.actions.CDOImportResourceAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.core.Channel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class CDOExplorer
extends ViewPart
implements ISelectionProvider {
    public static final String VIEW_ID = "org.eclipse.emf.cdo.examples.ui.CDOExplorer";
    public static CDOExplorer INSTANCE;
    private ResourceCache resourceCache;
    private TableViewer viewer;
    private Action deleteResourceAction;
    private CDOCreateResourceAction createResourceAction;
    private CDOImportResourceAction importResourceAction;
    private CDOExportResourceAction exportResourceAction;
    private Action openResourceAction;

    public CDOExplorer() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        this.resourceCache = ExampleClientPlugin.getResourceCache();
    }

    public synchronized void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.resourceCache);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        INSTANCE = this;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public void dispose() {
        INSTANCE = null;
        super.dispose();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CDOExplorer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.createResourceAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteResourceAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importResourceAction);
        manager.add((IAction)this.exportResourceAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.deleteResourceAction);
        manager.add((IAction)this.exportResourceAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.createResourceAction);
        manager.add((IAction)this.deleteResourceAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importResourceAction);
        manager.add((IAction)this.exportResourceAction);
    }

    private void makeActions() {
        this.createResourceAction = new CDOCreateResourceAction();
        this.importResourceAction = new CDOImportResourceAction();
        this.exportResourceAction = new CDOExportResourceAction();
        this.deleteResourceAction = new Action(){

            public void run() {
                if (MessageDialog.openQuestion((Shell)CDOExplorer.this.viewer.getControl().getShell(), (String)"CDO Explorer", (String)"Sure to delete the selected resources from the CDO repository?")) {
                    HashSet<Integer> rids = new HashSet<Integer>();
                    ISelection selection = CDOExplorer.this.viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ssel = (IStructuredSelection)selection;
                        for (Object element : ssel) {
                            int rid;
                            if (element instanceof ResourceInfo) {
                                ResourceInfo resourceInfo = (ResourceInfo)element;
                                rid = resourceInfo.getRID();
                                rids.add(rid);
                                continue;
                            }
                            if (!(element instanceof CDOResource)) continue;
                            CDOResource resource = (CDOResource)element;
                            rid = resource.getRID();
                            rids.add(rid);
                        }
                    }
                    if (rids.isEmpty()) {
                        CDOExplorer.this.showMessage("No CDO resource is selected.");
                        return;
                    }
                    Channel channel = CDOExplorer.this.resourceCache.getChannel();
                    boolean ok = ClientCDOResProtocolImpl.deleteResources((Channel)channel, rids);
                    if (ok) {
                        CDOExplorer.this.showMessage("Resources have been successfully deleted.");
                    } else {
                        CDOExplorer.this.showMessage("Resources have not been deleted.");
                    }
                }
            }
        };
        this.deleteResourceAction.setText("Delete CDO Resource");
        this.deleteResourceAction.setToolTipText("Delete CDO Resource");
        this.deleteResourceAction.setImageDescriptor(UIUtils.getImageDescriptor("full/ctool16/DeleteCDOResource"));
        this.openResourceAction = new Action(){

            public void run() {
                ISelection selection = CDOExplorer.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ResourceInfo) {
                    UIUtils.openCDOEditor((ResourceInfo)obj);
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CDOExplorer.this.openResourceAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"CDO Explorer", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

