/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceContentProvider;
import org.eclipse.emf.cdo.examples.ui.ResourceLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOLoadResourceDialog
extends Dialog {
    private TableViewer resourcesViewer;
    private List<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();

    public CDOLoadResourceDialog(Shell parentShell) {
        super(parentShell);
    }

    public List<ResourceInfo> getResourceInfos() {
        return this.resourceInfos;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResourceDialog_title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Table table = new Table(container, 2050);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resourcesViewer = new TableViewer(table);
        this.resourcesViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.resourcesViewer.setSorter(new ViewerSorter());
        this.resourcesViewer.setInput((Object)ExampleClientPlugin.getResourceCache());
        this.resourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CDOLoadResourceDialog.this.resourceInfos.clear();
                IStructuredSelection selection = (IStructuredSelection)CDOLoadResourceDialog.this.resourcesViewer.getSelection();
                for (ResourceInfo element : selection) {
                    CDOLoadResourceDialog.this.resourceInfos.add(element);
                }
                CDOLoadResourceDialog.this.dialogChanged();
            }
        });
        this.resourcesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CDOLoadResourceDialog.this.okPressed();
            }
        });
        this.dialogChanged();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 375);
    }

    private void dialogChanged() {
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(!this.resourceInfos.isEmpty());
        }
    }
}

