/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.applier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.epatch.Assignment;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.CreatedObject;
import org.eclipse.emf.compare.epatch.EPackageImport;
import org.eclipse.emf.compare.epatch.Epatch;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.ModelImport;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.NamedResource;
import org.eclipse.emf.compare.epatch.ObjectCopy;
import org.eclipse.emf.compare.epatch.ObjectNew;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.ResourceImport;
import org.eclipse.emf.compare.epatch.SingleAssignment;
import org.eclipse.emf.compare.epatch.applier.AbstractEpatchMapping;
import org.eclipse.emf.compare.epatch.applier.ApplyStrategy;
import org.eclipse.emf.compare.epatch.applier.EpatchApplyStrategy;
import org.eclipse.emf.compare.epatch.applier.EpatchMapping;
import org.eclipse.emf.compare.epatch.util.EpatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyingEpatchApplier {
    protected EpatchApplyStrategy dir;
    protected Epatch epatch;
    protected Map<ModelImport, Resource> imports;
    protected Map<NamedResource, Resource> inputResources;
    protected Map<NamedResource, Resource> outputResources;
    protected ResourceSet outputResourceSet;
    protected ApplyStrategy strategy;
    protected EpatchMapping triMap;

    public CopyingEpatchApplier(ApplyStrategy strategy, Epatch epatch, Map<ModelImport, Resource> imports, Map<NamedResource, Resource> inputResources, ResourceSet outputResourceSet) {
        this.strategy = strategy;
        this.dir = EpatchApplyStrategy.Util.get(strategy);
        this.epatch = epatch;
        this.imports = imports;
        this.inputResources = inputResources;
        this.outputResourceSet = outputResourceSet;
    }

    public CopyingEpatchApplier(ApplyStrategy strategy, Epatch epatch, ResourceSet inputResourceSet) {
        this.strategy = strategy;
        this.dir = EpatchApplyStrategy.Util.get(strategy);
        this.epatch = epatch;
        this.imports = this.matchImports(inputResourceSet);
        this.inputResources = this.matchResources(inputResourceSet);
        this.outputResourceSet = this.createOutputResourceSet(inputResourceSet);
    }

    public void apply() {
        this.createOutputResources();
        this.mapObjects();
        this.copyFeatures();
    }

    protected void copyFeatures() {
        for (NamedResource nr : this.epatch.getResources()) {
            Resource res = this.outputResources.get(nr);
            EObject src = (EObject)this.inputResources.get(nr).getContents().get(0);
            res.getContents().add((Object)this.getDestObject(src, this.dir.getOutputRoot(nr), true));
        }
    }

    protected void createOutputResources() {
        this.outputResources = new HashMap<NamedResource, Resource>();
        for (NamedResource res : this.epatch.getResources()) {
            if (this.dir.getOutputURI(res) == null) continue;
            URI uri = URI.createURI((String)this.dir.getOutputURI(res));
            Resource r = this.outputResourceSet.createResource(uri);
            if (r == null) {
                throw new RuntimeException("Failed to create resource for URI " + uri);
            }
            this.outputResources.put(res, r);
        }
    }

    protected ResourceSet createOutputResourceSet(ResourceSet base) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setPackageRegistry(base.getPackageRegistry());
        rs.setResourceFactoryRegistry(base.getResourceFactoryRegistry());
        return rs;
    }

    protected Object getAssignmentValue(EStructuralFeature feat, AssignmentValue val) {
        if (val.getKeyword() != null) {
            return null;
        }
        if (val.getNewObject() != null) {
            return this.getDestObject(null, val.getNewObject(), ((EReference)feat).isContainment());
        }
        if (val.getValue() != null) {
            EDataType dt = (EDataType)feat.getEType();
            return dt.getEPackage().getEFactoryInstance().createFromString(dt, val.getValue());
        }
        if (val.getRefObject() != null) {
            EObject eobj = this.getDestObject(null, val.getRefObject(), ((EReference)feat).isContainment());
            if (val.getRefFeature() != null) {
                EStructuralFeature rf = eobj.eClass().getEStructuralFeature(val.getRefFeature());
                Object obj = eobj.eGet(rf);
                if (rf.isMany()) {
                    return ((EList)obj).get(val.getRefIndex());
                }
                return obj;
            }
            return eobj;
        }
        if (val.getImport() != null) {
            EObject e = this.getImport(val.getImport()).getEObject(val.getImpFrag());
            if (e == null) {
                throw new RuntimeException("import not resolved!");
            }
            return e;
        }
        return null;
    }

    protected EObject getDestObject(EObject src, NamedObject ptc, boolean init) {
        EpatchMapping.EpatchMappingEntry e;
        if (ptc == null) {
            e = this.triMap.getBySrc(src);
            if (e != null) {
                ptc = e.getPtc();
            }
        } else {
            e = this.triMap.getByPtc(ptc);
        }
        if (ptc == null) {
            EObject dst;
            if (e == null) {
                if (this.isExternal(src)) {
                    return src;
                }
                dst = this.objectClone(src);
                this.triMap.put(src, dst, null);
            } else {
                dst = e.getDst();
            }
            if (init) {
                this.objectClone(src, dst);
            }
            return dst;
        }
        if (init) {
            if (e.getSrc() == null) {
                this.objectCreate(e.getDst(), ptc);
            } else {
                this.objectModify(e.getSrc(), e.getDst(), ptc);
            }
        }
        return e.getDst();
    }

    protected EObject getEObject(CreatedObject obj) {
        EObject parent;
        AssignmentValue asv = (AssignmentValue)obj.eContainer();
        Assignment ass = (Assignment)asv.eContainer();
        NamedObject no = (NamedObject)ass.eContainer();
        if (no instanceof ObjectRef) {
            ObjectRef or = (ObjectRef)no;
            parent = this.getEObject(this.dir.getInputResource(or), this.dir.getInputFragment(or));
        } else if (no instanceof CreatedObject) {
            parent = this.getEObject((CreatedObject)no);
        } else {
            throw new RuntimeException("Unknown Type: " + no.eClass().getName());
        }
        EStructuralFeature f = parent.eClass().getEStructuralFeature(ass.getFeature());
        Object val = parent.eGet(f);
        if (ass instanceof ListAssignment) {
            int i = no instanceof CreatedObject ? ((List)ass.eGet((EStructuralFeature)asv.eContainmentFeature())).indexOf(asv) : asv.getIndex();
            val = ((List)val).get(i);
        }
        return (EObject)val;
    }

    protected EObject getEObject(NamedResource res, String fragment) {
        Resource r = this.inputResources.get(res);
        EObject o = r.getEObject(fragment);
        if (o != null) {
            return o;
        }
        throw new RuntimeException("EObject for " + fragment + " not found in " + r.getURI());
    }

    public Epatch getEpatch() {
        return this.epatch;
    }

    protected Resource getImport(ModelImport imp) {
        Resource r = this.imports.get(imp);
        if (r != null) {
            return r;
        }
        throw new RuntimeException("No Resource Found for import " + imp);
    }

    public EpatchMapping getMap() {
        return this.triMap;
    }

    public ResourceSet getOutputResourceSet() {
        return this.outputResourceSet;
    }

    protected boolean isExternal(EObject obj) {
        for (Resource r : this.inputResources.values()) {
            if (r != obj.eResource()) continue;
            return false;
        }
        return true;
    }

    protected void mapAddedObject(CreatedObject o) {
        if (o instanceof ObjectCopy) {
            ObjectCopy oc = (ObjectCopy)o;
            EObject src = this.getEObject(oc.getResource(), oc.getFragment());
            EObject dst = this.objectClone(src);
            this.triMap.put(o, dst, o);
        } else if (o instanceof ObjectNew) {
            ObjectNew on = (ObjectNew)o;
            Resource res = this.getImport(on.getImport());
            EClass cls = (EClass)res.getEObject(on.getImpFrag());
            EObject dst = cls.getEPackage().getEFactoryInstance().create(cls);
            this.triMap.put(null, dst, o);
        } else {
            throw new RuntimeException("Unknown CreatObject: " + o);
        }
    }

    protected void mapModifiedObject(EObject src, ObjectRef obj) {
        this.triMap.put(src, this.objectClone(src), obj);
    }

    protected void mapObjects() {
        this.triMap = new TriMap();
        for (NamedResource r : this.epatch.getResources()) {
            CreatedObject in = this.dir.getInputRoot(r);
            CreatedObject out = this.dir.getOutputRoot(r);
            if (in != null) {
                this.mapRemovedObject(in);
            }
            if (out == null) continue;
            this.mapAddedObject(out);
        }
        for (ObjectRef nobj : this.epatch.getObjects()) {
            EObject eobj = this.getEObject(this.dir.getInputResource(nobj), this.dir.getInputFragment(nobj));
            this.mapModifiedObject(eobj, nobj);
            for (CreatedObject o : this.dir.getAllAddedObjects(nobj)) {
                this.mapAddedObject(o);
            }
            for (CreatedObject o : this.dir.getAllRemovedObjects(nobj)) {
                this.mapRemovedObject(o);
            }
        }
    }

    protected void mapRemovedObject(CreatedObject o) {
        this.triMap.put(this.getEObject(o), null, o);
    }

    protected Map<ModelImport, Resource> matchImports(ResourceSet rs) {
        HashMap<ModelImport, Resource> map = new HashMap<ModelImport, Resource>();
        for (ModelImport imp : this.epatch.getModelImports()) {
            if (!(imp instanceof ModelImport)) continue;
            map.put(imp, this.matchImports(rs, imp));
        }
        return map;
    }

    protected Resource matchImports(ResourceSet rs, ModelImport imp) {
        block6: {
            block5: {
                if (!(imp instanceof EPackageImport)) break block5;
                EPackageImport ei = (EPackageImport)imp;
                EPackage pkg = rs.getPackageRegistry().getEPackage(ei.getNsURI());
                if (pkg != null) {
                    return pkg.eResource();
                }
                for (Resource r : rs.getResources()) {
                    for (EObject o : r.getContents()) {
                        if (!(o instanceof EPackage)) continue;
                        EPackage p = (EPackage)o;
                        if (!ei.getNsURI().equals(p.getNsURI())) continue;
                        return r;
                    }
                }
                break block6;
            }
            if (!(imp instanceof ResourceImport)) break block6;
            ResourceImport ri = (ResourceImport)imp;
            Resource res = rs.getResource(URI.createURI((String)ri.getUri()), true);
            if (res != null) {
                return res;
            }
            for (Resource r : rs.getResources()) {
                if (r.getURI() == null || !r.getURI().toString().endsWith(ri.getUri())) continue;
                return r;
            }
        }
        throw new RuntimeException("No Resource found in ResourceSet for Import :" + imp + " ResourceSet:" + rs);
    }

    protected boolean matchResource(NamedResource res, Resource resources) {
        for (ObjectRef obj : this.epatch.getObjects()) {
            if (this.dir.getInputResource(obj) != res) continue;
            EObject o = resources.getEObject(this.dir.getInputFragment(obj));
            if (o == null) {
                return false;
            }
            for (Assignment ass : obj.getAssignments()) {
                EStructuralFeature f = o.eClass().getEStructuralFeature(ass.getFeature());
                if (f != null) continue;
                return false;
            }
        }
        return true;
    }

    protected Resource matchResource(NamedResource res, ResourceSet resources) {
        for (Resource r : resources.getResources()) {
            if (!this.matchResource(res, r)) continue;
            return r;
        }
        throw new RuntimeException("No Resource found in ResourceSet for " + this.dir.getInputURI(res));
    }

    protected Map<NamedResource, Resource> matchResources(ResourceSet input) {
        HashMap<NamedResource, Resource> map = new HashMap<NamedResource, Resource>();
        for (NamedResource r : this.epatch.getResources()) {
            map.put(r, this.matchResource(r, input));
        }
        return map;
    }

    protected EObject objectClone(EObject obj) {
        EClass cls = obj.eClass();
        return cls.getEPackage().getEFactoryInstance().create(cls);
    }

    protected void objectClone(EObject src, EObject dst) {
        for (EStructuralFeature f : src.eClass().getEAllStructuralFeatures()) {
            if (!f.isChangeable() || f.isDerived() || f.isTransient() || !src.eIsSet(f)) continue;
            this.objectCloneFeature(src, dst, f);
        }
    }

    protected void objectCloneFeature(EObject src, EObject dst, EStructuralFeature f) {
        if (f.isMany()) {
            EList s = (EList)src.eGet(f);
            EList d = (EList)dst.eGet(f);
            for (Object o : s) {
                d.add(this.objectCopyValue(f, o));
            }
        } else {
            dst.eSet(f, this.objectCopyValue(f, src.eGet(f)));
        }
    }

    protected Object objectCopyValue(EStructuralFeature feature, Object src) {
        if (feature instanceof EReference) {
            EReference r = (EReference)feature;
            return this.getDestObject((EObject)src, null, r.isContainment());
        }
        return src;
    }

    protected void objectCreate(EObject dst, NamedObject ptc) {
        for (Assignment ass : ptc.getAssignments()) {
            EStructuralFeature f = dst.eClass().getEStructuralFeature(ass.getFeature());
            if (ass instanceof ListAssignment) {
                ListAssignment li = (ListAssignment)ass;
                EList vals = (EList)dst.eGet(f);
                for (AssignmentValue av : li.getLeftValues()) {
                    vals.add(this.getAssignmentValue(f, av));
                }
                continue;
            }
            if (!(ass instanceof SingleAssignment)) continue;
            SingleAssignment si = (SingleAssignment)ass;
            dst.eSet(f, this.getAssignmentValue(f, si.getLeftValue()));
        }
    }

    protected void objectModify(EObject src, EObject dst, NamedObject ptc) {
        HashMap<String, Assignment> assmap = new HashMap<String, Assignment>();
        for (Assignment ass : ptc.getAssignments()) {
            assmap.put(ass.getFeature(), ass);
        }
        for (EStructuralFeature f : src.eClass().getEAllStructuralFeatures()) {
            if (!f.isChangeable() || f.isDerived() || f.isTransient()) continue;
            Assignment ass = (Assignment)assmap.get(f.getName());
            if (!src.eIsSet(f) && ass == null) continue;
            if (ass instanceof ListAssignment) {
                this.objectModifyMergeLists(f, (EList<Object>)((EList)src.eGet(f)), (EList<Object>)((EList)dst.eGet(f)), (ListAssignment)ass);
                continue;
            }
            if (ass instanceof SingleAssignment) {
                SingleAssignment si = (SingleAssignment)ass;
                dst.eSet(f, this.getAssignmentValue(f, this.dir.getOutputValue(si)));
                continue;
            }
            this.objectCloneFeature(src, dst, f);
        }
    }

    protected void objectModifyMergeLists(EStructuralFeature fest, EList<Object> src, EList<Object> dst, ListAssignment ass) {
        ArrayList<Object> items = new ArrayList<Object>((Collection<Object>)src);
        HashMap<AssignmentValue, Object> backup = new HashMap<AssignmentValue, Object>();
        for (AssignmentValue a : this.dir.getOutputValues(ass)) {
            if (a.getRefObject() != null || a.getKeyword() != null || a.getNewObject() != null || a.getValue() != null || a.getImport() != null) continue;
            backup.put(a, src.get(a.getRefIndex()));
        }
        ArrayList<AssignmentValue> toRemove = new ArrayList<AssignmentValue>((Collection<AssignmentValue>)this.dir.getInputValues(ass));
        Collections.sort(toRemove, EpatchUtil.ASS_VAL_SORTER_DESC);
        for (AssignmentValue i : toRemove) {
            items.remove(i.getIndex());
        }
        int i = 0;
        while (i < items.size()) {
            items.set(i, this.objectCopyValue(fest, items.get(i)));
            ++i;
        }
        ArrayList<AssignmentValue> toAdd = new ArrayList<AssignmentValue>((Collection<AssignmentValue>)this.dir.getOutputValues(ass));
        Collections.sort(toAdd, EpatchUtil.ASS_VAL_SORTER_ASC);
        for (AssignmentValue i2 : toAdd) {
            Object o = backup.get(i2);
            o = o == null ? this.getAssignmentValue(fest, i2) : this.objectCopyValue(fest, o);
            items.add(i2.getIndex(), o);
        }
        dst.addAll(items);
    }

    protected void printMaps() {
        System.out.println("inputResources:");
        for (Map.Entry<NamedResource, Resource> entry : this.inputResources.entrySet()) {
            System.out.println(String.valueOf(entry.getKey().getName()) + " -> " + entry.getValue().getURI());
        }
        System.out.println("outputResources:");
        for (Map.Entry<NamedResource, Resource> entry : this.outputResources.entrySet()) {
            System.out.println(String.valueOf(entry.getKey().getName()) + " -> " + entry.getValue().getURI());
        }
        System.out.println("triMap:");
        for (EpatchMapping.EpatchMappingEntry epatchMappingEntry : this.triMap.getAllEntries()) {
            System.out.println(epatchMappingEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TriMap
    extends AbstractEpatchMapping {
        @Override
        public Map<NamedResource, Resource> getDstResources() {
            return CopyingEpatchApplier.this.outputResources;
        }

        @Override
        public Map<ModelImport, Resource> getImportedResources() {
            return CopyingEpatchApplier.this.imports;
        }

        @Override
        public Map<NamedResource, Resource> getSrcResources() {
            return CopyingEpatchApplier.this.inputResources;
        }

        @Override
        public ApplyStrategy getStrategy() {
            return CopyingEpatchApplier.this.strategy;
        }
    }
}

