/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer.actions;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.CoreCommand;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.HenshinNACPrinter;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.ViewCommand;
import org.eclipse.emf.henshin.presentation.HenshinEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class HenshinNACPrintViewActionShortVersion
implements IObjectActionDelegate {
    protected IWorkbenchPart workbenchPart;
    protected Rule rule;
    private CoreCommand wincmd;
    File pdfFile = null;

    public void run(IAction action) {
        this.print();
    }

    protected void print() {
        HenshinNACPrinter henshinNACPrinter = new HenshinNACPrinter(this.rule, this.rule.eClass().getEPackage(), true);
        henshinNACPrinter.printDocument();
        final String filepath = henshinNACPrinter.getOutputFilePath();
        Thread thread = new Thread(){

            @Override
            public void run() {
                System.out.println("Thread Running");
                HenshinNACPrintViewActionShortVersion.this.compileLatex2PDF(filepath);
                File texFile = new File(filepath);
                int lastIndexOf = texFile.getName().lastIndexOf(".tex");
                String pdfFileName = texFile.getName().substring(0, lastIndexOf).concat(".pdf");
                HenshinNACPrintViewActionShortVersion.this.pdfFile = new File(texFile.getParent(), pdfFileName);
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.pdfFile != null && !this.pdfFile.exists()) {
            System.err.println("The PDF file of the generated latex is not produced.");
        } else {
            ViewCommand.openView(this.pdfFile);
        }
    }

    private void compileLatex2PDF(String filePath) {
        Path p = new Path(filePath);
        this.wincmd = new CoreCommand();
        this.wincmd.executePDFLatexCommand(p.toOSString(), p.toFile().getParent());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.rule = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof Rule) {
            this.rule = (Rule)first;
        }
        action.setEnabled(this.rule != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.workbenchPart = part instanceof HenshinEditor ? part : null;
        action.setEnabled(this.workbenchPart != null);
    }
}

