/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.ui.viewer.util;

import configuration.Configuration;
import configuration.Feature;
import configuration.FeatureBinding;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.VariabilityModelHelper;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class FeatureViewerBindingEditingSupport
extends EditingSupport {
    private final TableViewer viewer;
    private String[] nonContradictingOptions = FeatureBinding.getNames();

    public FeatureViewerBindingEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        Configuration configuration = (Configuration)this.viewer.getInput();
        Feature feature = (Feature)element;
        this.nonContradictingOptions = VariabilityModelHelper.getNonContradictingBindingOptions(configuration, feature);
        return new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.nonContradictingOptions, 8);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        Feature feature = (Feature)element;
        String bindingname = feature.getBinding().getName();
        int index = -1;
        int i = this.nonContradictingOptions.length - 1;
        while (i >= 0) {
            if (this.nonContradictingOptions[i].equals(bindingname)) {
                index = i;
            }
            --i;
        }
        return index;
    }

    protected void setValue(Object element, Object value) {
        String bindingString;
        FeatureBinding newBinding;
        Feature vp = (Feature)element;
        FeatureBinding oldBinding = vp.getBinding();
        if (oldBinding != (newBinding = FeatureBinding.getByName((String)(bindingString = this.nonContradictingOptions[(Integer)value])))) {
            vp.setBinding(newBinding);
            this.getViewer().update(element, new String[]{"binding"});
        }
    }
}

