/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.PathConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.interpreter.monitoring.PerformanceMonitor;
import org.eclipse.emf.henshin.interpreter.monitoring.VariableCheck;

public class DomainSlot {
    Variable owner;
    boolean initialized = false;
    boolean locked = false;
    EObject value;
    List<EObject> domain;
    List<EObject> temporaryDomain;
    final Map<BinaryConstraint, DomainChange> remoteChangeMap;
    final List<String> initializedParameters;
    final ConditionHandler conditionHandler;
    final Set<Variable> checkedVariables;
    final Set<EObject> usedObjects;
    final boolean injective;
    final boolean dangling;
    final boolean deterministic;
    final boolean inverseMatchingOrder;
    private VariableCheck varCheckRecord = null;
    private PerformanceMonitor monitor = null;

    public DomainSlot(ConditionHandler conditionHandler, Set<EObject> usedObjects, boolean injective, boolean dangling, boolean deterministic, boolean inverseMatchingOrder, ApplicationMonitor monitor) {
        this.conditionHandler = conditionHandler;
        this.usedObjects = usedObjects;
        this.remoteChangeMap = new HashMap<BinaryConstraint, DomainChange>();
        this.initializedParameters = new ArrayList<String>();
        this.checkedVariables = new HashSet<Variable>();
        this.injective = injective;
        this.dangling = dangling;
        this.deterministic = deterministic;
        this.inverseMatchingOrder = inverseMatchingOrder;
        if (monitor instanceof PerformanceMonitor) {
            this.monitor = (PerformanceMonitor)((Object)monitor);
        }
    }

    public boolean instantiate(Variable variable, Map<Variable, DomainSlot> domainMap, EGraph graph) {
        if (!this.initialize(variable, graph)) {
            return false;
        }
        if (this.varCheckRecord != null && this.varCheckRecord.getDomainSize() == -1L && this.domain != null) {
            this.varCheckRecord.setDomainSize(this.domain.size());
        }
        if (!this.setValueAndLock()) {
            return false;
        }
        if (this.monitor != null) {
            this.varCheckRecord.incCheckedModelElements();
        }
        if (!this.checkedVariables.contains(variable)) {
            if (!this.checkTypeConstraint(variable)) {
                return false;
            }
            if (this.dangling) {
                for (DanglingConstraint danglingConstraint : variable.danglingConstraints) {
                    if (this.checkDanglingConstraint(danglingConstraint, graph)) continue;
                    return false;
                }
            }
            for (AttributeConstraint attributeConstraint : variable.attributeConstraints) {
                UnaryConstraint unaryUserConstraint;
                if (this.checkAttributeConstraint(attributeConstraint, unaryUserConstraint = variable.attributeUserConstraints.get(attributeConstraint))) continue;
                return false;
            }
            for (ContainmentConstraint containmentConstraint : variable.containmentConstraints) {
                if (!this.checkContainmentConstraint(containmentConstraint, domainMap)) {
                    return false;
                }
                if (this.monitor == null || domainMap.get((Object)containmentConstraint.targetVariable).temporaryDomain == null) continue;
                this.monitor.addDomainRestrictionRecord(variable.variableId, containmentConstraint.targetVariable.variableId, domainMap.get((Object)containmentConstraint.getTargetVariable()).temporaryDomain.size());
            }
            for (ReferenceConstraint referenceConstraint : variable.referenceConstraints) {
                BinaryConstraint binaryUserConstraint;
                if (!this.checkReferenceConstraint(referenceConstraint, binaryUserConstraint = variable.binaryUserConstraints.get(referenceConstraint), domainMap)) {
                    return false;
                }
                if (this.monitor == null || domainMap.get((Object)referenceConstraint.targetVariable).temporaryDomain == null) continue;
                this.monitor.addDomainRestrictionRecord(variable.variableId, referenceConstraint.targetVariable.variableId, domainMap.get((Object)referenceConstraint.targetVariable).temporaryDomain.size());
            }
            for (PathConstraint pathConstraint : variable.pathConstraints) {
                if (!this.checkPathConstraint(pathConstraint, domainMap)) {
                    return false;
                }
                if (this.monitor == null || domainMap.get((Object)pathConstraint.targetVariable).temporaryDomain == null) continue;
                this.monitor.addDomainRestrictionRecord(variable.variableId, pathConstraint.targetVariable.variableId, domainMap.get((Object)pathConstraint.targetVariable).temporaryDomain.size());
            }
            for (UnaryConstraint userConstraint : variable.userConstraints) {
                if (this.checkUserConstraint(userConstraint)) continue;
                return false;
            }
            this.checkedVariables.add(variable);
        }
        return true;
    }

    public boolean unlock(Variable sender) {
        int refCount = sender.referenceConstraints.size();
        int conCount = sender.containmentConstraints.size();
        int i = refCount + conCount - 1;
        while (i >= 0) {
            BinaryConstraint constraint = i >= refCount ? (BinaryConstraint)sender.containmentConstraints.get(i - refCount) : (BinaryConstraint)sender.referenceConstraints.get(i);
            DomainChange change = this.remoteChangeMap.get(constraint);
            if (change != null) {
                change.slot.temporaryDomain = change.originalValues;
                this.remoteChangeMap.remove(constraint);
            }
            --i;
        }
        if (this.locked && sender == this.owner) {
            this.locked = false;
            this.usedObjects.remove(this.value);
            for (String parameterName : this.initializedParameters) {
                this.conditionHandler.unsetParameter(parameterName);
            }
            this.initializedParameters.clear();
            this.checkedVariables.clear();
            return this.domain != null && !this.domain.isEmpty();
        }
        this.checkedVariables.remove(sender);
        return false;
    }

    public void clear(Variable sender) {
        this.unlock(sender);
        if (sender == this.owner) {
            this.initialized = false;
            this.remoteChangeMap.clear();
            this.owner = null;
            this.value = null;
            this.domain = null;
        }
    }

    public void reset(Variable sender) {
        if (sender == this.owner) {
            this.temporaryDomain = null;
        }
        this.clear(sender);
    }

    public boolean recheck(Variable variable, Map<Variable, DomainSlot> domainMap) {
        this.checkedVariables.remove(variable);
        return this.instantiate(variable, domainMap, null);
    }

    public boolean instantiationPossible() {
        if (this.domain == null) {
            return false;
        }
        if (!this.locked) {
            return this.domain.size() > 0;
        }
        return false;
    }

    public void fixInstantiation(EObject value) {
        this.locked = true;
        this.value = value;
        this.initialized = true;
        this.usedObjects.add(value);
        this.owner = null;
    }

    public boolean initialize(Variable variable, EGraph graph) {
        if (this.initialized) {
            return true;
        }
        this.initialized = true;
        this.owner = variable;
        if (this.temporaryDomain != null) {
            this.domain = new ArrayList<EObject>(this.temporaryDomain);
        }
        variable.typeConstraint.initDomain(this, graph);
        if (this.domain.isEmpty()) {
            return false;
        }
        if (!this.deterministic) {
            Collections.shuffle(this.domain);
        }
        if (this.injective) {
            this.domain.removeAll(this.usedObjects);
        }
        return true;
    }

    public boolean setValueAndLock() {
        if (this.locked) {
            return true;
        }
        if (this.domain.isEmpty()) {
            return false;
        }
        this.value = this.inverseMatchingOrder ? this.domain.remove(this.domain.size() - 1) : this.domain.remove(0);
        this.usedObjects.add(this.value);
        this.locked = true;
        return true;
    }

    public boolean checkTypeConstraint(Variable variable) {
        return variable.typeConstraint.check(this);
    }

    public boolean checkDanglingConstraint(DanglingConstraint constraint, EGraph graph) {
        return constraint.postpone || constraint.check(this.value, graph);
    }

    public boolean checkAttributeConstraint(AttributeConstraint constraint, UnaryConstraint unaryUserConstraint) {
        if (!constraint.isConstantValue && !this.conditionHandler.isSet((String)constraint.value)) {
            this.initializedParameters.add((String)constraint.value);
        }
        if (!constraint.check(this)) {
            return false;
        }
        return unaryUserConstraint == null || unaryUserConstraint.check(this);
    }

    public boolean checkContainmentConstraint(ContainmentConstraint constraint, Map<Variable, DomainSlot> domainMap) {
        DomainSlot targetSlot = domainMap.get(constraint.targetVariable);
        return constraint.check(this, targetSlot);
    }

    public boolean checkReferenceConstraint(ReferenceConstraint constraint, BinaryConstraint binaryUserConstraint, Map<Variable, DomainSlot> domainMap) {
        DomainSlot targetSlot = domainMap.get(constraint.targetVariable);
        if (!constraint.check(this, targetSlot)) {
            return false;
        }
        return binaryUserConstraint == null || binaryUserConstraint.check(this, targetSlot);
    }

    public boolean checkPathConstraint(PathConstraint constraint, Map<Variable, DomainSlot> domainMap) {
        DomainSlot targetSlot = domainMap.get(constraint.targetVariable);
        return constraint.check(this, targetSlot);
    }

    public boolean checkUserConstraint(UnaryConstraint constraint) {
        return constraint.check(this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public EObject getValue() {
        return this.value;
    }

    public List<EObject> getDomain() {
        return this.domain;
    }

    public void setTemporaryDomain(List<EObject> temporaryDomain) {
        this.temporaryDomain = temporaryDomain;
    }

    public List<EObject> getTemporaryDomain() {
        return this.temporaryDomain;
    }

    public Map<BinaryConstraint, DomainChange> getRemoteChangeMap() {
        return this.remoteChangeMap;
    }

    public ConditionHandler getConditionHandler() {
        return this.conditionHandler;
    }

    public VariableCheck getVarCheckRecord() {
        return this.varCheckRecord;
    }

    public void setVarCheckRecord(VariableCheck varCheckRecord) {
        this.varCheckRecord = varCheckRecord;
    }
}

