/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.text.henshin_text.AndExpression;
import org.eclipse.emf.henshin.text.henshin_text.Attribute;
import org.eclipse.emf.henshin.text.henshin_text.Call;
import org.eclipse.emf.henshin.text.henshin_text.ComparisonExpression;
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdge;
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraph;
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraphRef;
import org.eclipse.emf.henshin.text.henshin_text.ConditionNode;
import org.eclipse.emf.henshin.text.henshin_text.ConditionNodeTypes;
import org.eclipse.emf.henshin.text.henshin_text.ConditionReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.ConditionalUnit;
import org.eclipse.emf.henshin.text.henshin_text.EPackageImport;
import org.eclipse.emf.henshin.text.henshin_text.Edge;
import org.eclipse.emf.henshin.text.henshin_text.Edges;
import org.eclipse.emf.henshin.text.henshin_text.EqualityExpression;
import org.eclipse.emf.henshin.text.henshin_text.Expression;
import org.eclipse.emf.henshin.text.henshin_text.Formula;
import org.eclipse.emf.henshin.text.henshin_text.Graph;
import org.eclipse.emf.henshin.text.henshin_text.Henshin_textPackage;
import org.eclipse.emf.henshin.text.henshin_text.IndependentUnit;
import org.eclipse.emf.henshin.text.henshin_text.IntegerValue;
import org.eclipse.emf.henshin.text.henshin_text.IteratedUnit;
import org.eclipse.emf.henshin.text.henshin_text.JavaAttributeValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaClassValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaImport;
import org.eclipse.emf.henshin.text.henshin_text.List;
import org.eclipse.emf.henshin.text.henshin_text.Logic;
import org.eclipse.emf.henshin.text.henshin_text.LoopUnit;
import org.eclipse.emf.henshin.text.henshin_text.Match;
import org.eclipse.emf.henshin.text.henshin_text.MinusExpression;
import org.eclipse.emf.henshin.text.henshin_text.Model;
import org.eclipse.emf.henshin.text.henshin_text.MulOrDivExpression;
import org.eclipse.emf.henshin.text.henshin_text.MultiRule;
import org.eclipse.emf.henshin.text.henshin_text.MultiRuleReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.Node;
import org.eclipse.emf.henshin.text.henshin_text.NotExpression;
import org.eclipse.emf.henshin.text.henshin_text.NumberValue;
import org.eclipse.emf.henshin.text.henshin_text.OrExpression;
import org.eclipse.emf.henshin.text.henshin_text.Parameter;
import org.eclipse.emf.henshin.text.henshin_text.ParameterKind;
import org.eclipse.emf.henshin.text.henshin_text.ParameterValue;
import org.eclipse.emf.henshin.text.henshin_text.PlusExpression;
import org.eclipse.emf.henshin.text.henshin_text.PriorityUnit;
import org.eclipse.emf.henshin.text.henshin_text.Rule;
import org.eclipse.emf.henshin.text.henshin_text.RuleNodeTypes;
import org.eclipse.emf.henshin.text.henshin_text.Unit;
import org.eclipse.emf.henshin.text.henshin_text.UnitElement;
import org.eclipse.emf.henshin.text.henshin_text.impl.ANDImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.CheckDanglingImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.ConditionsImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.GraphImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.InjectiveMatchingImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.JavaImportImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.NotImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.ORorXORImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.RollbackImpl;
import org.eclipse.emf.henshin.text.henshin_text.impl.StrictImpl;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textTypeProvider;
import org.eclipse.emf.henshin.text.validation.AbstractHenshin_textValidator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Henshin_textValidator
extends AbstractHenshin_textValidator {
    @Inject
    @Extension
    private Henshin_textTypeProvider _henshin_textTypeProvider;

    @Check
    public void checkCallParameter(Call call) {
        int _size_1;
        boolean _notEquals;
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterKind _kind = it.getKind();
                return !Objects.equal((Object)((Object)_kind), (Object)((Object)ParameterKind.VAR));
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(call.getElementCall().getParameters(), (Functions.Function1)_function));
        boolean bl = _notEquals = _size != (_size_1 = call.getParameters().size());
        if (_notEquals) {
            this.error("Bad Parameter Count.'", (EStructuralFeature)Henshin_textPackage.eINSTANCE.getCall_ElementCall());
        } else {
            int i = 0;
            while (i < IterableExtensions.size((Iterable)IterableExtensions.filter(call.getElementCall().getParameters(), (Functions.Function1)new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterKind _kind = it.getKind();
                    return !Objects.equal((Object)((Object)_kind), (Object)((Object)ParameterKind.VAR));
                }
            }))) {
                Henshin_textType _typeFor_1;
                boolean _notEquals_1;
                Parameter param = (Parameter)call.getElementCall().getParameters().get(i);
                Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(param.getType());
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_typeFor, (Object)(_typeFor_1 = this._henshin_textTypeProvider.typeFor(((Parameter)call.getParameters().get(i)).getType())));
                if (_notEquals_1) {
                    String _string = this._henshin_textTypeProvider.typeFor(param.getType()).toString();
                    String _plus = "Call expected " + _string;
                    String _plus_1 = String.valueOf(_plus) + " type, but was ";
                    String _string_1 = this._henshin_textTypeProvider.typeFor(((Parameter)call.getParameters().get(i)).getType()).toString();
                    String _plus_2 = String.valueOf(_plus_1) + _string_1;
                    String _plus_3 = String.valueOf(_plus_2) + ".'";
                    this.error(_plus_3, call, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getCall_Parameters());
                }
                ++i;
            }
        }
    }

    @Check
    public void checkParameterKind(Parameter param) {
        ParameterKind _kind = param.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)ParameterKind.UNKNOWN));
        if (_equals) {
            String _name = param.getName();
            String _plus = "Parameter " + _name;
            String _plus_1 = String.valueOf(_plus) + " should have a parameter kind of IN, INOUT, OUR or VAR. Specifying no parameter kind is deprecated.";
            this.warning(_plus_1, param, (EStructuralFeature)Henshin_textPackage.Literals.PARAMETER__KIND);
        }
    }

    @Check
    public void ckeckExistingEdge(Edge edge) {
        RuleNodeTypes _target;
        boolean _notEquals_1;
        boolean _notEquals;
        EClass sourceType = null;
        EClass targetType = null;
        RuleNodeTypes _source = edge.getSource();
        boolean bl = _notEquals = !Objects.equal((Object)_source, null);
        if (_notEquals) {
            RuleNodeTypes _source_1 = edge.getSource();
            if (_source_1 instanceof Node) {
                RuleNodeTypes _source_2 = edge.getSource();
                sourceType = ((Node)_source_2).getNodetype();
            } else {
                try {
                    RuleNodeTypes _source_3 = edge.getSource();
                    sourceType = ((MultiRuleReuseNode)_source_3).getName().getNodetype();
                }
                catch (Throwable _t) {
                    if (_t instanceof ClassCastException) {
                        sourceType = null;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_target = edge.getTarget()), null);
        if (_notEquals_1) {
            RuleNodeTypes _target_1 = edge.getTarget();
            if (_target_1 instanceof Node) {
                RuleNodeTypes _target_2 = edge.getTarget();
                targetType = ((Node)_target_2).getNodetype();
            } else {
                try {
                    RuleNodeTypes _target_3 = edge.getTarget();
                    targetType = ((MultiRuleReuseNode)_target_3).getName().getNodetype();
                }
                catch (Throwable _t) {
                    if (_t instanceof ClassCastException) {
                        targetType = null;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        if (!Objects.equal((Object)sourceType, null) && !Objects.equal(targetType, null)) {
            boolean wrongType = true;
            EClass referenceType = null;
            EList _eAllReferences = sourceType.getEAllReferences();
            for (EReference reference : _eAllReferences) {
                String _name_1;
                String _name = edge.getType().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = reference.getName()));
                if (!_equals) continue;
                wrongType = false;
                referenceType = reference.getEReferenceType();
            }
            if (wrongType) {
                String _name_2 = edge.getType().getName();
                String _plus = "Edgetype " + _name_2;
                String _plus_1 = String.valueOf(_plus) + " does not exist.'";
                this.error(_plus_1, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Type());
            }
            if (!Objects.equal(referenceType, (Object)targetType) && !targetType.getEAllSuperTypes().contains(referenceType)) {
                String _name_3 = sourceType.getName();
                String _plus_2 = "Edge " + _name_3;
                String _plus_3 = String.valueOf(_plus_2) + "->";
                String _name_4 = targetType.getName();
                String _plus_4 = String.valueOf(_plus_3) + _name_4;
                String _plus_5 = String.valueOf(_plus_4) + ":";
                String _name_5 = edge.getType().getName();
                String _plus_6 = String.valueOf(_plus_5) + _name_5;
                String _plus_7 = String.valueOf(_plus_6) + " does not exist.'";
                this.error(_plus_7, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Type());
            }
        }
    }

    @Check
    public void checkNodeType(Node node) {
        boolean isImported = false;
        java.util.List<EPackageImport> _ePackageImports = this.getEPackageImports(node);
        for (EPackageImport ePackage : _ePackageImports) {
            boolean _contains = ePackage.getRef().getEClassifiers().contains((Object)node.getNodetype());
            if (!_contains) continue;
            isImported = true;
        }
        if (!isImported) {
            String _name = node.getNodetype().getName();
            String _plus = "Nodetype " + _name;
            String _plus_1 = String.valueOf(_plus) + " is not imported.'";
            this.error(_plus_1, node, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getNode_Nodetype());
        }
    }

    private java.util.List<EPackageImport> getEPackageImports(EObject startObject) {
        ArrayList<EPackageImport> listOfEPackageImport = new ArrayList<EPackageImport>();
        EObject container = startObject.eContainer();
        while (!(container instanceof Model)) {
            container = container.eContainer();
        }
        if (container instanceof Model) {
            listOfEPackageImport.addAll((Collection<EPackageImport>)((Model)container).getEPackageimports());
        }
        return listOfEPackageImport;
    }

    @Check
    public void checkNodeAttribute(Node node) {
        EList<Attribute> _attribute = node.getAttribute();
        for (Attribute attribute : _attribute) {
            boolean _not;
            boolean superTypeAttribute = false;
            boolean _contains = node.getNodetype().getEAttributes().contains((Object)attribute.getName());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            EList _eAllSuperTypes = node.getNodetype().getEAllSuperTypes();
            for (EClass supertype : _eAllSuperTypes) {
                boolean _contains_1 = supertype.getEAttributes().contains((Object)attribute.getName());
                if (!_contains_1) continue;
                superTypeAttribute = true;
            }
            if (superTypeAttribute) continue;
            String _name = node.getNodetype().getName();
            String _plus = String.valueOf(_name) + " has no attribute '";
            String _name_1 = attribute.getName().getName();
            String _plus_1 = String.valueOf(_plus) + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + "'.'";
            this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Name());
        }
    }

    @Check
    public void checkattributeOnlyOnce(Node node) {
        int i = 0;
        while (i < node.getAttribute().size()) {
            Attribute attribute = (Attribute)node.getAttribute().get(i);
            int j = i + 1;
            while (j < node.getAttribute().size()) {
                if (Objects.equal((Object)attribute.getName(), (Object)((Attribute)node.getAttribute().get(j)).getName()) && Objects.equal((Object)attribute.getUpdate(), (Object)((Attribute)node.getAttribute().get(j)).getUpdate())) {
                    String _name = attribute.getName().getName();
                    String _plus = "'" + _name;
                    String _plus_1 = String.valueOf(_plus) + "' can only be used once.'";
                    this.error(_plus_1, (EObject)node.getAttribute().get(j), (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkAbstractNode(Node node) {
        if (node.getNodetype().isAbstract() && Objects.equal((Object)node.getActiontype(), (Object)"create")) {
            this.error("Node of abstract type cannot be created.'", node, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getNode_Nodetype());
        }
    }

    @Check
    public void checkSetAttribute(Node node) {
        if (Objects.equal((Object)node.getActiontype(), (Object)"preserve") || Objects.equal((Object)node.getActiontype(), null)) {
            EList<Attribute> _attribute = node.getAttribute();
            for (Attribute attribute : _attribute) {
                boolean _notEquals;
                String _update = attribute.getUpdate();
                boolean bl = _notEquals = !Objects.equal((Object)_update, null);
                if (!_notEquals) continue;
                EList<Attribute> _attribute_1 = node.getAttribute();
                for (Attribute checkAttribute : _attribute_1) {
                    if (Objects.equal((Object)checkAttribute, (Object)attribute) || !Objects.equal((Object)attribute.getName(), (Object)checkAttribute.getName()) || Objects.equal((Object)checkAttribute.getUpdate(), null) && !Objects.equal((Object)checkAttribute.getActiontype(), (Object)"create")) continue;
                    this.error("Duplicate update.'", attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
                    this.error("Duplicate update.'", checkAttribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                }
            }
        }
    }

    @Check
    public void checkSetandMatchAttribute(Node node) {
        if (Objects.equal((Object)node.getActiontype(), (Object)"preserve") || Objects.equal((Object)node.getActiontype(), null)) {
            EList<Attribute> _attribute = node.getAttribute();
            for (Attribute attribute : _attribute) {
                boolean _notEquals;
                String _update = attribute.getUpdate();
                boolean bl = _notEquals = !Objects.equal((Object)_update, null);
                if (!_notEquals) continue;
                boolean matchExist = false;
                EList<Attribute> _attribute_1 = node.getAttribute();
                for (Attribute checkAttribute : _attribute_1) {
                    if (Objects.equal((Object)checkAttribute, (Object)attribute) || !Objects.equal((Object)attribute.getName(), (Object)checkAttribute.getName()) || !Objects.equal((Object)checkAttribute.getActiontype(), (Object)"preserve") && (!Objects.equal((Object)checkAttribute.getActiontype(), null) || !Objects.equal((Object)node.getActiontype(), (Object)"preserve") && !Objects.equal((Object)node.getActiontype(), null))) continue;
                    matchExist = true;
                }
                if (matchExist) continue;
                String _name = attribute.getName().getName();
                String _plus = "Preserve-attribute " + _name;
                String _plus_1 = String.valueOf(_plus) + " needed.'";
                this.error(_plus_1, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
            }
        }
    }

    @Check
    public void checkNodeAttributeAction(Node node) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        String _actiontype = node.getActiontype();
                        boolean _equals = Objects.equal((Object)_actiontype, (Object)"create");
                        if (!_equals) break block8;
                        EList<Attribute> _attribute = node.getAttribute();
                        for (Attribute attribute : _attribute) {
                            String _update;
                            boolean _notEquals;
                            if (Objects.equal((Object)attribute.getActiontype(), (Object)"preserve") && Objects.equal((Object)attribute.getUpdate(), null) || Objects.equal((Object)attribute.getActiontype(), (Object)"delete") || Objects.equal((Object)attribute.getActiontype(), (Object)"forbid") || Objects.equal((Object)attribute.getActiontype(), (Object)"require")) {
                                String _actiontype_1 = attribute.getActiontype();
                                String _plus = String.valueOf(_actiontype_1) + "-attributes are not allowed in ";
                                String _actiontype_2 = node.getActiontype();
                                String _plus_1 = String.valueOf(_plus) + _actiontype_2;
                                String _plus_2 = String.valueOf(_plus_1) + "-nodes.'";
                                this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                            }
                            boolean bl = _notEquals = !Objects.equal((Object)(_update = attribute.getUpdate()), null);
                            if (!_notEquals) continue;
                            String _actiontype_3 = node.getActiontype();
                            String _plus_3 = "set-attributes are not allowed in " + _actiontype_3;
                            String _plus_4 = String.valueOf(_plus_3) + "-nodes. '";
                            this.error(_plus_4, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
                        }
                        break block9;
                    }
                    String _actiontype_1 = node.getActiontype();
                    boolean _equals_1 = Objects.equal((Object)_actiontype_1, (Object)"delete");
                    if (!_equals_1) break block10;
                    EList<Attribute> _attribute_1 = node.getAttribute();
                    for (Attribute attribute_1 : _attribute_1) {
                        String _update;
                        boolean _notEquals;
                        if (Objects.equal((Object)attribute_1.getActiontype(), (Object)"preserve") && Objects.equal((Object)attribute_1.getUpdate(), null) || Objects.equal((Object)attribute_1.getActiontype(), (Object)"create")) {
                            String _actiontype_2 = attribute_1.getActiontype();
                            String _plus = String.valueOf(_actiontype_2) + "-attributes are not allowed in ";
                            String _actiontype_3 = node.getActiontype();
                            String _plus_1 = String.valueOf(_plus) + _actiontype_3;
                            String _plus_2 = String.valueOf(_plus_1) + "-nodes.'";
                            this.error(_plus_2, attribute_1, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                        }
                        boolean bl = _notEquals = !Objects.equal((Object)(_update = attribute_1.getUpdate()), null);
                        if (!_notEquals) continue;
                        String _actiontype_4 = node.getActiontype();
                        String _plus_3 = "set-attributes are not allowed in " + _actiontype_4;
                        String _plus_4 = String.valueOf(_plus_3) + "-nodes.'";
                        this.error(_plus_4, attribute_1, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
                    }
                    break block9;
                }
                String _actiontype_2 = node.getActiontype();
                boolean _equals_2 = Objects.equal((Object)_actiontype_2, (Object)"forbid");
                if (!_equals_2) break block11;
                EList<Attribute> _attribute_2 = node.getAttribute();
                for (Attribute attribute_2 : _attribute_2) {
                    String _update;
                    boolean _notEquals;
                    if (Objects.equal((Object)attribute_2.getActiontype(), (Object)"preserve") && Objects.equal((Object)attribute_2.getUpdate(), null) || Objects.equal((Object)attribute_2.getActiontype(), (Object)"delete") || Objects.equal((Object)attribute_2.getActiontype(), (Object)"create") || Objects.equal((Object)attribute_2.getActiontype(), (Object)"require")) {
                        String _actiontype_3 = attribute_2.getActiontype();
                        String _plus = String.valueOf(_actiontype_3) + "-attributes are not allowed in ";
                        String _actiontype_4 = node.getActiontype();
                        String _plus_1 = String.valueOf(_plus) + _actiontype_4;
                        String _plus_2 = String.valueOf(_plus_1) + "-nodes.'";
                        this.error(_plus_2, attribute_2, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                    }
                    boolean bl = _notEquals = !Objects.equal((Object)(_update = attribute_2.getUpdate()), null);
                    if (!_notEquals) continue;
                    String _actiontype_5 = node.getActiontype();
                    String _plus_3 = "set-attributes are not allowed in " + _actiontype_5;
                    String _plus_4 = String.valueOf(_plus_3) + "-nodes.'";
                    this.error(_plus_4, attribute_2, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
                }
                break block9;
            }
            String _actiontype_3 = node.getActiontype();
            boolean _equals_3 = Objects.equal((Object)_actiontype_3, (Object)"require");
            if (!_equals_3) break block9;
            EList<Attribute> _attribute_3 = node.getAttribute();
            for (Attribute attribute_3 : _attribute_3) {
                String _update;
                boolean _notEquals;
                if (Objects.equal((Object)attribute_3.getActiontype(), (Object)"preserve") && Objects.equal((Object)attribute_3.getUpdate(), null) || Objects.equal((Object)attribute_3.getActiontype(), (Object)"delete") || Objects.equal((Object)attribute_3.getActiontype(), (Object)"create") || Objects.equal((Object)attribute_3.getActiontype(), (Object)"forbid")) {
                    String _actiontype_4 = attribute_3.getActiontype();
                    String _plus = String.valueOf(_actiontype_4) + "-attributes are not allowed in ";
                    String _actiontype_5 = node.getActiontype();
                    String _plus_1 = String.valueOf(_plus) + _actiontype_5;
                    String _plus_2 = String.valueOf(_plus_1) + "-nodes.'";
                    this.error(_plus_2, attribute_3, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                }
                boolean bl = _notEquals = !Objects.equal((Object)(_update = attribute_3.getUpdate()), null);
                if (!_notEquals) continue;
                String _actiontype_6 = node.getActiontype();
                String _plus_3 = "set-attributes are not allowed in " + _actiontype_6;
                String _plus_4 = String.valueOf(_plus_3) + "-nodes.'";
                this.error(_plus_4, attribute_3, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Update());
            }
        }
    }

    @Check
    public void checkNodeEdgeAction(Edge edge) {
        Node source = null;
        Node target = null;
        RuleNodeTypes _source = edge.getSource();
        if (_source instanceof Node) {
            RuleNodeTypes _source_1 = edge.getSource();
            source = (Node)_source_1;
        } else {
            try {
                RuleNodeTypes _source_2 = edge.getSource();
                source = ((MultiRuleReuseNode)_source_2).getName();
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    target = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        RuleNodeTypes _target = edge.getTarget();
        if (_target instanceof Node) {
            RuleNodeTypes _target_1 = edge.getTarget();
            target = (Node)_target_1;
        } else {
            try {
                RuleNodeTypes _target_2 = edge.getTarget();
                target = ((MultiRuleReuseNode)_target_2).getName();
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    target = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (!Objects.equal((Object)target, null) && !Objects.equal((Object)source, null)) {
            String tagettype;
            boolean _equals_2;
            String sourcetype;
            boolean _equals_1;
            String edgetype = edge.getActiontype();
            boolean _equals = Objects.equal((Object)edgetype, null);
            if (_equals) {
                edgetype = "preserve";
            }
            if (_equals_1 = Objects.equal((Object)(sourcetype = source.getActiontype()), null)) {
                sourcetype = "preserve";
            }
            if (_equals_2 = Objects.equal((Object)(tagettype = target.getActiontype()), null)) {
                tagettype = "preserve";
            }
            if (Objects.equal((Object)edge.getActiontype(), (Object)"preserve") || Objects.equal((Object)edge.getActiontype(), null)) {
                if ((Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), null)) && !Objects.equal((Object)target.getActiontype(), (Object)"preserve") && !Objects.equal((Object)target.getActiontype(), null)) {
                    this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                } else if (!Objects.equal((Object)source.getActiontype(), (Object)"preserve") && !Objects.equal((Object)source.getActiontype(), null)) {
                    this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                }
            } else {
                String _actiontype = edge.getActiontype();
                boolean _equals_3 = Objects.equal((Object)_actiontype, (Object)"create");
                if (_equals_3) {
                    if ((Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"create")) && !Objects.equal((Object)target.getActiontype(), null) && !Objects.equal((Object)target.getActiontype(), (Object)"preserve") && !Objects.equal((Object)target.getActiontype(), (Object)"create")) {
                        this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                    } else if (!(Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"create"))) {
                        this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                    }
                } else {
                    String _actiontype_1 = edge.getActiontype();
                    boolean _equals_4 = Objects.equal((Object)_actiontype_1, (Object)"delete");
                    if (_equals_4) {
                        if ((Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"delete")) && !Objects.equal((Object)target.getActiontype(), null) && !Objects.equal((Object)target.getActiontype(), (Object)"preserve") && !Objects.equal((Object)target.getActiontype(), (Object)"delete")) {
                            this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                        } else if (!(Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"delete"))) {
                            this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                        }
                    } else {
                        String _actiontype_2 = edge.getActiontype();
                        boolean _equals_5 = Objects.equal((Object)_actiontype_2, (Object)"forbid");
                        if (_equals_5) {
                            if ((Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"delete") || Objects.equal((Object)source.getActiontype(), (Object)"forbid")) && (Objects.equal((Object)target.getActiontype(), (Object)"create") || Objects.equal((Object)target.getActiontype(), (Object)"require"))) {
                                this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                            } else if (Objects.equal((Object)source.getActiontype(), (Object)"create") || Objects.equal((Object)source.getActiontype(), (Object)"require")) {
                                this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                            }
                        } else {
                            String _actiontype_3 = edge.getActiontype();
                            boolean _equals_6 = Objects.equal((Object)_actiontype_3, (Object)"require");
                            if (_equals_6) {
                                if ((Objects.equal((Object)source.getActiontype(), null) || Objects.equal((Object)source.getActiontype(), (Object)"preserve") || Objects.equal((Object)source.getActiontype(), (Object)"delete") || Objects.equal((Object)source.getActiontype(), (Object)"require")) && (Objects.equal((Object)target.getActiontype(), (Object)"create") || Objects.equal((Object)target.getActiontype(), (Object)"forbid"))) {
                                    this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                                } else if (Objects.equal((Object)source.getActiontype(), (Object)"create") || Objects.equal((Object)source.getActiontype(), (Object)"forbid")) {
                                    this.error("A " + edgetype + "-edge is not allowed between a " + sourcetype + "-node and a " + tagettype + "-node.'", edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Actiontype());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Check
    public void checkCountGraph(Rule rule) {
        boolean _greaterThan;
        Iterable iterableOfGraphImpl = Iterables.filter(rule.getRuleElements(), GraphImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfGraphImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (GraphImpl graph : iterableOfGraphImpl) {
                String _name = rule.getName();
                String _plus = "Multiple graphs in rule " + _name;
                String _plus_1 = String.valueOf(_plus) + ".'";
                this.error(_plus_1, graph, (EStructuralFeature)Henshin_textPackage.Literals.GRAPH__GRAPH_ELEMENTS);
            }
        } else {
            boolean _equals;
            int _size_1 = IterableExtensions.size((Iterable)iterableOfGraphImpl);
            boolean bl2 = _equals = _size_1 == 0;
            if (_equals) {
                String _name_1 = rule.getName();
                String _plus_2 = "No graph in rule " + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".'";
                this.error(_plus_3, rule, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getRule_RuleElements());
            }
        }
    }

    @Check
    public void checkCountCheckDangling(Rule rule) {
        boolean _greaterThan;
        Iterable iterableOfCheckDanglingImpl = Iterables.filter(rule.getRuleElements(), CheckDanglingImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfCheckDanglingImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (CheckDanglingImpl checkDangling : iterableOfCheckDanglingImpl) {
                this.error("CheckDangling can only be used once.'", checkDangling, (EStructuralFeature)Henshin_textPackage.Literals.CHECK_DANGLING__CHECK_DANGLING);
            }
        }
    }

    @Check
    public void checkCountInjectiveMatching(Rule rule) {
        boolean _greaterThan;
        Iterable iterableOfInjectiveMatchingImpl = Iterables.filter(rule.getRuleElements(), InjectiveMatchingImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfInjectiveMatchingImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (InjectiveMatchingImpl injectiveMatching : iterableOfInjectiveMatchingImpl) {
                this.error("InjectiveMatching can only be used once.'", injectiveMatching, (EStructuralFeature)Henshin_textPackage.Literals.INJECTIVE_MATCHING__INJECTIVE_MATCHING);
            }
        }
    }

    @Check
    public void checkCountCondition(Rule rule) {
        boolean _greaterThan;
        Iterable iterableOfConditionsImpl = Iterables.filter(rule.getRuleElements(), ConditionsImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfConditionsImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (ConditionsImpl conditions : iterableOfConditionsImpl) {
                this.error("Conditions can only be used once.'", conditions, (EStructuralFeature)Henshin_textPackage.Literals.CONDITIONS__ATTRIBUTE_CONDITIONS);
            }
        }
    }

    @Check
    public void checkJavaImport(Rule rule) {
        try {
            IProject[] _projects;
            Iterable iterableOfJavaImportImpl = Iterables.filter(rule.getRuleElements(), JavaImportImpl.class);
            String projectName = rule.eResource().getURI().toString().replaceAll("platform:/resource/", "").replaceAll("\\/.*", "");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IJavaProject javaProject = null;
            IProject[] iProjectArray = _projects = root.getProjects();
            int n = _projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                boolean _equals = projectName.equals(project.getName());
                if (_equals) {
                    javaProject = JavaCore.create((IProject)project);
                }
                ++n2;
            }
            for (JavaImportImpl javaImport : iterableOfJavaImportImpl) {
                boolean importCorrect = false;
                if (javaProject != null) {
                    IPackageFragmentRoot[] _allPackageFragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = _allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    int n3 = _allPackageFragmentRoots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot package_ = iPackageFragmentRootArray[n4];
                        boolean _exists = package_.getPackageFragment(javaImport.getPackagename()).exists();
                        if (_exists) {
                            importCorrect = true;
                        }
                        ++n4;
                    }
                }
                if (importCorrect) continue;
                String _packagename = javaImport.getPackagename();
                String _plus = "Package " + _packagename;
                String _plus_1 = String.valueOf(_plus) + " doesn't exist.'";
                this.error(_plus_1, javaImport, (EStructuralFeature)Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Check
    public void checkMultiJavaImport(Rule rule) {
        Iterable iterableOfJavaImportImpl = Iterables.filter(rule.getRuleElements(), JavaImportImpl.class);
        int i = 0;
        while (i < IterableExtensions.size((Iterable)iterableOfJavaImportImpl)) {
            Iterable _converted_iterableOfJavaImportImpl = iterableOfJavaImportImpl;
            JavaImportImpl javaImport = ((JavaImportImpl[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl, JavaImportImpl.class))[i];
            int j = i + 1;
            while (j < IterableExtensions.size((Iterable)iterableOfJavaImportImpl)) {
                String _packagename_1;
                Iterable _converted_iterableOfJavaImportImpl_1 = iterableOfJavaImportImpl;
                String _packagename = ((JavaImportImpl[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl_1, JavaImportImpl.class))[j].getPackagename();
                boolean _equals = Objects.equal((Object)_packagename, (Object)(_packagename_1 = javaImport.getPackagename()));
                if (_equals) {
                    String _packagename_2 = javaImport.getPackagename();
                    String _plus = "Package " + _packagename_2;
                    String _plus_1 = String.valueOf(_plus) + " is already imported.'";
                    Iterable _converted_iterableOfJavaImportImpl_2 = iterableOfJavaImportImpl;
                    this.warning(_plus_1, ((EObject[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl_2, EObject.class))[j], (EStructuralFeature)Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkJavaImport(MultiRule rule) {
        try {
            IProject[] _projects;
            Iterable iterableOfJavaImportImpl = Iterables.filter(rule.getMultiruleElements(), JavaImportImpl.class);
            String projectName = rule.eResource().getURI().toString().replaceAll("platform:/resource/", "").replaceAll("\\/.*", "");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IJavaProject javaProject = null;
            IProject[] iProjectArray = _projects = root.getProjects();
            int n = _projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                boolean _equals = projectName.equals(project.getName());
                if (_equals) {
                    javaProject = JavaCore.create((IProject)project);
                }
                ++n2;
            }
            for (JavaImportImpl javaImport : iterableOfJavaImportImpl) {
                boolean importCorrect = false;
                if (javaProject != null) {
                    IPackageFragmentRoot[] _allPackageFragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = _allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    int n3 = _allPackageFragmentRoots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot package_ = iPackageFragmentRootArray[n4];
                        boolean _exists = package_.getPackageFragment(javaImport.getPackagename()).exists();
                        if (_exists) {
                            importCorrect = true;
                        }
                        ++n4;
                    }
                }
                if (importCorrect) continue;
                String _packagename = javaImport.getPackagename();
                String _plus = "Package " + _packagename;
                String _plus_1 = String.valueOf(_plus) + " doesn't exist.'";
                this.error(_plus_1, javaImport, (EStructuralFeature)Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Check
    public void checkMultiJavaImport(MultiRule rule) {
        Iterable iterableOfJavaImportImpl = Iterables.filter(rule.getMultiruleElements(), JavaImportImpl.class);
        int i = 0;
        while (i < IterableExtensions.size((Iterable)iterableOfJavaImportImpl)) {
            Iterable _converted_iterableOfJavaImportImpl = iterableOfJavaImportImpl;
            JavaImportImpl javaImport = ((JavaImportImpl[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl, JavaImportImpl.class))[i];
            int j = i + 1;
            while (j < IterableExtensions.size((Iterable)iterableOfJavaImportImpl)) {
                String _packagename_1;
                Iterable _converted_iterableOfJavaImportImpl_1 = iterableOfJavaImportImpl;
                String _packagename = ((JavaImportImpl[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl_1, JavaImportImpl.class))[j].getPackagename();
                boolean _equals = Objects.equal((Object)_packagename, (Object)(_packagename_1 = javaImport.getPackagename()));
                if (_equals) {
                    String _packagename_2 = javaImport.getPackagename();
                    String _plus = "Package " + _packagename_2;
                    String _plus_1 = String.valueOf(_plus) + " is already imported.'";
                    Iterable _converted_iterableOfJavaImportImpl_2 = iterableOfJavaImportImpl;
                    this.warning(_plus_1, ((EObject[])Conversions.unwrapArray((Object)_converted_iterableOfJavaImportImpl_2, EObject.class))[j], (EStructuralFeature)Henshin_textPackage.Literals.JAVA_IMPORT__PACKAGENAME);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkCountCondition(MultiRule rule) {
        boolean _greaterThan;
        Iterable iterableOfConditionsImpl = Iterables.filter(rule.getMultiruleElements(), ConditionsImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfConditionsImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (ConditionsImpl conditions : iterableOfConditionsImpl) {
                this.error("Conditions can only be used once.'", conditions, (EStructuralFeature)Henshin_textPackage.Literals.CONDITIONS__ATTRIBUTE_CONDITIONS);
            }
        }
    }

    @Check
    public void checkCountInjectiveMatching(MultiRule rule) {
        boolean _greaterThan;
        Iterable iterableOfInjectiveMatchingImpl = Iterables.filter(rule.getMultiruleElements(), InjectiveMatchingImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfInjectiveMatchingImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (InjectiveMatchingImpl injectiveMatching : iterableOfInjectiveMatchingImpl) {
                this.error("InjectiveMatching can only be used once.'", injectiveMatching, (EStructuralFeature)Henshin_textPackage.Literals.INJECTIVE_MATCHING__INJECTIVE_MATCHING);
            }
        }
    }

    @Check
    public void checkCountCheckDangling(MultiRule rule) {
        boolean _greaterThan;
        Iterable iterableOfCheckDanglingImpl = Iterables.filter(rule.getMultiruleElements(), CheckDanglingImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfCheckDanglingImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (CheckDanglingImpl checkDangling : iterableOfCheckDanglingImpl) {
                this.error("CheckDangling can only be used once.'", checkDangling, (EStructuralFeature)Henshin_textPackage.Literals.CHECK_DANGLING__CHECK_DANGLING);
            }
        }
    }

    @Check
    public void checkCountGraph(MultiRule rule) {
        boolean _greaterThan;
        Iterable iterableOfGraphImpl = Iterables.filter(rule.getMultiruleElements(), GraphImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfGraphImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (GraphImpl graph : iterableOfGraphImpl) {
                String _name = rule.getName();
                String _plus = "Multiple graphs in rule " + _name;
                String _plus_1 = String.valueOf(_plus) + ".'";
                this.error(_plus_1, graph, (EStructuralFeature)Henshin_textPackage.Literals.GRAPH__GRAPH_ELEMENTS);
            }
        }
    }

    @Check
    public void checkNodeAttribute(MultiRuleReuseNode node) {
        EList<Attribute> _attribute = node.getAttribute();
        for (Attribute attribute : _attribute) {
            boolean _not;
            boolean superTypeAttribute = false;
            boolean _contains = node.getName().getNodetype().getEAttributes().contains((Object)attribute.getName());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            EList _eAllSuperTypes = node.getName().getNodetype().getEAllSuperTypes();
            for (EClass supertype : _eAllSuperTypes) {
                boolean _contains_1 = supertype.getEAttributes().contains((Object)attribute.getName());
                if (!_contains_1) continue;
                superTypeAttribute = true;
            }
            if (superTypeAttribute) continue;
            String _name = node.getName().getNodetype().getName();
            String _plus = String.valueOf(_name) + " has no attribute '";
            String _name_1 = attribute.getName().getName();
            String _plus_1 = String.valueOf(_plus) + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + "'.'";
            this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Name());
        }
    }

    @Check
    public void checkattributeOnlyOnce(MultiRuleReuseNode node) {
        int i = 0;
        while (i < node.getAttribute().size()) {
            Attribute attribute = (Attribute)node.getAttribute().get(i);
            int j = i + 1;
            while (j < node.getAttribute().size()) {
                if (Objects.equal((Object)attribute.getName(), (Object)((Attribute)node.getAttribute().get(j)).getName()) && Objects.equal((Object)attribute.getUpdate(), (Object)((Attribute)node.getAttribute().get(j)).getUpdate())) {
                    String _name = attribute.getName().getName();
                    String _plus = "'" + _name;
                    String _plus_1 = String.valueOf(_plus) + "' can only be used once.'";
                    this.error(_plus_1, (EObject)node.getAttribute().get(j), (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    private void checkEdgesInMultiRuleRekursive(java.util.List<Node> conNodes, Graph graph) {
        boolean _greaterThan;
        Iterable _filter = Iterables.filter(graph.getGraphElements(), Edges.class);
        for (Edges edges : _filter) {
            EList<Edge> _edges = edges.getEdges();
            for (Edge edge : _edges) {
                boolean _notEquals_1;
                boolean _notEquals;
                Node testNode = null;
                RuleNodeTypes _source = edge.getSource();
                boolean bl = _notEquals = !Objects.equal((Object)_source, null);
                if (_notEquals) {
                    RuleNodeTypes _source_1 = edge.getSource();
                    if (_source_1 instanceof Node) {
                        RuleNodeTypes _source_2 = edge.getSource();
                        testNode = (Node)_source_2;
                    } else {
                        try {
                            RuleNodeTypes _source_3 = edge.getSource();
                            testNode = ((MultiRuleReuseNode)_source_3).getName();
                        }
                        catch (Throwable _t) {
                            if (_t instanceof ClassCastException) {
                                testNode = null;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                }
                for (Node conNode : conNodes) {
                    String _name_1;
                    String _name = conNode.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = testNode.getName()));
                    if (!_equals) continue;
                    String _actiontype = testNode.getActiontype();
                    String _plus = String.valueOf(_actiontype) + "-nodes are not allowed to be reused in edges in MultiRuleReuseNodes.'";
                    this.error(_plus, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Source());
                }
                RuleNodeTypes _target = edge.getTarget();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_target, null);
                if (_notEquals_1) {
                    RuleNodeTypes _target_1 = edge.getTarget();
                    if (_target_1 instanceof Node) {
                        RuleNodeTypes _target_2 = edge.getTarget();
                        testNode = (Node)_target_2;
                    } else {
                        RuleNodeTypes _target_3 = edge.getTarget();
                        testNode = ((MultiRuleReuseNode)_target_3).getName();
                    }
                }
                for (Node conNode_1 : conNodes) {
                    String _name_3;
                    String _name_2 = conNode_1.getName();
                    boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = testNode.getName()));
                    if (!_equals_1) continue;
                    String _actiontype_1 = testNode.getActiontype();
                    String _plus_1 = String.valueOf(_actiontype_1) + "-nodes are not allowed to be reused in edges in MultiRuleReuseNodes.'";
                    this.error(_plus_1, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getEdge_Target());
                }
            }
        }
        Iterable multiRules = Iterables.filter(graph.getGraphElements(), MultiRule.class);
        int _size = IterableExtensions.size((Iterable)multiRules);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Iterable _filter_1 = Iterables.filter(graph.getGraphElements(), Node.class);
            for (Node node : _filter_1) {
                if (!Objects.equal((Object)node.getActiontype(), (Object)"forbid") && !Objects.equal((Object)node.getActiontype(), (Object)"require")) continue;
                conNodes.add(node);
            }
            for (MultiRule multiRule : multiRules) {
                this.checkEdgesInMultiRuleRekursive(conNodes, ((Graph[])Conversions.unwrapArray((Object)Iterables.filter(multiRule.getMultiruleElements(), Graph.class), Graph.class))[0]);
            }
        }
    }

    @Check
    public void checkEdgesInMultiRule(Rule rule) {
        boolean _greaterThan;
        Iterable graph = Iterables.filter(rule.getRuleElements(), Graph.class);
        int _size = IterableExtensions.size((Iterable)graph);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            ArrayList<Node> conNodes = new ArrayList<Node>();
            Iterable _converted_graph = graph;
            Iterable _filter = Iterables.filter(((Graph[])Conversions.unwrapArray((Object)_converted_graph, Graph.class))[0].getGraphElements(), Node.class);
            for (Node node : _filter) {
                if (!Objects.equal((Object)node.getActiontype(), (Object)"forbid") && !Objects.equal((Object)node.getActiontype(), (Object)"require")) continue;
                conNodes.add(node);
            }
            Iterable _converted_graph_1 = graph;
            Iterable _filter_1 = Iterables.filter(((Graph[])Conversions.unwrapArray((Object)_converted_graph_1, Graph.class))[0].getGraphElements(), MultiRule.class);
            for (MultiRule multiRule : _filter_1) {
                boolean _greaterThan_1;
                int _size_1 = IterableExtensions.size((Iterable)Iterables.filter(multiRule.getMultiruleElements(), Graph.class));
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (!_greaterThan_1) continue;
                this.checkEdgesInMultiRuleRekursive(conNodes, ((Graph[])Conversions.unwrapArray((Object)Iterables.filter(multiRule.getMultiruleElements(), Graph.class), Graph.class))[0]);
            }
        }
    }

    @Check
    public void checkMultiRuleReuseNodeActionType(MultiRuleReuseNode multiReuseNode) {
        if (Objects.equal((Object)multiReuseNode.getName().getActiontype(), (Object)"require") || Objects.equal((Object)multiReuseNode.getName().getActiontype(), (Object)"forbid")) {
            String _actiontype = multiReuseNode.getName().getActiontype();
            String _plus = String.valueOf(_actiontype) + "-Node '";
            String _name = multiReuseNode.getName().getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            String _plus_2 = String.valueOf(_plus_1) + "' is not allowed in MultiRules.'";
            this.error(_plus_2, multiReuseNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
        }
    }

    @Check
    public void checkMultiRuleReuseNodAttributeSet(MultiRuleReuseNode reuseNode) {
        EList<Attribute> _attribute = reuseNode.getAttribute();
        for (Attribute attribute : _attribute) {
            boolean _notEquals;
            String _update = attribute.getUpdate();
            boolean bl = _notEquals = !Objects.equal((Object)_update, null);
            if (!_notEquals) continue;
            this.error("Set-attributes are not allowed in MultiRuleReuseNodes.'", attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
        }
    }

    @Check
    public void checkMultiRuleReuseNodAttributeAction(MultiRuleReuseNode reuseNode) {
        block5: {
            String reuseNodeType;
            block6: {
                block4: {
                    String _actiontype;
                    boolean _equals_1;
                    reuseNodeType = reuseNode.getName().getActiontype();
                    boolean _equals = Objects.equal((Object)reuseNodeType, null);
                    if (_equals) {
                        reuseNodeType = "preserve";
                    }
                    if (!(_equals_1 = Objects.equal((Object)(_actiontype = reuseNode.getName().getActiontype()), (Object)"create"))) break block4;
                    EList<Attribute> _attribute = reuseNode.getAttribute();
                    for (Attribute attribute : _attribute) {
                        if (Objects.equal((Object)attribute.getActiontype(), (Object)"create") || Objects.equal((Object)attribute.getActiontype(), null)) continue;
                        String _actiontype_1 = attribute.getActiontype();
                        String _plus = String.valueOf(_actiontype_1) + "-attributes are not allowed in ";
                        String _plus_1 = String.valueOf(_plus) + reuseNodeType;
                        String _plus_2 = String.valueOf(_plus_1) + "-reuseNodes. '";
                        this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                    }
                    break block5;
                }
                String _actiontype_2 = reuseNode.getName().getActiontype();
                boolean _equals_2 = Objects.equal((Object)_actiontype_2, (Object)"delete");
                if (!_equals_2) break block6;
                EList<Attribute> _attribute_1 = reuseNode.getAttribute();
                for (Attribute attribute_1 : _attribute_1) {
                    if (Objects.equal((Object)attribute_1.getActiontype(), (Object)"delete") || Objects.equal((Object)attribute_1.getActiontype(), null)) continue;
                    String _actiontype_3 = attribute_1.getActiontype();
                    String _plus_3 = String.valueOf(_actiontype_3) + "-attributes are not allowed in ";
                    String _plus_4 = String.valueOf(_plus_3) + reuseNodeType;
                    String _plus_5 = String.valueOf(_plus_4) + "-reuseNodes. '";
                    this.error(_plus_5, attribute_1, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
                }
                break block5;
            }
            if (!Objects.equal((Object)reuseNode.getName().getActiontype(), (Object)"preserve") && !Objects.equal((Object)reuseNode.getName().getActiontype(), null)) break block5;
            EList<Attribute> _attribute_2 = reuseNode.getAttribute();
            for (Attribute attribute_2 : _attribute_2) {
                if (!Objects.equal((Object)attribute_2.getActiontype(), (Object)"forbid") && !Objects.equal((Object)attribute_2.getActiontype(), (Object)"require")) continue;
                String _actiontype_4 = attribute_2.getActiontype();
                String _plus_6 = String.valueOf(_actiontype_4) + "-attributes are not allowed in ";
                String _plus_7 = String.valueOf(_plus_6) + reuseNodeType;
                String _plus_8 = String.valueOf(_plus_7) + "-reuseNodes. '";
                this.error(_plus_8, attribute_2, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Actiontype());
            }
        }
    }

    @Check
    public void checkRuleReuseNodes(Rule rule) {
        boolean _greaterThan;
        Iterable graph = Iterables.filter(rule.getRuleElements(), Graph.class);
        int _size = IterableExtensions.size((Iterable)graph);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Iterable _converted_graph = graph;
            Iterable reuseNodes = Iterables.filter(((Graph[])Conversions.unwrapArray((Object)_converted_graph, Graph.class))[0].getGraphElements(), MultiRuleReuseNode.class);
            for (MultiRuleReuseNode node : reuseNodes) {
                this.error("Reuse-Nodes are only allowed in multiRules.''", node, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
            }
        }
    }

    @Check
    public void checkMultiRuleGraphNodes(Graph graph) {
        Iterable _filter = Iterables.filter(graph.getGraphElements(), MultiRuleReuseNode.class);
        for (MultiRuleReuseNode reuse : _filter) {
            Iterable _filter_1 = Iterables.filter(graph.getGraphElements(), Node.class);
            for (Node node : _filter_1) {
                String _name_1;
                String _name = reuse.getName().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = node.getName()));
                if (!_equals) continue;
                this.error("Graph cannot reuse its own nodes.'", reuse, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
            }
        }
    }

    @Check
    public void checkGraphMultiReuse(Graph graph) {
        Iterable reuseNodes = Iterables.filter(graph.getGraphElements(), MultiRuleReuseNode.class);
        int i = 0;
        while (i < IterableExtensions.size((Iterable)reuseNodes)) {
            int j = i + 1;
            while (j < IterableExtensions.size((Iterable)reuseNodes)) {
                Iterable _converted_reuseNodes_1;
                String _name_1;
                Iterable _converted_reuseNodes = reuseNodes;
                String _name = ((MultiRuleReuseNode[])Conversions.unwrapArray((Object)_converted_reuseNodes, MultiRuleReuseNode.class))[i].getName().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = ((MultiRuleReuseNode[])Conversions.unwrapArray((Object)(_converted_reuseNodes_1 = reuseNodes), MultiRuleReuseNode.class))[j].getName().getName()));
                if (_equals) {
                    Iterable _converted_reuseNodes_2 = reuseNodes;
                    String _name_2 = ((MultiRuleReuseNode[])Conversions.unwrapArray((Object)_converted_reuseNodes_2, MultiRuleReuseNode.class))[j].getName().getName();
                    String _plus = String.valueOf(_name_2) + " is already reused.'";
                    Iterable _converted_reuseNodes_3 = reuseNodes;
                    this.error(_plus, ((EObject[])Conversions.unwrapArray((Object)_converted_reuseNodes_3, EObject.class))[j], (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMultiRuleReuseNode_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkOverrideNodeNamesinMultiRuleGraph(Graph graph) {
        Iterable multiRules = Iterables.filter(graph.getGraphElements(), MultiRule.class);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        for (MultiRule rule : multiRules) {
            Iterable _filter = Iterables.filter(rule.getMultiruleElements(), Graph.class);
            for (Graph multiGraph : _filter) {
                boolean _greaterThan;
                Iterable _filter_1 = Iterables.filter(multiGraph.getGraphElements(), Node.class);
                for (Node multiNode : _filter_1) {
                    Iterable _filter_2 = Iterables.filter(graph.getGraphElements(), Node.class);
                    for (Node node : _filter_2) {
                        topNodes.add(node);
                        String _name = multiNode.getName();
                        String _name_1 = node.getName();
                        boolean _equals = Objects.equal((Object)_name, (Object)_name_1);
                        if (!_equals) continue;
                        String _name_2 = multiNode.getName();
                        String _plus = "Duplicate Node '" + _name_2;
                        String _plus_1 = String.valueOf(_plus) + "'.'";
                        this.error(_plus_1, multiNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                    }
                }
                int _size = IterableExtensions.size((Iterable)Iterables.filter(multiGraph.getGraphElements(), MultiRule.class));
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                this.checkRekursiveOverrideNodeNamesinMultiRuleGraph(topNodes, multiGraph);
            }
        }
    }

    private void checkRekursiveOverrideNodeNamesinMultiRuleGraph(java.util.List<Node> topNodes, Graph graph) {
        Iterable multiRules = Iterables.filter(graph.getGraphElements(), MultiRule.class);
        for (MultiRule rule : multiRules) {
            Iterable _filter = Iterables.filter(rule.getMultiruleElements(), Graph.class);
            for (Graph multiGraph : _filter) {
                boolean _greaterThan;
                Iterable _filter_1 = Iterables.filter(multiGraph.getGraphElements(), Node.class);
                for (Node multiNode : _filter_1) {
                    for (Node node : topNodes) {
                        String _name_1;
                        String _name = multiNode.getName();
                        boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = node.getName()));
                        if (!_equals) continue;
                        String _name_2 = multiNode.getName();
                        String _plus = "Duplicate Node '" + _name_2;
                        String _plus_1 = String.valueOf(_plus) + "'.'";
                        this.error(_plus_1, multiNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                    }
                    Iterable _filter_2 = Iterables.filter(graph.getGraphElements(), Node.class);
                    for (Node node_1 : _filter_2) {
                        topNodes.add(node_1);
                        String _name_3 = multiNode.getName();
                        String _name_4 = node_1.getName();
                        boolean _equals_1 = Objects.equal((Object)_name_3, (Object)_name_4);
                        if (!_equals_1) continue;
                        String _name_5 = multiNode.getName();
                        String _plus_2 = "Duplicate Node '" + _name_5;
                        String _plus_3 = String.valueOf(_plus_2) + "'.'";
                        this.error(_plus_3, multiNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getNode_Nodetype());
                    }
                }
                int _size = IterableExtensions.size((Iterable)Iterables.filter(multiGraph.getGraphElements(), MultiRule.class));
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                this.checkRekursiveOverrideNodeNamesinMultiRuleGraph(topNodes, multiGraph);
            }
        }
    }

    @Check
    public void ckeckExistingEdge(ConditionEdge edge) {
        EClass sourceType = null;
        EClass targetType = null;
        ConditionNodeTypes _source = edge.getSource();
        if (_source instanceof Node) {
            ConditionNodeTypes _source_1 = edge.getSource();
            sourceType = ((Node)_source_1).getNodetype();
        } else {
            try {
                ConditionNodeTypes _source_2 = edge.getSource();
                sourceType = ((ConditionNode)_source_2).getType();
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    sourceType = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ConditionNodeTypes _target = edge.getTarget();
        if (_target instanceof Node) {
            ConditionNodeTypes _target_1 = edge.getTarget();
            targetType = ((Node)_target_1).getNodetype();
        } else {
            try {
                ConditionNodeTypes _target_2 = edge.getTarget();
                targetType = ((ConditionNode)_target_2).getType();
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    targetType = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (!Objects.equal((Object)sourceType, null) && !Objects.equal((Object)targetType, null)) {
            boolean wrongType = true;
            EClass referenceType = null;
            EList _eAllReferences = sourceType.getEAllReferences();
            for (EReference reference : _eAllReferences) {
                String _name_1;
                String _name = edge.getType().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = reference.getName()));
                if (!_equals) continue;
                wrongType = false;
                referenceType = reference.getEReferenceType();
            }
            if (wrongType) {
                String _name_2 = edge.getType().getName();
                String _plus = "Edgetype " + _name_2;
                String _plus_1 = String.valueOf(_plus) + " does not exist.'";
                this.error(_plus_1, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionEdge_Type());
            }
            if (!Objects.equal(referenceType, (Object)targetType) && !targetType.getEAllSuperTypes().contains(referenceType)) {
                String _name_3 = sourceType.getName();
                String _plus_2 = "Edge " + _name_3;
                String _plus_3 = String.valueOf(_plus_2) + "->";
                String _name_4 = targetType.getName();
                String _plus_4 = String.valueOf(_plus_3) + _name_4;
                String _plus_5 = String.valueOf(_plus_4) + ":";
                String _name_5 = edge.getType().getName();
                String _plus_6 = String.valueOf(_plus_5) + _name_5;
                String _plus_7 = String.valueOf(_plus_6) + " does not exist.'";
                this.error(_plus_7, edge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionEdge_Type());
            }
        }
    }

    @Check
    public void checkNodeAttribute(ConditionNode node) {
        EList<Match> _attribute = node.getAttribute();
        for (Match attribute : _attribute) {
            boolean _not;
            boolean superTypeAttribute = false;
            boolean _contains = node.getType().getEAttributes().contains((Object)attribute.getName());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            EList _eAllSuperTypes = node.getType().getEAllSuperTypes();
            for (EClass supertype : _eAllSuperTypes) {
                boolean _contains_1 = supertype.getEAttributes().contains((Object)attribute.getName());
                if (!_contains_1) continue;
                superTypeAttribute = true;
            }
            if (superTypeAttribute) continue;
            String _name = node.getType().getName();
            String _plus = String.valueOf(_name) + " has no attribute '";
            String _name_1 = attribute.getName().getName();
            String _plus_1 = String.valueOf(_plus) + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + "'.'";
            this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Name());
        }
    }

    @Check
    public void checkConditionNodeType(ConditionNode node) {
        boolean isImported = false;
        java.util.List<EPackageImport> _ePackageImports = this.getEPackageImports(node);
        for (EPackageImport ePackage : _ePackageImports) {
            boolean _contains = ePackage.getRef().getEClassifiers().contains((Object)node.getType());
            if (!_contains) continue;
            isImported = true;
        }
        if (!isImported) {
            String _name = node.getType().getName();
            String _plus = "Nodetype " + _name;
            String _plus_1 = String.valueOf(_plus) + " is not imported.'";
            this.error(_plus_1, node, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionNode_Type());
        }
    }

    @Check
    public void checkNodeAttribute(ConditionReuseNode node) {
        boolean _notEquals;
        EClass nodeType = null;
        ConditionNodeTypes _name = node.getName();
        if (_name instanceof Node) {
            ConditionNodeTypes _name_1 = node.getName();
            nodeType = ((Node)_name_1).getNodetype();
        } else {
            try {
                ConditionNodeTypes _name_2 = node.getName();
                nodeType = ((ConditionNode)_name_2).getType();
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    nodeType = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        boolean bl = _notEquals = !Objects.equal((Object)nodeType, null);
        if (_notEquals) {
            EList<Match> _attribute = node.getAttribute();
            for (Match attribute : _attribute) {
                boolean _not;
                boolean superTypeAttribute = false;
                boolean _contains = nodeType.getEAttributes().contains((Object)attribute.getName());
                boolean bl2 = _not = !_contains;
                if (!_not) continue;
                EList _eAllSuperTypes = nodeType.getEAllSuperTypes();
                for (EClass supertype : _eAllSuperTypes) {
                    boolean _contains_1 = supertype.getEAttributes().contains((Object)attribute.getName());
                    if (!_contains_1) continue;
                    superTypeAttribute = true;
                }
                if (superTypeAttribute) continue;
                String _name_2 = nodeType.getName();
                String _plus = String.valueOf(_name_2) + " has no attribute '";
                String _name_3 = attribute.getName().getName();
                String _plus_1 = String.valueOf(_plus) + _name_3;
                String _plus_2 = String.valueOf(_plus_1) + "'.'";
                this.error(_plus_2, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Name());
            }
        }
    }

    @Check
    public void checkattributeOnlyOnce(ConditionNode node) {
        int i = 0;
        while (i < node.getAttribute().size()) {
            Match match = (Match)node.getAttribute().get(i);
            int j = i + 1;
            while (j < node.getAttribute().size()) {
                EAttribute _name_1;
                EAttribute _name = match.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = ((Match)node.getAttribute().get(j)).getName()));
                if (_equals) {
                    String _name_2 = match.getName().getName();
                    String _plus = "'" + _name_2;
                    String _plus_1 = String.valueOf(_plus) + "' can only be used once.'";
                    this.error(_plus_1, (EObject)node.getAttribute().get(j), (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkattributeOnlyOnce(ConditionReuseNode node) {
        int i = 0;
        while (i < node.getAttribute().size()) {
            Match match = (Match)node.getAttribute().get(i);
            int j = i + 1;
            while (j < node.getAttribute().size()) {
                EAttribute _name_1;
                EAttribute _name = match.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = ((Match)node.getAttribute().get(j)).getName()));
                if (_equals) {
                    String _name_2 = match.getName().getName();
                    String _plus = "'" + _name_2;
                    String _plus_1 = String.valueOf(_plus) + "' can only be used once.'";
                    this.error(_plus_1, (EObject)node.getAttribute().get(j), (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkConditionReuseNodeInLHS(ConditionReuseNode conReuseNode) {
        ConditionNodeTypes _name = conReuseNode.getName();
        if (_name instanceof Node && !Objects.equal((Object)((Node)conReuseNode.getName()).getActiontype(), null) && !Objects.equal((Object)((Node)conReuseNode.getName()).getActiontype(), (Object)"preserve") && !Objects.equal((Object)((Node)conReuseNode.getName()).getActiontype(), (Object)"delete")) {
            ConditionNodeTypes _name_1 = conReuseNode.getName();
            String _name_2 = ((Node)_name_1).getName();
            String _plus = "Node '" + _name_2;
            String _plus_1 = String.valueOf(_plus) + "' is not in LHS.'";
            this.error(_plus_1, conReuseNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
        }
    }

    @Check
    public void checkConditionEdgeInLHS(ConditionEdge conEdge) {
        ConditionNodeTypes _target;
        ConditionNodeTypes _source = conEdge.getSource();
        if (_source instanceof Node && !Objects.equal((Object)((Node)conEdge.getSource()).getActiontype(), null) && !Objects.equal((Object)((Node)conEdge.getSource()).getActiontype(), (Object)"preserve") && !Objects.equal((Object)((Node)conEdge.getSource()).getActiontype(), (Object)"delete")) {
            ConditionNodeTypes _source_1 = conEdge.getSource();
            String _name = ((Node)_source_1).getName();
            String _plus = "Node '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' is not in LHS.'";
            this.error(_plus_1, conEdge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionEdge_Source());
        }
        if ((_target = conEdge.getTarget()) instanceof Node && !Objects.equal((Object)((Node)conEdge.getTarget()).getActiontype(), null) && !Objects.equal((Object)((Node)conEdge.getTarget()).getActiontype(), (Object)"preserve") && !Objects.equal((Object)((Node)conEdge.getTarget()).getActiontype(), (Object)"delete")) {
            ConditionNodeTypes _target_1 = conEdge.getTarget();
            String _name_1 = ((Node)_target_1).getName();
            String _plus_2 = "Node '" + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "' is not in LHS.'";
            this.error(_plus_3, conEdge, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionEdge_Target());
        }
    }

    @Check
    public void matchingFormulaOnce(Graph graph) {
        boolean _greaterThan;
        Iterable formulaList = Iterables.filter(graph.getGraphElements(), Formula.class);
        int _size = IterableExtensions.size((Iterable)formulaList);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (Formula formula : formulaList) {
                this.error("matchingFormula can only use once.'", formula, (EStructuralFeature)Henshin_textPackage.Literals.FORMULA__FORMULA);
            }
        }
    }

    @Check
    public void matchingFormulaOnce(ConditionGraph graph) {
        boolean _greaterThan;
        Iterable formulaList = Iterables.filter(graph.getConditionGraphElements(), Formula.class);
        int _size = IterableExtensions.size((Iterable)formulaList);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (Formula formula : formulaList) {
                this.error("matchingFormula can only use once.'", formula, (EStructuralFeature)Henshin_textPackage.Literals.FORMULA__FORMULA);
            }
        }
    }

    @Check
    public void checkOverrideNodeNamesinConditionGraph(Graph graph) {
        boolean _greaterThan;
        Iterable formula = Iterables.filter(graph.getGraphElements(), Formula.class);
        ArrayList<ConditionNode> topConNodes = new ArrayList<ConditionNode>();
        int _size = IterableExtensions.size((Iterable)formula);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Iterable _converted_formula = formula;
            EList<ConditionGraph> _conditionGraphs = ((Formula[])Conversions.unwrapArray((Object)_converted_formula, Formula.class))[0].getConditionGraphs();
            for (ConditionGraph conGraph : _conditionGraphs) {
                boolean _greaterThan_1;
                Iterable _filter = Iterables.filter(conGraph.getConditionGraphElements(), ConditionNode.class);
                for (ConditionNode conNode : _filter) {
                    Iterable _filter_1 = Iterables.filter(graph.getGraphElements(), Node.class);
                    for (Node node : _filter_1) {
                        String _name_1;
                        String _name = conNode.getName();
                        boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = node.getName()));
                        if (!_equals) continue;
                        String _name_2 = conNode.getName();
                        String _plus = "Duplicate Node '" + _name_2;
                        String _plus_1 = String.valueOf(_plus) + "'.'";
                        this.error(_plus_1, conNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                    }
                    topConNodes.add(conNode);
                }
                int _size_1 = IterableExtensions.size((Iterable)Iterables.filter(conGraph.getConditionGraphElements(), Formula.class));
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (!_greaterThan_1) continue;
                this.checkRekursiveOverrideNodeNamesinConditionGraph(Iterables.filter(graph.getGraphElements(), Node.class), topConNodes, conGraph);
            }
        }
    }

    private void checkRekursiveOverrideNodeNamesinConditionGraph(Iterable<Node> topNodes, java.util.List<ConditionNode> topConNodes, ConditionGraph graph) {
        boolean _greaterThan;
        Iterable formula = Iterables.filter(graph.getConditionGraphElements(), Formula.class);
        int _size = IterableExtensions.size((Iterable)formula);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Iterable _converted_formula = formula;
            EList<ConditionGraph> _conditionGraphs = ((Formula[])Conversions.unwrapArray((Object)_converted_formula, Formula.class))[0].getConditionGraphs();
            for (ConditionGraph conGraph : _conditionGraphs) {
                boolean _greaterThan_1;
                Iterable _filter = Iterables.filter(conGraph.getConditionGraphElements(), ConditionNode.class);
                for (ConditionNode conNode : _filter) {
                    Iterable _filter_1 = Iterables.filter(graph.getConditionGraphElements(), ConditionNode.class);
                    for (ConditionNode node : _filter_1) {
                        String _name_1;
                        String _name = conNode.getName();
                        boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = node.getName()));
                        if (!_equals) continue;
                        String _name_2 = conNode.getName();
                        String _plus = "Duplicate Node '" + _name_2;
                        String _plus_1 = String.valueOf(_plus) + "'.'";
                        this.error(_plus_1, conNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                    }
                    for (Node node_1 : topNodes) {
                        String _name_4;
                        String _name_3 = conNode.getName();
                        boolean _equals_1 = Objects.equal((Object)_name_3, (Object)(_name_4 = node_1.getName()));
                        if (!_equals_1) continue;
                        String _name_5 = conNode.getName();
                        String _plus_2 = "Duplicate Node '" + _name_5;
                        String _plus_3 = String.valueOf(_plus_2) + "'.'";
                        this.error(_plus_3, conNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                    }
                    for (ConditionNode node_2 : topConNodes) {
                        String _name_7;
                        String _name_6 = conNode.getName();
                        boolean _equals_2 = Objects.equal((Object)_name_6, (Object)(_name_7 = node_2.getName()));
                        if (!_equals_2) continue;
                        String _name_8 = conNode.getName();
                        String _plus_4 = "Duplicate Node '" + _name_8;
                        String _plus_5 = String.valueOf(_plus_4) + "'.'";
                        this.error(_plus_5, conNode, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionNode_Type());
                    }
                    topConNodes.add(conNode);
                }
                int _size_1 = IterableExtensions.size((Iterable)Iterables.filter(conGraph.getConditionGraphElements(), Formula.class));
                boolean bl2 = _greaterThan_1 = _size_1 > 0;
                if (!_greaterThan_1) continue;
                this.checkRekursiveOverrideNodeNamesinConditionGraph(topNodes, topConNodes, conGraph);
            }
        }
    }

    @Check
    public void checkFormulaConditionGraphLevel(Formula formula) {
        Logic _formula = formula.getFormula();
        ArrayList<ConditionGraph> _arrayList = new ArrayList<ConditionGraph>();
        ArrayList<ConditionGraph> formulaGraphs = this.findDuplicate(_formula, _arrayList);
        for (ConditionGraph graph : formulaGraphs) {
            boolean _not;
            boolean _contains = formula.getConditionGraphs().contains((Object)graph);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            String _name = graph.getName();
            String _plus = "ConditionGraph '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' does not exist.'";
            this.error(_plus_1, formula, (EStructuralFeature)Henshin_textPackage.Literals.FORMULA__FORMULA);
        }
    }

    @Check
    public boolean checkConditionFormula(Formula formula) {
        boolean _xblockexpression = false;
        ArrayList<ConditionGraph> conditionGraphs = new ArrayList<ConditionGraph>();
        boolean _xifexpression = false;
        Logic _formula = formula.getFormula();
        if (_formula instanceof ANDImpl) {
            boolean _xblockexpression_1 = false;
            Logic _formula_1 = formula.getFormula();
            conditionGraphs.addAll(this.findDuplicate(((ANDImpl)_formula_1).getLeft(), conditionGraphs));
            Logic _formula_2 = formula.getFormula();
            _xifexpression = _xblockexpression_1 = conditionGraphs.addAll(this.findDuplicate(((ANDImpl)_formula_2).getRight(), conditionGraphs));
        } else {
            boolean _xifexpression_1 = false;
            Logic _formula_1 = formula.getFormula();
            if (_formula_1 instanceof ORorXORImpl) {
                boolean _xblockexpression_2 = false;
                Logic _formula_2 = formula.getFormula();
                conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl)_formula_2).getLeft(), conditionGraphs));
                Logic _formula_3 = formula.getFormula();
                _xifexpression_1 = _xblockexpression_2 = conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl)_formula_3).getRight(), conditionGraphs));
            } else {
                boolean _xifexpression_2 = false;
                Logic _formula_2 = formula.getFormula();
                if (_formula_2 instanceof NotImpl) {
                    Logic _formula_3 = formula.getFormula();
                    _xifexpression_2 = conditionGraphs.addAll(this.findDuplicate(((NotImpl)_formula_3).getNegation(), conditionGraphs));
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private ArrayList<ConditionGraph> findDuplicate(Logic logic, ArrayList<ConditionGraph> conditionGraphs) {
        if (logic instanceof ANDImpl) {
            conditionGraphs.addAll(this.findDuplicate(((ANDImpl)logic).getLeft(), conditionGraphs));
            conditionGraphs.addAll(this.findDuplicate(((ANDImpl)logic).getRight(), conditionGraphs));
        } else if (logic instanceof ORorXORImpl) {
            conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl)logic).getLeft(), conditionGraphs));
            conditionGraphs.addAll(this.findDuplicate(((ORorXORImpl)logic).getRight(), conditionGraphs));
        } else if (logic instanceof NotImpl) {
            conditionGraphs.addAll(this.findDuplicate(((NotImpl)logic).getNegation(), conditionGraphs));
        } else if (logic instanceof ConditionGraphRef) {
            boolean _contains = conditionGraphs.contains(((ConditionGraphRef)logic).getConditionGraphRef());
            if (_contains) {
                String _name = ((ConditionGraphRef)logic).getConditionGraphRef().getName();
                String _plus = "Duplicate ConditionGraph '" + _name;
                String _plus_1 = String.valueOf(_plus) + "'.'";
                this.error(_plus_1, (ConditionGraphRef)logic, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionGraphRef_ConditionGraphRef());
            } else {
                conditionGraphs.add(((ConditionGraphRef)logic).getConditionGraphRef());
            }
        }
        return conditionGraphs;
    }

    @Check
    public void checkConditionGraphReuseOwnNodes(ConditionGraph graph) {
        Iterable _filter = Iterables.filter(graph.getConditionGraphElements(), ConditionReuseNode.class);
        for (ConditionReuseNode reuse : _filter) {
            Iterable _filter_1 = Iterables.filter(graph.getConditionGraphElements(), ConditionNode.class);
            for (ConditionNode node : _filter_1) {
                String _name_1;
                String _name = reuse.getName().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = node.getName()));
                if (!_equals) continue;
                this.error("ConditionGraph cannot reuse its own nodes.'", reuse, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
            }
        }
    }

    @Check
    public void checkConditionGraphMultiReuse(ConditionGraph graph) {
        Iterable reuseNodes = Iterables.filter(graph.getConditionGraphElements(), ConditionReuseNode.class);
        int i = 0;
        while (i < IterableExtensions.size((Iterable)reuseNodes)) {
            int j = i + 1;
            while (j < IterableExtensions.size((Iterable)reuseNodes)) {
                Iterable _converted_reuseNodes_1;
                String _name_1;
                Iterable _converted_reuseNodes = reuseNodes;
                String _name = ((ConditionReuseNode[])Conversions.unwrapArray((Object)_converted_reuseNodes, ConditionReuseNode.class))[i].getName().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = ((ConditionReuseNode[])Conversions.unwrapArray((Object)(_converted_reuseNodes_1 = reuseNodes), ConditionReuseNode.class))[j].getName().getName()));
                if (_equals) {
                    Iterable _converted_reuseNodes_2 = reuseNodes;
                    String _name_2 = ((ConditionReuseNode[])Conversions.unwrapArray((Object)_converted_reuseNodes_2, ConditionReuseNode.class))[j].getName().getName();
                    String _plus = String.valueOf(_name_2) + " is already reused in ConditionGraph ";
                    String _name_3 = graph.getName();
                    String _plus_1 = String.valueOf(_plus) + _name_3;
                    String _plus_2 = String.valueOf(_plus_1) + ".'";
                    Iterable _converted_reuseNodes_3 = reuseNodes;
                    this.error(_plus_2, ((EObject[])Conversions.unwrapArray((Object)_converted_reuseNodes_3, EObject.class))[j], (EStructuralFeature)Henshin_textPackage.eINSTANCE.getConditionReuseNode_Name());
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkIterationUnitIterationsNegative(IteratedUnit unit) {
        Expression _iterations = unit.getIterations();
        if (_iterations instanceof NumberValue) {
            Expression _iterations_1 = unit.getIterations();
            boolean _contains = ((NumberValue)_iterations_1).getValue().contains("-");
            if (_contains) {
                this.error("Negative values are not allowed.'", unit, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
            }
        } else {
            Expression _iterations_3;
            boolean _contains_1;
            Expression _iterations_2 = unit.getIterations();
            if (_iterations_2 instanceof IntegerValue && (_contains_1 = ((IntegerValue)(_iterations_3 = unit.getIterations())).getValue().contains("-"))) {
                this.error("Negative values are not allowed.'", unit, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
            }
        }
    }

    @Check
    public void checkIterationUnitIterationsType(IteratedUnit unit) {
        boolean _notEquals;
        Expression _iterations = unit.getIterations();
        boolean bl = _notEquals = !Objects.equal((Object)_iterations, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String _string = this._henshin_textTypeProvider.typeFor(unit.getIterations()).toString();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_string, (Object)"number");
            if (_notEquals_1) {
                Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(unit.getIterations());
                String _plus = "IteratedUnit expected number type, but was " + _typeFor;
                String _plus_1 = String.valueOf(_plus) + ".'";
                this.error(_plus_1, unit, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getIteratedUnit_Iterations());
            }
        }
    }

    @Check
    public void checkCountStrict(Unit unit) {
        boolean _greaterThan;
        Iterable iterableOfStrictImpl = Iterables.filter(unit.getUnitElements(), StrictImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictSubSequence(UnitElement unit) {
        boolean _greaterThan;
        Iterable iterableOfStrictImpl = Iterables.filter(unit.getSubSequence(), StrictImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictIndependentUnit(IndependentUnit unit) {
        EList<List> _listOfLists = unit.getListOfLists();
        for (List e : _listOfLists) {
            boolean _greaterThan;
            Iterable iterableOfStrictImpl = Iterables.filter(e.getSubElements(), StrictImpl.class);
            int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictConditionalUnit(ConditionalUnit unit) {
        int _size_2;
        boolean _greaterThan_2;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        Iterable iterableOfStrictImplIF = Iterables.filter(unit.getIf(), StrictImpl.class);
        Iterable iterableOfStrictImplTHEN = Iterables.filter(unit.getThen(), StrictImpl.class);
        Iterable iterableOfStrictImplELSE = Iterables.filter(unit.getElse(), StrictImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfStrictImplIF);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (StrictImpl strict : iterableOfStrictImplIF) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = IterableExtensions.size((Iterable)iterableOfStrictImplTHEN)) > 1;
        if (_greaterThan_1) {
            for (StrictImpl strict_1 : iterableOfStrictImplTHEN) {
                this.error("Strict can only be used once.'", strict_1, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
        boolean bl3 = _greaterThan_2 = (_size_2 = IterableExtensions.size((Iterable)iterableOfStrictImplELSE)) > 1;
        if (_greaterThan_2) {
            for (StrictImpl strict_2 : iterableOfStrictImplELSE) {
                this.error("Strict can only be used once.'", strict_2, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictPriorityUnit(PriorityUnit unit) {
        EList<List> _listOfLists = unit.getListOfLists();
        for (List e : _listOfLists) {
            boolean _greaterThan;
            Iterable iterableOfStrictImpl = Iterables.filter(e.getSubElements(), StrictImpl.class);
            int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictIteratedUnit(IteratedUnit unit) {
        boolean _greaterThan;
        Iterable iterableOfStrictImpl = Iterables.filter(unit.getSubElement(), StrictImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountStrictLoopUnit(LoopUnit unit) {
        boolean _greaterThan;
        Iterable iterableOfStrictImpl = Iterables.filter(unit.getSubElement(), StrictImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfStrictImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (StrictImpl strict : iterableOfStrictImpl) {
                this.error("Strict can only be used once.'", strict, (EStructuralFeature)Henshin_textPackage.Literals.STRICT__STRICT);
            }
        }
    }

    @Check
    public void checkCountRollback(Unit unit) {
        boolean _greaterThan;
        Iterable iterableOfRollbackImpl = Iterables.filter(unit.getUnitElements(), RollbackImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackSubSequence(UnitElement unit) {
        boolean _greaterThan;
        Iterable iterableOfRollbackImpl = Iterables.filter(unit.getSubSequence(), RollbackImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackIndependentUnit(IndependentUnit unit) {
        EList<List> _listOfLists = unit.getListOfLists();
        for (List e : _listOfLists) {
            boolean _greaterThan;
            Iterable iterableOfRollbackImpl = Iterables.filter(e.getSubElements(), RollbackImpl.class);
            int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackConditionalUnit(ConditionalUnit unit) {
        int _size_2;
        boolean _greaterThan_2;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        Iterable iterableOfRollbackImplIF = Iterables.filter(unit.getIf(), RollbackImpl.class);
        Iterable iterableOfRollbackImplTHEN = Iterables.filter(unit.getThen(), RollbackImpl.class);
        Iterable iterableOfRollbackImplELSE = Iterables.filter(unit.getElse(), RollbackImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfRollbackImplIF);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (RollbackImpl rollback : iterableOfRollbackImplIF) {
                this.error("Strict can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = IterableExtensions.size((Iterable)iterableOfRollbackImplTHEN)) > 1;
        if (_greaterThan_1) {
            for (RollbackImpl rollback_1 : iterableOfRollbackImplTHEN) {
                this.error("Strict can only be used once.'", rollback_1, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
        boolean bl3 = _greaterThan_2 = (_size_2 = IterableExtensions.size((Iterable)iterableOfRollbackImplELSE)) > 1;
        if (_greaterThan_2) {
            for (RollbackImpl rollback_2 : iterableOfRollbackImplELSE) {
                this.error("Strict can only be used once.'", rollback_2, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackPriorityUnit(PriorityUnit unit) {
        EList<List> _listOfLists = unit.getListOfLists();
        for (List e : _listOfLists) {
            boolean _greaterThan;
            Iterable iterableOfRollbackImpl = Iterables.filter(e.getSubElements(), RollbackImpl.class);
            int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackIteratedUnit(IteratedUnit unit) {
        boolean _greaterThan;
        Iterable iterableOfRollbackImpl = Iterables.filter(unit.getSubElement(), RollbackImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkCountRollbackLoopUnit(LoopUnit unit) {
        boolean _greaterThan;
        Iterable iterableOfRollbackImpl = Iterables.filter(unit.getSubElement(), RollbackImpl.class);
        int _size = IterableExtensions.size((Iterable)iterableOfRollbackImpl);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (RollbackImpl rollback : iterableOfRollbackImpl) {
                this.error("Rollback can only be used once.'", rollback, (EStructuralFeature)Henshin_textPackage.Literals.ROLLBACK__ROLLBACK);
            }
        }
    }

    @Check
    public void checkTypeNot(NotExpression not) {
        this.checkExpectedType(not.getExpression(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.NOT_EXPRESSION__EXPRESSION);
    }

    @Check
    public void checkTypeMulOrDiv(MulOrDivExpression mulOrDiv) {
        this.checkExpectedType(mulOrDiv.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MUL_OR_DIV_EXPRESSION__LEFT);
        this.checkExpectedType(mulOrDiv.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MUL_OR_DIV_EXPRESSION__RIGHT);
    }

    @Check
    public void checkTypeMinus(MinusExpression minus) {
        this.checkExpectedType(minus.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MINUS_EXPRESSION__LEFT);
        this.checkExpectedType(minus.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.MINUS_EXPRESSION__RIGHT);
    }

    @Check
    public void checkTypePlus(PlusExpression plus) {
        this.checkExpectedType(plus.getLeft(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.PLUS_EXPRESSION__LEFT);
        this.checkExpectedType(plus.getRight(), Henshin_textTypeProvider.numberType, Henshin_textPackage.Literals.PLUS_EXPRESSION__RIGHT);
    }

    @Check
    public void checkTypeAnd(AndExpression and) {
        this.checkExpectedType(and.getLeft(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.AND_EXPRESSION__LEFT);
        this.checkExpectedType(and.getRight(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.AND_EXPRESSION__RIGHT);
    }

    @Check
    public void checkTypeOr(OrExpression or) {
        this.checkExpectedType(or.getLeft(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.OR_EXPRESSION__LEFT);
        this.checkExpectedType(or.getRight(), Henshin_textTypeProvider.boolType, Henshin_textPackage.Literals.OR_EXPRESSION__RIGHT);
    }

    @Check
    public void checkTypeEquality(EqualityExpression equality) {
        Henshin_textType rightType;
        Henshin_textType leftType = this.getTypeAndCheckNotNull(equality.getLeft(), Henshin_textPackage.Literals.EQUALITY_EXPRESSION__LEFT);
        if (!(Objects.equal((Object)leftType, (Object)(rightType = this.getTypeAndCheckNotNull(equality.getRight(), Henshin_textPackage.Literals.EQUALITY_EXPRESSION__RIGHT))) || Objects.equal((Object)leftType, null) || Objects.equal((Object)rightType, null))) {
            this.error("Expression expected the same type, but was " + leftType + " and " + rightType + ".'", (EStructuralFeature)Henshin_textPackage.Literals.EQUALITY_EXPRESSION.getEIDAttribute(), "", new String[0]);
        }
    }

    @Check
    public void checkTypeComparison(ComparisonExpression comparison) {
        Henshin_textType rightType;
        Henshin_textType leftType = this.getTypeAndCheckNotNull(comparison.getLeft(), Henshin_textPackage.Literals.COMPARISON_EXPRESSION__LEFT);
        if (!(Objects.equal((Object)leftType, (Object)(rightType = this.getTypeAndCheckNotNull(comparison.getRight(), Henshin_textPackage.Literals.COMPARISON_EXPRESSION__RIGHT))) || Objects.equal((Object)leftType, null) || Objects.equal((Object)rightType, null))) {
            this.error("Expression expected the same type, but was " + leftType + " and " + rightType + ".'", (EStructuralFeature)Henshin_textPackage.Literals.COMPARISON_EXPRESSION.getEIDAttribute(), "", new String[0]);
        }
        if (Objects.equal((Object)leftType, (Object)Henshin_textTypeProvider.boolType) || Objects.equal((Object)leftType, (Object)Henshin_textTypeProvider.complexType)) {
            this.error("Value cannot be compared.'", (EStructuralFeature)Henshin_textPackage.Literals.COMPARISON_EXPRESSION__LEFT, "", new String[0]);
        }
        if (Objects.equal((Object)rightType, (Object)Henshin_textTypeProvider.boolType) || Objects.equal((Object)leftType, (Object)Henshin_textTypeProvider.complexType)) {
            this.error("Value cannot be compared.'", (EStructuralFeature)Henshin_textPackage.Literals.COMPARISON_EXPRESSION__RIGHT, "", new String[0]);
        }
    }

    private void checkExpectedType(Expression expression, Henshin_textType expectedType, EReference reference) {
        boolean _notEquals;
        Henshin_textType actualType = this.getTypeAndCheckNotNull(expression, reference);
        boolean bl = _notEquals = !Objects.equal((Object)actualType, (Object)expectedType);
        if (_notEquals) {
            this.error("Expression expected " + expectedType + " type, but was " + actualType + ".'", (EStructuralFeature)reference, "", new String[0]);
        }
    }

    private Henshin_textType getTypeAndCheckNotNull(Expression expression, EReference reference) {
        boolean _equals;
        boolean _notEquals;
        Henshin_textType type = null;
        boolean bl = _notEquals = !Objects.equal((Object)expression, null);
        if (_notEquals) {
            type = this._henshin_textTypeProvider.typeFor(expression);
        }
        if (_equals = Objects.equal(type, null)) {
            this.error("Null type.'", (EStructuralFeature)reference, "", new String[0]);
        }
        return type;
    }

    @Check
    public void checkAttributeType(Attribute attribute) {
        Expression _value = attribute.getValue();
        if (_value instanceof ParameterValue) {
            if (!Objects.equal((Object)((ParameterValue)attribute.getValue()).getValue().getType().getType(), null) && !Objects.equal((Object)attribute.getName().getEAttributeType().getName(), (Object)((ParameterValue)attribute.getValue()).getValue().getType().getType().getName())) {
                String _name = attribute.getName().getEAttributeType().getName();
                String _plus = "Attribute expected " + _name;
                String _plus_1 = String.valueOf(_plus) + " type, but was ";
                Expression _value_1 = attribute.getValue();
                String _name_1 = ((ParameterValue)_value_1).getValue().getType().getType().getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".'";
                this.error(_plus_3, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Value());
            } else if (!Objects.equal((Object)this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()).toString(), (Object)"string") && !Objects.equal((Object)this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()), (Object)this._henshin_textTypeProvider.typeFor(((ParameterValue)attribute.getValue()).getValue().getType().getEnumType().getLiteral()))) {
                String _name_2 = attribute.getName().getEAttributeType().getName();
                String _plus_4 = "Attribute expected " + _name_2;
                String _plus_5 = String.valueOf(_plus_4) + " type, but was ";
                Expression _value_2 = attribute.getValue();
                String _literal = ((ParameterValue)_value_2).getValue().getType().getEnumType().getLiteral();
                String _plus_6 = String.valueOf(_plus_5) + _literal;
                String _plus_7 = String.valueOf(_plus_6) + ".'";
                this.error(_plus_7, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Value());
            }
        } else if (!Objects.equal((Object)this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()).toString(), (Object)"string") && !Objects.equal((Object)this._henshin_textTypeProvider.typeFor(attribute.getName().getEAttributeType().getName()), (Object)this._henshin_textTypeProvider.typeFor(attribute.getValue()))) {
            String _name_3 = attribute.getName().getEAttributeType().getName();
            String _plus_8 = "Attribute expected " + _name_3;
            String _plus_9 = String.valueOf(_plus_8) + " type, but was ";
            Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(attribute.getValue());
            String _plus_10 = String.valueOf(_plus_9) + _typeFor;
            String _plus_11 = String.valueOf(_plus_10) + ".'";
            this.error(_plus_11, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getAttribute_Value());
        }
    }

    @Check
    public void checkMatchType(Match match) {
        Expression _value = match.getValue();
        if (_value instanceof ParameterValue) {
            if (!Objects.equal((Object)((ParameterValue)match.getValue()).getValue().getType().getType(), null) && !Objects.equal((Object)match.getName().getEAttributeType().getName(), (Object)((ParameterValue)match.getValue()).getValue().getType().getType().getName())) {
                String _name = match.getName().getEAttributeType().getName();
                String _plus = "Attribute expected " + _name;
                String _plus_1 = String.valueOf(_plus) + " type, but was ";
                Expression _value_1 = match.getValue();
                String _name_1 = ((ParameterValue)_value_1).getValue().getType().getType().getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".'";
                this.error(_plus_3, match, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Value());
            } else if (!Objects.equal((Object)this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()).toString(), (Object)"string") && !Objects.equal((Object)this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()), (Object)this._henshin_textTypeProvider.typeFor(((ParameterValue)match.getValue()).getValue().getType().getEnumType().getLiteral()))) {
                String _name_2 = match.getName().getEAttributeType().getName();
                String _plus_4 = "Attribute expected " + _name_2;
                String _plus_5 = String.valueOf(_plus_4) + " type, but was ";
                Expression _value_2 = match.getValue();
                String _literal = ((ParameterValue)_value_2).getValue().getType().getEnumType().getLiteral();
                String _plus_6 = String.valueOf(_plus_5) + _literal;
                String _plus_7 = String.valueOf(_plus_6) + ".'";
                this.error(_plus_7, match, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Value());
            }
        } else if (!Objects.equal((Object)this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()).toString(), (Object)"string") && !Objects.equal((Object)this._henshin_textTypeProvider.typeFor(match.getName().getEAttributeType().getName()), (Object)this._henshin_textTypeProvider.typeFor(match.getValue()))) {
            String _name_3 = match.getName().getEAttributeType().getName();
            String _plus_8 = "Attribute expected " + _name_3;
            String _plus_9 = String.valueOf(_plus_8) + " type, but was ";
            Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor(match.getValue());
            String _plus_10 = String.valueOf(_plus_9) + _typeFor;
            String _plus_11 = String.valueOf(_plus_10) + ".'";
            this.error(_plus_11, match, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getMatch_Value());
        }
    }

    @Check
    public void checkJavaAttribute(JavaAttributeValue attribute) {
        java.util.List<JavaImport> iterableOfJavaImportImpl = this.getImportList(attribute);
        Field javaAttribute = null;
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Field[] _declaredFields;
                String _packagename = imports.getPackagename();
                String _plus = String.valueOf(_packagename) + ".";
                String _get = attribute.getValue().split("\\.")[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Field[] fieldArray = _declaredFields = calledClass.getDeclaredFields();
                int n = _declaredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String _get_1;
                    Field atrib = fieldArray[n2];
                    String _name = atrib.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = attribute.getValue().split("\\.")[1]));
                    if (_equals) {
                        javaAttribute = atrib;
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ClassNotFoundException) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        boolean _equals = Objects.equal(javaAttribute, null);
        if (_equals) {
            String _value = attribute.getValue();
            String _plus = String.valueOf(_value) + " doesn't exist.'";
            this.error(_plus, attribute, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getJavaAttributeValue_Value());
        }
    }

    @Check
    public void checkJavaCall(JavaClassValue classCall) {
        boolean _lessEqualsThan;
        String _name;
        String _plus;
        java.util.List<JavaImport> iterableOfJavaImportImpl = this.getImportList(classCall);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Method[] _methods;
                String _packagename = imports.getPackagename();
                _plus = String.valueOf(_packagename) + ".";
                String _get = classCall.getValue().split("\\.")[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Method[] methodArray = _methods = calledClass.getMethods();
                int n = _methods.length;
                int n2 = 0;
                while (n2 < n) {
                    String _get_1;
                    Method method = methodArray[n2];
                    _name = method.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = classCall.getValue().split("\\.")[1]));
                    if (_equals) {
                        methods.add(method);
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ClassNotFoundException) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        int _size = methods.size();
        boolean bl = _lessEqualsThan = _size <= 0;
        if (_lessEqualsThan) {
            String _value = classCall.getValue();
            _plus = String.valueOf(_value) + " doesn't exist.'";
            this.error(_plus, classCall, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getJavaClassValue_Value());
        } else {
            boolean badParametercount = true;
            boolean wrongParameterType = false;
            boolean methodExist = false;
            for (Method method : methods) {
                int _size_2;
                boolean _equals;
                if (methodExist) continue;
                int _size_1 = ((java.util.List)Conversions.doWrapArray(method.getParameterTypes())).size();
                boolean bl2 = _equals = _size_1 == (_size_2 = classCall.getJavaParameter().size());
                if (_equals) {
                    badParametercount = false;
                    int i = 0;
                    while (i < classCall.getJavaParameter().size()) {
                        Henshin_textType _typeForJavaType;
                        boolean _notEquals;
                        Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor((Expression)classCall.getJavaParameter().get(i));
                        boolean bl3 = _notEquals = !Objects.equal((Object)_typeFor, (Object)(_typeForJavaType = this._henshin_textTypeProvider.typeForJavaType(method.getParameterTypes()[i].getName())));
                        if (_notEquals) {
                            wrongParameterType = true;
                        }
                        ++i;
                    }
                }
                if (!badParametercount && !wrongParameterType) {
                    methodExist = true;
                    continue;
                }
                badParametercount = true;
                wrongParameterType = false;
            }
            if (!methodExist) {
                int _size_4;
                boolean _notEquals;
                int _size_3 = ((java.util.List)Conversions.doWrapArray(((Method)methods.get(0)).getParameterTypes())).size();
                boolean bl4 = _notEquals = _size_3 != (_size_4 = classCall.getJavaParameter().size());
                if (_notEquals) {
                    this.error("Bad Parameter Count.'", classCall, (EStructuralFeature)Henshin_textPackage.eINSTANCE.getJavaClassValue_Value());
                } else {
                    int i = 0;
                    while (i < classCall.getJavaParameter().size()) {
                        Henshin_textType _typeForJavaType;
                        boolean _notEquals_1;
                        Henshin_textType _typeFor = this._henshin_textTypeProvider.typeFor((Expression)classCall.getJavaParameter().get(i));
                        boolean bl5 = _notEquals_1 = !Objects.equal((Object)_typeFor, (Object)(_typeForJavaType = this._henshin_textTypeProvider.typeForJavaType(((Method)methods.get(0)).getParameterTypes()[i].getName())));
                        if (_notEquals_1) {
                            _name = ((Method)methods.get(0)).getParameterTypes()[i].getName();
                            String _plus_1 = "Methode expected " + _name;
                            String _plus_2 = String.valueOf(_plus_1) + " type, but was ";
                            Henshin_textType _typeFor_1 = this._henshin_textTypeProvider.typeFor((Expression)classCall.getJavaParameter().get(i));
                            String _plus_3 = String.valueOf(_plus_2) + _typeFor_1;
                            String _plus_4 = String.valueOf(_plus_3) + ".'";
                            this.error(_plus_4, (EObject)classCall.getJavaParameter().get(i), (EStructuralFeature)Henshin_textPackage.eINSTANCE.getJavaClassValue_JavaParameter());
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private java.util.List<JavaImport> getImportList(EObject startObject) {
        boolean _not;
        ArrayList<JavaImport> iterableOfJavaImportImpl = new ArrayList<JavaImport>();
        EObject container = startObject.eContainer();
        while (!(container instanceof Rule) && !(container instanceof MultiRule)) {
            container = container.eContainer();
        }
        if (container instanceof Rule) {
            Iterables.addAll(iterableOfJavaImportImpl, (Iterable)Iterables.filter(((Rule)container).getRuleElements(), JavaImport.class));
        } else {
            Iterables.addAll(iterableOfJavaImportImpl, (Iterable)Iterables.filter(((MultiRule)container).getMultiruleElements(), JavaImport.class));
        }
        EObject _eContainer = container.eContainer();
        boolean bl = _not = !(_eContainer instanceof Model);
        if (_not) {
            iterableOfJavaImportImpl.addAll(this.getImportList(container));
        }
        return iterableOfJavaImportImpl;
    }
}

