/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.staticanalysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.staticanalysis.NodeMap;

public class NodeEquivalence
extends ArrayList<Node> {
    private static final long serialVersionUID = 1L;

    public static List<NodeEquivalence> computeEquivalences(Graph graph) {
        ArrayList<NodeEquivalence> equivalences = new ArrayList<NodeEquivalence>();
        HashSet<Node> usedNodes = new HashSet<Node>();
        for (Node x : graph.getNodes()) {
            if (usedNodes.contains(x)) continue;
            NodeEquivalence equivalence = new NodeEquivalence();
            equivalence.add(x);
            for (Node y : graph.getNodes()) {
                if (x == y || usedNodes.contains(y) || x.getType() != y.getType()) continue;
                NodeMap map = new NodeMap(graph, graph);
                for (Node z : graph.getNodes()) {
                    if (z == x) {
                        map.put(z, y);
                        continue;
                    }
                    if (z == y) {
                        map.put(z, x);
                        continue;
                    }
                    map.put(z, z);
                }
                if (!map.isGraphMorphism()) continue;
                try {
                    if (!map.getInverse().isGraphMorphism()) continue;
                    equivalence.add(y);
                    usedNodes.add(x);
                    usedNodes.add(y);
                }
                catch (Exception exception) {}
            }
            if (equivalence.size() <= 1) continue;
            equivalences.add(equivalence);
        }
        return equivalences;
    }
}

