/**
 * <copyright>
 * Copyright (c) 2010-2014 Henshin developers. All rights reserved. 
 * This program and the accompanying materials are made available 
 * under the terms of the Eclipse Public License v1.0 which 
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * </copyright>
 */
package org.eclipse.emf.henshin.model.impl;

import java.util.Collection;
import java.util.LinkedList;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Unit;

/**
 * <!-- begin-user-doc --> 
 * An implementation of the model object '<em><b>Unit</b></em>'. 
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emf.henshin.model.impl.UnitImpl#getParameters <em>Parameters</em>}</li>
 *   <li>{@link org.eclipse.emf.henshin.model.impl.UnitImpl#getParameterMappings <em>Parameter Mappings</em>}</li>
 *   <li>{@link org.eclipse.emf.henshin.model.impl.UnitImpl#isActivated <em>Activated</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class UnitImpl extends NamedElementImpl implements Unit {
	
	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<Parameter> parameters;
	
	/**
	 * The cached value of the '{@link #getParameterMappings() <em>Parameter Mappings</em>}' containment reference list.
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @see #getParameterMappings()
	 * @generated
	 * @ordered
	 */
	protected EList<ParameterMapping> parameterMappings;

	/**
	 * The default value of the '{@link #isActivated() <em>Activated</em>}' attribute.
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @see #isActivated()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ACTIVATED_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isActivated() <em>Activated</em>}' attribute.
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @see #isActivated()
	 * @generated
	 * @ordered
	 */
	protected boolean activated = ACTIVATED_EDEFAULT;
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnitImpl() {
		super();
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HenshinPackage.Literals.UNIT;
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isActivated() {
		return activated;
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActivated(boolean newActivated) {
		boolean oldActivated = activated;
		activated = newActivated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HenshinPackage.UNIT__ACTIVATED, oldActivated, activated));
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Module getModule() {
		EObject container = eContainer();
		while (container!=null) {
			if (container instanceof Module) {
				return (Module) container;
			}
			container = container.eContainer();
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Parameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentWithInverseEList.Resolving<Parameter>(Parameter.class, this, HenshinPackage.UNIT__PARAMETERS, HenshinPackage.PARAMETER__UNIT);
		}
		return parameters;
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ParameterMapping> getParameterMappings() {
		if (parameterMappings == null) {
			parameterMappings = new EObjectContainmentEList.Resolving<ParameterMapping>(ParameterMapping.class, this, HenshinPackage.UNIT__PARAMETER_MAPPINGS);
		}
		return parameterMappings;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * Get the direct subUnits of this unit. Subclasses must implement this method.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected abstract EList<Unit> getSubUnits();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public final EList<Unit> getSubUnits(boolean deep) {
		EList<Unit> result = new BasicEList<Unit>();
		result.addAll(getSubUnits());
		if (deep) {
			boolean changed;
			do {
				changed = false;
				int count = result.size();
				for (int i=0; i<count; i++) {
					for (Unit unit : ((UnitImpl) result.get(i)).getSubUnits()) {
						if (!result.contains(unit)) {
							result.add(unit);
							changed = true;
						}
					}
				}
			} while (changed);
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Parameter getParameter(String name) {
		for (Parameter parameter : getParameters()) {
			if (name==null) {
				if (parameter.getName()==null) {
					return parameter;
				}
			} else {
				if (name.equals(parameter.getName())) {
					return parameter;
				}
			}
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Parameter getParameterByName(String name) {
		return getParameter(name);
	}

	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID,
			NotificationChain msgs) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getParameters()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID,
			NotificationChain msgs) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
			case HenshinPackage.UNIT__PARAMETER_MAPPINGS:
				return ((InternalEList<?>)getParameterMappings()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				return getParameters();
			case HenshinPackage.UNIT__PARAMETER_MAPPINGS:
				return getParameterMappings();
			case HenshinPackage.UNIT__ACTIVATED:
				return isActivated();
		}
		return super.eGet(featureID, resolve, coreType);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends Parameter>)newValue);
				return;
			case HenshinPackage.UNIT__PARAMETER_MAPPINGS:
				getParameterMappings().clear();
				getParameterMappings().addAll((Collection<? extends ParameterMapping>)newValue);
				return;
			case HenshinPackage.UNIT__ACTIVATED:
				setActivated((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				getParameters().clear();
				return;
			case HenshinPackage.UNIT__PARAMETER_MAPPINGS:
				getParameterMappings().clear();
				return;
			case HenshinPackage.UNIT__ACTIVATED:
				setActivated(ACTIVATED_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HenshinPackage.UNIT__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
			case HenshinPackage.UNIT__PARAMETER_MAPPINGS:
				return parameterMappings != null && !parameterMappings.isEmpty();
			case HenshinPackage.UNIT__ACTIVATED:
				return activated != ACTIVATED_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		StringBuilder unitStringBuilder = new StringBuilder();
		
		unitStringBuilder.append(eClass().getName());

		if(name != null) {
			unitStringBuilder.append(" ");
			unitStringBuilder.append(name);
		}

		if (!getParameters().isEmpty()) {
			String delimiter = "";
			int numberOfParameters = parameters.size();
			LinkedList<Parameter> varParameters = new LinkedList<Parameter>();
			
			unitStringBuilder.append("(");
			for (int i=0; i<numberOfParameters; i++) {
				Parameter param = parameters.get(i);
				if (param.getKind() == ParameterKind.VAR) {
					varParameters.add(param);
				} else {
					unitStringBuilder.append(delimiter);	
					unitStringBuilder.append(param.toCompactString());
					delimiter = ", ";	
				}
			}
			for(Parameter param : varParameters) {
				unitStringBuilder.append(delimiter);
				unitStringBuilder.append(param.toCompactString());
				delimiter = ", ";
			}
			unitStringBuilder.append(")");
		}
		return unitStringBuilder.toString();		
	}	
} // UnitImpl
