/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RuleLayer {
    private Hashtable<Rule, Integer> ruleLayer;
    private Vector<Rule> rulesVec;

    public RuleLayer(Enumeration<Rule> rules) {
        this.rulesVec = new Vector(0);
        while (rules.hasMoreElements()) {
            this.rulesVec.addElement(rules.nextElement());
        }
        this.initRuleLayer();
    }

    public RuleLayer(List<Rule> rules) {
        this.rulesVec = new Vector(0);
        int i = 0;
        while (i < rules.size()) {
            this.rulesVec.add(rules.get(i));
            ++i;
        }
        this.initRuleLayer();
    }

    public RuleLayer(Vector<Rule> rules) {
        this.rulesVec = rules;
        this.initRuleLayer();
    }

    public void dispose() {
        this.ruleLayer.clear();
        this.rulesVec = null;
    }

    public void setLayer(Rule rule, int layer) {
        rule.setLayer(layer);
        this.ruleLayer.put(rule, layer);
    }

    private void initRuleLayer() {
        this.ruleLayer = new Hashtable();
        int i = 0;
        while (i < this.rulesVec.size()) {
            Rule rule = this.rulesVec.elementAt(i);
            this.ruleLayer.put(rule, rule.getLayer());
            ++i;
        }
    }

    public boolean compareTo(RuleLayer rl) {
        return this.ruleLayer.equals(rl.getRuleLayer());
    }

    public Hashtable<Rule, Integer> getRuleLayer() {
        return this.ruleLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Rule> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer layer = this.getRuleLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable<Integer, HashSet<Rule>> invertLayer() {
        Hashtable<Integer, HashSet<Rule>> inverted = new Hashtable<Integer, HashSet<Rule>>();
        Enumeration<Rule> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer value = this.ruleLayer.get(key);
            HashSet<Rule> invertedValue = inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Rule:\t\tLayer:\n";
        Enumeration<Rule> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer value = this.ruleLayer.get(key);
            resultString = String.valueOf(resultString) + key.getName() + "\t\t" + value.toString() + "    " + key.getLayer() + "\n";
        }
        return resultString;
    }
}

