/*
 * Decompiled with CFR 0.152.
 */
package agg.ruleappl;

import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarTuple;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePair;
import agg.parser.ExcludePairHelper;
import agg.parser.PairContainer;
import agg.parser.ParserFactory;
import agg.parser.SimpleExcludePair;
import agg.ruleappl.ObjectFlow;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ApplicabilityChecker
implements Runnable {
    private GraGra gragra;
    private final Completion_InjCSP strategy = new Completion_InjCSP();
    private MorphCompletionStrategy gragraStrategy;
    private CriticalPairOption cpOption;
    private RuleSequence ruleSequence;
    private final List<Rule> nonApplicableRules = new Vector<Rule>();
    private final List<ConcurrentRule> concurrentRules = new Vector<ConcurrentRule>();
    private final List<ConcurrentRule> applicableConcurrentRules = new Vector<ConcurrentRule>();
    private String info = "";
    private int depth = -1;
    private boolean completeConcurrency;
    private boolean completeCPA;
    private boolean consistentConcurrency;
    private boolean completeConcurRuleBackward = true;
    private boolean ignoreDanglingEdgeOfDelNode;
    private boolean mainResult;

    public ApplicabilityChecker(RuleSequence sequence, GraGra grammar) {
        this.ruleSequence = sequence;
        this.gragra = grammar;
        this.cpOption = sequence.getCriticalPairOption();
        if (this.cpOption == null) {
            this.cpOption = new CriticalPairOption();
        }
        this.completeConcurRuleBackward = true;
        if (this.gragra != null) {
            this.gragraStrategy = this.gragra.getMorphismCompletionStrategy();
        }
    }

    public ApplicabilityChecker(RuleSequence sequence, GraGra grammar, CriticalPairOption option) {
        this.ruleSequence = sequence;
        this.gragra = grammar;
        this.cpOption = option;
        this.completeConcurRuleBackward = true;
        this.gragraStrategy = this.gragra.getMorphismCompletionStrategy();
    }

    public void setCriticalPairOption(CriticalPairOption option) {
        this.cpOption = option;
    }

    @Override
    public void run() {
        this.check();
    }

    public boolean getResult() {
        return this.mainResult;
    }

    public void setDepthOfConcurrentRule(int d) {
        this.depth = d;
    }

    public int getDepthOfConcurrentRule() {
        return this.depth;
    }

    public void setCompleteConcurrency(boolean b) {
        this.completeConcurrency = b;
    }

    public boolean getCompleteConcurrency() {
        return this.completeConcurrency;
    }

    public void setCompleteCPAOfConcurrency(boolean b) {
        this.completeCPA = b;
    }

    public boolean getCompleteCPAOfConcurrency() {
        return this.completeCPA;
    }

    public void setConsistentConcurrency(boolean b) {
        this.consistentConcurrency = b;
    }

    public boolean getConsistentConcurrency() {
        return this.consistentConcurrency;
    }

    public boolean isCompletionConcurrentRuleForward() {
        return !this.completeConcurRuleBackward;
    }

    public boolean isCompletionConcurrentRuleBackward() {
        return this.completeConcurRuleBackward;
    }

    public void setIgnoreDanglingEdgeOfDelNode(boolean b) {
        this.ignoreDanglingEdgeOfDelNode = b;
    }

    public boolean getIgnoreDanglingEdgeOfDelNode() {
        return this.ignoreDanglingEdgeOfDelNode;
    }

    public void dispose() {
        this.clear();
        this.gragra = null;
        this.cpOption = null;
        this.gragraStrategy = null;
        this.ruleSequence = null;
    }

    public void clear() {
        this.nonApplicableRules.clear();
        this.applicableConcurrentRules.clear();
        this.concurrentRules.clear();
    }

    public RuleSequence getRuleSequence() {
        return this.ruleSequence;
    }

    public boolean check() {
        this.mainResult = false;
        if (this.ruleSequence != null) {
            this.mainResult = this.ruleSequence.getGraph() == null ? this.checkWithoutGraph() : this.checkAtGraph();
            this.ruleSequence.checked = true;
        }
        return this.mainResult;
    }

    private boolean checkAtGraph() {
        Rule preRule;
        int preIndx;
        boolean applicabilityOfPreRuleTrue;
        System.out.println("\n*** ApplicabilityChecker.checkAtGraph    " + this.ruleSequence.getGraph().getName() + "   start at: " + this.ruleSequence.getStartIndexOfCheck() + "   " + this.ruleSequence.getStartRule().getName());
        this.clear();
        if (this.ruleSequence.checked) {
            this.ruleSequence.reinit();
        }
        if (this.ruleSequence.getStartIndexOfCheck() > 0 && !(applicabilityOfPreRuleTrue = this.ruleSequence.getRuleApplicabilityResult(preIndx = this.ruleSequence.getStartIndexOfCheck() - 1, (preRule = this.ruleSequence.getRule(preIndx)).getName()))) {
            this.setApplicabilityResult(false, "enabling-predecessor");
            this.setNonApplicabilityResult(true, "no-enabling-predecessor");
            return false;
        }
        boolean result1 = this.initializationRule(this.ruleSequence.getRules(), this.ruleSequence.getGraph());
        if (!result1) {
            return result1;
        }
        boolean result2 = this.noNodeDeletingRules(this.ruleSequence.getRules());
        if (!result2 && !this.ruleSequence.getIgnoreDanglingEdgeOfDelNode()) {
            return result2;
        }
        boolean result3 = this.noImpedingPredecessors(this.ruleSequence.getRules());
        boolean result4 = true;
        result4 = this.completeConcurrency ? this.enablingPredecessorApplicablePureConcurrent(this.ruleSequence.getStartIndexOfCheck(), this.ruleSequence.getRules(), this.ruleSequence.getGraph()) : this.enablingPredecessorPureConcurrentApplicable(this.ruleSequence.getStartIndexOfCheck(), this.ruleSequence.getRules(), this.ruleSequence.getGraph());
        return result1 && result2 && result3 && result4;
    }

    public boolean checkWithoutGraph() {
        Rule preRule;
        int preIndx;
        boolean applicabilityOfPreRuleTrue;
        this.clear();
        if (this.ruleSequence.checked) {
            this.ruleSequence.reinit();
        }
        if (this.ruleSequence.getStartIndexOfCheck() > 0 && !(applicabilityOfPreRuleTrue = this.ruleSequence.getRuleApplicabilityResult(preIndx = this.ruleSequence.getStartIndexOfCheck() - 1, (preRule = this.ruleSequence.getRule(preIndx)).getName()))) {
            this.setApplicabilityResult(false, "enabling-predecessor");
            this.setNonApplicabilityResult(true, "no-enabling-predecessor");
            return false;
        }
        boolean result1 = this.initializationRule(this.ruleSequence.getRules(), null);
        if (!result1) {
            return result1;
        }
        boolean result2 = this.noNodeDeletingRules(this.ruleSequence.getRules());
        if (!result2) {
            return result2;
        }
        boolean result3 = this.noImpedingPredecessors(this.ruleSequence.getRules());
        boolean result4 = true;
        result4 = this.completeConcurrency ? this.enablingPredecessorApplicablePureConcurrent(this.ruleSequence.getStartIndexOfCheck(), this.ruleSequence.getRules()) : this.enablingPredecessorPureConcurrentApplicable(this.ruleSequence.getStartIndexOfCheck(), this.ruleSequence.getRules());
        return result1 && result2 && result3 && result4;
    }

    public List<ConcurrentRule> getConcurrentRules() {
        return this.concurrentRules;
    }

    public List<ConcurrentRule> getApplicableConcurrentRules() {
        return this.applicableConcurrentRules;
    }

    private boolean initializationRule(List<Rule> sequence, Graph g) {
        boolean result = sequence.isEmpty();
        if (result) {
            this.setApplicabilityResult(true, "initialization");
        } else {
            Rule r = sequence.get(0);
            Pair<Boolean, List<String>> ruleRes = this.ruleSequence.getRuleResult(0, r.getName(), "initialization");
            result = ruleRes != null ? (Boolean)ruleRes.first : (g != null ? this.initializationCheck(0, r, g) : true);
            if (result) {
                System.out.println("=== >>>  ApplicabilityChecker.initialization:  rule: " + r.getName() + "   applicable");
                this.setApplicabilityResult(true, "initialization");
                this.setNonApplicabilityResult(false, "initialization-error");
                this.setRuleResult(0, r.getName(), true, "initialization", "");
                this.setRuleResult(0, r.getName(), false, "initialization-error", "");
            } else {
                this.setApplicabilityResult(false, "initialization");
                this.setNonApplicabilityResult(true, "initialization-error");
                this.setRuleResult(0, r.getName(), false, "initialization", "");
                this.setRuleResult(0, r.getName(), true, "initialization-error", "");
            }
        }
        return result;
    }

    private boolean isNonApplicableRule(Rule r, Graph g) {
        boolean result = true;
        Match m = BaseFactory.theFactory().createMatch(r, g);
        if (m != null) {
            this.setMatchCompletionStrategy(m, this.gragraStrategy, true);
            m.enableInputParameter(false);
            while (m.nextCompletion()) {
                m.clearErrorMsg();
                if (!m.isValid()) continue;
                result = false;
                break;
            }
            m.dispose();
        }
        return result;
    }

    private Hashtable<GraphObject, GraphObject> makeMatchMapByObjectFlow(int indx, Rule r, Graph g) {
        boolean result;
        int sizeOfObjectFlow = this.ruleSequence.getSizeOfObjFlowForRule(r, indx);
        if (sizeOfObjectFlow == 0) {
            return null;
        }
        List<ObjectFlow> objFlowList = this.ruleSequence.getObjFlowForRule(r, indx);
        Hashtable<GraphObject, GraphObject> matchmap = this.ruleSequence.getMatchSequence().makeMatchMapByObjectFlow(r, objFlowList);
        boolean bl = result = matchmap.size() == sizeOfObjectFlow;
        if (!result) {
            Rule ri = r;
            int i = indx;
            Hashtable<GraphObject, GraphObject> inputToPostInput = new Hashtable<GraphObject, GraphObject>();
            while (ri != null) {
                matchmap.putAll(this.ruleSequence.getInput2outputMapIntoGraphAbovePreRule(r, indx, objFlowList, ri, i, inputToPostInput, g));
                boolean bl2 = result = matchmap.size() == sizeOfObjectFlow;
                if (result) break;
                ri = this.ruleSequence.getRule(--i);
            }
        }
        return matchmap;
    }

    private boolean initializationCheck(int indx, Rule r, Graph g) {
        if (g == null) {
            return true;
        }
        boolean result = false;
        Match m = BaseFactory.theFactory().createMatch(r, g);
        if (m != null) {
            Hashtable<GraphObject, GraphObject> matchmap;
            this.setMatchCompletionStrategy(m, this.gragraStrategy, true);
            m.enableInputParameter(false);
            if (!r.getLeft().isEmpty() && this.ruleSequence.isObjFlowActive() && (matchmap = this.makeMatchMapByObjectFlow(indx, r, g)) != null && !matchmap.isEmpty()) {
                try {
                    m.addMapping(matchmap);
                    m.setPartialMorphismCompletion(true);
                }
                catch (BadMappingException ex) {
                    m.dispose();
                    return false;
                }
                if (m.isTotal()) {
                    m.clearErrorMsg();
                    if (m.isAttrConditionSatisfied() && m.areNACsSatisfied() && m.arePACsSatisfied() && m.isValid()) {
                        result = true;
                    }
                }
            }
            while (!result && m.nextCompletion()) {
                m.clearErrorMsg();
                if (!m.isValid()) continue;
                result = true;
                break;
            }
            if (result) {
                this.ruleSequence.getMatchSequence().addDirectMatch(r, m);
            }
            m.dispose();
        }
        return result;
    }

    private boolean isRuleApplicable(int indx, Rule r, Graph g, boolean checkIfRuleReadyToTransform) {
        if (checkIfRuleReadyToTransform && r.isReadyToTransform() || !checkIfRuleReadyToTransform) {
            return this.initializationCheck(indx, r, g);
        }
        return false;
    }

    private Hashtable<GraphObject, GraphObject> makeMatchMapByObjectFlow(ConcurrentRule cr, int indx, Graph g) {
        boolean result;
        int sizeOfObjectFlow = cr.getSizeOfReflectedInputObjectFlow();
        if (sizeOfObjectFlow == 0) {
            return null;
        }
        Hashtable<GraphObject, GraphObject> matchmap = cr.applyReflectedObjectFlowToMatchMap(g);
        boolean bl = result = matchmap.size() == sizeOfObjectFlow;
        if (!result) {
            List<ObjectFlow> objFlowList = this.ruleSequence.getObjFlowForRule(cr.getLastSecondSourceRule(), indx + cr.getDepth());
            Rule ri = cr.getLastSecondSourceRule();
            int i = indx + cr.getDepth();
            Hashtable<GraphObject, GraphObject> inputToPostInput = new Hashtable<GraphObject, GraphObject>();
            while (ri != null) {
                matchmap.putAll(this.ruleSequence.getReflectedObjectFlowOfGraphAndPreRule(cr, objFlowList, ri, i, inputToPostInput, g));
                boolean bl2 = result = matchmap.size() == sizeOfObjectFlow;
                if (result) break;
                ri = this.ruleSequence.getRule(--i);
            }
        }
        return matchmap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRuleApplicable(Rule r, ConcurrentRule cr, Graph g, boolean checkIfRuleReadyToTransform) {
        if (cr.getRule().isNotApplicable()) {
            return false;
        }
        boolean result = false;
        boolean crReady = cr.isReadyToTransform();
        if (checkIfRuleReadyToTransform && crReady || !checkIfRuleReadyToTransform) {
            Match m = cr.getRule().getMatch();
            if (m == null) {
                m = BaseFactory.theFactory().createMatch(cr.getRule(), g);
            }
            if (m != null) {
                boolean withOF;
                block26: {
                    this.setMatchCompletionStrategy(m, this.gragraStrategy, true);
                    m.enableInputParameter(false);
                    withOF = false;
                    if (cr.getRule().getLeft().isEmpty()) {
                        if (m.areNACsSatisfied() && m.arePACsSatisfied()) {
                            result = true;
                            break block26;
                        } else {
                            m.dispose();
                            return false;
                        }
                    }
                    if (this.ruleSequence.isObjFlowActive()) {
                        withOF = true;
                        if (cr.getSizeOfReflectedInputObjectFlow() > 0) {
                            Hashtable<GraphObject, GraphObject> matchmap = this.makeMatchMapByObjectFlow(cr, this.ruleSequence.getIndexOf(cr.getFirstSourceRule()), this.ruleSequence.getGraph());
                            if (matchmap == null) {
                                m.dispose();
                                return false;
                            }
                            try {
                                m.addMapping(matchmap);
                                m.setPartialMorphismCompletion(true);
                            }
                            catch (BadMappingException ex) {
                                m.dispose();
                                return false;
                            }
                        }
                        if (m.isTotal()) {
                            m.clearErrorMsg();
                            if (m.isAttrConditionSatisfied() && m.areNACsSatisfied() && m.arePACsSatisfied() && m.isValid()) {
                                result = true;
                                break block26;
                            } else {
                                m.dispose();
                                return false;
                            }
                        }
                        if (this.completeConcurRuleBackward) {
                            m.getCompletionStrategy().getProperties().clear(0);
                        }
                        m.getCompletionStrategy().initialize(m);
                        while (m.nextCompletion()) {
                            if (!m.isAttrConditionSatisfied() || !m.areNACsSatisfied() || !m.arePACsSatisfied() || !m.isValid()) continue;
                            result = true;
                            cr.setInjectiveMatchProperty(false);
                            this.ruleSequence.getMatchSequence().addConcurrentSourceMatch(r, cr, m);
                            System.out.println("=== >>>  ApplicabilityChecker.isRuleApplicable   concurrent rule:  " + cr.getRule().getName() + "  match found  ");
                        }
                        if (!result) {
                            m.dispose();
                            cr.getRule().setApplicable(false);
                            return false;
                        }
                    }
                }
                if (!result || !withOF) {
                    while (!result && m.nextCompletion()) {
                        if (!m.isAttrConditionSatisfied()) {
                            if (!this.usingAttrConditionAndInputParameter(m.getRule(), m)) {
                                m.dispose();
                                return false;
                            }
                            result = true;
                        }
                        if (!m.isValid()) continue;
                        result = true;
                        cr.setInjectiveMatchProperty(true);
                        this.ruleSequence.getMatchSequence().addConcurrentSourceMatch(r, cr, m);
                        System.out.println("=== >>>  ApplicabilityChecker.isRuleApplicable   concurrent rule:  " + cr.getRule().getName() + "   INJECTIVE match found  ");
                        break;
                    }
                    if (!result) {
                        m.getCompletionStrategy().getProperties().clear(0);
                        m.getCompletionStrategy().initialize(m);
                        while (m.nextCompletion()) {
                            if (!m.isAttrConditionSatisfied()) {
                                if (!this.usingAttrConditionAndInputParameter(m.getRule(), m)) {
                                    m.dispose();
                                    return false;
                                }
                                result = true;
                            }
                            if (!m.isValid()) continue;
                            result = true;
                            cr.setInjectiveMatchProperty(false);
                            this.ruleSequence.getMatchSequence().addConcurrentSourceMatch(r, cr, m);
                            System.out.println("=== >>>  ApplicabilityChecker.isRuleApplicable   concurrent rule:  " + cr.getRule().getName() + "   NON-INJECTIVE match found  ");
                            break;
                        }
                    }
                    m.dispose();
                }
            }
        }
        return result;
    }

    private void setMatchCompletionStrategy(Match m, MorphCompletionStrategy strat, boolean injective) {
        m.setCompletionStrategy(strat, true);
        if (injective) {
            m.getCompletionStrategy().getProperties().set(0);
        } else {
            m.getCompletionStrategy().getProperties().clear(0);
        }
    }

    private boolean noNodeDeletingRules(List<Rule> sequence) {
        boolean result = true;
        int i = 0;
        while (i < sequence.size()) {
            Rule r = sequence.get(i);
            Pair<Boolean, List<String>> ruleRes = this.ruleSequence.getRuleResult(i, r.getName(), "no-node-deleting-rules");
            if (ruleRes != null) {
                if (!((Boolean)ruleRes.first).booleanValue()) {
                    result = false;
                }
            } else if (r.mayCauseDanglingEdge()) {
                result = false;
                this.setRuleResult(i, r.getName(), false, "no-node-deleting-rules", "");
                System.out.println("=== >>> ApplicabilityChecker.noNodeDeletingRules::  FAILED!  rule: " + r.getName() + "  may cause dangling edge.");
            } else {
                this.setRuleResult(i, r.getName(), true, "no-node-deleting-rules", "");
            }
            ++i;
        }
        if (!result && !this.ruleSequence.getIgnoreDanglingEdgeOfDelNode()) {
            this.setApplicabilityResult(false, "no-node-deleting-rules");
        }
        return result;
    }

    private boolean noImpedingPredecessors(List<Rule> sequence) {
        boolean result = true;
        int i = 1;
        while (i < sequence.size()) {
            Rule ri = sequence.get(i);
            boolean localResult = true;
            Pair<Boolean, List<String>> ruleRes = this.ruleSequence.getRuleResult(i, ri.getName(), "no-impeding-predecessors");
            if (ruleRes != null) {
                localResult = (Boolean)ruleRes.first;
            } else {
                int j = 0;
                while (j < i) {
                    Rule rj = sequence.get(j);
                    SimpleExcludePair excludePair = this.makeExcludePair();
                    if (!this.asymParallelIndependentByCPA(excludePair, rj, j, ri, i)) {
                        localResult = false;
                        this.setRuleResult(i, ri.getName(), false, "no-impeding-predecessors", rj.getName());
                        break;
                    }
                    excludePair.dispose();
                    ++j;
                }
                if (localResult) {
                    this.setRuleResult(i, ri.getName(), true, "no-impeding-predecessors", "");
                }
            }
            if (!localResult) {
                result = false;
            }
            ++i;
        }
        if (!result) {
            this.setApplicabilityResult(false, "no-impeding-predecessors");
        }
        return result;
    }

    private DependencyPairContainer makeDependencyPairContainer() {
        PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.gragra, 1, false);
        ((DependencyPairContainer)pc).enableComplete(this.cpOption.completeEnabled());
        ((DependencyPairContainer)pc).enableNACs(this.cpOption.nacsEnabled());
        ((DependencyPairContainer)pc).enablePACs(this.cpOption.pacsEnabled());
        ((DependencyPairContainer)pc).enableReduce(this.cpOption.reduceEnabled());
        ((DependencyPairContainer)pc).enableConsistent(this.cpOption.consistentEnabled());
        ((DependencyPairContainer)pc).enableStrongAttrCheck(this.cpOption.strongAttrCheckEnabled());
        ((DependencyPairContainer)pc).enableEqualVariableNameOfAttrMapping(this.cpOption.equalVariableNameOfAttrMappingEnabled());
        ((DependencyPairContainer)pc).enableIgnoreIdenticalRules(this.cpOption.ignoreIdenticalRulesEnabled());
        ((DependencyPairContainer)pc).enableReduceSameMatch(this.cpOption.reduceSameMatchEnabled());
        ((DependencyPairContainer)pc).enableDirectlyStrictConfluent(this.cpOption.directlyStrictConflEnabled());
        ((DependencyPairContainer)pc).enableDirectlyStrictConfluentUpToIso(this.cpOption.directlyStrictConflUpToIsoEnabled());
        ((DependencyPairContainer)pc).enableNamedObjectOnly(this.cpOption.namedObjectEnabled());
        ((DependencyPairContainer)pc).enableMaxBoundOfCriticKind(this.cpOption.getMaxBoundOfCriticKind());
        return (DependencyPairContainer)pc;
    }

    private SimpleExcludePair makeExcludePair() {
        SimpleExcludePair pc = new SimpleExcludePair();
        pc.enableNACs(this.cpOption.nacsEnabled());
        pc.enablePACs(this.cpOption.pacsEnabled());
        pc.enableReduce(this.cpOption.reduceEnabled());
        pc.enableConsistent(this.cpOption.consistentEnabled(), this.gragra);
        pc.enableStrongAttrCheck(true);
        pc.enableEqualVariableNameOfAttrMapping(this.cpOption.equalVariableNameOfAttrMappingEnabled());
        pc.enableIgnoreIdenticalRules(this.cpOption.ignoreIdenticalRulesEnabled());
        pc.enableReduceSameMatch(this.cpOption.reduceSameMatchEnabled());
        pc.enableDirectlyStrictConfluent(false);
        pc.enableDirectlyStrictConfluentUpToIso(false);
        pc.enableNamedObjectOnly(this.cpOption.namedObjectEnabled());
        pc.setMaxBoundOfCriticKind(this.cpOption.getMaxBoundOfCriticKind());
        return pc;
    }

    private boolean asymParallelIndependentByCPA(ExcludePair excludePair, Rule r1, int indx_r1, Rule r2, int indx_r2) {
        boolean result = false;
        try {
            if (!this.gragra.isLayered() || r1.getLayer() == r2.getLayer()) {
                Object conflicts = excludePair.isCritical(0, r1, r2);
                if (conflicts != null && !((Vector)conflicts).isEmpty()) {
                    result = false;
                    if (indx_r1 >= 0 && indx_r1 >= 0) {
                        int i = 0;
                        while (i < ((Vector)conflicts).size()) {
                            ObjectFlow objFlow;
                            Pair pair = (Pair)((Pair)((Vector)conflicts).get((int)i)).first;
                            if (this.ruleSequence.isObjFlowActive() && (objFlow = this.ruleSequence.getObjFlowForRules(r1, indx_r1, r2, indx_r2)) != null && !objFlow.isEmpty()) {
                                boolean inside = false;
                                List<Object> inputs = objFlow.getInputs();
                                Enumeration<GraphObject> objs = ((OrdinaryMorphism)pair.second).getDomain();
                                while (objs.hasMoreElements() && !inside) {
                                    GraphObject obj = objs.nextElement();
                                    if (!((OrdinaryMorphism)pair.first).getInverseImage(((OrdinaryMorphism)pair.second).getImage(obj)).hasMoreElements() || !inputs.contains(obj)) continue;
                                    inside = true;
                                }
                                if (!inside) {
                                    ((Vector)conflicts).remove(i);
                                    --i;
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private boolean pureEnablingPredecessor(Rule ri, int i, List<Rule> sequence, Graph g) {
        boolean result = false;
        int j = 0;
        while (j < i) {
            Rule rj = sequence.get(j);
            if ((g != null && !this.checkForbiddenObjects(ri.getNACs(), rj, g) || g == null && !this.checkForbiddenObjects(ri.getNACs(), rj)) && this.purelySequentialDependent(rj, j, ri, i, g)) {
                result = true;
                System.out.println("=== >>>  ApplicabilityChecker.pureEnablingPredecessor  of  rule: " + ri.getName() + "  is  rule: " + rj.getName());
                this.setRuleResult(i, ri.getName(), false, "no-enabling-predecessor", "pure");
                break;
            }
            ++j;
        }
        return result;
    }

    private boolean pureEnablingPredecessor(Rule ri, int i, List<Rule> sequence) {
        boolean result = false;
        int j = 0;
        while (j < i) {
            Rule rj = sequence.get(j);
            if (!this.checkForbiddenObjects(ri.getNACs(), rj) && this.purelySequentialDependent(rj, j, ri, i, null)) {
                result = true;
                System.out.println("=== >>>  ApplicabilityChecker.pureEnablingPredecessor  of  rule: " + ri.getName() + "  is  rule: " + rj.getName());
                this.setRuleResult(i, ri.getName(), true, "pure-enabling-predecessor", rj.getName());
                this.setRuleResult(i, ri.getName(), false, "no-enabling-predecessor", "pure");
                break;
            }
            ++j;
        }
        return result;
    }

    private boolean enablingPredecessorApplicablePureConcurrent(int startIndx, List<Rule> sequence, Graph graph) {
        int start;
        System.out.println("=== >>>  ApplicabilityChecker.enablingPredecessorApplicablePureConcurrent");
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        String criterion = "";
        boolean result = true;
        boolean noEnablingPredecessor = false;
        int i = start = startIndx > 1 ? startIndx : 1;
        while (i < sequence.size()) {
            Rule ri = sequence.get(i);
            Rule ri_1 = sequence.get(i - 1);
            criterion = "predecessor-not-needed";
            result = this.isPredecessorNotNeeded(ri, i, graph);
            if (!result) {
                this.nonApplicableRules.add(ri);
                this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                noEnablingPredecessor = this.noEnablingPredecessor(sequence, i, ri, dependencyContainer);
                if (!noEnablingPredecessor) {
                    criterion = "pure-enabling-predecessor";
                    result = this.pureEnablingPredecessor(ri, i, sequence, graph);
                    if (!result) {
                        this.setRuleResult(i, ri.getName(), false, "pure-enabling-predecessor", "");
                        criterion = "partial-enabling-predecessor";
                        result = this.partialEnablingPredecessor(ri, i, sequence, graph);
                        if (!result) {
                            this.setRuleResult(i, ri.getName(), false, "partial-enabling-predecessor", "");
                            criterion = "direct-enabling-predecessor";
                            result = this.directEnablingPredecessor(i, ri, sequence, graph);
                            if (!result) {
                                this.setRuleResult(i, ri.getName(), false, "direct-enabling-predecessor", "");
                            }
                        }
                    }
                }
            }
            this.setApplicabilityResult(result, "enabling-predecessor");
            this.setNonApplicabilityResult(noEnablingPredecessor, "no-enabling-predecessor");
            ++i;
        }
        dependencyContainer.clear();
        dependencyContainer.refreshOptions(this.cpOption);
        return result;
    }

    private boolean enablingPredecessorApplicablePureConcurrent(int startIndx, List<Rule> sequence) {
        int start;
        System.out.println("=== >>>  ApplicabilityChecker.enablingPredecessorApplicablePureConcurrent");
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        String criterion = "";
        boolean result = true;
        boolean noEnablingPredecessor = false;
        int i = start = startIndx > 1 ? startIndx : 1;
        while (i < sequence.size()) {
            Rule ri = sequence.get(i);
            Rule ri_1 = sequence.get(i - 1);
            criterion = "predecessor-not-needed";
            result = this.isPredecessorNotNeeded(ri, i, null);
            if (!result) {
                this.nonApplicableRules.add(ri);
                this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                noEnablingPredecessor = this.noEnablingPredecessor(sequence, i, ri, dependencyContainer);
                if (!noEnablingPredecessor) {
                    criterion = "pure-enabling-predecessor";
                    result = this.pureEnablingPredecessor(ri, i, sequence);
                    if (!result) {
                        this.setRuleResult(i, ri.getName(), false, "pure-enabling-predecessor", "");
                        criterion = "partial-enabling-predecessor";
                        result = this.partialEnablingPredecessor(ri, i, sequence, null);
                        if (!result) {
                            this.setRuleResult(i, ri.getName(), false, "partial-enabling-predecessor", "");
                            criterion = "direct-enabling-predecessor";
                            result = this.directEnablingPredecessor(i, ri, sequence, null);
                            if (!result) {
                                this.setRuleResult(i, ri.getName(), false, "direct-enabling-predecessor", "");
                            }
                        }
                    }
                }
            }
            this.setApplicabilityResult(result, "enabling-predecessor");
            this.setNonApplicabilityResult(noEnablingPredecessor, "no-enabling-predecessor");
            ++i;
        }
        dependencyContainer.clear();
        dependencyContainer.refreshOptions(this.cpOption);
        return result;
    }

    private boolean isRuleWithEmptyLHSApplicableAtGraph(Rule r, int indx, Graph g) {
        boolean result = false;
        if (r.getLeft().isEmpty()) {
            if (this.isRuleApplicable(indx, r, g, true)) {
                result = true;
                System.out.println("=== >>>   ApplicabilityChecker.isRuleWithEmptyLHSApplicableAtGraph: rule: " + r.getName() + "  applicable");
                this.setRuleResult(indx, r.getName(), true, "predecessor-not-needed", "(applicable)");
                this.setRuleResult(indx, r.getName(), false, "no-enabling-predecessor", "(applicable)");
            } else {
                result = false;
                this.nonApplicableRules.add(r);
                this.setRuleResult(indx, r.getName(), false, "predecessor-not-needed", "");
            }
        }
        return result;
    }

    private boolean isPredecessorNotNeeded(Rule r, int indx, Graph g) {
        boolean result = false;
        result = this.isRuleApplicable(indx, r, g, true);
        if (result) {
            this.setRuleResult(indx, r.getName(), true, "predecessor-not-needed", "(applicable)");
            this.setRuleResult(indx, r.getName(), false, "no-enabling-predecessor", "(applicable)");
        }
        return result;
    }

    private boolean enablingPredecessorPureConcurrentApplicable(int startIndx, List<Rule> sequence, Graph graph) {
        int start;
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        boolean result = true;
        String criterion = "";
        boolean noEnablingPredecessor = false;
        int i = start = startIndx > 1 ? startIndx : 1;
        while (i < sequence.size()) {
            Rule ri = sequence.get(i);
            Rule ri_1 = sequence.get(i - 1);
            System.out.println("=== >>>ApplicabilityChecker.enablingPredecessorPureConcurrentApplicable:  check rule: " + ri.getName());
            criterion = "predecessor-not-needed";
            result = this.isRuleWithEmptyLHSApplicableAtGraph(ri, i, graph);
            if (!result) {
                if (this.isNonApplicableRule(ri, graph)) {
                    noEnablingPredecessor = this.noEnablingPredecessor(sequence, i, ri, dependencyContainer);
                }
                if (!noEnablingPredecessor) {
                    criterion = "pure-enabling-predecessor";
                    result = this.pureEnablingPredecessor(ri, i, sequence, graph);
                    if (!result) {
                        this.setRuleResult(i, ri.getName(), false, "pure-enabling-predecessor", "");
                        criterion = "partial-enabling-predecessor";
                        result = this.partialEnablingPredecessor(ri, i, sequence, graph);
                        if (!result) {
                            this.setRuleResult(i, ri.getName(), false, "partial-enabling-predecessor", "");
                            criterion = "direct-enabling-predecessor";
                            result = this.directEnablingPredecessor(i, ri, sequence, graph);
                            if (!result) {
                                this.setRuleResult(i, ri.getName(), false, "direct-enabling-predecessor", "");
                                criterion = "predecessor-not-needed";
                                result = this.isPredecessorNotNeeded(ri, i, graph);
                                if (!result) {
                                    this.nonApplicableRules.add(ri);
                                    this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                                    noEnablingPredecessor = true;
                                    this.setRuleResult(i, ri.getName(), true, "no-enabling-predecessor", "");
                                }
                            }
                        }
                    } else {
                        Pair<Boolean, List<String>> resPair = this.ruleSequence.getRuleResult(i, ri.getName(), "pure-enabling-predecessor");
                        if (resPair != null && !((Boolean)resPair.first).booleanValue()) {
                            result = false;
                            this.setRuleResult(i, ri.getName(), true, "pure-enabling-predecessor", ri_1.getName());
                        }
                    }
                } else {
                    criterion = "predecessor-not-needed";
                    result = this.isPredecessorNotNeeded(ri, i, graph);
                    if (!result) {
                        this.nonApplicableRules.add(ri);
                        this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                        noEnablingPredecessor = true;
                        this.setRuleResult(i, ri.getName(), true, "no-enabling-predecessor", "");
                    }
                }
            }
            this.setApplicabilityResult(result, "enabling-predecessor");
            this.setNonApplicabilityResult(noEnablingPredecessor, "no-enabling-predecessor");
            if (noEnablingPredecessor && ((Boolean)this.ruleSequence.getNonApplicabilityResult().first).booleanValue()) break;
            ++i;
        }
        dependencyContainer.clear();
        dependencyContainer.refreshOptions(this.cpOption);
        return result;
    }

    private boolean enablingPredecessorPureConcurrentApplicable(int startIndx, List<Rule> sequence) {
        int start;
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        boolean result = true;
        String criterion = "";
        boolean noEnablingPredecessor = false;
        int i = start = startIndx > 1 ? startIndx : 1;
        while (i < sequence.size()) {
            Rule ri = sequence.get(i);
            Rule ri_1 = sequence.get(i - 1);
            System.out.println("=== >>>ApplicabilityChecker.enablingPredecessorPureConcurrentApplicable:  check rule: " + ri.getName());
            criterion = "predecessor-not-needed";
            result = this.isRuleWithEmptyLHSApplicableAtGraph(ri, i, null);
            if (!result) {
                noEnablingPredecessor = this.noEnablingPredecessor(sequence, i, ri, dependencyContainer);
                if (!noEnablingPredecessor) {
                    criterion = "pure-enabling-predecessor";
                    result = this.pureEnablingPredecessor(ri, i, sequence, null);
                    if (!result) {
                        this.setRuleResult(i, ri.getName(), false, "pure-enabling-predecessor", "");
                        criterion = "partial-enabling-predecessor";
                        result = this.partialEnablingPredecessor(ri, i, sequence, null);
                        if (!result) {
                            this.setRuleResult(i, ri.getName(), false, "partial-enabling-predecessor", "");
                            criterion = "direct-enabling-predecessor";
                            result = this.directEnablingPredecessor(i, ri, sequence, null);
                            if (!result) {
                                this.setRuleResult(i, ri.getName(), false, "direct-enabling-predecessor", "");
                                criterion = "predecessor-not-needed";
                                result = this.isPredecessorNotNeeded(ri, i, null);
                                if (!result) {
                                    this.nonApplicableRules.add(ri);
                                    this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                                    noEnablingPredecessor = true;
                                    this.setRuleResult(i, ri.getName(), true, "no-enabling-predecessor", "");
                                }
                            }
                        }
                    }
                } else {
                    criterion = "predecessor-not-needed";
                    result = this.isPredecessorNotNeeded(ri, i, null);
                    if (!result) {
                        this.nonApplicableRules.add(ri);
                        this.setRuleResult(i, ri.getName(), false, "predecessor-not-needed", "");
                        noEnablingPredecessor = true;
                        this.setRuleResult(i, ri.getName(), true, "no-enabling-predecessor", "");
                    }
                }
            }
            this.setApplicabilityResult(result, "enabling-predecessor");
            this.setNonApplicabilityResult(noEnablingPredecessor, "no-enabling-predecessor");
            if (noEnablingPredecessor && ((Boolean)this.ruleSequence.getNonApplicabilityResult().first).booleanValue()) break;
            ++i;
        }
        dependencyContainer.clear();
        dependencyContainer.refreshOptions(this.cpOption);
        return result;
    }

    public List<ConcurrentRule> buildPlainConcurrentRule(List<Rule> seq, Graph g) {
        if (seq.size() <= 1 || BaseFactory.theFactory().checkApplCondsOfRules(seq) != null) {
            return null;
        }
        Vector<ConcurrentRule> crs = new Vector<ConcurrentRule>(1);
        int i = 1;
        while (i < seq.size()) {
            Rule ri = seq.get(i);
            int preI = i - 1;
            Rule preR = seq.get(preI);
            List<List<ConcurrentRule>> concurRuleListsOfRule = this.getListsOfConcurrentRulesOfRule(ri, i);
            if (concurRuleListsOfRule == null) {
                concurRuleListsOfRule = new Vector<List<ConcurrentRule>>();
                this.ruleSequence.putListsOfConcurrentRules(ri, i, concurRuleListsOfRule);
            }
            List<ConcurrentRule> list = null;
            if (i == 1) {
                list = this.makeConcurrentRulesDuetoDependency(preR, preI, ri, i, null);
                concurRuleListsOfRule.add(list);
            } else if (this.getListsOfConcurrentRulesOfRule(preR, preI) != null) {
                List<ConcurrentRule> listOfPreRule = this.getListsOfConcurrentRulesOfRule(preR, preI).get(0);
                list = new Vector<ConcurrentRule>();
                int c = 0;
                while (c < listOfPreRule.size()) {
                    ConcurrentRule cr = listOfPreRule.get(c);
                    list.addAll(this.makeConcurrentRulesDuetoDependency(cr, ri, null));
                    ++c;
                }
                concurRuleListsOfRule.add(list);
            }
            if (list != null && !list.isEmpty()) {
                crs.clear();
                crs.addAll(list);
                System.out.println("=== >>> ApplicabilityChecker.buildPlainConcurrentRule:: " + list.get(0).getRule().getName());
            }
            ++i;
        }
        return crs;
    }

    private Rule getFirstEnablingPredecessor(List<Rule> sequence, int i, Rule ri, DependencyPairContainer dependencyContainer) {
        dependencyContainer.enableProduceConcurrentRule(false);
        dependencyContainer.enableComplete(false);
        Rule r = null;
        int j = 0;
        while (j < i) {
            Rule rj = sequence.get(j);
            try {
                if (dependencyContainer.getCriticalPair(rj, ri, 0, true) != null) {
                    r = rj;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        dependencyContainer.enableComplete(true);
        return r;
    }

    private boolean noEnablingPredecessor(List<Rule> sequence, int i, Rule ri, DependencyPairContainer dependencyContainer) {
        boolean result = false;
        this.info = "";
        Rule enablingRule = this.getFirstEnablingPredecessor(sequence, i, ri, dependencyContainer);
        if (enablingRule != null) {
            this.setRuleResult(i, ri.getName(), false, "no-enabling-predecessor", this.info);
        } else {
            result = true;
            this.setNonApplicabilityResult(true, "no-enabling-predecessor");
            this.setRuleResult(i, ri.getName(), true, "no-enabling-predecessor", "");
        }
        return result;
    }

    private boolean purelySequentialDependent(Rule r1, int indx_r1, Rule r2, int indx_r2, Graph g) {
        Match embedding = BaseFactory.theFactory().createMatch(r2, r1.getRight());
        embedding.setCompletionStrategy(this.strategy, true);
        boolean result = false;
        while (embedding.nextCompletionWithConstantsChecking() && !result) {
            Enumeration<GraphObject> codom = embedding.getCodomain();
            while (codom.hasMoreElements()) {
                ObjectFlow objFlow;
                GraphObject obj = codom.nextElement();
                if (r1.getInverseImage(obj).hasMoreElements()) continue;
                result = true;
                if (this.ruleSequence.isObjFlowActive() && (objFlow = this.ruleSequence.getObjFlowForRules(r1, indx_r1, r2, indx_r2)) != null && !objFlow.isEmpty()) {
                    result = this.pureEnablingAlongObjectFlow(embedding, objFlow);
                }
                if (!result) break;
                this.ruleSequence.getMatchSequence().addTotalPureEnablingSourceMatch(r2, r1, embedding, indx_r2, indx_r1);
                break;
            }
            if (!result) continue;
            boolean attrCondUsesIP = this.attrConditionUsesInputParameterRight(r2, r1, embedding);
            if (attrCondUsesIP) {
                this.setRuleResult(indx_r2, r2.getName(), false, "pure-enabling-predecessor", r1.getName());
                continue;
            }
            this.setRuleResult(indx_r2, r2.getName(), true, "pure-enabling-predecessor", r1.getName());
        }
        embedding.dispose();
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(r1);
        return result;
    }

    private boolean attrConditionUsesInputParameterRight(Rule ruleAC, Rule preRuleIP, Match ruleLHS2preRuleRHS) {
        if (ruleAC.getAttrContext().getConditions().getNumberOfEntries() > 0 && ((VarTuple)preRuleIP.getAttrContext().getVariables()).hasInputParameter()) {
            OrdinaryMorphism morph;
            Vector<String> inputParams = preRuleIP.getInputParameterNames();
            List<GraphObject> goIP = preRuleIP.getInputParameterObjectsRight(inputParams);
            Vector<String> varsAC = ((CondTuple)ruleAC.getAttrContext().getConditions()).getAllVariables();
            Vector<GraphObject> goAC = new Vector<GraphObject>();
            this.addObjsWithVarOfCond(ruleAC.getLeft(), varsAC, null, goAC);
            Enumeration<OrdinaryMorphism> morphs = ruleAC.getPACs();
            while (morphs.hasMoreElements()) {
                morph = morphs.nextElement();
                this.addObjsWithVarOfCond(morph.getTarget(), varsAC, morph, goAC);
            }
            morphs = ruleAC.getNACs();
            while (morphs.hasMoreElements()) {
                morph = morphs.nextElement();
                this.addObjsWithVarOfCond(morph.getTarget(), varsAC, morph, goAC);
            }
            Enumeration<GraphObject> dom = ruleLHS2preRuleRHS.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go_ac = dom.nextElement();
                GraphObject go_ip = ruleLHS2preRuleRHS.getImage(go_ac);
                if (!goAC.contains(go_ac) || !goIP.contains(go_ip)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean usingAttrConditionAndInputParameter(Rule rule, Match m) {
        return rule.getAttrContext().getConditions().getNumberOfEntries() > 0 && ((VarTuple)rule.getAttrContext().getVariables()).hasInputParameter();
    }

    private void addObjsWithVarOfCond(Graph g, List<String> vars, OrdinaryMorphism morph, List<GraphObject> list) {
        this.addGOsWithVarOfCond(g.getNodesSet().iterator(), vars, morph, list);
        this.addGOsWithVarOfCond(g.getArcsSet().iterator(), vars, morph, list);
    }

    private void addGOsWithVarOfCond(Iterator<?> iter, List<String> vars, OrdinaryMorphism morph, List<GraphObject> list) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getEntryAt(i);
                if (mem.isSet() && mem.getExpr().isVariable() && vars.contains(mem.getExprAsText())) {
                    GraphObject go1;
                    if (morph == null) {
                        if (!list.contains(go)) {
                            list.add(go);
                        }
                    } else if (morph.getInverseImage(go).hasMoreElements() && !list.contains(go1 = morph.getInverseImage(go).nextElement())) {
                        list.add(go1);
                    }
                }
                ++i;
            }
        }
    }

    private boolean pureEnablingAlongObjectFlow(OrdinaryMorphism morph, ObjectFlow objFlow) {
        Enumeration<Object> outs = objFlow.getMapping().keys();
        while (outs.hasMoreElements()) {
            Object out = outs.nextElement();
            Object in = objFlow.getMapping().get(out);
            GraphObject img = morph.getImage((GraphObject)in);
            if (img == null || img == out) continue;
            return false;
        }
        return true;
    }

    private boolean checkForbiddenObjects(Enumeration<OrdinaryMorphism> nacs, Rule r, Graph g) {
        List<GraphObject> toCreate = r.getElementsToCreate();
        boolean found = false;
        while (nacs.hasMoreElements() && !found) {
            OrdinaryMorphism nac = nacs.nextElement();
            boolean bl = found = this.checkForbiddenObjs(nac, g, nac.getTarget().getNodesSet().iterator(), toCreate) || this.checkForbiddenObjs(nac, g, nac.getTarget().getArcsSet().iterator(), toCreate);
        }
        return found;
    }

    private boolean checkForbiddenObjs(OrdinaryMorphism nac, Graph g, Iterator<?> iter, List<GraphObject> toCreate) {
        boolean found = false;
        while (iter.hasNext()) {
            String key;
            GraphObject elem = (GraphObject)iter.next();
            if (nac.getInverseImage(elem).hasMoreElements()) continue;
            Type t = elem.getType();
            int i = 0;
            while (i < toCreate.size()) {
                GraphObject newgo = toCreate.get(i);
                if (elem.isNode()) {
                    if (t.isParentOf(newgo.getType())) {
                        found = true;
                        break;
                    }
                } else if (t == newgo.getType() && ((Arc)elem).getSource().getType().isParentOf(((Arc)newgo).getSource().getType()) && ((Arc)elem).getTarget().getType().isParentOf(((Arc)newgo).getTarget().getType())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            Hashtable<String, HashSet<GraphObject>> type2objects = g.getTypeObjectsMap();
            if (elem.isNode()) {
                key = elem.convertToKey();
                if (type2objects.get(key) == null || type2objects.get(key).isEmpty()) continue;
                found = true;
                continue;
            }
            key = ((Arc)elem).convertToKey();
            if (type2objects.get(key) == null || type2objects.get(key).isEmpty()) continue;
            found = true;
        }
        return found;
    }

    private boolean checkForbiddenObjects(Enumeration<OrdinaryMorphism> nacs, Rule r) {
        List<GraphObject> toCreate = r.getElementsToCreate();
        boolean found = false;
        while (nacs.hasMoreElements() && !found) {
            OrdinaryMorphism nac = nacs.nextElement();
            boolean bl = found = this.doCheckForbiddenObjs(nac, toCreate, nac.getTarget().getNodesSet().iterator()) || this.doCheckForbiddenObjs(nac, toCreate, nac.getTarget().getArcsSet().iterator());
        }
        return found;
    }

    private boolean doCheckForbiddenObjs(OrdinaryMorphism nac, List<GraphObject> toCreate, Iterator<?> elems) {
        boolean noObj = !toCreate.isEmpty();
        block0: while (elems.hasNext()) {
            GraphObject elem = (GraphObject)elems.next();
            if (nac.getInverseImage(elem).hasMoreElements()) continue;
            Type t = elem.getType();
            int i = 0;
            while (i < toCreate.size()) {
                if (t.isParentOf(toCreate.get(i).getType())) {
                    noObj = false;
                    continue block0;
                }
                ++i;
            }
        }
        return !noObj;
    }

    private boolean directEnablingPredecessor(int i, Rule ri, List<Rule> sequence, Graph g) {
        boolean result = false;
        Rule ri_1 = sequence.get(i - 1);
        if (ri_1 != null) {
            this.info = ri_1.getName();
            List<List<ConcurrentRule>> concurRuleLists = this.ruleSequence.getListsOfConcurrentRules(ri, i);
            if (concurRuleLists == null) {
                concurRuleLists = new Vector<List<ConcurrentRule>>();
                this.ruleSequence.putListsOfConcurrentRules(ri, i, concurRuleLists);
            }
            this.completeConcurRuleBackward = this.ruleSequence.isObjFlowActive();
            result = this.completeConcurRuleBackward ? this.buildConcurrentRulesBackward(ri_1, i - 1, ri, i, g) : this.buildConcurrentRulesForward(ri_1, i - 1, ri, i, g);
        }
        if (result) {
            System.out.println("=== >>>  ApplicabilityChecker.directEnablingPredecessor:  of  rule: " + ri.getName() + "  is  rule: " + this.info);
            this.setRuleResult(i, ri.getName(), true, "direct-enabling-predecessor", this.info);
            this.setRuleResult(i, ri.getName(), false, "no-enabling-predecessor", "(direct)");
        }
        return result;
    }

    private boolean partialEnablingPredecessor(Rule ri, int i, List<Rule> sequence, Graph g) {
        boolean result = false;
        int j = i - 1;
        while (j >= 0) {
            Rule rj = sequence.get(j);
            this.info = rj.getName();
            Pair<Boolean, List<String>> pair = this.ruleSequence.getRuleResult(j, rj.getName(), "predecessor-not-needed");
            if (pair == null) {
                pair = this.ruleSequence.getRuleResult(j, rj.getName(), "initialization");
            }
            if (pair != null && ((Boolean)pair.first).booleanValue()) {
                List<ConcurrentRule> list;
                List<List<ConcurrentRule>> concurRuleLists = this.ruleSequence.getListsOfConcurrentRules(ri, i);
                if (concurRuleLists == null) {
                    concurRuleLists = new Vector<List<ConcurrentRule>>();
                    this.ruleSequence.putListsOfConcurrentRules(ri, i, concurRuleLists);
                }
                if ((list = this.makeJointlyConcurrentRule(rj, j, ri, i)) != null && !list.isEmpty()) {
                    concurRuleLists.add(list);
                    int d = 1;
                    Hashtable<GraphObject, GraphObject> rjMatch = this.ruleSequence.getMatchSequence().getDirectMatch(j, rj);
                    if (rjMatch != null) {
                        ConcurrentRule cr;
                        int c = 0;
                        while (c < list.size()) {
                            cr = list.get(c);
                            if (!rjMatch.isEmpty() && !cr.forwardMatchMappingOfFirstSourceRule(rjMatch, this.ruleSequence.getGraph())) {
                                list.remove(c);
                                --c;
                            }
                            ++c;
                        }
                        int k = 0;
                        while (k < list.size()) {
                            cr = list.get(k);
                            if (this.isConcurrentRuleApplicable(i, ri, this.ruleSequence.getRules(), g, cr, d, "partial-enabling-predecessor")) {
                                result = true;
                                System.out.println("=== >>>  ApplicabilityChecker.partialEnablingPredecessor:  of  rule: " + ri.getName() + "  is  rule: " + rj.getName());
                                break;
                            }
                            ++k;
                        }
                        if (result) break;
                    }
                }
            }
            --j;
        }
        if (result) {
            this.setRuleResult(i, ri.getName(), true, "partial-enabling-predecessor", this.info);
            this.setRuleResult(i, ri.getName(), false, "no-enabling-predecessor", "(partial)");
        }
        return result;
    }

    private boolean isConcurrentRuleApplicable(int i, Rule ri, List<Rule> sequence, Graph g, ConcurrentRule cr, int concurdepth, String criterion) {
        boolean result = false;
        if (g == null || this.isRuleApplicable(ri, cr, g, false)) {
            this.applicableConcurrentRules.add(cr);
            result = true;
            System.out.println("=== >>> Concurrent rule:  " + cr.getRule().getName() + "    applicable");
            if (this.completeCPA) {
                this.concurrentRuleAsymParallelIndependentByCPA(i, ri, cr, sequence, concurdepth, criterion);
            } else {
                this.concurrentRuleAsymParallelIndependent(i, ri, cr, sequence, concurdepth, criterion);
            }
        }
        return result;
    }

    private boolean concurrentRuleAsymParallelIndependent(int i, Rule ri, ConcurrentRule cr, List<Rule> sequence, int concurdepth, String criterion) {
        int start;
        boolean result = true;
        int concurrrentRuleDepth = cr.getDepth();
        Vector<Rule> remainList = new Vector<Rule>();
        int l = i + 1;
        while (l < sequence.size()) {
            remainList.add(sequence.get(l));
            ++l;
        }
        Vector<Rule> crSourceList = new Vector<Rule>();
        int l2 = start = i - concurrrentRuleDepth;
        while (l2 <= i) {
            crSourceList.add(sequence.get(l2));
            ++l2;
        }
        l2 = 0;
        while (l2 < crSourceList.size()) {
            int indx = start + l2;
            Rule r = (Rule)crSourceList.get(l2);
            Pair<Boolean, List<String>> ruleRes = this.ruleSequence.getRuleResult(indx, r.getName(), "no-impeding-predecessors");
            if (ruleRes != null && !((Boolean)ruleRes.first).booleanValue()) {
                result = false;
                break;
            }
            ++l2;
        }
        if (result) {
            l2 = 0;
            while (l2 < crSourceList.size()) {
                Rule r1 = (Rule)crSourceList.get(l2);
                int k = 0;
                while (k < remainList.size()) {
                    Rule r2 = (Rule)remainList.get(k);
                    SimpleExcludePair excludePair = this.makeExcludePair();
                    if (!this.asymParallelIndependentByCPA(excludePair, r1, -1, r2, -1)) {
                        result = false;
                        break;
                    }
                    excludePair.dispose();
                    ++k;
                }
                if (!result) break;
                ++l2;
            }
        }
        this.info = this.getConcurrentRuleNameInfo(cr.getRule(), ri);
        this.setRuleResult(i, ri.getName(), result, criterion, this.info);
        remainList.clear();
        crSourceList.clear();
        return result;
    }

    private boolean concurrentRuleAsymParallelIndependentByCPA(int i, Rule ri, ConcurrentRule cr, List<Rule> sequence, int concurdepth, String criterion) {
        SimpleExcludePair excludePair;
        Rule rj;
        boolean result = true;
        Vector<Rule> tmp = new Vector<Rule>();
        tmp.addAll(sequence);
        int n = 0;
        while (concurdepth - n >= 0) {
            tmp.remove(i - n);
            ++n;
        }
        if (i - n < 0) {
            tmp.add(0, cr.getRule());
        } else {
            tmp.add(i - n, cr.getRule());
        }
        int c = tmp.indexOf(cr.getRule());
        int j = 0;
        while (j < c) {
            rj = (Rule)tmp.get(j);
            excludePair = this.makeExcludePair();
            if (!this.asymParallelIndependentByCPA(excludePair, rj, -1, cr.getRule(), -1)) {
                result = false;
                break;
            }
            excludePair.dispose();
            ++j;
        }
        if (result) {
            int l = c + 1;
            while (l < tmp.size()) {
                rj = (Rule)tmp.get(l);
                excludePair = this.makeExcludePair();
                if (!this.asymParallelIndependentByCPA(excludePair, cr.getRule(), -1, rj, -1)) {
                    result = false;
                    break;
                }
                excludePair.dispose();
                ++l;
            }
        }
        this.info = this.getConcurrentRuleNameInfo(cr.getRule(), ri);
        this.setRuleResult(i, ri.getName(), result, criterion, this.info);
        tmp.clear();
        return result;
    }

    private String getConcurrentRuleNameInfo(Rule concurRule, Rule rule) {
        String name = concurRule.getName();
        int pos = name.indexOf(rule.getName());
        if (pos > 0) {
            name = name.substring(0, pos - 1);
        }
        return name;
    }

    private List<List<ConcurrentRule>> getListsOfConcurrentRulesOfRule(Rule r, int indx) {
        return this.ruleSequence.getListsOfConcurrentRules(r, indx);
    }

    private List<ConcurrentRule> getConcurrentRulesOfRule(Rule r, int indx, int listIndx) {
        List<List<ConcurrentRule>> lists = this.ruleSequence.getListsOfConcurrentRules(r, indx);
        if (lists == null) {
            lists = new Vector<List<ConcurrentRule>>();
            this.ruleSequence.putListsOfConcurrentRules(r, indx, lists);
            return null;
        }
        if (listIndx < lists.size()) {
            return lists.get(listIndx);
        }
        return null;
    }

    private boolean completeConcurrentRules(Rule r, int rIndx, List<List<ConcurrentRule>> crsOfRule, int listIndx, Hashtable<?, ?> matchmap) {
        boolean res = false;
        if (listIndx >= crsOfRule.size()) {
            int x = listIndx;
            int preIndx = rIndx - 1;
            Rule preRule = this.ruleSequence.getRule(preIndx);
            if (x == 0) {
                List<ConcurrentRule> list = this.makeConcurrentRulesDuetoDependency(preRule, preIndx, r, rIndx, matchmap);
                crsOfRule.add(list);
                res = true;
            } else {
                List<ConcurrentRule> crListOfPreRule = this.getConcurrentRulesOfRule(preRule, preIndx, x - 1);
                if (crListOfPreRule == null || crListOfPreRule.isEmpty()) {
                    List<List<ConcurrentRule>> conRuleListsOfPreRule = this.getListsOfConcurrentRulesOfRule(preRule, preIndx);
                    this.completeConcurrentRules(preRule, rIndx - 1, conRuleListsOfPreRule, x - 1, matchmap);
                    crListOfPreRule = this.getConcurrentRulesOfRule(preRule, preIndx, x - 1);
                }
                if (crListOfPreRule != null) {
                    Vector<ConcurrentRule> list = new Vector<ConcurrentRule>();
                    int c = 0;
                    while (c < crListOfPreRule.size()) {
                        ConcurrentRule cr = crListOfPreRule.get(c);
                        list.addAll(this.makeConcurrentRulesDuetoDependency(cr, r, matchmap));
                        ++c;
                    }
                    while (crsOfRule.size() < x) {
                        crsOfRule.add(new Vector());
                    }
                    crsOfRule.add(list);
                    res = true;
                }
            }
        }
        return res;
    }

    private boolean buildConcurrentRulesForward(Rule ri_1, int i_1, Rule ri, int i, Graph g) {
        System.out.println("=== >>>  ApplicabilityChecker.buildConcurrentRulesForwards:: " + ri_1.getName() + "  &  " + ri.getName());
        boolean result = false;
        List<List<ConcurrentRule>> crListsOfRuleI = this.getListsOfConcurrentRulesOfRule(ri, i);
        List<List<ConcurrentRule>> crListsOfRuleI_1 = this.getListsOfConcurrentRulesOfRule(ri_1, i_1);
        if (crListsOfRuleI_1 != null && !crListsOfRuleI_1.isEmpty()) {
            int l = 0;
            while (l < crListsOfRuleI_1.size() && !result) {
                Vector<ConcurrentRule> listAll = new Vector<ConcurrentRule>();
                crListsOfRuleI.add(listAll);
                List<ConcurrentRule> crList = crListsOfRuleI_1.get(l);
                int c = 0;
                while (c < crList.size() && !result) {
                    ConcurrentRule cr = crList.get(c);
                    List<ConcurrentRule> list = this.makeConcurrentRulesDuetoDependency(cr, ri, null);
                    listAll.addAll(list);
                    if (!list.isEmpty()) {
                        int d = crListsOfRuleI.size();
                        int j = 0;
                        while (j < list.size()) {
                            ConcurrentRule crj = list.get(j);
                            if (this.isConcurrentRuleApplicable(i, ri, this.ruleSequence.getRules(), g, crj, d, "direct-enabling-predecessor")) {
                                result = true;
                            } else {
                                list.remove(j);
                                --j;
                            }
                            ++j;
                        }
                    }
                    ++c;
                }
                ++l;
            }
        }
        if (!result) {
            int k = 0;
            while (k < i) {
                int c;
                Rule r = this.ruleSequence.getRule(k);
                int k1 = k + 1;
                Rule r1 = this.ruleSequence.getRule(k1);
                List<ConcurrentRule> list = null;
                if (k == 0) {
                    list = this.makeConcurrentRulesDuetoDependency(r, k, r1, k1, null);
                    crListsOfRuleI.add(list);
                } else {
                    List<ConcurrentRule> listOfPreRule = this.getConcurrentRulesOfRule(r, k, k - 1);
                    if (listOfPreRule == null || listOfPreRule.isEmpty()) {
                        List<List<ConcurrentRule>> crListsOfPreRule = this.getListsOfConcurrentRulesOfRule(r, k);
                        this.completeConcurrentRules(r, k, crListsOfPreRule, k - 1, null);
                        listOfPreRule = this.getConcurrentRulesOfRule(r, k, k - 1);
                        if (listOfPreRule == null || listOfPreRule.isEmpty()) {
                            result = false;
                            break;
                        }
                    }
                    list = new Vector<ConcurrentRule>();
                    c = 0;
                    while (c < listOfPreRule.size()) {
                        ConcurrentRule cr = listOfPreRule.get(c);
                        list.addAll(this.makeConcurrentRulesDuetoDependency(cr, r1, null));
                        ++c;
                    }
                    crListsOfRuleI.add(list);
                }
                if (!list.isEmpty()) {
                    int d = crListsOfRuleI.size();
                    c = 0;
                    while (c < list.size()) {
                        ConcurrentRule cr = list.get(c);
                        if (this.isConcurrentRuleApplicable(i, ri, this.ruleSequence.getRules(), g, cr, d, "direct-enabling-predecessor")) {
                            result = true;
                        }
                        ++c;
                    }
                    if (result) break;
                }
                ++k;
            }
        }
        return result;
    }

    private boolean buildConcurrentRulesBackward(Rule ri_1, int i_1, Rule ri, int i, Graph g) {
        System.out.println("=== >>>  ApplicabilityChecker.buildConcurrentRulesBackwards:: " + ri_1.getName() + "  &  " + ri.getName());
        boolean result = false;
        int size = i;
        List<List<ConcurrentRule>> concurrentRuleListsOfRule = this.getListsOfConcurrentRulesOfRule(ri, i);
        List<ConcurrentRule> list = null;
        int m = size - 1;
        while (m >= 0) {
            if (m == size - 1) {
                if (this.ruleSequence.isObjFlowActive()) {
                    ObjectFlow objFlow = this.ruleSequence.getObjFlowForRules(ri_1, i_1, ri, i);
                    if (objFlow != null && !objFlow.isEmpty()) {
                        Hashtable<Object, Object> objFlowMap = objFlow.getMapping();
                        System.out.println("=== >>>  ApplicabilityChecker.buildConcurrentRulesBackwards::  USE   ObjectFlow ");
                        list = this.makeConcurrentRules(ri_1, i_1, ri, i, objFlowMap);
                    } else {
                        list = this.makeConcurrentRules(ri_1, i_1, ri, i);
                    }
                } else {
                    System.out.println("=== >>>  ApplicabilityChecker.buildConcurrentRulesBackwards::  WITHOUT   ObjectFlow ");
                    list = this.makeConcurrentRules(ri_1, i_1, ri, i);
                }
                concurrentRuleListsOfRule.add(list);
            } else if (this.depth == -1 || m < this.depth) {
                Rule r = this.ruleSequence.getRule(m);
                list = this.makeConcurrentRules(r, m, list, m + 1);
                concurrentRuleListsOfRule.add(list);
            }
            if (list != null && !list.isEmpty()) {
                int d = concurrentRuleListsOfRule.size();
                int k = 0;
                while (k < list.size()) {
                    ConcurrentRule cr = list.get(k);
                    if (this.isConcurrentRuleApplicable(i, ri, this.ruleSequence.getRules(), g, cr, d, "direct-enabling-predecessor")) {
                        result = true;
                        break;
                    }
                    ++k;
                }
                if (result) break;
            }
            --m;
        }
        return result;
    }

    private List<ConcurrentRule> makeJointlyConcurrentRule(Rule r1, int indx_r1, Rule r2, int indx_r2) {
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        dependencyContainer.enableProduceConcurrentRule(true);
        dependencyContainer.setCompleteConcurrency(true);
        List<ConcurrentRule> list = null;
        try {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalPairs = dependencyContainer.getCriticalPair(r1, r2, 0, true);
            if (criticalPairs != null) {
                list = dependencyContainer.getConcurrentRules();
                this.reduceConcurrentRulesDuetoObjectFlow(r1, indx_r1, r2, indx_r2, list);
                this.extendRuleNameByIndex(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private List<ConcurrentRule> makeConcurrentRulesDuetoDependency(Rule r1, int indx_r1, Rule r2, int indx_r2, Hashtable<?, ?> matchmap) {
        ConcurrentRule cr;
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        dependencyContainer.enableProduceConcurrentRule(true);
        dependencyContainer.setCompleteConcurrency(this.completeConcurrency);
        List<Object> list = null;
        try {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalPairs = dependencyContainer.getCriticalPair(r1, r2, 0, true);
            if (criticalPairs != null) {
                list = dependencyContainer.getConcurrentRules();
            }
        }
        catch (Exception criticalPairs) {
            // empty catch block
        }
        if (list == null) {
            list = new Vector(1);
        } else {
            int i = 0;
            while (i < list.size()) {
                ((ConcurrentRule)list.get(i)).setIndexOfFirstSourceRule(indx_r1);
                ((ConcurrentRule)list.get(i)).setIndexOfSecondSourceRule(indx_r2);
                ++i;
            }
        }
        if (this.completeConcurrency && (cr = new ConcurrentRule(r1, r2)).getRule() != null) {
            cr.setIndexOfFirstSourceRule(indx_r1);
            cr.setIndexOfSecondSourceRule(indx_r2);
            list.add(cr);
        }
        if (!list.isEmpty()) {
            this.reduceConcurrentRulesDuetoObjectFlow(r1, indx_r1, r2, indx_r2, list);
        }
        this.extendRuleNameByIndex(list);
        return list;
    }

    private List<ConcurrentRule> makeConcurrentRulesDuetoDependency(ConcurrentRule cr1, Rule r2, Hashtable<?, ?> matchmap) {
        ConcurrentRule cr;
        DependencyPairContainer dependencyContainer = this.makeDependencyPairContainer();
        dependencyContainer.enableProduceConcurrentRule(true);
        dependencyContainer.setCompleteConcurrency(this.completeConcurrency);
        Vector<ConcurrentRule> list = null;
        try {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalPairs = dependencyContainer.getCriticalPair(cr1.getRule(), r2, 0, true);
            if (criticalPairs != null) {
                list = dependencyContainer.getConcurrentRules();
            }
        }
        catch (Exception criticalPairs) {
            // empty catch block
        }
        if (list == null) {
            list = new Vector(1);
        }
        if (this.completeConcurrency && (cr = new ConcurrentRule(cr1, r2)).getRule() != null) {
            list.add(cr);
        }
        int c = 0;
        while (c < list.size()) {
            if (this.completeConcurRuleBackward) {
                ((ConcurrentRule)list.get(c)).setSecondSourceConcurrentRule(cr1);
            } else {
                ((ConcurrentRule)list.get(c)).setFirstSourceConcurrentRule(cr1);
            }
            ++c;
        }
        this.extendRuleNameByIndex(list);
        return list;
    }

    private Hashtable<Object, Object> getObjectFlowForRules(Rule r1, int indx_r1, ConcurrentRule cr, int indx_cr) {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        map.putAll(cr.getReflectedInputObjectFlowFromRule(r1, this.ruleSequence.getObjFlowFromRule(r1, indx_r1)));
        return map;
    }

    private List<ConcurrentRule> makeConcurrentRules(Rule r1, int indx_r1, List<ConcurrentRule> crules, int indx_cr) {
        Vector<ConcurrentRule> reslist = new Vector<ConcurrentRule>();
        if (this.completeConcurRuleBackward) {
            int i = 0;
            while (i < crules.size()) {
                ConcurrentRule cr = crules.get(i);
                if (this.ruleSequence.isObjFlowActive()) {
                    int j;
                    Hashtable<Object, Object> matchmap = this.getObjectFlowForRules(r1, indx_r1, cr, indx_cr);
                    if (!matchmap.isEmpty()) {
                        List<ConcurrentRule> list = this.makeConcurrentRules(r1, indx_r1, cr.getRule(), indx_cr, matchmap);
                        if (list != null) {
                            j = 0;
                            while (j < list.size()) {
                                ConcurrentRule concrule = list.get(j);
                                concrule.setSecondSourceConcurrentRule(cr);
                                this.reflectObjectFlows(concrule, indx_r1, indx_r1 + concrule.getDepth());
                                reslist.add(concrule);
                                ++j;
                            }
                        }
                    } else {
                        System.out.println("=== >>>  " + r1.getName() + "  &  " + cr.getRule().getName() + "  ::  ObjectFlow is EMPTY. ");
                        List<ConcurrentRule> list = this.makeConcurrentRules(r1, indx_r1, cr.getRule(), indx_cr);
                        if (list != null) {
                            j = 0;
                            while (j < list.size()) {
                                list.get(j).setSecondSourceConcurrentRule(cr);
                                reslist.add(list.get(j));
                                ++j;
                            }
                        }
                    }
                } else {
                    List<ConcurrentRule> list = this.makeConcurrentRules(r1, indx_r1, cr.getRule(), indx_cr);
                    if (list != null) {
                        int j = 0;
                        while (j < list.size()) {
                            list.get(j).setSecondSourceConcurrentRule(cr);
                            reslist.add(list.get(j));
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return reslist;
    }

    private void reflectObjectFlows(ConcurrentRule cr, int fromRuleIndx, int toRuleIndx) {
        int i = fromRuleIndx;
        while (i <= toRuleIndx) {
            Rule r = this.ruleSequence.getRule(i);
            if (r != null) {
                cr.reflectObjectFlow(this.ruleSequence.getObjFlowForRule(r, i));
            }
            ++i;
        }
    }

    private List<ConcurrentRule> makeConcurrentRules(Rule r1, int indx_r1, Rule r2, int indx_r2, Hashtable<?, ?> objFlowMap) {
        if (objFlowMap == null || objFlowMap.isEmpty()) {
            return this.makeConcurrentRules(r1, indx_r1, r2, indx_r2);
        }
        System.out.println("=== >>>  ApplicabilityChecker.makeConcurrentRules::  " + r1.getName() + "   " + r2.getName() + "  by  Object Flow: ");
        Hashtable<String, String> storeNewName2OldName = new Hashtable<String, String>();
        if (r1 != r2) {
            BaseFactory.theFactory().renameSimilarVariable(r2, r1, "r1_", storeNewName2OldName);
        }
        Vector<ConcurrentRule> list = new Vector<ConcurrentRule>();
        Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> inverseRulePair = BaseFactory.theFactory().reverseRule(r1);
        Rule inverseRule1 = (Rule)((Pair)inverseRulePair.first).first;
        int maxsize = objFlowMap.size();
        if (maxsize > 0) {
            Hashtable<Object, Object> inversematchmap = new Hashtable<Object, Object>();
            Enumeration<?> keys = objFlowMap.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                inversematchmap.put(objFlowMap.get(key), ((OrdinaryMorphism)((Pair)inverseRulePair.second).second).getImage((GraphObject)key));
            }
            Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> enums = BaseFactory.theFactory().getOverlappingByPredefinedIntersection(r2.getLeft(), inverseRule1.getLeft(), inversematchmap);
            if (enums != null && enums.hasMoreElements()) {
                while (enums.hasMoreElements()) {
                    ConcurrentRule cr;
                    Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping = enums.nextElement();
                    if (!this.checkIntersectionDuetoObjectFlow(overlapping, objFlowMap) || (cr = new ConcurrentRule(r1, (Rule)((Pair)inverseRulePair.first).first, r2, (OrdinaryMorphism)((Pair)inverseRulePair.second).first, (OrdinaryMorphism)((Pair)inverseRulePair.second).second, (OrdinaryMorphism)overlapping.second, (OrdinaryMorphism)overlapping.first)).getRule() == null) continue;
                    cr.setIndexOfFirstSourceRule(indx_r1);
                    cr.setIndexOfSecondSourceRule(indx_r2);
                    cr.reflectObjectFlow(this.ruleSequence.getObjFlowForRule(r1, indx_r1));
                    cr.reflectObjectFlow(this.ruleSequence.getObjFlowForRule(r2, indx_r2));
                    list.add(0, cr);
                    System.out.println("=== >>>  Concurrent rule: " + cr.getRule().getName() + "  has NACs: " + cr.getRule().getNACs().hasMoreElements() + ", has PACs: " + cr.getRule().getPACs().hasMoreElements());
                }
            }
        }
        this.extendRuleNameByIndex(list);
        System.out.println("=== >>> ApplicabilityChecker.makeConcurrentRules::  count: " + list.size());
        if (!storeNewName2OldName.isEmpty()) {
            BaseFactory.theFactory().restoreVariableNameOfRule(r1, storeNewName2OldName);
        }
        return list;
    }

    private List<ConcurrentRule> makeConcurrentRules(Rule r1, int indx_r1, Rule r2, int indx_r2) {
        System.out.println("=== >>>  ApplicabilityChecker.makeConcurrentRules::  of  " + r1.getName() + "   " + r2.getName());
        Hashtable<String, String> storeNewName2OldName = new Hashtable<String, String>();
        if (r1 != r2) {
            BaseFactory.theFactory().renameSimilarVariable(r2, r1, "r1_", storeNewName2OldName);
        }
        Vector<ConcurrentRule> list = new Vector<ConcurrentRule>();
        ConcurrentRule cr = new ConcurrentRule(r1, r2);
        if (cr.getRule() != null && this.isOverlappingGraphValid(r1, null, r2, cr.getFirstLeftEmbedding(), cr.getSecondLeftEmbedding())) {
            cr.setIndexOfFirstSourceRule(indx_r1);
            cr.setIndexOfSecondSourceRule(indx_r2);
            cr.reflectObjectFlow(this.ruleSequence.getObjFlowForRule(r1, indx_r1));
            cr.reflectObjectFlow(this.ruleSequence.getObjFlowForRule(r2, indx_r2));
            System.out.println("=== >>>  ApplicabilityChecker.makeConcurrentRules::  DISJOINT  CR: " + cr.getRule().getName() + "  has NACs: " + cr.getRule().getNACs().hasMoreElements() + ", has PACs: " + cr.getRule().getPACs().hasMoreElements());
            list.add(cr);
        }
        this.extendRuleNameByIndex(list);
        System.out.println("=== >>>  ApplicabilityChecker.makeConcurrentRules::  count: " + list.size());
        if (!storeNewName2OldName.isEmpty()) {
            BaseFactory.theFactory().restoreVariableNameOfRule(r1, storeNewName2OldName);
        }
        return list;
    }

    private boolean isOverlappingGraphValid(Rule r1, Rule inverse_r1, Rule r2, OrdinaryMorphism morph1, OrdinaryMorphism morph2) {
        boolean valid = true;
        ((ContextView)morph1.getAttrContext()).setVariableContext(true);
        if (inverse_r1 == null) {
            Match m1 = BaseFactory.theFactory().makeMatch(r1, morph1);
            if (m1 != null) {
                if (r1.hasNACs()) {
                    valid = ExcludePairHelper.isMatchValid(r1, m1, null, true, null);
                }
                if (!valid) {
                    return false;
                }
            } else {
                return false;
            }
        }
        ((ContextView)morph2.getAttrContext()).setVariableContext(true);
        Match m2 = BaseFactory.theFactory().makeMatch(r2, morph2);
        if (m2 != null) {
            if (valid) {
                valid = ExcludePairHelper.isMatchValid(r2, m2, null, false, null);
            }
            if (!valid) {
                return false;
            }
        } else {
            return false;
        }
        return valid;
    }

    private boolean checkIntersectionDuetoObjectFlow(Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping, Hashtable<?, ?> objFlow) {
        boolean ok = true;
        if (objFlow != null) {
            List<GraphObject> r2LHSobjs = this.getOverlappingObjectsOfFirstMorphism(overlapping);
            Iterator<?> r2_objFlow = objFlow.values().iterator();
            while (r2_objFlow.hasNext() && ok) {
                boolean bl = ok = ok && r2LHSobjs.contains(r2_objFlow.next());
            }
        }
        return ok;
    }

    private List<GraphObject> getOverlappingObjectsOfFirstMorphism(Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        for (GraphObject graphObject : ((OrdinaryMorphism)overlapping.first).getTarget().getNodesSet()) {
            if (!((OrdinaryMorphism)overlapping.second).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)overlapping.first).getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(((OrdinaryMorphism)overlapping.first).getInverseImage(graphObject).nextElement());
        }
        for (GraphObject graphObject : ((OrdinaryMorphism)overlapping.first).getTarget().getArcsSet()) {
            if (!((OrdinaryMorphism)overlapping.second).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)overlapping.first).getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(((OrdinaryMorphism)overlapping.first).getInverseImage(graphObject).nextElement());
        }
        return list;
    }

    private boolean checkConcurrentRuleDuetoObjectFlow(ConcurrentRule cr, Hashtable<?, ?> objFlow) {
        if (objFlow == null || objFlow.isEmpty() || cr.getOverlappingObjectsOfSecondRule() == null) {
            return true;
        }
        boolean ok = true;
        boolean inside = false;
        Enumeration<?> outs = objFlow.keys();
        while (outs.hasMoreElements()) {
            GraphObject out = (GraphObject)outs.nextElement();
            Hashtable<GraphObject, GraphObject> map = cr.getOverlappingObjects();
            Enumeration<GraphObject> objs = map.keys();
            while (objs.hasMoreElements()) {
                GraphObject obj_rhs1 = objs.nextElement();
                GraphObject obj_lhs2 = map.get(obj_rhs1);
                GraphObject input = (GraphObject)objFlow.get(out);
                if (input != obj_lhs2) {
                    ok = false;
                    continue;
                }
                inside = true;
            }
        }
        if (!inside) {
            return true;
        }
        return ok;
    }

    private void reduceConcurrentRulesDuetoObjectFlow(Rule r1, int indx_r1, Rule r2, int indx_r2, List<ConcurrentRule> list) {
        ObjectFlow objFlow;
        if (this.ruleSequence.isObjFlowActive() && (objFlow = this.ruleSequence.getObjFlowForRules(r1, indx_r1, r2, indx_r2)) != null && !objFlow.isEmpty()) {
            Hashtable<Object, Object> map = objFlow.getMapping();
            int c = 0;
            while (c < list.size()) {
                ConcurrentRule cr = list.get(c);
                if (!this.checkConcurrentRuleDuetoObjectFlow(cr, map)) {
                    list.remove(c);
                    --c;
                }
                ++c;
            }
        }
    }

    private void extendRuleNameByIndex(List<ConcurrentRule> list) {
        int i = 1;
        while (i < list.size()) {
            Rule r = list.get(i).getRule();
            r.setName(r.getName().concat("_").concat(String.valueOf(i)));
            ++i;
        }
    }

    private void setRuleResult(int indx, String ruleName, boolean result, String criterion, String otherRuleName) {
        this.ruleSequence.setRuleResult(indx, ruleName, result, criterion, otherRuleName);
    }

    private void setApplicabilityResult(boolean result, String criterion) {
        this.ruleSequence.setApplicabilityResult(result, criterion);
    }

    private void setNonApplicabilityResult(boolean result, String criterion) {
        this.ruleSequence.setNonApplicabilityResult(result, criterion);
    }
}

