/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.termination;

import agg.gui.termination.RuleTable;
import agg.gui.termination.TypeTable;
import agg.termination.TerminationLGTS;
import agg.termination.TerminationLGTSInterface;
import agg.termination.TerminationLGTSTypedByTypeGraph;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class LayerTerminationCondTable
extends JDialog
implements ActionListener {
    static final Color NOT_VALID = Color.red;
    static final Color VALID = Color.green;
    private Hashtable<Integer, Hashtable<String, JButton>> buttons = new Hashtable();
    private TerminationLGTSInterface termination;
    private Hashtable<JButton, Integer> firstLayers = new Hashtable();
    private Hashtable<JButton, String> secondConds = new Hashtable();
    private JPanel panel;
    private JPanel tablePanel;
    private JScrollPane scrLayer;
    private RuleTable tableRule;
    private TypeTable tableTypeDeletion;
    private TypeTable tableTypeCreation;
    private JButton lastButton;
    private Vector<Pair<String, String>> conds;
    private int w;
    private int h;

    private static Vector<Pair<String, String>> getConditionName() {
        Vector<Pair<String, String>> names = new Vector<Pair<String, String>>(3);
        names.add(new Pair<String, String>("Deletion_1", "Type Deletion Layer Condition"));
        names.add(new Pair<String, String>("Deletion_2", "Deletion Layer Condition"));
        names.add(new Pair<String, String>("Nondeletion", "Nondeletion Layer Condition"));
        return names;
    }

    public LayerTerminationCondTable(TerminationLGTSInterface termination) {
        super((Frame)new JFrame(), false);
        this.setTitle("Termination of LGTS");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LayerTerminationCondTable.this.setVisible(false);
                LayerTerminationCondTable.this.dispose();
            }
        });
        this.termination = termination;
        GridBagLayout gridbag = new GridBagLayout();
        JPanel main = new JPanel(new BorderLayout());
        main.setBackground(Color.lightGray);
        this.panel = new JPanel(gridbag);
        this.scrLayer = new JScrollPane();
        this.scrLayer.setBackground(Color.orange);
        this.scrLayer.setBorder(new TitledBorder(" Termination Conditions of LGTS "));
        JPanel rowHead = new JPanel();
        rowHead.setLayout(new GridLayout(termination.getOrderedRuleLayer().size(), 1));
        Enumeration<Integer> en = termination.getOrderedRuleLayer().elements();
        while (en.hasMoreElements()) {
            String text = en.nextElement().toString();
            JLabel act = new JLabel(" Layer " + text + " ");
            act.setToolTipText("");
            rowHead.add(act);
        }
        JPanel colHead = new JPanel();
        colHead.setLayout(new GridLayout(1, 3));
        this.conds = LayerTerminationCondTable.getConditionName();
        int i = 0;
        while (i < this.conds.size()) {
            Pair<String, String> cond = this.conds.get(i);
            String text = (String)cond.first;
            JLabel act = new JLabel(" " + text);
            act.setToolTipText("");
            colHead.add(act);
            ++i;
        }
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridLayout(termination.getOrderedRuleLayer().size(), 3));
        i = 0;
        while (i < termination.getOrderedRuleLayer().size()) {
            int ii = 0;
            while (ii < 3) {
                JButton act = new JButton("   ");
                act.setToolTipText((String)this.conds.elementAt((int)ii).first);
                act.setMinimumSize(new Dimension(act.getHeight(), act.getHeight()));
                act.addActionListener(this);
                this.addButton(termination.getOrderedRuleLayer().elementAt(i), (String)this.conds.elementAt((int)ii).first, act);
                this.tablePanel.add(act);
                this.refreshView(termination.getOrderedRuleLayer().elementAt(i), (String)this.conds.elementAt((int)ii).first, act);
                ++ii;
            }
            ++i;
        }
        Dimension dim = this.tablePanel.getPreferredSize();
        Dimension dim1 = new Dimension();
        dim1.setSize(dim.getWidth() + 50.0, dim.getHeight() + 20.0);
        Dimension dim2 = new Dimension();
        dim2.setSize(dim1.getWidth(), colHead.getPreferredSize().getHeight());
        colHead.setMinimumSize(dim2);
        colHead.setPreferredSize(dim2);
        dim2 = new Dimension();
        dim2.setSize(rowHead.getPreferredSize().getWidth(), dim1.getHeight());
        rowHead.setPreferredSize(dim2);
        rowHead.setMinimumSize(dim2);
        this.tablePanel.setPreferredSize(dim1);
        this.tablePanel.setMinimumSize(dim1);
        this.scrLayer.setRowHeaderView(rowHead);
        this.scrLayer.setColumnHeaderView(colHead);
        this.scrLayer.setViewportView(this.tablePanel);
        this.scrLayer.setCorner("UPPER_LEFT_CORNER", new JLabel(""));
        this.constrainBuild(this.panel, this.scrLayer, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerTerminationCondTable.this.setVisible(false);
                LayerTerminationCondTable.this.dispose();
            }
        });
        JPanel closeP = new JPanel(new GridLayout(1, 3));
        closeP.add(new JLabel("  "));
        closeP.add(closeButton);
        closeP.add(new JLabel("  "));
        main.add((Component)this.panel, "Center");
        main.add((Component)closeP, "South");
        main.revalidate();
        JScrollPane scroll = new JScrollPane(main);
        scroll.setPreferredSize(new Dimension(300, 250));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(scroll);
        this.validate();
        this.setLocation(200, 100);
        this.pack();
    }

    public void showGUI() {
        this.setVisible(true);
        this.w = this.getWidth();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Integer layer = this.firstLayers.get(source);
        String second = this.secondConds.get(source);
        if (this.lastButton != null) {
            this.lastButton.setText("");
        }
        if (layer != null && second != null) {
            if (this.scrLayer != null) {
                this.panel.remove(this.scrLayer);
            }
            if (this.tableRule != null) {
                this.panel.remove(this.tableRule);
            }
            if (this.tableTypeDeletion != null) {
                this.panel.remove(this.tableTypeDeletion);
            }
            if (this.tableTypeCreation != null) {
                this.panel.remove(this.tableTypeCreation);
            }
            ((JButton)source).setText("X");
            this.h = (int)this.scrLayer.getPreferredSize().getHeight();
            this.constrainBuild(this.panel, this.scrLayer, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
            Vector<String> rules = this.getRules(layer, second);
            if (rules.size() != 0) {
                this.tableRule = new RuleTable(rules, " Rules of the Layer  " + layer);
                this.tableRule.setPreferredSize(new Dimension(this.w, this.tableRule.getTableHeight()));
                this.h += (int)this.tableRule.getPreferredSize().getHeight();
                this.constrainBuild(this.panel, this.tableRule, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                if (second.equals("Deletion_1")) {
                    Vector<String> deletionTypeTypes = this.getTypes(layer, "Deletion_1");
                    this.tableTypeDeletion = new TypeTable(deletionTypeTypes, " Type - Deletion ");
                    this.tableTypeDeletion.setPreferredSize(new Dimension(this.w, this.tableTypeDeletion.getTableHeight()));
                    this.h += (int)this.tableTypeDeletion.getPreferredSize().getHeight();
                    this.constrainBuild(this.panel, this.tableTypeDeletion, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                } else if (second.equals("Deletion_2")) {
                    Vector<String> deletionTypes = this.getTypes(layer, "Deletion_2");
                    this.tableTypeDeletion = new TypeTable(deletionTypes, " Type  Deletion of the Layer  " + layer);
                    this.tableTypeDeletion.setPreferredSize(new Dimension(this.w, this.tableTypeDeletion.getTableHeight()));
                    this.h += (int)this.tableTypeDeletion.getPreferredSize().getHeight();
                    this.constrainBuild(this.panel, this.tableTypeDeletion, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    Vector<String> creationTypes = this.getCreatedTypesOnDeletionLayer(layer);
                    if (creationTypes.size() != 0) {
                        this.tableTypeCreation = new TypeTable(creationTypes, " Type  Creation of the Layer  " + layer);
                        this.tableTypeCreation.setPreferredSize(new Dimension(this.w, this.tableTypeCreation.getTableHeight()));
                        this.h += (int)this.tableTypeCreation.getPreferredSize().getHeight();
                        this.constrainBuild(this.panel, this.tableTypeCreation, 0, 3, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    }
                } else if (second.equals("Nondeletion")) {
                    Vector<String> creationTypes = this.getTypes(layer, "Nondeletion");
                    this.tableTypeCreation = new TypeTable(creationTypes, " Type  Creation of the Layer  " + layer);
                    this.tableTypeCreation.setPreferredSize(new Dimension(this.w, this.tableTypeCreation.getTableHeight()));
                    this.constrainBuild(this.panel, this.tableTypeCreation, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.h += (int)this.tableTypeCreation.getPreferredSize().getHeight();
                }
            }
            this.h += 50;
            this.panel.setPreferredSize(new Dimension(this.w, this.h));
            this.panel.revalidate();
            this.setSize(this.w + 50, this.h + 80);
            this.validate();
            this.lastButton = (JButton)source;
        }
    }

    void addButton(Integer layer, String condName, JButton button) {
        Hashtable<String, JButton> hash1 = this.buttons.get(layer);
        if (hash1 == null) {
            hash1 = new Hashtable();
            this.buttons.put(layer, hash1);
        }
        hash1.put(condName, button);
        this.firstLayers.put(button, layer);
        this.secondConds.put(button, condName);
    }

    JButton getButton(Integer layer, String condName) {
        Hashtable<String, JButton> hash1 = this.buttons.get(layer);
        if (hash1 == null) {
            return null;
        }
        return hash1.get(condName);
    }

    public void refreshView() {
        Enumeration<Integer> en1 = this.buttons.keys();
        while (en1.hasMoreElements()) {
            Integer first = en1.nextElement();
            Enumeration<String> en2 = this.buttons.get(first).keys();
            while (en2.hasMoreElements()) {
                String second = en2.nextElement();
                this.refreshView(first, second);
            }
        }
    }

    void refreshView(Integer first, String second) {
        this.refreshView(first, second, this.getButton(first, second));
    }

    void refreshView(Integer layer, String cond, JButton button) {
        boolean value = this.getValue(layer, cond);
        if (value) {
            button.setBackground(VALID);
            button.setText(" ");
        } else {
            button.setBackground(NOT_VALID);
            button.setText(" ");
        }
    }

    private boolean getValue(Integer layer, String condName) {
        if (condName.equals("Deletion_1")) {
            Pair<Boolean, Vector<Rule>> value = this.termination.getResultTypeDeletion().get(layer);
            return (Boolean)value.first;
        }
        if (condName.equals("Deletion_2")) {
            Pair<Boolean, Vector<Rule>> value = this.termination.getResultDeletion().get(layer);
            return (Boolean)value.first;
        }
        if (condName.equals("Nondeletion")) {
            Pair<Boolean, Vector<Rule>> value = this.termination.getResultNondeletion().get(layer);
            return (Boolean)value.first;
        }
        return false;
    }

    private Vector<String> getRules(Integer layer, String condName) {
        Pair<Boolean, Vector<Rule>> p;
        Vector<String> names = new Vector<String>();
        boolean result = false;
        if (condName.equals("Deletion_1")) {
            p = this.termination.getResultTypeDeletion().get(layer);
            result = (Boolean)p.first;
        } else if (condName.equals("Deletion_2")) {
            p = this.termination.getResultDeletion().get(layer);
            result = (Boolean)p.first;
        } else if (condName.equals("Nondeletion")) {
            p = this.termination.getResultNondeletion().get(layer);
            result = (Boolean)p.first;
        }
        HashSet<Rule> rulesForLayer = this.termination.getInvertedRuleLayer().get(layer);
        for (Rule rule : rulesForLayer) {
            names.addElement(rule.getName());
        }
        return names;
    }

    private Vector<String> getTypes(Integer layer, String condName) {
        Vector<String> names = new Vector<String>();
        HashSet<Object> typesForLayer = null;
        if (condName.equals("Deletion_1")) {
            Vector<GraphObject> typeObjs;
            if (this.termination instanceof TerminationLGTS) {
                Vector<Type> types;
                if (this.termination.getDeletionType() != null && this.termination.getDeletionType().containsKey(layer) && (types = this.termination.getDeletionType().get(layer)) != null) {
                    Enumeration<Type> enumeration = types.elements();
                    while (enumeration.hasMoreElements()) {
                        Type t = enumeration.nextElement();
                        if (t.getStringRepr().equals("")) {
                            names.addElement("(unnamed)");
                            continue;
                        }
                        names.addElement(t.getStringRepr());
                    }
                }
            } else if (this.termination instanceof TerminationLGTSTypedByTypeGraph && this.termination.getDeletionTypeObject() != null && this.termination.getDeletionTypeObject().containsKey(layer) && (typeObjs = this.termination.getDeletionTypeObject().get(layer)) != null) {
                Enumeration<GraphObject> enumeration = typeObjs.elements();
                while (enumeration.hasMoreElements()) {
                    GraphObject tobj = enumeration.nextElement();
                    if (tobj.isNode()) {
                        if (tobj.getType().getStringRepr().equals("")) {
                            names.add("(unnamed)");
                            continue;
                        }
                        names.add(tobj.getType().getStringRepr());
                        continue;
                    }
                    names.add(this.getTypeStringOfEdge((Arc)tobj));
                }
            }
            return names;
        }
        if (condName.equals("Deletion_2")) {
            if (this.termination.getInvertedTypeDeletionLayer() != null && this.termination.getInvertedTypeDeletionLayer().containsKey(layer)) {
                typesForLayer = this.termination.getInvertedTypeDeletionLayer().get(layer);
            }
        } else if (condName.equals("Nondeletion") && this.termination.getInvertedTypeCreationLayer() != null && this.termination.getInvertedTypeCreationLayer().containsKey(layer)) {
            typesForLayer = this.termination.getInvertedTypeCreationLayer().get(layer);
        }
        if (typesForLayer != null) {
            for (Object e : typesForLayer) {
                if (e instanceof Type) {
                    Type t = (Type)e;
                    if (t.getStringRepr().equals("")) {
                        names.addElement("(unnamed)");
                        continue;
                    }
                    names.addElement(t.getStringRepr());
                    continue;
                }
                if (e instanceof Node) {
                    names.add(this.getTypeStringOfNode((Node)e));
                    continue;
                }
                if (!(e instanceof Arc)) continue;
                names.add(this.getTypeStringOfEdge((Arc)e));
            }
        }
        return names;
    }

    private Vector<String> getCreatedTypesOnDeletionLayer(Integer layer) {
        Vector<String> names = new Vector<String>();
        Vector<Object> types = this.termination.getCreatedTypesOnDeletionLayer(layer);
        Enumeration<Object> en = types.elements();
        while (en.hasMoreElements()) {
            Object tobj = en.nextElement();
            if (tobj instanceof Type) {
                Type t = (Type)tobj;
                if (t.getStringRepr().equals("")) {
                    names.addElement("(unnamed)");
                    continue;
                }
                names.addElement(t.getStringRepr());
                continue;
            }
            if (tobj instanceof Node) {
                names.add(this.getTypeStringOfNode((Node)tobj));
                continue;
            }
            if (!(tobj instanceof Arc)) continue;
            names.add(this.getTypeStringOfEdge((Arc)tobj));
        }
        return names;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private String getTypeStringOfNode(Node go) {
        String s = go.getType().getStringRepr();
        if (s.equals("")) {
            s = "(unnamed)";
        }
        return s;
    }

    private String getTypeStringOfEdge(Arc go) {
        String s = this.getTypeStringOfNode((Node)go.getSource());
        s = s.concat("--");
        String s1 = go.getType().getStringRepr();
        if (s1.equals("")) {
            s1 = "(unnamed)";
        }
        s = s.concat(s1);
        s = s.concat("->");
        s = s.concat(this.getTypeStringOfNode((Node)go.getTarget()));
        return s;
    }
}

