/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.gui.options.AbstractOptionGUI;
import agg.gui.parser.event.StatusMessageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionGUI
extends JDialog
implements ActionListener,
ChangeListener {
    public static final int GENERAL = 0;
    public static final int TRANSFORMATION = 1;
    public static final int PARSER = 2;
    public static final int CRITICAL_PAIRS = 3;
    public static final int LAYOUTER = 4;
    private Vector<StatusMessageListener> listener;
    private JButton closeButton;
    private JTabbedPane tabbedPane;
    private JPanel dialogPanel;
    private WindowAdapter wl;
    private final Hashtable<String, AbstractOptionGUI> title2optiongui;

    public OptionGUI(JFrame parent, String title, boolean modal) {
        this.setModal(modal);
        this.setTitle(title);
        this.setLocation(200, 100);
        this.listener = new Vector();
        this.wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OptionGUI.this.setVisible(false);
            }
        };
        this.addWindowListener(this.wl);
        this.title2optiongui = new Hashtable();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.dialogPanel = new JPanel(new BorderLayout());
        this.dialogPanel.setBackground(Color.cyan);
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialogPanel.add((Component)this.tabbedPane, "Center");
        this.dialogPanel.add((Component)this.closeButton, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.pack();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(430, 700);
    }

    public void addGUI(AbstractOptionGUI gui, int pos) {
        if (pos < 0) {
            this.tabbedPane.addTab(gui.getTabTitle(), gui.getIcon(), gui, gui.getTabTip());
        } else {
            this.tabbedPane.insertTab(gui.getTabTitle(), gui.getIcon(), gui, gui.getTabTip(), pos);
        }
        this.title2optiongui.put(gui.getTabTitle(), gui);
        this.pack();
        this.validate();
    }

    public AbstractOptionGUI getGuiComponent(String title) {
        int i = 0;
        while (i < this.tabbedPane.getComponentCount()) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof AbstractOptionGUI && ((AbstractOptionGUI)comp).getTabTitle().indexOf(title) != -1) {
                return (AbstractOptionGUI)comp;
            }
            ++i;
        }
        return null;
    }

    public void addGUI(AbstractOptionGUI gui) {
        this.addGUI(gui, -1);
        this.pack();
    }

    public void removeGUI(AbstractOptionGUI gui) {
        this.tabbedPane.remove(gui);
        this.pack();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.executeOnClose();
            this.setVisible(false);
        }
    }

    public void addStatusMessageListener(StatusMessageListener sml) {
        if (!this.listener.contains(sml)) {
            this.listener.addElement(sml);
        }
    }

    public void removeStatusMessageListener(StatusMessageListener sml) {
        if (this.listener.contains(sml)) {
            this.listener.removeElement(sml);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ((AbstractOptionGUI)this.tabbedPane.getSelectedComponent()).update();
    }

    public void selectOptions(int kind) {
        switch (kind) {
            case 0: {
                this.tabbedPane.setSelectedComponent(this.title2optiongui.get("General"));
                break;
            }
            case 1: {
                this.tabbedPane.setSelectedComponent(this.title2optiongui.get("Transformation"));
                break;
            }
            case 2: {
                this.tabbedPane.setSelectedComponent(this.title2optiongui.get("Parser"));
                break;
            }
            case 3: {
                this.tabbedPane.setSelectedComponent(this.title2optiongui.get("Critical Pairs"));
                break;
            }
            case 4: {
                this.tabbedPane.setSelectedComponent(this.title2optiongui.get("Layouter"));
            }
        }
    }

    protected void executeOnClose() {
        int i = 0;
        while (i < this.tabbedPane.getComponentCount()) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof AbstractOptionGUI) {
                ((AbstractOptionGUI)comp).executeOnClose();
            }
            ++i;
        }
    }
}

