/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.wrapper;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityAttribute;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityEdge;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityGraphElement;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityNestedCondition;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityNode;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;

public class VariabilityFactory {
    private VariabilityFactory() {
    }

    public static VariabilityAttribute createVariabilityAttribute() {
        return new VariabilityAttribute();
    }

    public static VariabilityAttribute createVariabilityAttribute(Node node, EAttribute type, String value) {
        return new VariabilityAttribute(node, type, value);
    }

    public static VariabilityAttribute createVariabilityAttribute(Attribute attribute) {
        if (attribute instanceof VariabilityAttribute) {
            return (VariabilityAttribute)attribute;
        }
        return new VariabilityAttribute(attribute);
    }

    public static VariabilityEdge createVariabilityEdge() {
        return new VariabilityEdge();
    }

    public static VariabilityEdge createVariabilityEdge(Node source, Node target, EReference type) {
        return new VariabilityEdge(source, target, type);
    }

    public static VariabilityEdge createVariabilityEdge(Edge edge) {
        if (edge instanceof VariabilityEdge) {
            return (VariabilityEdge)edge;
        }
        return new VariabilityEdge(edge);
    }

    public static VariabilityGraphElement createVariabilityGraphElement(GraphElement graphElement) {
        if (graphElement instanceof VariabilityGraphElement) {
            return (VariabilityGraphElement)graphElement;
        }
        if (graphElement instanceof Attribute) {
            return VariabilityFactory.createVariabilityAttribute((Attribute)graphElement);
        }
        if (graphElement instanceof Node) {
            return VariabilityFactory.createVariabilityNode((Node)graphElement);
        }
        if (graphElement instanceof Edge) {
            return VariabilityFactory.createVariabilityEdge((Edge)graphElement);
        }
        throw new RuntimeException();
    }

    public static VariabilityNestedCondition createVariabilityNestedCondition() {
        return new VariabilityNestedCondition();
    }

    public static VariabilityNestedCondition createVariabilityNestedCondition(NestedCondition condition) {
        if (condition instanceof VariabilityGraphElement) {
            return (VariabilityNestedCondition)condition;
        }
        return new VariabilityNestedCondition(condition);
    }

    public static VariabilityNode createVariabilityNode() {
        return new VariabilityNode();
    }

    public static VariabilityNode createVariabilityNode(Graph graph, EClass type, String name) {
        return new VariabilityNode(graph, type, name);
    }

    public static VariabilityNode createVariabilityNode(Node node) {
        if (node instanceof VariabilityNode) {
            return (VariabilityNode)node;
        }
        VariabilityFactory.transformAttributes(node);
        return new VariabilityNode(node);
    }

    public static VariabilityRule createVariabilityRule() {
        return new VariabilityRule();
    }

    public static VariabilityRule createVariabilityRule(String name) {
        return new VariabilityRule(name);
    }

    public static VariabilityRule createVariabilityRule(Rule rule) {
        if (rule instanceof VariabilityRule) {
            return (VariabilityRule)rule;
        }
        VariabilityFactory.transformGraphElements(rule.getLhs());
        VariabilityFactory.transformGraphElements(rule.getRhs());
        return new VariabilityRule(rule);
    }

    private static void transformGraphElements(Graph graph) {
        for (Node node : graph.getNodes()) {
            VariabilityNode.addVariabilityToNode(node);
            VariabilityFactory.transformAttributes(node);
        }
        for (Edge edge : graph.getEdges()) {
            VariabilityEdge.addVariabilityToEdge(edge);
        }
        for (NestedCondition condition : graph.getNestedConditions()) {
            VariabilityNestedCondition.addVariabilityToNestedCondition(condition);
            VariabilityFactory.transformGraphElements(condition.getConclusion());
        }
    }

    private static void transformAttributes(Node node) {
        for (Attribute attribute : node.getAttributes()) {
            VariabilityAttribute.addVariabilityToAttribute(attribute);
        }
    }
}

