/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityGraphElement;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;

public class VariabilityEdge
implements Edge,
VariabilityGraphElement {
    final Edge edge;
    final Annotation presenceCondition;

    static Annotation addVariabilityToEdge(Edge edge) {
        EList annos = edge.getAnnotations();
        Iterator it = annos.iterator();
        Annotation pc = null;
        while (it.hasNext()) {
            Annotation anno = (Annotation)it.next();
            if (!anno.getKey().equals("presenceCondition")) continue;
            pc = anno;
            break;
        }
        if (pc != null) {
            return pc;
        }
        return VariabilityTransactionHelper.addAnnotation((ModelElement)edge, "presenceCondition", "");
    }

    VariabilityEdge() {
        this(HenshinFactoryImpl.eINSTANCE.createEdge());
    }

    VariabilityEdge(Node source, Node target, EReference type) {
        this(HenshinFactoryImpl.eINSTANCE.createEdge(source, target, type));
    }

    VariabilityEdge(Edge edge) {
        this.edge = edge;
        this.presenceCondition = VariabilityEdge.addVariabilityToEdge(edge);
    }

    @Override
    public GraphElement getGraphElement() {
        return this.edge;
    }

    @Override
    public String getPresenceCondition() {
        return this.presenceCondition.getValue();
    }

    @Override
    public void setPresenceCondition(String condition) {
        this.presenceCondition.setValue(condition);
    }

    public EList<Adapter> eAdapters() {
        return this.edge.eAdapters();
    }

    public boolean eDeliver() {
        return this.edge.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.edge.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.edge.eNotify(notification);
    }

    public EClass eClass() {
        return this.edge.eClass();
    }

    public Resource eResource() {
        return this.edge.eResource();
    }

    public EObject eContainer() {
        return this.edge.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.edge.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.edge.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.edge.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.edge.eAllContents();
    }

    public boolean eIsProxy() {
        return this.edge.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.edge.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.edge.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.edge.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.edge.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.edge.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.edge.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.edge.eInvoke(operation, arguments);
    }

    public Action getAction() {
        return this.edge.getAction();
    }

    public Edge getActionEdge() {
        return this.edge.getActionEdge();
    }

    public EList<Annotation> getAnnotations() {
        return this.edge.getAnnotations();
    }

    public Graph getGraph() {
        return this.edge.getGraph();
    }

    public String getIndex() {
        return this.edge.getIndex();
    }

    public Integer getIndexConstant() {
        return this.edge.getIndexConstant();
    }

    public Node getSource() {
        return this.edge.getSource();
    }

    public Node getTarget() {
        return this.edge.getTarget();
    }

    public EReference getType() {
        return this.edge.getType();
    }

    public void setAction(Action arg0) {
        this.edge.setAction(arg0);
    }

    public void setGraph(Graph arg0) {
        this.edge.setGraph(arg0);
    }

    public void setIndex(String arg0) {
        this.edge.setIndex(arg0);
    }

    public void setSource(Node arg0) {
        this.edge.setSource(arg0);
    }

    public void setTarget(Node arg0) {
        this.edge.setTarget(arg0);
    }

    public void setType(EReference arg0) {
        this.edge.setType(arg0);
    }

    public int hashCode() {
        return this.edge.hashCode();
    }

    public boolean equals(Object obj) {
        return this.edge.equals(obj);
    }
}

